Object.defineProperty(exports, '__esModule', {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _atom = require('atom');

var _reporterProxy = require('./reporter-proxy');

var _reporterProxy2 = _interopRequireDefault(_reporterProxy);

var WelcomeView = undefined,
    GuideView = undefined,
    ConsentView = undefined;

var WELCOME_URI = 'atom://welcome/welcome';
var GUIDE_URI = 'atom://welcome/guide';
var CONSENT_URI = 'atom://welcome/consent';

var WelcomePackage = (function () {
  function WelcomePackage() {
    _classCallCheck(this, WelcomePackage);

    this.reporterProxy = new _reporterProxy2['default']();
  }

  _createClass(WelcomePackage, [{
    key: 'activate',
    value: _asyncToGenerator(function* () {
      var _this = this;

      this.subscriptions = new _atom.CompositeDisposable();

      this.subscriptions.add(atom.workspace.addOpener(function (filePath) {
        if (filePath === WELCOME_URI) {
          return _this.createWelcomeView({ uri: WELCOME_URI });
        }
      }));

      this.subscriptions.add(atom.workspace.addOpener(function (filePath) {
        if (filePath === GUIDE_URI) {
          return _this.createGuideView({ uri: GUIDE_URI });
        }
      }));

      this.subscriptions.add(atom.workspace.addOpener(function (filePath) {
        if (filePath === CONSENT_URI) {
          return _this.createConsentView({ uri: CONSENT_URI });
        }
      }));

      this.subscriptions.add(atom.commands.add('atom-workspace', 'welcome:show', function () {
        return _this.show();
      }));

      if (atom.config.get('core.telemetryConsent') === 'undecided') {
        yield atom.workspace.open(CONSENT_URI);
      }

      if (atom.config.get('welcome.showOnStartup')) {
        yield this.show();
        this.reporterProxy.sendEvent('show-on-initial-load');
      }
    })
  }, {
    key: 'show',
    value: function show() {
      return Promise.all([atom.workspace.open(WELCOME_URI, { split: 'left' }), atom.workspace.open(GUIDE_URI, { split: 'right' })]);
    }
  }, {
    key: 'consumeReporter',
    value: function consumeReporter(reporter) {
      return this.reporterProxy.setReporter(reporter);
    }
  }, {
    key: 'deactivate',
    value: function deactivate() {
      this.subscriptions.dispose();
    }
  }, {
    key: 'createWelcomeView',
    value: function createWelcomeView(state) {
      if (WelcomeView == null) WelcomeView = require('./welcome-view');
      return new WelcomeView(_extends({ reporterProxy: this.reporterProxy }, state));
    }
  }, {
    key: 'createGuideView',
    value: function createGuideView(state) {
      if (GuideView == null) GuideView = require('./guide-view');
      return new GuideView(_extends({ reporterProxy: this.reporterProxy }, state));
    }
  }, {
    key: 'createConsentView',
    value: function createConsentView(state) {
      if (ConsentView == null) ConsentView = require('./consent-view');
      return new ConsentView(_extends({ reporterProxy: this.reporterProxy }, state));
    }
  }]);

  return WelcomePackage;
})();

exports['default'] = WelcomePackage;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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