(function() {
  var BufferedProcess, ProgressElement;

  BufferedProcess = require('atom').BufferedProcess;

  ProgressElement = require('./progress-element');

  module.exports = {
    activate: function() {
      return atom.commands.add("atom-workspace", 'update-package-dependencies:update', (function(_this) {
        return function() {
          return _this.update();
        };
      })(this));
    },
    update: function() {
      var args, command, exit, options, panel, view;
      view = new ProgressElement;
      view.displayLoading();
      panel = atom.workspace.addModalPanel({
        item: view
      });
      command = atom.packages.getApmPath();
      args = ['install'];
      options = {
        cwd: this.getActiveProjectPath()
      };
      exit = function(code) {
        view.element.focus();
        atom.commands.add(view.element, 'core:cancel', function() {
          return panel.destroy();
        });
        if (code === 0) {
          atom.notifications.addSuccess("Success!", {
            detail: "Package dependencies updated."
          });
          return panel.destroy();
        } else {
          atom.notifications.addError("Error!", {
            detail: "Failed to update package dependencies."
          });
          return panel.destroy();
        }
      };
      return this.runBufferedProcess({
        command: command,
        args: args,
        exit: exit,
        options: options
      });
    },
    runBufferedProcess: function(params) {
      return new BufferedProcess(params);
    },
    getActiveProjectPath: function() {
      var activeItemPath, ref;
      if (activeItemPath = (ref = atom.workspace.getActivePaneItem()) != null ? typeof ref.getPath === "function" ? ref.getPath() : void 0 : void 0) {
        return atom.project.relativizePath(activeItemPath)[0];
      } else {
        return atom.project.getPaths()[0];
      }
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
