Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/** @babel */

var _atom = require('atom');

var _humanizePlus = require('humanize-plus');

var _humanizePlus2 = _interopRequireDefault(_humanizePlus);

var _symbolsView = require('./symbols-view');

var _symbolsView2 = _interopRequireDefault(_symbolsView);

var _tagReader = require('./tag-reader');

var _tagReader2 = _interopRequireDefault(_tagReader);

var _getTagsFile = require('./get-tags-file');

var _getTagsFile2 = _interopRequireDefault(_getTagsFile);

var ProjectView = (function (_SymbolsView) {
  _inherits(ProjectView, _SymbolsView);

  function ProjectView(stack) {
    _classCallCheck(this, ProjectView);

    _get(Object.getPrototypeOf(ProjectView.prototype), 'constructor', this).call(this, stack, 'Project has no tags file or it is empty', 10);
    this.reloadTags = true;
  }

  _createClass(ProjectView, [{
    key: 'destroy',
    value: function destroy() {
      this.stopTask();
      this.unwatchTagsFiles();
      return _get(Object.getPrototypeOf(ProjectView.prototype), 'destroy', this).call(this);
    }
  }, {
    key: 'toggle',
    value: function toggle() {
      if (this.panel.isVisible()) {
        this.cancel();
      } else {
        this.populate();
        this.attach();
      }
    }
  }, {
    key: 'populate',
    value: _asyncToGenerator(function* () {
      var _this = this;

      if (this.tags) {
        yield this.selectListView.update({ items: this.tags });
      }

      if (this.reloadTags) {
        this.reloadTags = false;
        this.startTask();

        if (this.tags) {
          yield this.selectListView.update({
            loadingMessage: 'Reloading project symbols…'
          });
        } else {
          yield* (function* () {
            yield _this.selectListView.update({
              loadingMessage: 'Loading project symbols…',
              loadingBadge: 0
            });
            var tagsRead = 0;
            _this.loadTagsTask.on('tags', function (tags) {
              tagsRead += tags.length;
              _this.selectListView.update({ loadingBadge: _humanizePlus2['default'].intComma(tagsRead) });
            });
          })();
        }
      }
    })
  }, {
    key: 'stopTask',
    value: function stopTask() {
      if (this.loadTagsTask) {
        this.loadTagsTask.terminate();
      }
    }
  }, {
    key: 'startTask',
    value: function startTask() {
      var _this2 = this;

      this.stopTask();

      this.loadTagsTask = _tagReader2['default'].getAllTags(function (tags) {
        _this2.tags = tags;
        _this2.reloadTags = _this2.tags.length === 0;
        _this2.selectListView.update({
          loadingMessage: null,
          loadingBadge: null,
          items: _this2.tags
        });
      });

      this.watchTagsFiles();
    }
  }, {
    key: 'watchTagsFiles',
    value: function watchTagsFiles() {
      var _this3 = this;

      this.unwatchTagsFiles();

      this.tagsFileSubscriptions = new _atom.CompositeDisposable();
      var reloadTags = function reloadTags() {
        _this3.reloadTags = true;
        _this3.watchTagsFiles();
      };

      for (var projectPath of Array.from(atom.project.getPaths())) {
        var tagsFilePath = (0, _getTagsFile2['default'])(projectPath);
        if (tagsFilePath) {
          var tagsFile = new _atom.File(tagsFilePath);
          this.tagsFileSubscriptions.add(tagsFile.onDidChange(reloadTags));
          this.tagsFileSubscriptions.add(tagsFile.onDidDelete(reloadTags));
          this.tagsFileSubscriptions.add(tagsFile.onDidRename(reloadTags));
        }
      }
    }
  }, {
    key: 'unwatchTagsFiles',
    value: function unwatchTagsFiles() {
      if (this.tagsFileSubscriptions) {
        this.tagsFileSubscriptions.dispose();
      }
      this.tagsFileSubscriptions = null;
    }
  }]);

  return ProjectView;
})(_symbolsView2['default']);

exports['default'] = ProjectView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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