Object.defineProperty(exports, '__esModule', {
  value: true
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/** @babel */
/* global emit*/

var _async = require('async');

var _async2 = _interopRequireDefault(_async);

var _ctags = require('ctags');

var _ctags2 = _interopRequireDefault(_ctags);

var _getTagsFile = require('./get-tags-file');

var _getTagsFile2 = _interopRequireDefault(_getTagsFile);

exports['default'] = function (directoryPaths) {
  return _async2['default'].each(directoryPaths, function (directoryPath, done) {
    var tagsFilePath = (0, _getTagsFile2['default'])(directoryPath);
    if (!tagsFilePath) {
      return done();
    }

    var stream = _ctags2['default'].createReadStream(tagsFilePath);
    stream.on('data', function (tags) {
      for (var tag of Array.from(tags)) {
        tag.directory = directoryPath;
      }
      return emit('tags', tags);
    });
    stream.on('end', done);
    return stream.on('error', done);
  }, this.async());
};

module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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