Object.defineProperty(exports, '__esModule', {
  value: true
});

var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _atomSelectList = require('atom-select-list');

var _atomSelectList2 = _interopRequireDefault(_atomSelectList);

var CorrectionsView = (function () {
  function CorrectionsView(editor, corrections, marker, updateTarget, updateCallback) {
    var _this = this;

    _classCallCheck(this, CorrectionsView);

    this.editor = editor;
    this.corrections = corrections;
    this.marker = marker;
    this.updateTarget = updateTarget;
    this.updateCallback = updateCallback;
    this.selectListView = new _atomSelectList2['default']({
      emptyMessage: 'No corrections',
      items: this.corrections,
      filterKeyForItem: function filterKeyForItem(item) {
        return item.label;
      },
      elementForItem: function elementForItem(item) {
        var element = document.createElement('li');
        if (item.isSuggestion) {
          // This is a word replacement suggestion.
          element.textContent = item.label;
        } else {
          // This is an operation such as add word.
          var em = document.createElement('em');
          em.textContent = item.label;
          element.appendChild(em);
        }
        return element;
      },
      didConfirmSelection: function didConfirmSelection(item) {
        _this.editor.transact(function () {
          if (item.isSuggestion) {
            // Update the buffer with the correction.
            _this.editor.setSelectedBufferRange(_this.marker.getBufferRange());
            _this.editor.insertText(item.suggestion);
          } else {
            // Build up the arguments object for this buffer and text.
            var projectPath = null;
            var relativePath = null;
            if (_this.editor && _this.editor.buffer && _this.editor.buffer.file && _this.editor.buffer.file.path) {
              var _atom$project$relativizePath = atom.project.relativizePath(_this.editor.buffer.file.path);

              var _atom$project$relativizePath2 = _slicedToArray(_atom$project$relativizePath, 2);

              projectPath = _atom$project$relativizePath2[0];
              relativePath = _atom$project$relativizePath2[1];
            }

            var args = { id: _this.id, projectPath: projectPath, relativePath: relativePath };
            // Send the "add" request to the plugin.
            item.plugin.add(args, item);
            // Update the buffer to handle the corrections.
            _this.updateCallback.bind(_this.updateTarget)();
          }
        });
        _this.destroy();
      },
      didConfirmEmptySelection: function didConfirmEmptySelection() {
        _this.destroy();
      },
      didCancelSelection: function didCancelSelection() {
        _this.destroy();
      }
    });
    this.selectListView.element.classList.add('spell-check-corrections', 'corrections', 'popover-list');
  }

  _createClass(CorrectionsView, [{
    key: 'attach',
    value: function attach() {
      var _this2 = this;

      this.previouslyFocusedElement = document.activeElement;
      this.overlayDecoration = this.editor.decorateMarker(this.marker, { type: 'overlay', item: this.selectListView });
      process.nextTick(function () {
        atom.views.readDocument(function () {
          _this2.selectListView.focus();
        });
      });
    }
  }, {
    key: 'destroy',
    value: _asyncToGenerator(function* () {
      if (!this.destroyed) {
        this.destroyed = true;
        this.overlayDecoration.destroy();
        yield this.selectListView.destroy();
        if (this.previouslyFocusedElement) {
          this.previouslyFocusedElement.focus();
          this.previouslyFocusedElement = null;
        }
      }
    })
  }]);

  return CorrectionsView;
})();

exports['default'] = CorrectionsView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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