Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _atom = require('atom');

var _generalPanel = require('./general-panel');

var _generalPanel2 = _interopRequireDefault(_generalPanel);

var _editorPanel = require('./editor-panel');

var _editorPanel2 = _interopRequireDefault(_editorPanel);

var _packageDetailView = require('./package-detail-view');

var _packageDetailView2 = _interopRequireDefault(_packageDetailView);

var _keybindingsPanel = require('./keybindings-panel');

var _keybindingsPanel2 = _interopRequireDefault(_keybindingsPanel);

var _installPanel = require('./install-panel');

var _installPanel2 = _interopRequireDefault(_installPanel);

var _themesPanel = require('./themes-panel');

var _themesPanel2 = _interopRequireDefault(_themesPanel);

var _installedPackagesPanel = require('./installed-packages-panel');

var _installedPackagesPanel2 = _interopRequireDefault(_installedPackagesPanel);

var _updatesPanel = require('./updates-panel');

var _updatesPanel2 = _interopRequireDefault(_updatesPanel);

var _packageManager = require('./package-manager');

var _packageManager2 = _interopRequireDefault(_packageManager);

var SettingsView = (function () {
  function SettingsView() {
    var _this = this;

    var _ref = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

    var uri = _ref.uri;
    var packageManager = _ref.packageManager;
    var snippetsProvider = _ref.snippetsProvider;
    var activePanel = _ref.activePanel;

    _classCallCheck(this, SettingsView);

    this.uri = uri;
    this.packageManager = packageManager;
    this.snippetsProvider = snippetsProvider;
    this.deferredPanel = activePanel;
    this.destroyed = false;

    _etch2['default'].initialize(this);
    this.disposables = new _atom.CompositeDisposable();
    this.disposables.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));
    process.nextTick(function () {
      return _this.initializePanels();
    });
  }

  _createClass(SettingsView, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'destroy',
    value: function destroy() {
      this.destroyed = true;
      this.disposables.dispose();
      for (var _name in this.panelsByName) {
        var panel = this.panelsByName[_name];
        panel.destroy();
      }

      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'settings-view pane-item', tabIndex: '-1' },
        _etch2['default'].dom(
          'div',
          { className: 'config-menu', ref: 'sidebar' },
          _etch2['default'].dom(
            'ul',
            { className: 'panels-menu nav nav-pills nav-stacked', ref: 'panelMenu' },
            _etch2['default'].dom('div', { className: 'panel-menu-separator', ref: 'menuSeparator' })
          ),
          _etch2['default'].dom(
            'div',
            { className: 'button-area' },
            _etch2['default'].dom(
              'button',
              { className: 'btn btn-default icon icon-link-external', ref: 'openDotAtom' },
              'Open Config Folder'
            )
          )
        ),
        _etch2['default'].dom('div', { className: 'panels', tabIndex: '-1', ref: 'panels' })
      );
    }

    // This prevents the view being actually disposed when closed
    // If you remove it you will need to ensure the cached settingsView
    // in main.coffee is correctly released on close as well...
  }, {
    key: 'onDidChangeTitle',
    value: function onDidChangeTitle() {
      return new _atom.Disposable();
    }
  }, {
    key: 'initializePanels',
    value: function initializePanels() {
      var _this2 = this;

      if (this.refs.panels.children.length > 1) {
        return;
      }

      this.panelsByName = {};
      var clickHandler = function clickHandler(event) {
        var target = event.target.closest('.panels-menu li a, .panels-packages li a');
        if (target) {
          _this2.showPanel(target.closest('li').name);
        }
      };
      this.element.addEventListener('click', clickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        return _this2.element.removeEventListener('click', clickHandler);
      }));

      var focusHandler = function focusHandler() {
        _this2.focusActivePanel();
      };
      this.element.addEventListener('focus', focusHandler);
      this.disposables.add(new _atom.Disposable(function () {
        return _this2.element.removeEventListener('focus', focusHandler);
      }));

      var openDotAtomClickHandler = function openDotAtomClickHandler() {
        atom.open({ pathsToOpen: [atom.getConfigDirPath()] });
      };
      this.refs.openDotAtom.addEventListener('click', openDotAtomClickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        return _this2.refs.openDotAtom.removeEventListener('click', openDotAtomClickHandler);
      }));

      this.addCorePanel('Core', 'settings', function () {
        return new _generalPanel2['default']();
      });
      this.addCorePanel('Editor', 'code', function () {
        return new _editorPanel2['default']();
      });
      if (process.platform === 'win32' && require('atom').WinShell != null) {
        (function () {
          var SystemPanel = require('./system-windows-panel');
          _this2.addCorePanel('System', 'device-desktop', function () {
            return new SystemPanel();
          });
        })();
      }
      this.addCorePanel('Keybindings', 'keyboard', function () {
        return new _keybindingsPanel2['default']();
      });
      this.addCorePanel('Packages', 'package', function () {
        return new _installedPackagesPanel2['default'](_this2, _this2.packageManager);
      });
      this.addCorePanel('Themes', 'paintcan', function () {
        return new _themesPanel2['default'](_this2, _this2.packageManager);
      });
      this.addCorePanel('Updates', 'cloud-download', function () {
        return new _updatesPanel2['default'](_this2, _this2.packageManager);
      });
      this.addCorePanel('Install', 'plus', function () {
        return new _installPanel2['default'](_this2, _this2.packageManager);
      });

      this.showDeferredPanel();

      if (!this.activePanel) {
        this.showPanel('Core');
      }

      if (document.body.contains(this.element)) {
        this.refs.sidebar.style.width = this.refs.sidebar.offsetWidth;
      }
    }
  }, {
    key: 'serialize',
    value: function serialize() {
      return {
        deserializer: 'SettingsView',
        version: 2,
        activePanel: this.activePanel != null ? this.activePanel : this.deferredPanel,
        uri: this.uri
      };
    }
  }, {
    key: 'getPackages',
    value: function getPackages() {
      var _this3 = this;

      var bundledPackageMetadataCache = undefined;
      var left = undefined;
      if (this.packages != null) {
        return this.packages;
      }

      this.packages = atom.packages.getLoadedPackages();

      try {
        var packageMetadata = require(_path2['default'].join(atom.getLoadSettings().resourcePath, 'package.json'));
        bundledPackageMetadataCache = packageMetadata ? packageMetadata._atomPackages : null;
      } catch (error) {}

      // Include disabled packages so they can be re-enabled from the UI
      var disabledPackages = atom.config.get('core.disabledPackages') || [];
      for (var packageName of disabledPackages) {
        var metadata;
        var packagePath = atom.packages.resolvePackagePath(packageName);
        if (!packagePath) {
          continue;
        }

        try {
          metadata = require(_path2['default'].join(packagePath, 'package.json'));
        } catch (error) {
          if (bundledPackageMetadataCache && bundledPackageMetadataCache[packageName]) {
            metadata = bundledPackageMetadataCache[packageName].metadata;
          }
        }
        if (metadata == null) {
          continue;
        }

        var _name2 = metadata.name != null ? metadata.name : packageName;
        if (!_underscorePlus2['default'].findWhere(this.packages, { name: _name2 })) {
          this.packages.push({ name: _name2, metadata: metadata, path: packagePath });
        }
      }

      this.packages.sort(function (pack1, pack2) {
        var title1 = _this3.packageManager.getPackageTitle(pack1);
        var title2 = _this3.packageManager.getPackageTitle(pack2);
        return title1.localeCompare(title2);
      });

      return this.packages;
    }
  }, {
    key: 'addCorePanel',
    value: function addCorePanel(name, iconName, panel) {
      var panelMenuItem = document.createElement('li');
      panelMenuItem.name = name;
      panelMenuItem.setAttribute('name', name);

      var a = document.createElement('a');
      a.classList.add('icon', 'icon-' + iconName);
      a.textContent = name;
      panelMenuItem.appendChild(a);

      this.refs.menuSeparator.parentElement.insertBefore(panelMenuItem, this.refs.menuSeparator);
      this.addPanel(name, panel);
    }
  }, {
    key: 'addPanel',
    value: function addPanel(name, panelCreateCallback) {
      if (this.panelCreateCallbacks == null) {
        this.panelCreateCallbacks = {};
      }
      this.panelCreateCallbacks[name] = panelCreateCallback;
      if (this.deferredPanel && this.deferredPanel.name === name) {
        this.showDeferredPanel();
      }
    }
  }, {
    key: 'getOrCreatePanel',
    value: function getOrCreatePanel(name, options) {
      var _this4 = this;

      var panel = this.panelsByName ? this.panelsByName[name] : null;
      // These nested conditionals are not great but I feel like it's the most
      // expedient thing to do - I feel like the "right way" involves refactoring
      // this whole file.
      if (!panel) {
        var callback = this.panelCreateCallbacks ? this.panelCreateCallbacks[name] : null;

        if (options && options.pack && !callback) {
          callback = function () {
            if (!options.pack.metadata) {
              var metadata = _underscorePlus2['default'].clone(options.pack);
              options.pack.metadata = metadata;
            }
            return new _packageDetailView2['default'](options.pack, _this4, _this4.packageManager, _this4.snippetsProvider);
          };
        }

        if (callback) {
          panel = callback();
          if (this.panelsByName == null) {
            this.panelsByName = {};
          }
          this.panelsByName[name] = panel;
          if (this.panelCreateCallbacks) {
            delete this.panelCreateCallbacks[name];
          }
        }
      }

      return panel;
    }
  }, {
    key: 'makePanelMenuActive',
    value: function makePanelMenuActive(name) {
      var previouslyActivePanel = this.refs.sidebar.querySelector('.active');
      if (previouslyActivePanel) {
        previouslyActivePanel.classList.remove('active');
      }

      var newActivePanel = this.refs.sidebar.querySelector('[name=\'' + name + '\']');
      if (newActivePanel) {
        newActivePanel.classList.add('active');
      }
    }
  }, {
    key: 'focusActivePanel',
    value: function focusActivePanel() {
      // Pass focus to panel that is currently visible
      for (var i = 0; i < this.refs.panels.children.length; i++) {
        var child = this.refs.panels.children[i];
        if (child.offsetWidth > 0) {
          child.focus();
        }
      }
    }
  }, {
    key: 'showDeferredPanel',
    value: function showDeferredPanel() {
      if (this.deferredPanel) {
        var _deferredPanel = this.deferredPanel;
        var _name3 = _deferredPanel.name;
        var options = _deferredPanel.options;

        this.showPanel(_name3, options);
      }
    }

    // Public: show a panel.
    //
    // * `name` {String} the name of the panel to show
    // * `options` {Object} an options hash. Will be passed to `beforeShow()` on
    //   the panel. Options may include (but are not limited to):
    //   * `uri` the URI the panel was launched from
  }, {
    key: 'showPanel',
    value: function showPanel(name, options) {
      var panel = this.getOrCreatePanel(name, options);
      if (panel) {
        this.appendPanel(panel, options);
        this.makePanelMenuActive(name);
        this.setActivePanel(name, options);
        this.deferredPanel = null;
      } else {
        this.deferredPanel = { name: name, options: options };
      }
    }
  }, {
    key: 'appendPanel',
    value: function appendPanel(panel, options) {
      for (var i = 0; i < this.refs.panels.children.length; i++) {
        this.refs.panels.children[i].style.display = 'none';
      }

      if (!this.refs.panels.contains(panel.element)) {
        this.refs.panels.appendChild(panel.element);
      }

      if (panel.beforeShow) {
        panel.beforeShow(options);
      }
      panel.show();
      panel.focus();
    }
  }, {
    key: 'setActivePanel',
    value: function setActivePanel(name) {
      var options = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

      this.activePanel = { name: name, options: options };
    }
  }, {
    key: 'removePanel',
    value: function removePanel(name) {
      var panel = this.panelsByName ? this.panelsByName[name] : null;
      if (panel) {
        panel.destroy();
        delete this.panelsByName[name];
      }
    }
  }, {
    key: 'getTitle',
    value: function getTitle() {
      return 'Settings';
    }
  }, {
    key: 'getIconName',
    value: function getIconName() {
      return 'tools';
    }
  }, {
    key: 'getURI',
    value: function getURI() {
      return this.uri;
    }
  }, {
    key: 'isEqual',
    value: function isEqual(other) {
      return other instanceof SettingsView;
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }
  }]);

  return SettingsView;
})();

exports['default'] = SettingsView;
module.exports = exports['default'];
/* The tabindex attr below ensures that clicks in a panel item won't
cause this view to gain focus. This is important because when this view
gains focus (e.g. immediately after atom displays it), it focuses the
currently active panel item. If that focusing causes the active panel to
scroll (e.g. because the active panel itself passes focus on to a search
box at the top of a scrolled panel), then the browser will not fire the
click event on the element within the panel on which the user originally
clicked (e.g. a package card). This would prevent us from showing a
package detail view when clicking on a package card. Phew! */
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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