Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _atom = require('atom');

var _settingsPanel = require('./settings-panel');

var _settingsPanel2 = _interopRequireDefault(_settingsPanel);

// View to display the grammars that a package has registered.

var PackageGrammarsView = (function () {
  function PackageGrammarsView(packagePath) {
    var _this = this;

    _classCallCheck(this, PackageGrammarsView);

    this.element = document.createElement('section');
    this.element.classList.add('package-grammars');

    this.grammarSettings = document.createElement('div');
    this.element.appendChild(this.grammarSettings);

    this.disposables = new _atom.CompositeDisposable();
    this.packagePath = _path2['default'].join(packagePath, _path2['default'].sep);
    this.addGrammars();
    this.disposables.add(atom.grammars.onDidAddGrammar(function () {
      return _this.addGrammars();
    }));
    this.disposables.add(atom.grammars.onDidUpdateGrammar(function () {
      return _this.addGrammars();
    }));
  }

  _createClass(PackageGrammarsView, [{
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      this.element.remove();
    }
  }, {
    key: 'getPackageGrammars',
    value: function getPackageGrammars() {
      var packageGrammars = [];
      var grammars = atom.grammars.grammars != null ? atom.grammars.grammars : [];
      for (var grammar of grammars) {
        if (grammar.path) {
          if (grammar.path.indexOf(this.packagePath) === 0) {
            packageGrammars.push(grammar);
          }
        }
      }
      return packageGrammars.sort(function (grammar1, grammar2) {
        var name1 = grammar1.name || grammar1.scopeName || '';
        var name2 = grammar2.name || grammar2.scopeName || '';
        return name1.localeCompare(name2);
      });
    }
  }, {
    key: 'addGrammarHeading',
    value: function addGrammarHeading(grammar, panel) {
      var container = document.createElement('div');
      container.classList.add('native-key-bindings', 'text');
      container.tabIndex = -1;

      var grammarScope = document.createElement('div');
      grammarScope.classList.add('grammar-scope');

      var scopeStrong = document.createElement('strong');
      scopeStrong.textContent = 'Scope: ';
      grammarScope.appendChild(scopeStrong);

      var scopeSpan = document.createElement('span');
      scopeSpan.textContent = grammar.scopeName != null ? grammar.scopeName : '';
      grammarScope.appendChild(scopeSpan);
      container.appendChild(grammarScope);

      var grammarFileTypes = document.createElement('div');
      grammarFileTypes.classList.add('grammar-filetypes');

      var fileTypesStrong = document.createElement('strong');
      fileTypesStrong.textContent = 'File Types: ';
      grammarFileTypes.appendChild(fileTypesStrong);

      var fileTypes = grammar.fileTypes || [];
      var fileTypesSpan = document.createElement('span');
      fileTypesSpan.textContent = fileTypes.join(', ');
      grammarFileTypes.appendChild(fileTypesSpan);
      container.appendChild(grammarFileTypes);

      var sectionBody = panel.element.querySelector('.section-body');
      sectionBody.parentElement.insertBefore(container, sectionBody);
    }
  }, {
    key: 'addGrammars',
    value: function addGrammars() {
      this.grammarSettings.innerHTML = '';
      for (var grammar of this.getPackageGrammars()) {
        var scopeName = grammar.scopeName;
        var _name = grammar.name;

        if (!scopeName || !_name) {
          continue;
        }

        if (!scopeName.startsWith('.')) {
          scopeName = '.' + scopeName;
        }

        var title = _name + ' Grammar';
        var panel = new _settingsPanel2['default']({ title: title, scopeName: scopeName, icon: 'puzzle' });
        this.addGrammarHeading(grammar, panel);
        this.grammarSettings.appendChild(panel.element);
      }
    }
  }]);

  return PackageGrammarsView;
})();

exports['default'] = PackageGrammarsView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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