Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _atom = require('atom');

var _electron = require('electron');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _utils = require('./utils');

var marked = null;

var PackageCard = (function () {
  function PackageCard(pack, settingsView, packageManager) {
    var options = arguments.length <= 3 || arguments[3] === undefined ? {} : arguments[3];

    _classCallCheck(this, PackageCard);

    this.pack = pack;
    this.settingsView = settingsView;
    this.packageManager = packageManager;
    this.disposables = new _atom.CompositeDisposable();

    // It might be useful to either wrap this.pack in a class that has a
    // ::validate method, or add a method here. At the moment I think all cases
    // of malformed package metadata are handled here and in ::content but belt
    // and suspenders, you know
    this.client = this.packageManager.getClient();
    this.type = this.pack.theme ? 'theme' : 'package';
    this.name = this.pack.name;
    this.onSettingsView = options.onSettingsView;

    if (this.pack.latestVersion !== this.pack.version) {
      this.newVersion = this.pack.latestVersion;
    }

    if (this.pack.apmInstallSource && this.pack.apmInstallSource.type === 'git') {
      if (this.pack.apmInstallSource.sha !== this.pack.latestSha) {
        this.newSha = this.pack.latestSha;
      }
    }

    // Default to displaying the download count
    if (!options.stats) {
      options.stats = { downloads: true };
    }

    _etch2['default'].initialize(this);

    this.displayStats(options);
    this.handlePackageEvents();
    this.handleButtonEvents(options);
    this.loadCachedMetadata();

    // themes have no status and cannot be dis/enabled
    if (this.type === 'theme') {
      this.refs.statusIndicator.remove();
      this.refs.enablementButton.remove();
    }

    if (atom.packages.isBundledPackage(this.pack.name)) {
      this.refs.installButtonGroup.remove();
      this.refs.uninstallButton.remove();
    }

    if (!this.newVersion && !this.newSha) {
      this.refs.updateButtonGroup.style.display = 'none';
    }

    this.hasCompatibleVersion = true;
    this.updateInterfaceState();
  }

  _createClass(PackageCard, [{
    key: 'render',
    value: function render() {
      var displayName = (this.pack.gitUrlInfo ? this.pack.gitUrlInfo.project : this.pack.name) || '';
      var owner = (0, _utils.ownerFromRepository)(this.pack.repository);
      var description = this.pack.description || '';

      return _etch2['default'].dom(
        'div',
        { className: 'package-card col-lg-8' },
        _etch2['default'].dom(
          'div',
          { ref: 'statsContainer', className: 'stats pull-right' },
          _etch2['default'].dom(
            'span',
            { ref: 'packageStars', className: 'stats-item' },
            _etch2['default'].dom('span', { ref: 'stargazerIcon', className: 'icon icon-star' }),
            _etch2['default'].dom('span', { ref: 'stargazerCount', className: 'value' })
          ),
          _etch2['default'].dom(
            'span',
            { ref: 'packageDownloads', className: 'stats-item' },
            _etch2['default'].dom('span', { ref: 'downloadIcon', className: 'icon icon-cloud-download' }),
            _etch2['default'].dom('span', { ref: 'downloadCount', className: 'value' })
          )
        ),
        _etch2['default'].dom(
          'div',
          { className: 'body' },
          _etch2['default'].dom(
            'h4',
            { className: 'card-name' },
            _etch2['default'].dom(
              'a',
              { className: 'package-name', ref: 'packageName' },
              displayName
            ),
            _etch2['default'].dom(
              'span',
              null,
              ' '
            ),
            _etch2['default'].dom(
              'span',
              { className: 'package-version' },
              _etch2['default'].dom(
                'span',
                { ref: 'versionValue', className: 'value' },
                String(this.pack.version)
              )
            ),
            _etch2['default'].dom(
              'span',
              { className: 'deprecation-badge highlight-warning inline-block' },
              'Deprecated'
            )
          ),
          _etch2['default'].dom(
            'span',
            { ref: 'packageDescription', className: 'package-description' },
            description
          ),
          _etch2['default'].dom('div', { ref: 'packageMessage', className: 'package-message' })
        ),
        _etch2['default'].dom(
          'div',
          { className: 'meta' },
          _etch2['default'].dom(
            'div',
            { ref: 'metaUserContainer', className: 'meta-user' },
            _etch2['default'].dom(
              'a',
              { ref: 'avatarLink', href: 'https://atom.io/users/' + owner },
              _etch2['default'].dom('img', { ref: 'avatar', className: 'avatar', src: 'data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7' })
            ),
            _etch2['default'].dom(
              'a',
              { ref: 'loginLink', className: 'author', href: 'https://atom.io/users/' + owner },
              owner
            )
          ),
          _etch2['default'].dom(
            'div',
            { className: 'meta-controls' },
            _etch2['default'].dom(
              'div',
              { className: 'btn-toolbar' },
              _etch2['default'].dom(
                'div',
                { ref: 'updateButtonGroup', className: 'btn-group' },
                _etch2['default'].dom(
                  'button',
                  { type: 'button', className: 'btn btn-info icon icon-cloud-download install-button', ref: 'updateButton' },
                  'Update'
                )
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'installAlternativeButtonGroup', className: 'btn-group' },
                _etch2['default'].dom(
                  'button',
                  { type: 'button', className: 'btn btn-info icon icon-cloud-download install-button', ref: 'installAlternativeButton' },
                  'Install Alternative'
                )
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'installButtonGroup', className: 'btn-group' },
                _etch2['default'].dom(
                  'button',
                  { type: 'button', className: 'btn btn-info icon icon-cloud-download install-button', ref: 'installButton' },
                  'Install'
                )
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'packageActionButtonGroup', className: 'btn-group' },
                _etch2['default'].dom(
                  'button',
                  { type: 'button', className: 'btn icon icon-gear settings', ref: 'settingsButton' },
                  'Settings'
                ),
                _etch2['default'].dom(
                  'button',
                  { type: 'button', className: 'btn icon icon-trashcan uninstall-button', ref: 'uninstallButton' },
                  'Uninstall'
                ),
                _etch2['default'].dom(
                  'button',
                  { type: 'button', className: 'btn icon icon-playback-pause enablement', ref: 'enablementButton' },
                  _etch2['default'].dom(
                    'span',
                    { className: 'disable-text' },
                    'Disable'
                  )
                ),
                _etch2['default'].dom('button', { type: 'button', className: 'btn status-indicator', tabIndex: '-1', ref: 'statusIndicator' })
              )
            )
          )
        )
      );
    }
  }, {
    key: 'locateCompatiblePackageVersion',
    value: function locateCompatiblePackageVersion(callback) {
      var _this = this;

      this.packageManager.loadCompatiblePackageVersion(this.pack.name, function (err, pack) {
        if (err != null) {
          console.error(err);
        }

        var packageVersion = pack.version;

        // A compatible version exist, we activate the install button and
        // set this.installablePack so that the install action installs the
        // compatible version of the package.
        if (packageVersion) {
          _this.refs.versionValue.textContent = packageVersion;
          if (packageVersion !== _this.pack.version) {
            _this.refs.versionValue.classList.add('text-warning');
            _this.refs.packageMessage.classList.add('text-warning');
            _this.refs.packageMessage.textContent = 'Version ' + packageVersion + ' is not the latest version available for this package, but it\'s the latest that is compatible with your version of Atom.';
          }

          _this.installablePack = pack;
          _this.hasCompatibleVersion = true;
        } else {
          _this.hasCompatibleVersion = false;
          _this.refs.versionValue.classList.add('text-error');
          _this.refs.packageMessage.classList.add('text-error');
          _this.refs.packageMessage.insertAdjacentText('beforeend', 'There\'s no version of this package that is compatible with your Atom version. The version must satisfy ' + _this.pack.engines.atom + '.');
          console.error('No available version compatible with the installed Atom version: ' + atom.getVersion());
        }

        callback();
      });
    }
  }, {
    key: 'handleButtonEvents',
    value: function handleButtonEvents(options) {
      var _this2 = this;

      if (options && options.onSettingsView) {
        this.refs.settingsButton.style.display = 'none';
      } else {
        (function () {
          var clickHandler = function clickHandler(event) {
            event.stopPropagation();
            _this2.settingsView.showPanel(_this2.pack.name, { back: options ? options.back : null, pack: _this2.pack });
          };

          _this2.element.addEventListener('click', clickHandler);
          _this2.disposables.add(new _atom.Disposable(function () {
            _this2.element.removeEventListener('click', clickHandler);
          }));

          _this2.refs.settingsButton.addEventListener('click', clickHandler);
          _this2.disposables.add(new _atom.Disposable(function () {
            _this2.refs.settingsButton.removeEventListener('click', clickHandler);
          }));
        })();
      }

      var installButtonClickHandler = function installButtonClickHandler(event) {
        event.stopPropagation();
        _this2.install();
      };
      this.refs.installButton.addEventListener('click', installButtonClickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        _this2.refs.installButton.removeEventListener('click', installButtonClickHandler);
      }));

      var uninstallButtonClickHandler = function uninstallButtonClickHandler(event) {
        event.stopPropagation();
        _this2.uninstall();
      };
      this.refs.uninstallButton.addEventListener('click', uninstallButtonClickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        _this2.refs.uninstallButton.removeEventListener('click', uninstallButtonClickHandler);
      }));

      var installAlternativeButtonClickHandler = function installAlternativeButtonClickHandler(event) {
        event.stopPropagation();
        _this2.installAlternative();
      };
      this.refs.installAlternativeButton.addEventListener('click', installAlternativeButtonClickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        _this2.refs.installAlternativeButton.removeEventListener('click', installAlternativeButtonClickHandler);
      }));

      var updateButtonClickHandler = function updateButtonClickHandler(event) {
        event.stopPropagation();
        _this2.update().then(function () {
          var buttons = [{
            text: 'Restart',
            onDidClick: function onDidClick() {
              return atom.restartApplication();
            }
          }];

          atom.notifications.addSuccess('Restart Atom to complete the update of `' + _this2.pack.name + '`.', {
            dismissable: true, buttons: buttons
          });
        });
      };
      this.refs.updateButton.addEventListener('click', updateButtonClickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        _this2.refs.updateButton.removeEventListener('click', updateButtonClickHandler);
      }));

      var packageNameClickHandler = function packageNameClickHandler(event) {
        event.stopPropagation();
        var packageType = _this2.pack.theme ? 'themes' : 'packages';
        _electron.shell.openExternal('https://atom.io/' + packageType + '/' + _this2.pack.name);
      };
      this.refs.packageName.addEventListener('click', packageNameClickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        _this2.refs.packageName.removeEventListener('click', packageNameClickHandler);
      }));

      var enablementButtonClickHandler = function enablementButtonClickHandler(event) {
        event.stopPropagation();
        event.preventDefault();
        if (_this2.isDisabled()) {
          atom.packages.enablePackage(_this2.pack.name);
        } else {
          atom.packages.disablePackage(_this2.pack.name);
        }
      };
      this.refs.enablementButton.addEventListener('click', enablementButtonClickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        _this2.refs.enablementButton.removeEventListener('click', enablementButtonClickHandler);
      }));

      var packageMessageClickHandler = function packageMessageClickHandler(event) {
        var target = event.target.closest('a');
        if (target) {
          event.stopPropagation();
          event.preventDefault();
          if (target.href && target.href.startsWith('atom:')) {
            atom.workspace.open(target.href);
          }
        }
      };
      this.refs.packageMessage.addEventListener('click', packageMessageClickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        _this2.refs.packageMessage.removeEventListener('click', packageMessageClickHandler);
      }));
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'loadCachedMetadata',
    value: function loadCachedMetadata() {
      var _this3 = this;

      this.client.avatar((0, _utils.ownerFromRepository)(this.pack.repository), function (err, avatarPath) {
        if (avatarPath) {
          _this3.refs.avatar.src = 'file://' + avatarPath;
        }
      });

      this.client['package'](this.pack.name, function (err, data) {
        // We don't need to actually handle the error here, we can just skip
        // showing the download count if there's a problem.
        if (!err) {
          if (data == null) {
            data = {};
          }

          if (_this3.pack.apmInstallSource && _this3.pack.apmInstallSource.type === 'git') {
            _this3.refs.downloadIcon.classList.remove('icon-cloud-download');
            _this3.refs.downloadIcon.classList.add('icon-git-branch');
            _this3.refs.downloadCount.textContent = _this3.pack.apmInstallSource.sha.substr(0, 8);
          } else {
            _this3.refs.stargazerCount.textContent = data.stargazers_count ? data.stargazers_count.toLocaleString() : '';
            _this3.refs.downloadCount.textContent = data.downloads ? data.downloads.toLocaleString() : '';
          }
        }
      });
    }
  }, {
    key: 'updateInterfaceState',
    value: function updateInterfaceState() {
      this.refs.versionValue.textContent = (this.installablePack ? this.installablePack.version : null) || this.pack.version;
      if (this.pack.apmInstallSource && this.pack.apmInstallSource.type === 'git') {
        this.refs.downloadCount.textContent = this.pack.apmInstallSource.sha.substr(0, 8);
      }

      this.updateSettingsState();
      this.updateInstalledState();
      this.updateDisabledState();
      this.updateDeprecatedState();
    }
  }, {
    key: 'updateSettingsState',
    value: function updateSettingsState() {
      if (this.hasSettings() && !this.onSettingsView) {
        this.refs.settingsButton.style.display = '';
      } else {
        this.refs.settingsButton.style.display = 'none';
      }
    }

    // Section: disabled state updates

  }, {
    key: 'updateDisabledState',
    value: function updateDisabledState() {
      if (this.isDisabled()) {
        this.displayDisabledState();
      } else if (this.element.classList.contains('disabled')) {
        this.displayEnabledState();
      }
    }
  }, {
    key: 'displayEnabledState',
    value: function displayEnabledState() {
      this.element.classList.remove('disabled');
      if (this.type === 'theme') {
        this.refs.enablementButton.style.display = 'none';
      }
      this.refs.enablementButton.querySelector('.disable-text').textContent = 'Disable';
      this.refs.enablementButton.classList.add('icon-playback-pause');
      this.refs.enablementButton.classList.remove('icon-playback-play');
      this.refs.statusIndicator.classList.remove('is-disabled');
    }
  }, {
    key: 'displayDisabledState',
    value: function displayDisabledState() {
      this.element.classList.add('disabled');
      this.refs.enablementButton.querySelector('.disable-text').textContent = 'Enable';
      this.refs.enablementButton.classList.add('icon-playback-play');
      this.refs.enablementButton.classList.remove('icon-playback-pause');
      this.refs.statusIndicator.classList.add('is-disabled');
      if (this.isDeprecated()) {
        this.refs.enablementButton.disabled = true;
      } else {
        this.refs.enablementButton.disabled = false;
      }
    }

    // Section: installed state updates

  }, {
    key: 'updateInstalledState',
    value: function updateInstalledState() {
      if (this.isInstalled()) {
        this.displayInstalledState();
      } else {
        this.displayNotInstalledState();
      }
    }
  }, {
    key: 'displayInstalledState',
    value: function displayInstalledState() {
      if (this.newVersion || this.newSha) {
        this.refs.updateButtonGroup.style.display = '';
        if (this.newVersion) {
          this.refs.updateButton.textContent = 'Update to ' + this.newVersion;
        } else if (this.newSha) {
          this.refs.updateButton.textContent = 'Update to ' + this.newSha.substr(0, 8);
        }
      } else {
        this.refs.updateButtonGroup.style.display = 'none';
      }

      this.refs.installButtonGroup.style.display = 'none';
      this.refs.installAlternativeButtonGroup.style.display = 'none';
      this.refs.packageActionButtonGroup.style.display = '';
      this.refs.uninstallButton.style.display = '';
    }
  }, {
    key: 'displayNotInstalledState',
    value: function displayNotInstalledState() {
      var _this4 = this;

      this.refs.uninstallButton.style.display = 'none';
      var atomVersion = this.packageManager.normalizeVersion(atom.getVersion());
      if (!this.packageManager.satisfiesVersion(atomVersion, this.pack)) {
        this.hasCompatibleVersion = false;
        this.setNotInstalledStateButtons();
        this.locateCompatiblePackageVersion(function () {
          _this4.setNotInstalledStateButtons();
        });
      } else {
        this.setNotInstalledStateButtons();
      }
    }
  }, {
    key: 'setNotInstalledStateButtons',
    value: function setNotInstalledStateButtons() {
      if (!this.hasCompatibleVersion) {
        this.refs.installButtonGroup.style.display = 'none';
        this.refs.updateButtonGroup.style.display = 'none';
      } else if (this.newVersion || this.newSha) {
        this.refs.updateButtonGroup.style.display = '';
        this.refs.installButtonGroup.style.display = 'none';
      } else {
        this.refs.updateButtonGroup.style.display = 'none';
        this.refs.installButtonGroup.style.display = '';
      }
      this.refs.installAlternativeButtonGroup.style.display = 'none';
      this.refs.packageActionButtonGroup.style.display = 'none';
    }

    // Section: deprecated state updates

  }, {
    key: 'updateDeprecatedState',
    value: function updateDeprecatedState() {
      if (this.isDeprecated()) {
        this.displayDeprecatedState();
      } else if (this.element.classList.contains('deprecated')) {
        this.displayUndeprecatedState();
      }
    }
  }, {
    key: 'displayStats',
    value: function displayStats(options) {
      if (options && options.stats && options.stats.downloads) {
        this.refs.packageDownloads.style.display = '';
      } else {
        this.refs.packageDownloads.style.display = 'none';
      }

      if (options && options.stats && options.stats.stars) {
        this.refs.packageStars.style.display = '';
      } else {
        this.refs.packageStars.style.display = 'none';
      }
    }
  }, {
    key: 'displayUndeprecatedState',
    value: function displayUndeprecatedState() {
      this.element.classList.remove('deprecated');
      this.refs.packageMessage.classList.remove('text-warning');
      this.refs.packageMessage.textContent = '';
    }
  }, {
    key: 'displayDeprecatedState',
    value: function displayDeprecatedState() {
      this.element.classList.add('deprecated');
      this.refs.settingsButton.disabled = true;

      var info = this.getDeprecatedPackageMetadata();
      this.refs.packageMessage.classList.add('text-warning');

      var message = null;
      if (info && info.hasDeprecations) {
        message = this.getDeprecationMessage(this.newVersion);
      } else if (info && info.hasAlternative && info.alternative === 'core') {
        message = info.message != null ? info.message : 'The features in `' + this.pack.name + '` have been added to core.';
        message += ' Please uninstall this package.';
        this.refs.settingsButton.remove();
        this.refs.enablementButton.remove();
      } else if (info && info.hasAlternative && info.alternative) {
        var alt = info.alternative;
        var isInstalled = this.isInstalled();
        if (isInstalled && this.packageManager.isPackageInstalled(alt)) {
          message = '`' + this.pack.name + '` has been replaced by `' + alt + '` which is already installed. Please uninstall this package.';
          this.refs.settingsButton.remove();
          this.refs.enablementButton.remove();
        } else if (isInstalled) {
          message = '`' + this.pack.name + '` has been replaced by [`' + alt + '`](atom://config/install/package:' + alt + ').';
          this.refs.installAlternativeButton.textContent = 'Install ' + alt;
          this.refs.installAlternativeButtonGroup.style.display = '';
          this.refs.packageActionButtonGroup.style.display = '';
          this.refs.settingsButton.remove();
          this.refs.enablementButton.remove();
        } else {
          message = '`' + this.pack.name + '` has been replaced by [`' + alt + '`](atom://config/install/package:' + alt + ').';
          this.refs.installButtonGroup.style.display = 'none';
          this.refs.installAlternativeButtonGroup.style.display = 'none';
          this.refs.packageActionButtonGroup.style.display = 'none';
        }
      }

      if (message != null) {
        if (marked == null) {
          marked = require('marked');
        }

        this.refs.packageMessage.innerHTML = marked(message);
      }
    }
  }, {
    key: 'displayGitPackageInstallInformation',
    value: function displayGitPackageInstallInformation() {
      this.refs.metaUserContainer.remove();
      this.refs.statsContainer.remove();
      var gitUrlInfo = this.pack.gitUrlInfo;

      if (gitUrlInfo['default'] === 'shortcut') {
        this.refs.packageDescription.textContent = gitUrlInfo.https();
      } else {
        this.refs.packageDescription.textContent = gitUrlInfo.toString();
      }
      this.refs.installButton.classList.remove('icon-cloud-download');
      this.refs.installButton.classList.add('icon-git-commit');
      this.refs.updateButton.classList.remove('icon-cloud-download');
      this.refs.updateButton.classList.add('icon-git-commit');
    }
  }, {
    key: 'displayAvailableUpdate',
    value: function displayAvailableUpdate(newVersion) {
      this.newVersion = newVersion;
      this.updateInterfaceState();
    }
  }, {
    key: 'getDeprecationMessage',
    value: function getDeprecationMessage(newVersion) {
      var info = this.getDeprecatedPackageMetadata();
      if (!info || !info.hasDeprecations) {
        return;
      }

      if (newVersion) {
        if (this.isDeprecated(newVersion)) {
          return 'An update to `v' + newVersion + '` is available but still contains deprecations.';
        } else {
          return 'An update to `v' + newVersion + '` is available without deprecations.';
        }
      } else {
        if (this.isInstalled()) {
          return info.message != null ? info.message : 'This package has not been loaded due to using deprecated APIs. There is no update available.';
        } else {
          return 'This package has deprecations and is not installable.';
        }
      }
    }
  }, {
    key: 'handlePackageEvents',
    value: function handlePackageEvents() {
      var _this5 = this;

      var version = undefined;
      this.disposables.add(atom.packages.onDidDeactivatePackage(function (pack) {
        if (pack.name === _this5.pack.name) {
          _this5.updateDisabledState();
        }
      }));

      this.disposables.add(atom.packages.onDidActivatePackage(function (pack) {
        if (pack.name === _this5.pack.name) {
          _this5.updateDisabledState();
        }
      }));

      this.disposables.add(atom.config.onDidChange('core.disabledPackages', function () {
        _this5.updateDisabledState();
      }));

      this.subscribeToPackageEvent('package-installing theme-installing', function () {
        _this5.updateInterfaceState();
        _this5.refs.installButton.disabled = true;
        _this5.refs.installButton.classList.add('is-installing');
      });

      this.subscribeToPackageEvent('package-updating theme-updating', function () {
        _this5.updateInterfaceState();
        _this5.refs.updateButton.disabled = true;
        _this5.refs.updateButton.classList.add('is-installing');
      });

      this.subscribeToPackageEvent('package-installing-alternative', function () {
        _this5.updateInterfaceState();
        _this5.refs.installAlternativeButton.disabled = true;
        _this5.refs.installAlternativeButton.classList.add('is-installing');
      });

      this.subscribeToPackageEvent('package-uninstalling theme-uninstalling', function () {
        _this5.updateInterfaceState();
        _this5.refs.enablementButton.disabled = true;
        _this5.refs.uninstallButton.disabled = true;
        _this5.refs.uninstallButton.classList.add('is-uninstalling');
      });

      this.subscribeToPackageEvent('package-installed package-install-failed theme-installed theme-install-failed', function () {
        var loadedPack = atom.packages.getLoadedPackage(_this5.pack.name);
        var version = loadedPack && loadedPack.metadata ? loadedPack.metadata.version : null;
        if (version) {
          _this5.pack.version = version;
        }
        _this5.refs.installButton.disabled = false;
        _this5.refs.installButton.classList.remove('is-installing');
        _this5.updateInterfaceState();
      });

      this.subscribeToPackageEvent('package-updated theme-updated', function () {
        var loadedPack = atom.packages.getLoadedPackage(_this5.pack.name);
        var metadata = loadedPack ? loadedPack.metadata : null;
        if (metadata && metadata.version) {
          _this5.pack.version = metadata.version;
        }

        if (metadata && metadata.apmInstallSource) {
          _this5.pack.apmInstallSource = metadata.apmInstallSource;
        }

        _this5.newVersion = null;
        _this5.newSha = null;
        _this5.refs.updateButton.disabled = false;
        _this5.refs.updateButton.classList.remove('is-installing');
        _this5.updateInterfaceState();
      });

      this.subscribeToPackageEvent('package-update-failed theme-update-failed', function () {
        _this5.refs.updateButton.disabled = false;
        _this5.refs.updateButton.classList.remove('is-installing');
        _this5.updateInterfaceState();
      });

      this.subscribeToPackageEvent('package-uninstalled package-uninstall-failed theme-uninstalled theme-uninstall-failed', function () {
        _this5.newVersion = null;
        _this5.newSha = null;
        _this5.refs.enablementButton.disabled = false;
        _this5.refs.uninstallButton.disabled = false;
        _this5.refs.uninstallButton.classList.remove('is-uninstalling');
        _this5.updateInterfaceState();
      });

      this.subscribeToPackageEvent('package-installed-alternative package-install-alternative-failed', function () {
        _this5.refs.installAlternativeButton.disabled = false;
        _this5.refs.installAlternativeButton.classList.remove('is-installing');
        _this5.updateInterfaceState();
      });
    }
  }, {
    key: 'isInstalled',
    value: function isInstalled() {
      return this.packageManager.isPackageInstalled(this.pack.name);
    }
  }, {
    key: 'isDisabled',
    value: function isDisabled() {
      return atom.packages.isPackageDisabled(this.pack.name);
    }
  }, {
    key: 'isDeprecated',
    value: function isDeprecated(version) {
      var packVersion = version != null ? version : this.pack.version;
      return atom.packages.isDeprecatedPackage(this.pack.name, packVersion);
    }
  }, {
    key: 'getDeprecatedPackageMetadata',
    value: function getDeprecatedPackageMetadata() {
      return atom.packages.getDeprecatedPackageMetadata(this.pack.name);
    }
  }, {
    key: 'hasSettings',
    value: function hasSettings() {
      return this.packageManager.packageHasSettings(this.pack.name);
    }
  }, {
    key: 'subscribeToPackageEvent',
    value: function subscribeToPackageEvent(event, callback) {
      var _this6 = this;

      this.disposables.add(this.packageManager.on(event, function (_ref) {
        var pack = _ref.pack;
        var error = _ref.error;

        if (pack.pack != null) {
          pack = pack.pack;
        }

        var packageName = pack.name;
        if (packageName === _this6.pack.name) {
          callback(pack, error);
        }
      }));
    }

    /*
    Section: Methods that should be on a Package model
    */

  }, {
    key: 'install',
    value: function install() {
      var _this7 = this;

      this.packageManager.install(this.installablePack != null ? this.installablePack : this.pack, function (error) {
        if (error != null) {
          console.error('Installing ' + _this7.type + ' ' + _this7.pack.name + ' failed', error.stack != null ? error.stack : error, error.stderr);
        } else {
          // if a package was disabled before installing it, re-enable it
          if (_this7.isDisabled()) {
            atom.packages.enablePackage(_this7.pack.name);
          }
        }
      });
    }
  }, {
    key: 'update',
    value: function update() {
      var _this8 = this;

      if (!this.newVersion && !this.newSha) {
        return;
      }

      var pack = this.installablePack != null ? this.installablePack : this.pack;
      var version = this.newVersion ? 'v' + this.newVersion : '#' + this.newSha.substr(0, 8);
      return new Promise(function (resolve, reject) {
        _this8.packageManager.update(pack, _this8.newVersion, function (error) {
          if (error != null) {
            atom.assert(false, 'Package update failed', function (assertionError) {
              assertionError.metadata = {
                type: _this8.type,
                name: pack.name,
                version: version,
                errorMessage: error.message,
                errorStack: error.stack,
                errorStderr: error.stderr
              };
            });
            console.error('Updating ' + _this8.type + ' ' + pack.name + ' to ' + version + ' failed:\n', error, error.stderr != null ? error.stderr : '');
            reject(error);
          } else {
            resolve();
          }
        });
      });
    }
  }, {
    key: 'uninstall',
    value: function uninstall() {
      var _this9 = this;

      this.packageManager.uninstall(this.pack, function (error) {
        if (error != null) {
          console.error('Uninstalling ' + _this9.type + ' ' + _this9.pack.name + ' failed', error.stack != null ? error.stack : error, error.stderr);
        }
      });
    }
  }, {
    key: 'installAlternative',
    value: function installAlternative() {
      var _this10 = this;

      var metadata = this.getDeprecatedPackageMetadata();
      var loadedPack = atom.packages.getLoadedPackage(metadata ? metadata.alternative : null);
      if (!metadata || !metadata.hasAlternative || metadata.alternative === 'core' || loadedPack) {
        return;
      }

      this.packageManager.installAlternative(this.pack, metadata.alternative, function (error, _ref2) {
        var pack = _ref2.pack;
        var alternative = _ref2.alternative;

        if (error != null) {
          console.error('Installing alternative `' + alternative + '` ' + _this10.type + ' for ' + _this10.pack.name + ' failed', error.stack != null ? error.stack : error, error.stderr);
        }
      });
    }
  }]);

  return PackageCard;
})();

exports['default'] = PackageCard;
module.exports = exports['default'];
/* A transparent gif so there is no "broken border" */
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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