(function() {
  var ListView;

  module.exports = ListView = (function() {
    function ListView(list, container, createView) {
      this.list = list;
      this.container = container;
      this.createView = createView;
      this.views = [];
      this.viewMap = {};
      this.list.onDidAddItem((function(_this) {
        return function(item) {
          return _this.addView(item);
        };
      })(this));
      this.list.onDidRemoveItem((function(_this) {
        return function(item) {
          return _this.removeView(item);
        };
      })(this));
      this.addViews();
    }

    ListView.prototype.getViews = function() {
      return this.views;
    };

    ListView.prototype.filterViews = function(filterFn) {
      var i, item, len, ref, results;
      ref = this.list.filterItems(filterFn);
      results = [];
      for (i = 0, len = ref.length; i < len; i++) {
        item = ref[i];
        results.push(this.viewMap[this.list.keyForItem(item)]);
      }
      return results;
    };

    ListView.prototype.addViews = function() {
      var i, item, len, ref;
      ref = this.list.getItems();
      for (i = 0, len = ref.length; i < len; i++) {
        item = ref[i];
        this.addView(item);
      }
    };

    ListView.prototype.addView = function(item) {
      var row, view;
      view = this.createView(item);
      this.views.push(view);
      this.viewMap[this.list.keyForItem(item)] = view;
      row = document.createElement('div');
      row.classList.add('row');
      row.appendChild(view.element);
      return this.container.insertBefore(row, this.container.children[0]);
    };

    ListView.prototype.removeView = function(item) {
      var index, key, view;
      key = this.list.keyForItem(item);
      view = this.viewMap[key];
      if (view != null) {
        index = this.views.indexOf(view);
        if (index > -1) {
          this.views.splice(index, 1);
        }
        delete this.viewMap[key];
        view.element.parentElement.remove();
        return view.destroy();
      }
    };

    return ListView;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
