Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var KeybindingsPanel = (function () {
  function KeybindingsPanel() {
    var _this = this;

    _classCallCheck(this, KeybindingsPanel);

    _etch2['default'].initialize(this);
    this.disposables = new _atom.CompositeDisposable();
    this.disposables.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));
    this.otherPlatformPattern = new RegExp('\\.platform-(?!' + _underscorePlus2['default'].escapeRegExp(process.platform) + '\\b)');
    this.platformPattern = new RegExp('\\.platform-' + _underscorePlus2['default'].escapeRegExp(process.platform) + '\\b');

    this.disposables.add(this.refs.searchEditor.onDidStopChanging(function () {
      _this.filterKeyBindings(_this.keyBindings, _this.refs.searchEditor.getText());
    }));

    this.disposables.add(atom.keymaps.onDidReloadKeymap(function () {
      _this.loadKeyBindings();
    }));
    this.disposables.add(atom.keymaps.onDidUnloadKeymap(function () {
      _this.loadKeyBindings();
    }));
    this.loadKeyBindings();
  }

  _createClass(KeybindingsPanel, [{
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'panels-item', tabIndex: '-1' },
        _etch2['default'].dom(
          'section',
          { className: 'keybinding-panel section' },
          _etch2['default'].dom(
            'div',
            { className: 'section-heading icon icon-keyboard' },
            'Keybindings'
          ),
          _etch2['default'].dom(
            'div',
            { className: 'text native-key-bindings', tabIndex: '-1' },
            _etch2['default'].dom('span', { className: 'icon icon-question' }),
            _etch2['default'].dom(
              'span',
              null,
              'You can override these keybindings by copying '
            ),
            _etch2['default'].dom('span', { className: 'icon icon-clippy' }),
            _etch2['default'].dom(
              'span',
              null,
              'and pasting them into '
            ),
            _etch2['default'].dom(
              'a',
              { className: 'link', onclick: this.didClickOpenKeymapFile },
              'your keymap file'
            )
          ),
          _etch2['default'].dom(
            'div',
            { className: 'editor-container' },
            _etch2['default'].dom(_atom.TextEditor, { mini: true, ref: 'searchEditor', placeholderText: 'Search keybindings' })
          ),
          _etch2['default'].dom(
            'table',
            { className: 'native-key-bindings table text', tabIndex: '-1' },
            _etch2['default'].dom('col', { className: 'keystroke' }),
            _etch2['default'].dom('col', { className: 'command' }),
            _etch2['default'].dom('col', { className: 'source' }),
            _etch2['default'].dom('col', { className: 'selector' }),
            _etch2['default'].dom(
              'thead',
              null,
              _etch2['default'].dom(
                'tr',
                null,
                _etch2['default'].dom(
                  'th',
                  { className: 'keystroke' },
                  'Keystroke'
                ),
                _etch2['default'].dom(
                  'th',
                  { className: 'command' },
                  'Command'
                ),
                _etch2['default'].dom(
                  'th',
                  { className: 'source' },
                  'Source'
                ),
                _etch2['default'].dom(
                  'th',
                  { className: 'selector' },
                  'Selector'
                )
              )
            ),
            _etch2['default'].dom('tbody', { ref: 'keybindingRows' })
          )
        )
      );
    }
  }, {
    key: 'loadKeyBindings',
    value: function loadKeyBindings() {
      this.refs.keybindingRows.innerHTML = '';
      this.keyBindings = _underscorePlus2['default'].sortBy(atom.keymaps.getKeyBindings(), 'keystrokes');
      this.appendKeyBindings(this.keyBindings);
      this.filterKeyBindings(this.keyBindings, this.refs.searchEditor.getText());
    }
  }, {
    key: 'focus',
    value: function focus() {
      this.refs.searchEditor.element.focus();
    }
  }, {
    key: 'show',
    value: function show() {
      this.element.style.display = '';
    }
  }, {
    key: 'filterKeyBindings',
    value: function filterKeyBindings(keyBindings, filterString) {
      this.refs.keybindingRows.innerHTML = '';
      for (var keyBinding of keyBindings) {
        var selector = keyBinding.selector;
        var keystrokes = keyBinding.keystrokes;
        var command = keyBinding.command;
        var source = keyBinding.source;

        source = KeybindingsPanel.determineSource(source);
        var searchString = ('' + selector + keystrokes + command + source).toLowerCase();
        if (!searchString) {
          continue;
        }

        var keywords = filterString.trim().toLowerCase().split(' ');
        if (keywords.every(function (keyword) {
          return searchString.indexOf(keyword) !== -1;
        })) {
          this.appendKeyBinding(keyBinding);
        }
      }
    }
  }, {
    key: 'appendKeyBindings',
    value: function appendKeyBindings(keyBindings) {
      for (var keyBinding of keyBindings) {
        this.appendKeyBinding(keyBinding);
      }
    }
  }, {
    key: 'appendKeyBinding',
    value: function appendKeyBinding(keyBinding) {
      if (!this.showSelector(keyBinding.selector)) {
        return;
      }

      var element = this.elementForKeyBinding(keyBinding);
      element.dataset.keyBinding = keyBinding;
      this.refs.keybindingRows.appendChild(element);
    }
  }, {
    key: 'showSelector',
    value: function showSelector(selector) {
      var _this2 = this;

      var segments = undefined;
      if (selector) {
        segments = selector.split(',') || [];
      } else {
        segments = [];
      }

      return segments.some(function (s) {
        return _this2.platformPattern.test(s) || !_this2.otherPlatformPattern.test(s);
      });
    }
  }, {
    key: 'elementForKeyBinding',
    value: function elementForKeyBinding(keyBinding) {
      var selector = keyBinding.selector;
      var keystrokes = keyBinding.keystrokes;
      var command = keyBinding.command;
      var source = keyBinding.source;

      source = KeybindingsPanel.determineSource(source);

      var tr = document.createElement('tr');
      if (source === 'User') {
        tr.classList.add('is-user');
      }

      var keystrokeTd = document.createElement('td');
      keystrokeTd.classList.add('keystroke');

      var copyIcon = document.createElement('span');
      copyIcon.classList.add('icon', 'icon-clippy', 'copy-icon');
      copyIcon.onclick = function () {
        var content = undefined;
        var keymapExtension = _path2['default'].extname(atom.keymaps.getUserKeymapPath());
        if (keymapExtension === '.cson') {
          content = '\'' + selector + '\':\n  \'' + keystrokes + '\': \'' + command + '\'';
        } else {
          content = '"' + selector + '": {\n  "' + keystrokes + '": "' + command + '"\n}';
        }
        return atom.clipboard.write(content);
      };
      keystrokeTd.appendChild(copyIcon);

      var keystrokesSpan = document.createElement('span');
      keystrokesSpan.textContent = keystrokes;
      keystrokeTd.appendChild(keystrokesSpan);
      tr.appendChild(keystrokeTd);

      var commandTd = document.createElement('td');
      commandTd.classList.add('command');
      commandTd.textContent = command;
      tr.appendChild(commandTd);

      var sourceTd = document.createElement('td');
      sourceTd.classList.add('source');
      sourceTd.textContent = source;
      tr.appendChild(sourceTd);

      var selectorTd = document.createElement('td');
      selectorTd.classList.add('selector');
      selectorTd.textContent = selector;
      tr.appendChild(selectorTd);

      return tr;
    }
  }, {
    key: 'didClickOpenKeymapFile',
    value: function didClickOpenKeymapFile(e) {
      e.preventDefault();
      atom.commands.dispatch(atom.views.getView(atom.workspace), 'application:open-your-keymap');
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }

    // Private: Returns a user friendly description of where a keybinding was
    // loaded from.
    //
    // * filePath:
    //   The absolute path from which the keymap was loaded
    //
    // Returns one of:
    // * `Core` indicates it comes from a bundled package.
    // * `User` indicates that it was defined by a user.
    // * `<package-name>` the package which defined it.
    // * `Unknown` if an invalid path was passed in.
  }], [{
    key: 'determineSource',
    value: function determineSource(filePath) {
      if (!filePath) {
        return 'Unknown';
      }

      if (filePath.indexOf(_path2['default'].join(atom.getLoadSettings().resourcePath, 'keymaps')) === 0) {
        return 'Core';
      } else if (filePath === atom.keymaps.getUserKeymapPath()) {
        return 'User';
      } else {
        var pathParts = filePath.split(_path2['default'].sep);
        var packageNameIndex = pathParts.length - 3;
        var packageName = pathParts[packageNameIndex] != null ? pathParts[packageNameIndex] : '';
        return _underscorePlus2['default'].undasherize(_underscorePlus2['default'].uncamelcase(packageName));
      }
    }
  }]);

  return KeybindingsPanel;
})();

exports['default'] = KeybindingsPanel;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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