Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var ErrorView = (function () {
  function ErrorView(packageManager, _ref) {
    var _this = this;

    var message = _ref.message;
    var stderr = _ref.stderr;
    var packageInstallError = _ref.packageInstallError;

    _classCallCheck(this, ErrorView);

    _etch2['default'].initialize(this);

    this.isOutputHidden = true;
    this.refs.detailsArea.style.display = 'none';
    this.refs.details.textContent = stderr;
    this.refs.message.textContent = message;

    // Check for native build tools and show warning if missing.
    if (packageInstallError && process.platform === 'win32') {
      packageManager.checkNativeBuildTools()['catch'](function () {
        _this.refs.alert.appendChild(new CompileToolsErrorView().element);
      });
    }
  }

  _createClass(ErrorView, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'destroy',
    value: function destroy() {
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      return _etch2['default'].dom(
        'div',
        { className: 'error-message' },
        _etch2['default'].dom(
          'div',
          { ref: 'alert', className: 'alert alert-danger alert-dismissable native-key-bindings', tabIndex: '-1' },
          _etch2['default'].dom('button', { ref: 'close', className: 'close icon icon-x', onclick: function () {
              return _this2.destroy();
            } }),
          _etch2['default'].dom('span', { ref: 'message', className: 'native-key-bindings' }),
          _etch2['default'].dom(
            'a',
            { ref: 'detailsLink', className: 'alert-link error-link', onclick: function () {
                return _this2.toggleOutput();
              } },
            'Show output…'
          ),
          _etch2['default'].dom(
            'div',
            { ref: 'detailsArea', className: 'padded' },
            _etch2['default'].dom('pre', { ref: 'details', className: 'error-details text' })
          )
        )
      );
    }
  }, {
    key: 'toggleOutput',
    value: function toggleOutput() {
      if (this.isOutputHidden) {
        this.isOutputHidden = false;
        this.refs.detailsArea.style.display = '';
        this.refs.detailsLink.textContent = 'Hide output…';
      } else {
        this.isOutputHidden = true;
        this.refs.detailsArea.style.display = 'none';
        this.refs.detailsLink.textContent = 'Show output…';
      }
    }
  }]);

  return ErrorView;
})();

exports['default'] = ErrorView;

var CompileToolsErrorView = (function () {
  function CompileToolsErrorView() {
    _classCallCheck(this, CompileToolsErrorView);

    _etch2['default'].initialize(this);
  }

  _createClass(CompileToolsErrorView, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        null,
        _etch2['default'].dom(
          'div',
          { className: 'icon icon-alert compile-tools-heading compile-tools-message' },
          'Compiler tools not found'
        ),
        _etch2['default'].dom(
          'div',
          { className: 'compile-tools-message' },
          'Packages that depend on modules that contain C/C++ code will fail to install.'
        ),
        _etch2['default'].dom(
          'div',
          { className: 'compile-tools-message' },
          _etch2['default'].dom(
            'span',
            null,
            'Read '
          ),
          _etch2['default'].dom(
            'a',
            { className: 'link', href: 'https://atom.io/docs/latest/build-instructions/windows' },
            'here'
          ),
          _etch2['default'].dom(
            'span',
            null,
            ' for instructions on installing Python and Visual Studio.'
          )
        ),
        _etch2['default'].dom(
          'div',
          { className: 'compile-tools-message' },
          _etch2['default'].dom(
            'span',
            null,
            'Run '
          ),
          _etch2['default'].dom(
            'code',
            { className: 'alert-danger' },
            'apm install --check'
          ),
          _etch2['default'].dom(
            'span',
            null,
            ' after installing to test compiling a native module.'
          )
        )
      );
    }
  }]);

  return CompileToolsErrorView;
})();

module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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