(function() {
  var KeyBindingResolverView;

  KeyBindingResolverView = require('./keybinding-resolver-view');

  module.exports = {
    keybindingResolverView: null,
    activate: function(arg) {
      var attached;
      attached = (arg != null ? arg : {}).attached;
      if (attached) {
        this.createView().toggle();
      }
      return atom.commands.add('atom-workspace', {
        'key-binding-resolver:toggle': (function(_this) {
          return function() {
            return _this.createView().toggle();
          };
        })(this),
        'core:cancel': (function(_this) {
          return function() {
            return _this.createView().detach();
          };
        })(this),
        'core:close': (function(_this) {
          return function() {
            return _this.createView().detach();
          };
        })(this)
      });
    },
    createView: function() {
      return this.keybindingResolverView != null ? this.keybindingResolverView : this.keybindingResolverView = new KeyBindingResolverView();
    },
    deactivate: function() {
      var ref;
      return (ref = this.keybindingResolverView) != null ? ref.destroy() : void 0;
    },
    serialize: function() {
      var ref;
      return (ref = this.keybindingResolverView) != null ? ref.serialize() : void 0;
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
