Object.defineProperty(exports, '__esModule', {
  value: true
});
exports.activate = activate;
exports.deactivate = deactivate;
exports.consumeStatusBar = consumeStatusBar;
exports.deserializeIncompatiblePackagesComponent = deserializeIncompatiblePackagesComponent;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/** @babel */

var _atom = require('atom');

var _viewUri = require('./view-uri');

var _viewUri2 = _interopRequireDefault(_viewUri);

var disposables = null;

function activate() {
  disposables = new _atom.CompositeDisposable();

  disposables.add(atom.workspace.addOpener(function (uri) {
    if (uri === _viewUri2['default']) {
      return deserializeIncompatiblePackagesComponent();
    }
  }));

  disposables.add(atom.commands.add('atom-workspace', {
    'incompatible-packages:view': function incompatiblePackagesView() {
      atom.workspace.open(_viewUri2['default']);
    }
  }));
}

function deactivate() {
  disposables.dispose();
}

function consumeStatusBar(statusBar) {
  var incompatibleCount = 0;
  for (var pack of atom.packages.getLoadedPackages()) {
    if (!pack.isCompatible()) incompatibleCount++;
  }

  if (incompatibleCount > 0) {
    (function () {
      var icon = createIcon(incompatibleCount);
      var tile = statusBar.addRightTile({ item: icon, priority: 200 });
      icon.element.addEventListener('click', function () {
        atom.commands.dispatch(icon.element, 'incompatible-packages:view');
      });
      disposables.add(new _atom.Disposable(function () {
        return tile.destroy();
      }));
    })();
  }
}

function deserializeIncompatiblePackagesComponent() {
  var IncompatiblePackagesComponent = require('./incompatible-packages-component');
  return new IncompatiblePackagesComponent(atom.packages);
}

function createIcon(count) {
  var StatusIconComponent = require('./status-icon-component');
  return new StatusIconComponent({ count: count });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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