(function() {
  var CompositeDisposable, ImageEditor, _, imageExtensions, openURI, path;

  path = require('path');

  _ = require('underscore-plus');

  ImageEditor = require('./image-editor');

  CompositeDisposable = require('atom').CompositeDisposable;

  module.exports = {
    activate: function() {
      this.statusViewAttached = null;
      this.disposables = new CompositeDisposable;
      this.disposables.add(atom.workspace.addOpener(openURI));
      return this.disposables.add(atom.workspace.onDidChangeActivePaneItem((function(_this) {
        return function() {
          return _this.attachImageEditorStatusView();
        };
      })(this)));
    },
    deactivate: function() {
      var ref;
      if ((ref = this.statusViewAttached) != null) {
        ref.destroy();
      }
      return this.disposables.dispose();
    },
    consumeStatusBar: function(statusBar) {
      this.statusBar = statusBar;
      return this.attachImageEditorStatusView();
    },
    attachImageEditorStatusView: function() {
      var ImageEditorStatusView;
      if (this.statusViewAttached) {
        return;
      }
      if (this.statusBar == null) {
        return;
      }
      if (!(atom.workspace.getActivePaneItem() instanceof ImageEditor)) {
        return;
      }
      ImageEditorStatusView = require('./image-editor-status-view');
      this.statusViewAttached = new ImageEditorStatusView(this.statusBar);
      return this.statusViewAttached.attach();
    },
    deserialize: function(state) {
      return ImageEditor.deserialize(state);
    }
  };

  imageExtensions = ['.bmp', '.gif', '.ico', '.jpeg', '.jpg', '.png', '.webp'];

  openURI = function(uriToOpen) {
    var uriExtension;
    uriExtension = path.extname(uriToOpen).toLowerCase();
    if (_.include(imageExtensions, uriExtension)) {
      return new ImageEditor(uriToOpen);
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
