Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _atom = require('atom');

'use babel';

var GoToLineView = (function () {
  function GoToLineView() {
    var _this = this;

    _classCallCheck(this, GoToLineView);

    this.miniEditor = new _atom.TextEditor({ mini: true });
    this.miniEditor.element.addEventListener('blur', this.close.bind(this));

    this.message = document.createElement('div');
    this.message.classList.add('message');

    this.element = document.createElement('div');
    this.element.classList.add('go-to-line');
    this.element.appendChild(this.miniEditor.element);
    this.element.appendChild(this.message);

    this.panel = atom.workspace.addModalPanel({
      item: this,
      visible: false
    });
    atom.commands.add('atom-text-editor', 'go-to-line:toggle', function () {
      _this.toggle();
      return false;
    });
    atom.commands.add(this.miniEditor.element, 'core:confirm', function () {
      _this.confirm();
    });
    atom.commands.add(this.miniEditor.element, 'core:cancel', function () {
      _this.close();
    });
    this.miniEditor.onWillInsertText(function (arg) {
      if (arg.text.match(/[^0-9:]/)) {
        arg.cancel();
      }
    });
  }

  _createClass(GoToLineView, [{
    key: 'toggle',
    value: function toggle() {
      this.panel.isVisible() ? this.close() : this.open();
    }
  }, {
    key: 'close',
    value: function close() {
      if (!this.panel.isVisible()) return;
      this.miniEditor.setText('');
      this.panel.hide();
      if (this.miniEditor.element.hasFocus()) {
        this.restoreFocus();
      }
    }
  }, {
    key: 'confirm',
    value: function confirm() {
      var lineNumber = this.miniEditor.getText();
      var editor = atom.workspace.getActiveTextEditor();
      this.close();
      if (!editor || !lineNumber.length) return;

      var currentRow = editor.getCursorBufferPosition().row;
      var rowLineNumber = lineNumber.split(/:+/)[0] || '';
      var row = rowLineNumber.length > 0 ? parseInt(rowLineNumber) - 1 : currentRow;
      var columnLineNumber = lineNumber.split(/:+/)[1] || '';
      var column = columnLineNumber.length > 0 ? parseInt(columnLineNumber) - 1 : -1;

      var position = new _atom.Point(row, column);
      editor.setCursorBufferPosition(position);
      editor.unfoldBufferRow(row);
      if (column < 0) {
        editor.moveToFirstCharacterOfLine();
      }
      editor.scrollToBufferPosition(position, {
        center: true
      });
    }
  }, {
    key: 'storeFocusedElement',
    value: function storeFocusedElement() {
      this.previouslyFocusedElement = document.activeElement;
      return this.previouslyFocusedElement;
    }
  }, {
    key: 'restoreFocus',
    value: function restoreFocus() {
      if (this.previouslyFocusedElement && this.previouslyFocusedElement.parentElement) {
        return this.previouslyFocusedElement.focus();
      }
      atom.views.getView(atom.workspace).focus();
    }
  }, {
    key: 'open',
    value: function open() {
      if (this.panel.isVisible() || !atom.workspace.getActiveTextEditor()) return;
      this.storeFocusedElement();
      this.panel.show();
      this.message.textContent = 'Enter a <row> or <row>:<column> to go there. Examples: "3" for row 3 or "2:7" for row 2 and column 7';
      this.miniEditor.element.focus();
    }
  }]);

  return GoToLineView;
})();

exports['default'] = {
  activate: function activate() {
    return new GoToLineView();
  }
};
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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