'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _portal = require('./portal');

var _portal2 = _interopRequireDefault(_portal);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * `Panel` renders a React component into an Atom panel. Specify the
 * location via the `location` prop, and any additional options to the
 * `addXPanel` method in the `options` prop.
 *
 * You may pass a `getItem` function that takes an object with `portal` and
 * `subtree` properties. `getItem` should return an item to be added to the
 * Panel. `portal` is an instance of the Portal component, and `subtree` is the
 * rendered subtree component built from the `children` prop. The default
 * implementation simply returns the Portal instance, which contains a
 * `getElement` method (to be compatible with Atom's view system).
 *
 * You can get the underlying Atom panel via `getPanel()`, but you should
 * consider controlling the panel via React and the Panel component instead.
 */
let Panel = (_temp = _class = class Panel extends _react2.default.Component {

  componentDidMount() {
    this.setupPanel();
  }

  componentWillReceiveProps(newProps) {
    if (this.didCloseItem) {
      // eslint-disable-next-line no-console
      console.error('Unexpected update in `Panel`: the contained panel has been destroyed');
    }

    if (this.panel && this.props.visible !== newProps.visible) {
      this.panel[newProps.visible ? 'show' : 'hide']();
    }
  }

  render() {
    return _react2.default.createElement(
      _portal2.default,
      { ref: c => {
          this.portal = c;
        } },
      this.props.children
    );
  }

  setupPanel() {
    if (this.panel) {
      return;
    }

    // "left" => "Left"
    const location = this.props.location.substr(0, 1).toUpperCase() + this.props.location.substr(1);
    const methodName = `add${location}Panel`;

    const item = this.props.getItem({ portal: this.portal, subtree: this.portal.getRenderedSubtree() });
    const options = _extends({}, this.props.options, { visible: this.props.visible, item });
    this.panel = this.props.workspace[methodName](options);
    this.subscriptions = this.panel.onDidDestroy(() => {
      this.didCloseItem = true;
      this.props.onDidClosePanel(this.panel);
    });
  }

  componentWillUnmount() {
    this.subscriptions && this.subscriptions.dispose();
    if (this.panel) {
      this.panel.destroy();
    }
  }

  getPanel() {
    return this.panel;
  }
}, _class.propTypes = {
  workspace: _propTypes2.default.object.isRequired,
  location: _propTypes2.default.oneOf(['top', 'bottom', 'left', 'right', 'header', 'footer', 'modal']).isRequired,
  children: _propTypes2.default.element.isRequired,
  getItem: _propTypes2.default.func,
  options: _propTypes2.default.object,
  onDidClosePanel: _propTypes2.default.func,
  visible: _propTypes2.default.bool
}, _class.defaultProps = {
  options: {},
  getItem: (_ref) => {
    let portal = _ref.portal,
        subtree = _ref.subtree;
    return portal;
  },
  onDidClosePanel: panel => {},
  visible: true
}, _temp);
exports.default = Panel;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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