'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _desc, _value, _class, _class2, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

var _eventKit = require('event-kit');

var _commands = require('./commands');

var _commands2 = _interopRequireDefault(_commands);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let InitDialog = (_class = (_temp = _class2 = class InitDialog extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);

    this.state = {
      initDisabled: false
    };

    this.projectHome = this.props.config.get('core.projectHome');
    this.subs = new _eventKit.CompositeDisposable();
  }

  componentDidMount() {
    if (this.projectPathEditor) {
      this.projectPathEditor.setText(this.props.config.get('core.projectHome'));
      this.projectPathModified = false;
    }

    if (this.projectPathElement) {
      setTimeout(() => this.projectPathElement.focus());
    }
  }

  render() {
    return _react2.default.createElement(
      'div',
      { className: 'github-Dialog github-Init modal' },
      _react2.default.createElement(
        _commands2.default,
        { registry: this.props.commandRegistry, target: '.github-Init' },
        _react2.default.createElement(_commands.Command, { command: 'core:cancel', callback: this.cancel }),
        _react2.default.createElement(_commands.Command, { command: 'core:confirm', callback: this.init })
      ),
      _react2.default.createElement(
        'main',
        { className: 'github-DialogInputs' },
        _react2.default.createElement(
          'label',
          { className: 'github-DialogLabel github-ProjectPath' },
          'Initialize git repository in directory',
          _react2.default.createElement('atom-text-editor', { mini: true, ref: this.editorRef(), tabIndex: '2' })
        )
      ),
      _react2.default.createElement(
        'div',
        { className: 'github-DialogButtons' },
        _react2.default.createElement(
          'button',
          { className: 'btn github-CancelButton', onClick: this.cancel, tabIndex: '3' },
          'Cancel'
        ),
        _react2.default.createElement(
          'button',
          {
            className: 'btn btn-primary icon icon-repo-create',
            onClick: this.init,
            disabled: this.state.initDisabled,
            tabIndex: '4' },
          'Init'
        )
      )
    );
  }

  init() {
    if (this.getProjectPath().length === 0) {
      return;
    }

    this.props.didAccept(this.getProjectPath());
  }

  cancel() {
    this.props.didCancel();
  }

  editorRef() {
    return element => {
      if (!element) {
        return;
      }

      this.projectPathElement = element;
      const editor = element.getModel();
      if (this.projectPathEditor !== editor) {
        this.projectPathEditor = editor;

        if (this.projectPathSubs) {
          this.projectPathSubs.dispose();
          this.subs.remove(this.projectPathSubs);
        }

        this.projectPathSubs = editor.onDidChange(this.setInitEnablement);
        this.subs.add(this.projectPathSubs);
      }
    };
  }

  getProjectPath() {
    return this.projectPathEditor ? this.projectPathEditor.getText() : '';
  }

  getRemoteUrl() {
    return this.remoteUrlEditor ? this.remoteUrlEditor.getText() : '';
  }

  setInitEnablement() {
    this.setState({ initDisabled: this.getProjectPath().length === 0 });
  }
}, _class2.propTypes = {
  config: _propTypes2.default.object.isRequired,
  commandRegistry: _propTypes2.default.object.isRequired,
  didAccept: _propTypes2.default.func,
  didCancel: _propTypes2.default.func
}, _class2.defaultProps = {
  didAccept: () => {},
  didCancel: () => {}
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'init', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'init'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'cancel', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'cancel'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'editorRef', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'editorRef'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'setInitEnablement', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'setInitEnablement'), _class.prototype)), _class);
exports.default = InitDialog;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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