'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _desc, _value, _class, _class2, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let GithubLoginView = (_class = (_temp = _class2 = class GithubLoginView extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);
    this.state = {
      loggingIn: false,
      token: ''
    };
  }

  render() {
    let subview;
    if (this.state.loggingIn) {
      subview = this.renderTokenInput();
    } else {
      subview = this.renderLogin();
    }

    return _react2.default.createElement(
      'div',
      { className: 'github-GithubLoginView' },
      subview
    );
  }

  renderLogin() {
    return _react2.default.createElement(
      'div',
      { className: 'github-GithubLoginView-Subview' },
      this.props.children,
      _react2.default.createElement(
        'button',
        { onClick: this.handleLoginClick, className: 'btn btn-primary btn-lg icon icon-octoface' },
        'Login'
      )
    );
  }

  renderTokenInput() {
    return _react2.default.createElement(
      'form',
      { className: 'github-GithubLoginView-Subview', onSubmit: this.handleSubmitToken },
      _react2.default.createElement(
        'p',
        null,
        'Step 1: Visit ',
        _react2.default.createElement(
          'a',
          { href: 'https://github.atom.io/login' },
          'github.atom.io/login'
        ),
        ' to generate an authentication token.'
      ),
      _react2.default.createElement(
        'p',
        null,
        'Step 2: Enter the token below:'
      ),
      _react2.default.createElement('input', {
        type: 'text',
        className: 'input-text native-key-bindings',
        placeholder: 'Enter your token...',
        value: this.state.token,
        onChange: this.handleTokenChange
      }),
      _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
          'button',
          { type: 'button', onClick: this.handleCancelTokenClick, className: 'btn icon inline-block-tight' },
          'Cancel'
        ),
        _react2.default.createElement('input', {
          type: 'submit',
          value: 'Login',
          onClick: this.handleSubmitTokenClick, className: 'btn btn-primary icon icon-check inline-block-tight'
        })
      )
    );
  }

  handleLoginClick() {
    this.setState({ loggingIn: true });
  }

  handleCancelTokenClick(e) {
    e.preventDefault();
    this.setState({ loggingIn: false });
  }

  handleSubmitTokenClick(e) {
    e.preventDefault();
    this.handleSubmitToken();
  }

  handleSubmitToken() {
    this.props.onLogin(this.state.token);
  }

  handleTokenChange(e) {
    this.setState({ token: e.target.value });
  }
}, _class2.propTypes = {
  children: _propTypes2.default.node,
  onLogin: _propTypes2.default.func
}, _class2.defaultProps = {
  children: _react2.default.createElement(
    'p',
    null,
    'Log in to GitHub to access PR information and more!'
  ),
  onLogin: token => {}
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'handleLoginClick', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'handleLoginClick'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'handleCancelTokenClick', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'handleCancelTokenClick'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'handleSubmitTokenClick', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'handleSubmitTokenClick'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'handleSubmitToken', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'handleSubmitToken'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'handleTokenChange', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'handleTokenChange'), _class.prototype)), _class);
exports.default = GithubLoginView;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImdpdGh1Yi1sb2dpbi12aWV3LmpzIl0sIm5hbWVzIjpbIkdpdGh1YkxvZ2luVmlldyIsIkNvbXBvbmVudCIsImNvbnN0cnVjdG9yIiwicHJvcHMiLCJjb250ZXh0Iiwic3RhdGUiLCJsb2dnaW5nSW4iLCJ0b2tlbiIsInJlbmRlciIsInN1YnZpZXciLCJyZW5kZXJUb2tlbklucHV0IiwicmVuZGVyTG9naW4iLCJjaGlsZHJlbiIsImhhbmRsZUxvZ2luQ2xpY2siLCJoYW5kbGVTdWJtaXRUb2tlbiIsImhhbmRsZVRva2VuQ2hhbmdlIiwiaGFuZGxlQ2FuY2VsVG9rZW5DbGljayIsImhhbmRsZVN1Ym1pdFRva2VuQ2xpY2siLCJzZXRTdGF0ZSIsImUiLCJwcmV2ZW50RGVmYXVsdCIsIm9uTG9naW4iLCJ0YXJnZXQiLCJ2YWx1ZSIsInByb3BUeXBlcyIsIm5vZGUiLCJmdW5jIiwiZGVmYXVsdFByb3BzIl0sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7QUFBQTs7OztBQUNBOzs7O0FBQ0E7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztJQUVxQkEsZSxnQ0FBTixNQUFNQSxlQUFOLFNBQThCLGdCQUFNQyxTQUFwQyxDQUE4Qzs7QUFXM0RDLGNBQVlDLEtBQVosRUFBbUJDLE9BQW5CLEVBQTRCO0FBQzFCLFVBQU1ELEtBQU4sRUFBYUMsT0FBYjtBQUNBLFNBQUtDLEtBQUwsR0FBYTtBQUNYQyxpQkFBVyxLQURBO0FBRVhDLGFBQU87QUFGSSxLQUFiO0FBSUQ7O0FBRURDLFdBQVM7QUFDUCxRQUFJQyxPQUFKO0FBQ0EsUUFBSSxLQUFLSixLQUFMLENBQVdDLFNBQWYsRUFBMEI7QUFDeEJHLGdCQUFVLEtBQUtDLGdCQUFMLEVBQVY7QUFDRCxLQUZELE1BRU87QUFDTEQsZ0JBQVUsS0FBS0UsV0FBTCxFQUFWO0FBQ0Q7O0FBRUQsV0FDRTtBQUFBO0FBQUEsUUFBSyxXQUFVLHdCQUFmO0FBQ0dGO0FBREgsS0FERjtBQUtEOztBQUVERSxnQkFBYztBQUNaLFdBQ0U7QUFBQTtBQUFBLFFBQUssV0FBVSxnQ0FBZjtBQUNHLFdBQUtSLEtBQUwsQ0FBV1MsUUFEZDtBQUVFO0FBQUE7QUFBQSxVQUFRLFNBQVMsS0FBS0MsZ0JBQXRCLEVBQXdDLFdBQVUsMkNBQWxEO0FBQUE7QUFBQTtBQUZGLEtBREY7QUFRRDs7QUFFREgscUJBQW1CO0FBQ2pCLFdBQ0U7QUFBQTtBQUFBLFFBQU0sV0FBVSxnQ0FBaEIsRUFBaUQsVUFBVSxLQUFLSSxpQkFBaEU7QUFDRTtBQUFBO0FBQUE7QUFBQTtBQUNnQjtBQUFBO0FBQUEsWUFBRyxNQUFLLDhCQUFSO0FBQUE7QUFBQSxTQURoQjtBQUFBO0FBQUEsT0FERjtBQUtFO0FBQUE7QUFBQTtBQUFBO0FBQUEsT0FMRjtBQVFFO0FBQ0UsY0FBSyxNQURQO0FBRUUsbUJBQVUsZ0NBRlo7QUFHRSxxQkFBWSxxQkFIZDtBQUlFLGVBQU8sS0FBS1QsS0FBTCxDQUFXRSxLQUpwQjtBQUtFLGtCQUFVLEtBQUtRO0FBTGpCLFFBUkY7QUFlRTtBQUFBO0FBQUE7QUFDRTtBQUFBO0FBQUEsWUFBUSxNQUFLLFFBQWIsRUFBc0IsU0FBUyxLQUFLQyxzQkFBcEMsRUFBNEQsV0FBVSw2QkFBdEU7QUFBQTtBQUFBLFNBREY7QUFJRTtBQUNFLGdCQUFLLFFBRFA7QUFFRSxpQkFBTSxPQUZSO0FBR0UsbUJBQVMsS0FBS0Msc0JBSGhCLEVBR3dDLFdBQVU7QUFIbEQ7QUFKRjtBQWZGLEtBREY7QUE0QkQ7O0FBR0RKLHFCQUFtQjtBQUNqQixTQUFLSyxRQUFMLENBQWMsRUFBQ1osV0FBVyxJQUFaLEVBQWQ7QUFDRDs7QUFHRFUseUJBQXVCRyxDQUF2QixFQUEwQjtBQUN4QkEsTUFBRUMsY0FBRjtBQUNBLFNBQUtGLFFBQUwsQ0FBYyxFQUFDWixXQUFXLEtBQVosRUFBZDtBQUNEOztBQUdEVyx5QkFBdUJFLENBQXZCLEVBQTBCO0FBQ3hCQSxNQUFFQyxjQUFGO0FBQ0EsU0FBS04saUJBQUw7QUFDRDs7QUFHREEsc0JBQW9CO0FBQ2xCLFNBQUtYLEtBQUwsQ0FBV2tCLE9BQVgsQ0FBbUIsS0FBS2hCLEtBQUwsQ0FBV0UsS0FBOUI7QUFDRDs7QUFHRFEsb0JBQWtCSSxDQUFsQixFQUFxQjtBQUNuQixTQUFLRCxRQUFMLENBQWMsRUFBQ1gsT0FBT1ksRUFBRUcsTUFBRixDQUFTQyxLQUFqQixFQUFkO0FBQ0Q7QUFyRzBELEMsVUFDcERDLFMsR0FBWTtBQUNqQlosWUFBVSxvQkFBVWEsSUFESDtBQUVqQkosV0FBUyxvQkFBVUs7QUFGRixDLFVBS1pDLFksR0FBZTtBQUNwQmYsWUFBVTtBQUFBO0FBQUE7QUFBQTtBQUFBLEdBRFU7QUFFcEJTLFdBQVNkLFNBQVMsQ0FBRTtBQUZBLEM7a0JBTkhQLGUiLCJmaWxlIjoiZ2l0aHViLWxvZ2luLXZpZXcuanMiLCJzb3VyY2VSb290IjoiL2hvbWUvdHJhdmlzL2J1aWxkL2F0b20vYXRvbS9vdXQvYXBwL25vZGVfbW9kdWxlcy9naXRodWIiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgUmVhY3QgZnJvbSAncmVhY3QnO1xuaW1wb3J0IFByb3BUeXBlcyBmcm9tICdwcm9wLXR5cGVzJztcbmltcG9ydCB7YXV0b2JpbmR9IGZyb20gJ2NvcmUtZGVjb3JhdG9ycyc7XG5cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIEdpdGh1YkxvZ2luVmlldyBleHRlbmRzIFJlYWN0LkNvbXBvbmVudCB7XG4gIHN0YXRpYyBwcm9wVHlwZXMgPSB7XG4gICAgY2hpbGRyZW46IFByb3BUeXBlcy5ub2RlLFxuICAgIG9uTG9naW46IFByb3BUeXBlcy5mdW5jLFxuICB9XG5cbiAgc3RhdGljIGRlZmF1bHRQcm9wcyA9IHtcbiAgICBjaGlsZHJlbjogPHA+TG9nIGluIHRvIEdpdEh1YiB0byBhY2Nlc3MgUFIgaW5mb3JtYXRpb24gYW5kIG1vcmUhPC9wPixcbiAgICBvbkxvZ2luOiB0b2tlbiA9PiB7fSxcbiAgfVxuXG4gIGNvbnN0cnVjdG9yKHByb3BzLCBjb250ZXh0KSB7XG4gICAgc3VwZXIocHJvcHMsIGNvbnRleHQpO1xuICAgIHRoaXMuc3RhdGUgPSB7XG4gICAgICBsb2dnaW5nSW46IGZhbHNlLFxuICAgICAgdG9rZW46ICcnLFxuICAgIH07XG4gIH1cblxuICByZW5kZXIoKSB7XG4gICAgbGV0IHN1YnZpZXc7XG4gICAgaWYgKHRoaXMuc3RhdGUubG9nZ2luZ0luKSB7XG4gICAgICBzdWJ2aWV3ID0gdGhpcy5yZW5kZXJUb2tlbklucHV0KCk7XG4gICAgfSBlbHNlIHtcbiAgICAgIHN1YnZpZXcgPSB0aGlzLnJlbmRlckxvZ2luKCk7XG4gICAgfVxuXG4gICAgcmV0dXJuIChcbiAgICAgIDxkaXYgY2xhc3NOYW1lPVwiZ2l0aHViLUdpdGh1YkxvZ2luVmlld1wiPlxuICAgICAgICB7c3Vidmlld31cbiAgICAgIDwvZGl2PlxuICAgICk7XG4gIH1cblxuICByZW5kZXJMb2dpbigpIHtcbiAgICByZXR1cm4gKFxuICAgICAgPGRpdiBjbGFzc05hbWU9XCJnaXRodWItR2l0aHViTG9naW5WaWV3LVN1YnZpZXdcIj5cbiAgICAgICAge3RoaXMucHJvcHMuY2hpbGRyZW59XG4gICAgICAgIDxidXR0b24gb25DbGljaz17dGhpcy5oYW5kbGVMb2dpbkNsaWNrfSBjbGFzc05hbWU9XCJidG4gYnRuLXByaW1hcnkgYnRuLWxnIGljb24gaWNvbi1vY3RvZmFjZVwiPlxuICAgICAgICAgIExvZ2luXG4gICAgICAgIDwvYnV0dG9uPlxuICAgICAgPC9kaXY+XG4gICAgKTtcbiAgfVxuXG4gIHJlbmRlclRva2VuSW5wdXQoKSB7XG4gICAgcmV0dXJuIChcbiAgICAgIDxmb3JtIGNsYXNzTmFtZT1cImdpdGh1Yi1HaXRodWJMb2dpblZpZXctU3Vidmlld1wiIG9uU3VibWl0PXt0aGlzLmhhbmRsZVN1Ym1pdFRva2VufT5cbiAgICAgICAgPHA+XG4gICAgICAgICAgU3RlcCAxOiBWaXNpdCA8YSBocmVmPVwiaHR0cHM6Ly9naXRodWIuYXRvbS5pby9sb2dpblwiPmdpdGh1Yi5hdG9tLmlvL2xvZ2luPC9hPiB0byBnZW5lcmF0ZVxuICAgICAgICAgIGFuIGF1dGhlbnRpY2F0aW9uIHRva2VuLlxuICAgICAgICA8L3A+XG4gICAgICAgIDxwPlxuICAgICAgICAgIFN0ZXAgMjogRW50ZXIgdGhlIHRva2VuIGJlbG93OlxuICAgICAgICA8L3A+XG4gICAgICAgIDxpbnB1dFxuICAgICAgICAgIHR5cGU9XCJ0ZXh0XCJcbiAgICAgICAgICBjbGFzc05hbWU9XCJpbnB1dC10ZXh0IG5hdGl2ZS1rZXktYmluZGluZ3NcIlxuICAgICAgICAgIHBsYWNlaG9sZGVyPVwiRW50ZXIgeW91ciB0b2tlbi4uLlwiXG4gICAgICAgICAgdmFsdWU9e3RoaXMuc3RhdGUudG9rZW59XG4gICAgICAgICAgb25DaGFuZ2U9e3RoaXMuaGFuZGxlVG9rZW5DaGFuZ2V9XG4gICAgICAgIC8+XG4gICAgICAgIDxkaXY+XG4gICAgICAgICAgPGJ1dHRvbiB0eXBlPVwiYnV0dG9uXCIgb25DbGljaz17dGhpcy5oYW5kbGVDYW5jZWxUb2tlbkNsaWNrfSBjbGFzc05hbWU9XCJidG4gaWNvbiBpbmxpbmUtYmxvY2stdGlnaHRcIj5cbiAgICAgICAgICAgIENhbmNlbFxuICAgICAgICAgIDwvYnV0dG9uPlxuICAgICAgICAgIDxpbnB1dFxuICAgICAgICAgICAgdHlwZT1cInN1Ym1pdFwiXG4gICAgICAgICAgICB2YWx1ZT1cIkxvZ2luXCJcbiAgICAgICAgICAgIG9uQ2xpY2s9e3RoaXMuaGFuZGxlU3VibWl0VG9rZW5DbGlja30gY2xhc3NOYW1lPVwiYnRuIGJ0bi1wcmltYXJ5IGljb24gaWNvbi1jaGVjayBpbmxpbmUtYmxvY2stdGlnaHRcIlxuICAgICAgICAgIC8+XG4gICAgICAgIDwvZGl2PlxuICAgICAgPC9mb3JtPlxuICAgICk7XG4gIH1cblxuICBAYXV0b2JpbmRcbiAgaGFuZGxlTG9naW5DbGljaygpIHtcbiAgICB0aGlzLnNldFN0YXRlKHtsb2dnaW5nSW46IHRydWV9KTtcbiAgfVxuXG4gIEBhdXRvYmluZFxuICBoYW5kbGVDYW5jZWxUb2tlbkNsaWNrKGUpIHtcbiAgICBlLnByZXZlbnREZWZhdWx0KCk7XG4gICAgdGhpcy5zZXRTdGF0ZSh7bG9nZ2luZ0luOiBmYWxzZX0pO1xuICB9XG5cbiAgQGF1dG9iaW5kXG4gIGhhbmRsZVN1Ym1pdFRva2VuQ2xpY2soZSkge1xuICAgIGUucHJldmVudERlZmF1bHQoKTtcbiAgICB0aGlzLmhhbmRsZVN1Ym1pdFRva2VuKCk7XG4gIH1cblxuICBAYXV0b2JpbmRcbiAgaGFuZGxlU3VibWl0VG9rZW4oKSB7XG4gICAgdGhpcy5wcm9wcy5vbkxvZ2luKHRoaXMuc3RhdGUudG9rZW4pO1xuICB9XG5cbiAgQGF1dG9iaW5kXG4gIGhhbmRsZVRva2VuQ2hhbmdlKGUpIHtcbiAgICB0aGlzLnNldFN0YXRlKHt0b2tlbjogZS50YXJnZXQudmFsdWV9KTtcbiAgfVxufVxuIl19