'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _desc, _value, _class, _class2, _temp; /** @jsx etch.dom */
/* eslint react/no-unknown-property: "off" */

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _coreDecorators = require('core-decorators');

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _stagingView = require('./staging-view');

var _stagingView2 = _interopRequireDefault(_stagingView);

var _gitLogo = require('./git-logo');

var _gitLogo2 = _interopRequireDefault(_gitLogo);

var _commitViewController = require('../controllers/commit-view-controller');

var _commitViewController2 = _interopRequireDefault(_commitViewController);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let GitTabView = (_class = (_temp = _class2 = class GitTabView {

  constructor(props) {
    this.props = props;
    _etch2.default.initialize(this);

    this.subscriptions = this.props.commandRegistry.add(this.element, {
      'tool-panel:unfocus': this.blur,
      'core:focus-next': this.advanceFocus,
      'core:focus-previous': this.retreatFocus
    });
  }

  update(props) {
    this.props = props;
    return _etch2.default.update(this);
  }

  render() {
    if (this.props.repository.showGitTabInit()) {
      const inProgress = this.props.repository.showGitTabInitInProgress();
      const message = this.props.repository.hasDirectory() ? 'Initialize this project directory with a git repository' : 'Initialize a new project directory with a git repository';

      return _etch2.default.dom(
        'div',
        { className: 'github-Panel is-empty', tabIndex: '-1' },
        _etch2.default.dom(
          'div',
          { ref: 'noRepoMessage', className: 'github-Panel no-repository' },
          _etch2.default.dom(
            'div',
            { className: 'large-icon' },
            _etch2.default.dom(_gitLogo2.default, null)
          ),
          _etch2.default.dom(
            'div',
            { className: 'initialize-repo-description' },
            message
          ),
          _etch2.default.dom(
            'button',
            { onclick: this.initializeRepo, disabled: inProgress, className: 'btn btn-primary' },
            inProgress ? 'Creating repository...' : 'Create repository'
          )
        )
      );
    } else {
      const isLoading = this.props.fetchInProgress || this.props.repository.showGitTabLoading();

      return _etch2.default.dom(
        'div',
        { className: (0, _classnames2.default)('github-Panel', { 'is-loading': isLoading }), tabIndex: '-1' },
        _etch2.default.dom(_stagingView2.default, {
          ref: 'stagingView',
          commandRegistry: this.props.commandRegistry,
          stagedChanges: this.props.stagedChanges,
          unstagedChanges: this.props.unstagedChanges,
          mergeConflicts: this.props.mergeConflicts,
          workingDirectoryPath: this.props.workingDirectoryPath,
          resolutionProgress: this.props.resolutionProgress,
          didSelectFilePath: this.props.didSelectFilePath,
          didSelectMergeConflictFile: this.props.didSelectMergeConflictFile,
          didDiveIntoFilePath: this.props.didDiveIntoFilePath,
          didDiveIntoMergeConflictPath: this.props.didDiveIntoMergeConflictPath,
          openFiles: this.props.openFiles,
          discardWorkDirChangesForPaths: this.props.discardWorkDirChangesForPaths,
          focusFilePatchView: this.props.focusFilePatchView,
          attemptFileStageOperation: this.props.attemptFileStageOperation,
          undoLastDiscard: this.props.undoLastDiscard,
          abortMerge: this.props.abortMerge,
          resolveAsOurs: this.props.resolveAsOurs,
          resolveAsTheirs: this.props.resolveAsTheirs,
          lastCommit: this.props.lastCommit,
          isLoading: this.props.isLoading,
          isAmending: this.props.isAmending,
          hasUndoHistory: this.props.hasUndoHistory,
          isMerging: this.props.isMerging
        }),
        _etch2.default.dom(_commitViewController2.default, {
          ref: 'commitViewController',
          stagedChangesExist: this.props.stagedChanges.length > 0,
          mergeConflictsExist: this.props.mergeConflicts.length > 0,
          prepareToCommit: this.props.prepareToCommit,
          commit: this.props.commit,
          amending: this.props.amending,
          setAmending: this.props.setAmending,
          abortMerge: this.props.abortMerge,
          branchName: this.props.branchName,
          commandRegistry: this.props.commandRegistry,
          notificationManager: this.props.notificationManager,
          mergeMessage: this.props.mergeMessage,
          isMerging: this.props.isMerging,
          isAmending: this.props.isAmending,
          isLoading: this.props.isLoading,
          lastCommit: this.props.lastCommit,
          repository: this.props.repository
        })
      );
    }
  }

  destroy() {
    this.subscriptions.dispose();
    return _etch2.default.destroy(this);
  }

  initializeRepo(event) {
    var _this = this;

    return _asyncToGenerator(function* () {
      event.preventDefault();
      yield _this.props.initializeRepo();
    })();
  }

  rememberFocus(event) {
    let currentFocus = null;

    if (this.refs.stagingView) {
      currentFocus = this.refs.stagingView.rememberFocus(event);
    }

    if (!currentFocus && this.refs.commitViewController) {
      currentFocus = this.refs.commitViewController.rememberFocus(event);
    }

    return currentFocus;
  }

  setFocus(focus) {
    if (this.refs.stagingView) {
      if (this.refs.stagingView.setFocus(focus)) {
        return true;
      }
    }

    if (this.refs.commitViewController) {
      if (this.refs.commitViewController.setFocus(focus)) {
        return true;
      }
    }

    return false;
  }

  blur() {
    this.props.workspace.getActivePane().activate();
  }

  advanceFocus() {
    if (!this.refs.stagingView.activateNextList()) {
      this.refs.commitViewController.setFocus(GitTabView.focus.EDITOR);
    }
  }

  retreatFocus() {
    var _refs = this.refs;
    const stagingView = _refs.stagingView,
          commitViewController = _refs.commitViewController;


    if (commitViewController.hasFocus()) {
      if (stagingView.activateLastList()) {
        this.setFocus(GitTabView.focus.STAGING);
      }
    } else {
      stagingView.activatePreviousList();
    }
  }

  focusAndSelectStagingItem(filePath, stagingStatus) {
    var _this2 = this;

    return _asyncToGenerator(function* () {
      yield _this2.refs.stagingView.quietlySelectItem(filePath, stagingStatus);
      _this2.setFocus(GitTabView.focus.STAGING);
    })();
  }

  hasFocus() {
    return this.element.contains(document.activeElement);
  }

  quietlySelectItem(filePath, stagingStatus) {
    return this.refs.stagingView.quietlySelectItem(filePath, stagingStatus);
  }
}, _class2.focus = _extends({}, _stagingView2.default.focus, _commitViewController2.default.focus), _temp), (_applyDecoratedDescriptor(_class.prototype, 'initializeRepo', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'initializeRepo'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'blur', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'blur'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'advanceFocus', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'advanceFocus'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'retreatFocus', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'retreatFocus'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'quietlySelectItem', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'quietlySelectItem'), _class.prototype)), _class);
exports.default = GitTabView;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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