'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _helpers = require('../helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; } /** @jsx etch.dom */
/* eslint react/no-unknown-property: "off" */

let FilePatchListItemView = class FilePatchListItemView {
  constructor(props) {
    this.props = props;
    _etch2.default.initialize(this);
    this.props.registerItemElement(this.props.filePatch, this.element);
  }

  update(props) {
    this.props = props;
    this.props.registerItemElement(this.props.filePatch, this.element);
    return _etch2.default.update(this);
  }

  render() {
    var _props = this.props;

    const filePatch = _props.filePatch,
          selected = _props.selected,
          others = _objectWithoutProperties(_props, ['filePatch', 'selected']);

    const status = _helpers.classNameForStatus[filePatch.status];
    const className = selected ? 'is-selected' : '';

    return _etch2.default.dom(
      'div',
      _extends({}, others, { className: `github-FilePatchListView-item is-${status} ${className}` }),
      _etch2.default.dom('span', { className: `github-FilePatchListView-icon icon icon-diff-${status} status-${status}` }),
      _etch2.default.dom(
        'span',
        { className: 'github-FilePatchListView-path' },
        filePatch.filePath
      )
    );
  }
};
exports.default = FilePatchListItemView;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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