'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Command = exports.default = undefined;

var _class, _temp, _class2, _temp2;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _propTypes3 = require('../prop-types');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let Commands = (_temp = _class = class Commands extends _react2.default.Component {

  render() {
    var _props = this.props;
    const registry = _props.registry,
          target = _props.target;

    return _react2.default.createElement(
      'div',
      null,
      _react2.default.Children.map(this.props.children, child => {
        return _react2.default.cloneElement(child, { registry, target });
      })
    );
  }
}, _class.propTypes = {
  registry: _propTypes2.default.object.isRequired,
  target: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes3.DOMNodePropType]).isRequired,
  children: _propTypes2.default.oneOfType([_propTypes2.default.element, _propTypes2.default.arrayOf(_propTypes2.default.element)]).isRequired
}, _temp);
exports.default = Commands;
let Command = exports.Command = (_temp2 = _class2 = class Command extends _react2.default.Component {

  componentDidMount() {
    this.registerCommand(this.props);
  }

  componentWillReceiveProps(newProps) {
    for (const prop of ['registry', 'target', 'command', 'callback']) {
      if (newProps[prop] !== this.props[prop]) {
        this.disposable.dispose();
        this.registerCommand(newProps);
      }
    }
  }

  componentWillUnmount() {
    this.disposable.dispose();
  }

  registerCommand(_ref) {
    let registry = _ref.registry,
        target = _ref.target,
        command = _ref.command,
        callback = _ref.callback;

    this.disposable = registry.add(target, command, callback);
  }

  render() {
    return null;
  }
}, _class2.propTypes = {
  registry: _propTypes2.default.object,
  target: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes3.DOMNodePropType]),
  command: _propTypes2.default.string.isRequired,
  callback: _propTypes2.default.func.isRequired
}, _temp2);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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