'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _helpers = require('../../helpers');

var _state = require('./state');

var _state2 = _interopRequireDefault(_state);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

/**
 * Git is asynchronously cloning a repository into this working directory.
 */
let Cloning = class Cloning extends _state2.default {
  constructor(repository, remoteUrl) {
    super(repository);
    this.remoteUrl = remoteUrl;
  }

  start() {
    var _this = this;

    return _asyncToGenerator(function* () {
      yield (0, _helpers.mkdirs)(_this.workdir());
      yield _this.doClone(_this.remoteUrl, { recursive: true });

      yield _this.transitionTo('Loading');
    })();
  }

  showGitTabLoading() {
    return true;
  }

  directClone(remoteUrl, options) {
    return this.git().clone(remoteUrl, options);
  }
};
exports.default = Cloning;


_state2.default.register(Cloning);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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