'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _eventKit = require('event-kit');

var _nsfw = require('nsfw');

var _nsfw2 = _interopRequireDefault(_nsfw);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _eventLogger = require('./event-logger');

var _eventLogger2 = _interopRequireDefault(_eventLogger);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

let FileSystemChangeObserver = class FileSystemChangeObserver {
  constructor(repository) {
    this.emitter = new _eventKit.Emitter();
    this.repository = repository;
    this.logger = new _eventLogger2.default('fs watcher');
    this.started = false;
  }

  start() {
    var _this = this;

    return _asyncToGenerator(function* () {
      yield _this.watchRepository();
      _this.started = true;
      return _this;
    })();
  }

  destroy() {
    var _this2 = this;

    return _asyncToGenerator(function* () {
      _this2.started = false;
      _this2.emitter.dispose();
      yield _this2.stopCurrentFileWatcher();
    })();
  }

  isStarted() {
    return this.started;
  }

  didChange(payload) {
    this.emitter.emit('did-change', payload);
  }

  didChangeWorkdirOrHead() {
    this.emitter.emit('did-change-workdir-or-head');
  }

  onDidChange(callback) {
    return this.emitter.on('did-change', callback);
  }

  onDidChangeWorkdirOrHead(callback) {
    return this.emitter.on('did-change-workdir-or-head', callback);
  }

  getRepository() {
    return this.repository;
  }

  watchRepository() {
    var _this3 = this;

    return _asyncToGenerator(function* () {
      if (_this3.repository) {
        _this3.currentFileWatcher = yield (0, _nsfw2.default)(_this3.repository.getWorkingDirectoryPath(), function (events) {
          const isNonGitFile = function (event) {
            return !event.directory.split(_path2.default.sep).includes('.git') && event.file !== '.git';
          };
          const isWatchedGitFile = function (event) {
            return ['config', 'index', 'HEAD', 'MERGE_HEAD'].includes(event.file || event.newFile) || event.directory.includes(_path2.default.join('.git', 'refs'));
          };
          const filteredEvents = events.filter(function (e) {
            return isNonGitFile(e) || isWatchedGitFile(e);
          });
          if (filteredEvents.length) {
            _this3.logger.showEvents(filteredEvents);
            _this3.didChange(filteredEvents);
            const workdirOrHeadEvent = filteredEvents.find(function (e) {
              return !['config', 'index'].includes(e.file || e.newFile);
            });
            if (workdirOrHeadEvent) {
              _this3.logger.showWorkdirOrHeadEvents();
              _this3.didChangeWorkdirOrHead();
            }
          }
        }, {
          debounceMS: 100,
          errorCallback: function (errors) {
            const workingDirectory = _this3.repository.getWorkingDirectoryPath();
            // eslint-disable-next-line no-console
            console.warn(`Error in FileSystemChangeObserver in ${workingDirectory}:`, errors);
            _this3.stopCurrentFileWatcher();
          }
        });
        yield _this3.currentFileWatcher.start();
        _this3.logger.showStarted(_this3.repository.getWorkingDirectoryPath());
      }
    })();
  }

  stopCurrentFileWatcher() {
    var _this4 = this;

    return _asyncToGenerator(function* () {
      if (_this4.currentFileWatcher) {
        const stopPromise = _this4.currentFileWatcher.stop();
        _this4.currentFileWatcher = null;
        yield stopPromise;
        _this4.logger.showStopped();
      }
    })();
  }
};
exports.default = FileSystemChangeObserver;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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