'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _os = require('os');

var _os2 = _interopRequireDefault(_os);

var _mkdirp = require('mkdirp');

var _mkdirp2 = _interopRequireDefault(_mkdirp);

var _discardHistoryStores = require('./discard-history-stores');

var _helpers = require('../helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

const emptyFilePath = _path2.default.join(_os2.default.tmpdir(), 'empty-file.txt');
const emptyFilePromise = (0, _helpers.writeFile)(emptyFilePath, '');

let DiscardHistory = class DiscardHistory {
  constructor(createBlob, expandBlobToFile, mergeFile, workdirPath) {
    var _ref = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : {};

    let maxHistoryLength = _ref.maxHistoryLength;

    this.createBlob = createBlob;
    this.expandBlobToFile = expandBlobToFile;
    this.mergeFile = mergeFile;
    this.workdirPath = workdirPath;
    this.partialFileHistory = new _discardHistoryStores.PartialFileDiscardHistory(maxHistoryLength);
    this.wholeFileHistory = new _discardHistoryStores.WholeFileDiscardHistory(maxHistoryLength);
  }

  getLastSnapshots() {
    let partialDiscardFilePath = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

    if (partialDiscardFilePath) {
      return this.partialFileHistory.getLastSnapshotsForPath(partialDiscardFilePath);
    } else {
      return this.wholeFileHistory.getLastSnapshots();
    }
  }

  getHistory() {
    let partialDiscardFilePath = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

    if (partialDiscardFilePath) {
      return this.partialFileHistory.getHistoryForPath(partialDiscardFilePath);
    } else {
      return this.wholeFileHistory.getHistory();
    }
  }

  hasHistory() {
    let partialDiscardFilePath = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

    const history = this.getHistory(partialDiscardFilePath);
    return history.length > 0;
  }

  popHistory() {
    let partialDiscardFilePath = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

    if (partialDiscardFilePath) {
      return this.partialFileHistory.popHistoryForPath(partialDiscardFilePath);
    } else {
      return this.wholeFileHistory.popHistory();
    }
  }

  clearHistory() {
    let partialDiscardFilePath = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

    if (partialDiscardFilePath) {
      this.partialFileHistory.clearHistoryForPath(partialDiscardFilePath);
    } else {
      this.wholeFileHistory.clearHistory();
    }
  }

  updateHistory(history) {
    this.partialFileHistory.setHistory(history.partialFileHistory || {});
    this.wholeFileHistory.setHistory(history.wholeFileHistory || []);
  }

  createHistoryBlob() {
    var _this = this;

    return _asyncToGenerator(function* () {
      const histories = {
        wholeFileHistory: _this.wholeFileHistory.getHistory(),
        partialFileHistory: _this.partialFileHistory.getHistory()
      };
      const historySha = yield _this.createBlob({ stdin: JSON.stringify(histories) });
      return historySha;
    })();
  }

  storeBeforeAndAfterBlobs(filePaths, isSafe, destructiveAction) {
    var _this2 = this;

    let partialDiscardFilePath = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
    return _asyncToGenerator(function* () {
      if (partialDiscardFilePath) {
        return yield _this2.storeBlobsForPartialFileHistory(partialDiscardFilePath, isSafe, destructiveAction);
      } else {
        return yield _this2.storeBlobsForWholeFileHistory(filePaths, isSafe, destructiveAction);
      }
    })();
  }

  storeBlobsForPartialFileHistory(filePath, isSafe, destructiveAction) {
    var _this3 = this;

    return _asyncToGenerator(function* () {
      const beforeSha = yield _this3.createBlob({ filePath });
      const isNotSafe = !(yield isSafe());
      if (isNotSafe) {
        return null;
      }
      yield destructiveAction();
      const afterSha = yield _this3.createBlob({ filePath });
      const snapshots = { beforeSha, afterSha };
      _this3.partialFileHistory.addHistory(filePath, snapshots);
      return snapshots;
    })();
  }

  storeBlobsForWholeFileHistory(filePaths, isSafe, destructiveAction) {
    var _this4 = this;

    return _asyncToGenerator(function* () {
      const snapshotsByPath = {};
      const beforePromises = filePaths.map((() => {
        var _ref2 = _asyncToGenerator(function* (filePath) {
          snapshotsByPath[filePath] = { beforeSha: yield _this4.createBlob({ filePath }) };
        });

        return function (_x8) {
          return _ref2.apply(this, arguments);
        };
      })());
      yield Promise.all(beforePromises);
      const isNotSafe = !(yield isSafe());
      if (isNotSafe) {
        return null;
      }
      yield destructiveAction();
      const afterPromises = filePaths.map((() => {
        var _ref3 = _asyncToGenerator(function* (filePath) {
          snapshotsByPath[filePath].afterSha = yield _this4.createBlob({ filePath });
        });

        return function (_x9) {
          return _ref3.apply(this, arguments);
        };
      })());
      yield Promise.all(afterPromises);
      _this4.wholeFileHistory.addHistory(snapshotsByPath);
      return snapshotsByPath;
    })();
  }

  restoreLastDiscardInTempFiles(isSafe) {
    var _this5 = this;

    let partialDiscardFilePath = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    return _asyncToGenerator(function* () {
      let lastDiscardSnapshots = _this5.getLastSnapshots(partialDiscardFilePath);
      if (partialDiscardFilePath) {
        lastDiscardSnapshots = lastDiscardSnapshots ? [lastDiscardSnapshots] : [];
      }
      const tempFolderPaths = yield _this5.expandBlobsToFilesInTempFolder(lastDiscardSnapshots);
      if (!isSafe()) {
        return [];
      }
      return yield _this5.mergeFiles(tempFolderPaths);
    })();
  }

  expandBlobsToFilesInTempFolder(snapshots) {
    var _this6 = this;

    return _asyncToGenerator(function* () {
      const tempFolderPath = yield (0, _helpers.getTempDir)('github-discard-history-');
      const pathPromises = snapshots.map((() => {
        var _ref4 = _asyncToGenerator(function* (_ref5) {
          let filePath = _ref5.filePath,
              beforeSha = _ref5.beforeSha,
              afterSha = _ref5.afterSha;

          const dir = _path2.default.dirname(_path2.default.join(tempFolderPath, filePath));
          yield (0, _mkdirp2.default)(dir);
          const theirsPath = !beforeSha ? null : yield _this6.expandBlobToFile(_path2.default.join(tempFolderPath, `${filePath}-before-discard`), beforeSha);
          const commonBasePath = !afterSha ? null : yield _this6.expandBlobToFile(_path2.default.join(tempFolderPath, `${filePath}-after-discard`), afterSha);
          const resultPath = _path2.default.join(tempFolderPath, `~${_path2.default.basename(filePath)}-merge-result`);
          return { filePath, commonBasePath, theirsPath, resultPath, theirsSha: beforeSha, commonBaseSha: afterSha };
        });

        return function (_x11) {
          return _ref4.apply(this, arguments);
        };
      })());
      return yield Promise.all(pathPromises);
    })();
  }

  mergeFiles(filePaths) {
    var _this7 = this;

    return _asyncToGenerator(function* () {
      const mergeFilePromises = filePaths.map((() => {
        var _ref6 = _asyncToGenerator(function* (filePathInfo, i) {
          const filePath = filePathInfo.filePath,
                commonBasePath = filePathInfo.commonBasePath,
                theirsPath = filePathInfo.theirsPath,
                resultPath = filePathInfo.resultPath,
                theirsSha = filePathInfo.theirsSha,
                commonBaseSha = filePathInfo.commonBaseSha;

          const currentSha = yield _this7.createBlob({ filePath });
          let mergeResult;
          if (theirsPath && commonBasePath) {
            mergeResult = yield _this7.mergeFile(filePath, commonBasePath, theirsPath, resultPath);
          } else if (!theirsPath && commonBasePath) {
            // deleted file
            const oursSha = yield _this7.createBlob({ filePath });
            if (oursSha === commonBaseSha) {
              // no changes since discard, mark file to be deleted
              mergeResult = { filePath, resultPath: null, deleted: true, conflict: false };
            } else {
              // changes since discard result in conflict
              yield (0, _helpers.copyFile)(_path2.default.join(_this7.workdirPath, filePath), resultPath);
              mergeResult = { filePath, resultPath, conflict: true };
            }
          } else if (theirsPath && !commonBasePath) {
            // added file
            const fileDoesExist = yield (0, _helpers.fileExists)(_path2.default.join(_this7.workdirPath, filePath));
            if (!fileDoesExist) {
              yield (0, _helpers.copyFile)(theirsPath, resultPath);
              mergeResult = { filePath, resultPath, conflict: false };
            } else {
              yield emptyFilePromise;
              mergeResult = yield _this7.mergeFile(filePath, emptyFilePath, theirsPath, resultPath);
            }
          } else {
            throw new Error('One of the following must be defined - theirsPath:' + `${theirsPath} or commonBasePath: ${commonBasePath}`);
          }
          return _extends({}, mergeResult, { theirsSha, commonBaseSha, currentSha });
        });

        return function (_x12, _x13) {
          return _ref6.apply(this, arguments);
        };
      })());
      return yield Promise.all(mergeFilePromises);
    })();
  }
};
exports.default = DiscardHistory;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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