'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _desc, _value, _class;

var _eventKit = require('event-kit');

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

var _coreDecorators = require('core-decorators');

var _helpers = require('./helpers');

var _workdirCache = require('./models/workdir-cache');

var _workdirCache2 = _interopRequireDefault(_workdirCache);

var _workdirContext = require('./models/workdir-context');

var _workdirContext2 = _interopRequireDefault(_workdirContext);

var _workdirContextPool = require('./models/workdir-context-pool');

var _workdirContextPool2 = _interopRequireDefault(_workdirContextPool);

var _repository = require('./models/repository');

var _repository2 = _interopRequireDefault(_repository);

var _styleCalculator = require('./models/style-calculator');

var _styleCalculator2 = _interopRequireDefault(_styleCalculator);

var _rootController = require('./controllers/root-controller');

var _rootController2 = _interopRequireDefault(_rootController);

var _issueishPaneItem = require('./atom-items/issueish-pane-item');

var _issueishPaneItem2 = _interopRequireDefault(_issueishPaneItem);

var _stubItem = require('./atom-items/stub-item');

var _stubItem2 = _interopRequireDefault(_stubItem);

var _switchboard = require('./switchboard');

var _switchboard2 = _interopRequireDefault(_switchboard);

var _yardstick = require('./yardstick');

var _yardstick2 = _interopRequireDefault(_yardstick);

var _gitTimingsView = require('./views/git-timings-view');

var _gitTimingsView2 = _interopRequireDefault(_gitTimingsView);

var _contextMenuInterceptor = require('./context-menu-interceptor');

var _contextMenuInterceptor2 = _interopRequireDefault(_contextMenuInterceptor);

var _asyncQueue = require('./async-queue');

var _asyncQueue2 = _interopRequireDefault(_asyncQueue);

var _workerManager = require('./worker-manager');

var _workerManager2 = _interopRequireDefault(_workerManager);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

const defaultState = {};

let GithubPackage = (_class = class GithubPackage {
  constructor(workspace, project, commandRegistry, notificationManager, tooltips, styles, config, confirm, configDirPath, getLoadSettings) {
    this.workspace = workspace;
    this.project = project;
    this.commandRegistry = commandRegistry;
    this.notificationManager = notificationManager;
    this.tooltips = tooltips;
    this.config = config;
    this.styles = styles;
    this.configPath = _path2.default.join(configDirPath, 'github.cson');

    this.styleCalculator = new _styleCalculator2.default(this.styles, this.config);
    this.confirm = confirm;
    this.useLegacyPanels = !this.workspace.getLeftDock || this.config.get('github.useLegacyPanels');
    this.startOpen = false;
    this.activated = false;

    const criteria = {
      projectPathCount: this.project.getPaths().length,
      initPathCount: (getLoadSettings().initialPaths || []).length
    };

    this.activeContextQueue = new _asyncQueue2.default();
    this.guessedContext = _workdirContext2.default.guess(criteria);
    this.activeContext = this.guessedContext;
    this.workdirCache = new _workdirCache2.default();
    this.contextPool = new _workdirContextPool2.default({
      window,
      workspace,
      promptCallback: query => this.controller.promptForCredentials(query)
    });

    this.switchboard = new _switchboard2.default();

    // Handle events from all resident contexts.
    this.subscriptions = new _eventKit.CompositeDisposable(this.contextPool.onDidChangeWorkdirOrHead(context => {
      this.refreshAtomGitRepository(context.getWorkingDirectory());
    }), this.contextPool.onDidUpdateRepository(context => {
      this.switchboard.didUpdateRepository(context.getRepository());
    }), this.contextPool.onDidDestroyRepository(context => {
      if (context === this.activeContext) {
        this.setActiveContext(_workdirContext2.default.absent());
      }
    }), _contextMenuInterceptor2.default);

    this.setupYardstick();
  }

  setupYardstick() {
    const stagingSeries = ['stageLine', 'stageHunk', 'unstageLine', 'unstageHunk'];

    this.subscriptions.add(
    // Staging and unstaging operations
    this.switchboard.onDidBeginStageOperation(payload => {
      if (payload.stage && payload.line) {
        _yardstick2.default.begin('stageLine');
      } else if (payload.stage && payload.hunk) {
        _yardstick2.default.begin('stageHunk');
      } else if (payload.unstage && payload.line) {
        _yardstick2.default.begin('unstageLine');
      } else if (payload.unstage && payload.hunk) {
        _yardstick2.default.begin('unstageHunk');
      }
    }), this.switchboard.onDidUpdateRepository(() => {
      _yardstick2.default.mark(stagingSeries, 'update-repository');
    }), this.switchboard.onDidFinishRender(context => {
      if (context === 'RootController.showFilePatchForPath') {
        _yardstick2.default.finish(stagingSeries);
      }
    }),

    // Active context changes
    this.switchboard.onDidScheduleActiveContextUpdate(() => {
      _yardstick2.default.begin('activeContextChange');
    }), this.switchboard.onDidBeginActiveContextUpdate(() => {
      _yardstick2.default.mark('activeContextChange', 'queue-wait');
    }), this.switchboard.onDidFinishContextChangeRender(() => {
      _yardstick2.default.mark('activeContextChange', 'render');
    }), this.switchboard.onDidFinishActiveContextUpdate(() => {
      _yardstick2.default.finish('activeContextChange');
    }));
  }

  activate() {
    var _this = this;

    let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    return _asyncToGenerator(function* () {
      _this.savedState = _extends({}, defaultState, state);

      const firstRun = !(yield (0, _helpers.fileExists)(_this.configPath));
      _this.startOpen = firstRun && !_this.config.get('welcome.showOnStartup');
      if (firstRun) {
        yield (0, _helpers.writeFile)(_this.configPath, '# Store non-visible GitHub package state.\n');
      }

      _this.subscriptions.add(atom.config.onDidChange('github.useLegacyPanels', function (_ref) {
        let newValue = _ref.newValue;

        if (newValue) {
          _this.useLegacyPanels = true;
        } else {
          // Only use new docks if they exist
          _this.useLegacyPanels = !_this.workspace.getLeftDock;
        }

        _this.rerender();
      }), _this.project.onDidChangePaths(_this.scheduleActiveContextUpdate), _this.workspace.getCenter().onDidChangeActivePaneItem(_this.scheduleActiveContextUpdate), _this.styleCalculator.startWatching('github-package-styles', ['editor.fontSize', 'editor.fontFamily', 'editor.lineHeight'], function (config) {
        return `
          .github-FilePatchView {
            font-size: 1.1em;
          }

          .github-HunkView-line {
            font-size: ${config.get('editor.fontSize')}px;
            font-family: ${config.get('editor.fontFamily')};
            line-height: ${config.get('editor.lineHeight')};
          }
        `;
      }), _this.workspace.addOpener(function (uri) {
        if (uri === 'atom-github://debug/timings') {
          return _this.createGitTimingsView();
        } else {
          return null;
        }
      }), _this.workspace.addOpener(_issueishPaneItem2.default.opener));

      _this.activated = true;
      _this.scheduleActiveContextUpdate(_this.savedState);
      _this.rerender();
    })();
  }

  serialize() {
    const activeRepository = this.getActiveRepository();
    const activeRepositoryPath = activeRepository ? activeRepository.getWorkingDirectoryPath() : null;

    return {
      activeRepositoryPath,
      gitController: this.controller.serialize(),
      firstRun: false
    };
  }

  rerender(callback) {
    if (this.workspace.isDestroyed()) {
      return;
    }

    if (!this.activated) {
      return;
    }

    if (!this.element) {
      this.element = document.createElement('div');
      this.subscriptions.add(new _eventKit.Disposable(() => {
        _reactDom2.default.unmountComponentAtNode(this.element);
        delete this.element;
      }));
    }

    _reactDom2.default.render(_react2.default.createElement(_rootController2.default, {
      ref: c => {
        this.controller = c;
      },
      workspace: this.workspace,
      commandRegistry: this.commandRegistry,
      notificationManager: this.notificationManager,
      tooltips: this.tooltips,
      config: this.config,
      confirm: this.confirm,
      activeWorkingDirectory: this.getActiveWorkdir(),
      repository: this.getActiveRepository(),
      resolutionProgress: this.getActiveResolutionProgress(),
      statusBar: this.statusBar,
      savedState: this.savedState.gitController,
      createRepositoryForProjectPath: this.createRepositoryForProjectPath,
      cloneRepositoryForProjectPath: this.cloneRepositoryForProjectPath,
      switchboard: this.switchboard,
      useLegacyPanels: this.useLegacyPanels,
      startOpen: this.startOpen
    }), this.element, callback);
  }

  deactivate() {
    var _this2 = this;

    return _asyncToGenerator(function* () {
      _this2.subscriptions.dispose();
      _this2.contextPool.clear();
      _workerManager2.default.reset(true);
      if (_this2.guessedContext) {
        _this2.guessedContext.destroy();
        _this2.guessedContext = null;
      }
      yield _yardstick2.default.flush();
    })();
  }

  consumeStatusBar(statusBar) {
    this.statusBar = statusBar;
    this.rerender();
  }

  createGitTimingsView() {
    return _gitTimingsView2.default.createPaneItem();
  }

  createIssueishPaneItem(_ref2) {
    let uri = _ref2.uri;

    return _issueishPaneItem2.default.opener(uri);
  }

  createGitTabControllerStub() {
    return _stubItem2.default.create('git-tab-controller', {
      title: 'Git'
    });
  }

  createGithubTabControllerStub() {
    return _stubItem2.default.create('github-tab-controller', {
      title: 'GitHub (preview)'
    });
  }

  createRepositoryForProjectPath(projectPath) {
    var _this3 = this;

    return _asyncToGenerator(function* () {
      yield (0, _helpers.mkdirs)(projectPath);

      const repository = _this3.contextPool.add(projectPath).getRepository();
      yield repository.init();
      _this3.workdirCache.invalidate(projectPath);

      if (!_this3.project.contains(projectPath)) {
        _this3.project.addPath(projectPath);
      }

      yield _this3.scheduleActiveContextUpdate();
    })();
  }

  cloneRepositoryForProjectPath(remoteUrl, projectPath) {
    var _this4 = this;

    return _asyncToGenerator(function* () {
      const context = _this4.contextPool.getContext(projectPath);
      const repository = context.isPresent() ? context.getRepository() : new _repository2.default(projectPath);

      yield repository.clone(remoteUrl);
      _this4.workdirCache.invalidate(projectPath);

      _this4.project.addPath(projectPath);

      yield _this4.scheduleActiveContextUpdate();
    })();
  }

  getActiveWorkdir() {
    return this.activeContext.getWorkingDirectory();
  }

  getActiveRepository() {
    return this.activeContext.getRepository();
  }

  getActiveResolutionProgress() {
    return this.activeContext.getResolutionProgress();
  }

  getContextPool() {
    return this.contextPool;
  }

  getSwitchboard() {
    return this.switchboard;
  }

  scheduleActiveContextUpdate() {
    var _this5 = this;

    let savedState = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    return _asyncToGenerator(function* () {
      _this5.switchboard.didScheduleActiveContextUpdate();
      yield _this5.activeContextQueue.push(_this5.updateActiveContext.bind(_this5, savedState), { parallel: false });
    })();
  }

  /**
   * Derive the git working directory context that should be used for the package's git operations based on the current
   * state of the Atom workspace. In priority, this prefers:
   *
   * - A git working directory that contains the active pane item in the workspace's center.
   * - A git working directory corresponding to a single Project.
   * - When initially activating the package, the working directory that was active when the package was last
   *   serialized.
   * - The current context, unchanged, which may be a `NullWorkdirContext`.
   *
   * First updates the pool of resident contexts to match all git working directories that correspond to open
   * projects and pane items.
   */
  getNextContext(savedState) {
    var _this6 = this;

    return _asyncToGenerator(function* () {
      const workdirs = new Set((yield Promise.all(_this6.project.getPaths().map((() => {
        var _ref3 = _asyncToGenerator(function* (projectPath) {
          const workdir = yield _this6.workdirCache.find(projectPath);
          return workdir || projectPath;
        });

        return function (_x3) {
          return _ref3.apply(this, arguments);
        };
      })()))));

      const fromPaneItem = (() => {
        var _ref4 = _asyncToGenerator(function* (maybeItem) {
          const itemPath = pathForPaneItem(maybeItem);

          if (!itemPath) {
            return {};
          }

          const itemWorkdir = yield _this6.workdirCache.find(itemPath);

          if (itemWorkdir && !_this6.project.contains(itemPath)) {
            workdirs.add(itemWorkdir);
          }

          return { itemPath, itemWorkdir };
        });

        return function fromPaneItem(_x4) {
          return _ref4.apply(this, arguments);
        };
      })();

      const active = yield fromPaneItem(_this6.workspace.getCenter().getActivePaneItem());

      _this6.contextPool.set(workdirs, savedState);

      if (active.itemPath) {
        // Prefer an active item
        return _this6.contextPool.getContext(active.itemWorkdir || active.itemPath);
      }

      if (_this6.project.getPaths().length === 1) {
        // Single project
        const projectPath = _this6.project.getPaths()[0];
        const activeWorkingDir = yield _this6.workdirCache.find(projectPath);
        return _this6.contextPool.getContext(activeWorkingDir || projectPath);
      }

      if (_this6.project.getPaths().length === 0 && !_this6.activeContext.getRepository().isUndetermined()) {
        // No projects. Revert to the absent context unless we've guessed that more projects are on the way.
        return _workdirContext2.default.absent();
      }

      // Restore models from saved state. Will return a NullWorkdirContext if this path is not presently
      // resident in the pool.
      const savedWorkingDir = savedState.activeRepositoryPath;
      if (savedWorkingDir) {
        return _this6.contextPool.getContext(savedWorkingDir);
      }

      return _this6.activeContext;
    })();
  }

  setActiveContext(nextActiveContext) {
    if (nextActiveContext !== this.activeContext) {
      if (this.activeContext === this.guessedContext) {
        this.guessedContext.destroy();
        this.guessedContext = null;
      }
      this.activeContext = nextActiveContext;
      this.rerender(() => {
        this.switchboard.didFinishContextChangeRender();
        this.switchboard.didFinishActiveContextUpdate();
      });
    } else {
      this.switchboard.didFinishActiveContextUpdate();
    }
  }

  updateActiveContext() {
    var _this7 = this;

    let savedState = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    return _asyncToGenerator(function* () {
      if (_this7.workspace.isDestroyed()) {
        return;
      }

      _this7.switchboard.didBeginActiveContextUpdate();

      const nextActiveContext = yield _this7.getNextContext(savedState);
      _this7.setActiveContext(nextActiveContext);
    })();
  }

  refreshAtomGitRepository(workdir) {
    const atomGitRepo = this.project.getRepositories().find(repo => {
      return repo && _path2.default.normalize(repo.getWorkingDirectory()) === workdir;
    });
    return atomGitRepo ? atomGitRepo.refreshStatus() : Promise.resolve();
  }
}, (_applyDecoratedDescriptor(_class.prototype, 'rerender', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'rerender'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'consumeStatusBar', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'consumeStatusBar'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'createGitTimingsView', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'createGitTimingsView'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'createIssueishPaneItem', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'createIssueishPaneItem'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'createGitTabControllerStub', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'createGitTabControllerStub'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'createGithubTabControllerStub', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'createGithubTabControllerStub'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'createRepositoryForProjectPath', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'createRepositoryForProjectPath'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'cloneRepositoryForProjectPath', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'cloneRepositoryForProjectPath'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'scheduleActiveContextUpdate', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'scheduleActiveContextUpdate'), _class.prototype)), _class);
exports.default = GithubPackage;


function pathForPaneItem(paneItem) {
  if (!paneItem) {
    return null;
  }

  // Likely GitHub package provided pane item
  if (typeof paneItem.getWorkingDirectory === 'function') {
    return paneItem.getWorkingDirectory();
  }

  // TextEditor-like
  if (typeof paneItem.getPath === 'function') {
    return paneItem.getPath();
  }

  // Oh well
  return null;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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