'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _desc, _value, _class, _class2, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _yubikiri = require('yubikiri');

var _yubikiri2 = _interopRequireDefault(_yubikiri);

var _coreDecorators = require('core-decorators');

var _relayNetworkLayerManager = require('../relay-network-layer-manager');

var _relayNetworkLayerManager2 = _interopRequireDefault(_relayNetworkLayerManager);

var _relayRootContainer = require('../containers/relay-root-container');

var _relayRootContainer2 = _interopRequireDefault(_relayRootContainer);

var _githubLoginModel = require('../models/github-login-model');

var _githubLoginModel2 = _interopRequireDefault(_githubLoginModel);

var _githubLoginView = require('../views/github-login-view');

var _githubLoginView2 = _interopRequireDefault(_githubLoginView);

var _observeModel = require('../views/observe-model');

var _observeModel2 = _interopRequireDefault(_observeModel);

var _issueishInfoByNumberRoute = require('../routes/issueish-info-by-number-route');

var _issueishInfoByNumberRoute2 = _interopRequireDefault(_issueishInfoByNumberRoute);

var _issueishLookupByNumberContainer = require('../containers/issueish-lookup-by-number-container');

var _issueishLookupByNumberContainer2 = _interopRequireDefault(_issueishLookupByNumberContainer);

var _relayEnvironment = require('../views/relay-environment');

var _relayEnvironment2 = _interopRequireDefault(_relayEnvironment);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let IssueishPaneItemController = (_class = (_temp = _class2 = class IssueishPaneItemController extends _react2.default.Component {
  fetchData(loginModel) {
    return (0, _yubikiri2.default)({
      token: loginModel.getToken(this.props.host)
    });
  }

  render() {
    return _react2.default.createElement(
      _observeModel2.default,
      { model: this.props.loginModel, fetchData: this.fetchData },
      this.renderWithToken
    );
  }

  renderWithToken(data) {
    if (!data) {
      return null;
    }
    if (data.token === _githubLoginModel.UNAUTHENTICATED) {
      return _react2.default.createElement(_githubLoginView2.default, { onLogin: this.handleLogin });
    }

    const route = new _issueishInfoByNumberRoute2.default({
      repoOwner: this.props.owner,
      repoName: this.props.repo,
      issueishNumber: this.props.issueishNumber
    });

    const environment = _relayNetworkLayerManager2.default.getEnvironmentForHost(this.props.host, data.token);

    const Component = _issueishLookupByNumberContainer2.default;
    return _react2.default.createElement(
      _relayEnvironment2.default,
      { environment: environment },
      _react2.default.createElement(_relayRootContainer2.default, {
        Component: Component,
        route: route,
        environment: environment,
        renderFetched: props => {
          return _react2.default.createElement(Component, _extends({}, props, { onTitleChange: this.props.onTitleChange }));
        },
        renderLoading: () => {
          return _react2.default.createElement(
            'div',
            { className: 'github-Loader' },
            _react2.default.createElement('span', { className: 'github-Spinner' })
          );
        },
        renderFailure: (err, retry) => {
          if (err.response && err.response.status === 401) {
            return _react2.default.createElement(
              'div',
              { className: 'github-GithubLoginView-Container' },
              _react2.default.createElement(
                _githubLoginView2.default,
                { onLogin: this.handleLogin },
                _react2.default.createElement(
                  'p',
                  null,
                  'The API endpoint returned a unauthorized error. Please try to re-authenticate with the endpoint.'
                )
              )
            );
          } else {
            return _react2.default.createElement(
              'div',
              null,
              'An unknown error occurred.'
            );
          }
        }
      })
    );
  }

  handleLogin(token) {
    this.props.loginModel.setToken(this.props.host, token);
  }
}, _class2.propTypes = {
  onTitleChange: _propTypes2.default.func.isRequired,
  owner: _propTypes2.default.string.isRequired,
  repo: _propTypes2.default.string.isRequired,
  issueishNumber: _propTypes2.default.number.isRequired,
  host: _propTypes2.default.string,
  loginModel: _propTypes2.default.instanceOf(_githubLoginModel2.default).isRequired
}, _class2.defaultProps = {
  host: 'api.github.com'
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'fetchData', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'fetchData'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'renderWithToken', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'renderWithToken'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'handleLogin', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'handleLogin'), _class.prototype)), _class);
exports.default = IssueishPaneItemController;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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