'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _desc, _value, _class, _class2, _temp;

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _atom = require('atom');

var _eventKit = require('event-kit');

var _coreDecorators = require('core-decorators');

var _switchboard = require('../switchboard');

var _switchboard2 = _interopRequireDefault(_switchboard);

var _filePatchView = require('../views/file-patch-view');

var _filePatchView2 = _interopRequireDefault(_filePatchView);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let FilePatchController = (_class = (_temp = _class2 = class FilePatchController extends _react2.default.Component {

  static resetConfirmedLargeFilePatches() {
    this.confirmedLargeFilePatches = new Set();
  }

  constructor(props, context) {
    super(props, context);

    this.stagingOperationInProgress = false;
    this.emitter = new _eventKit.Emitter();
  }

  serialize() {
    return null;
  }

  componentDidUpdate(prevProps) {
    if (this.getTitle(prevProps) !== this.getTitle()) {
      this.emitter.emit('did-change-title');
    }
  }

  render() {
    const hunks = this.props.filePatch.getHunks();
    if (!hunks.length) {
      return _react2.default.createElement(
        'div',
        { className: 'github-PaneView pane-item is-blank' },
        _react2.default.createElement(
          'span',
          { className: 'icon icon-info' },
          'File has no contents'
        )
      );
    } else if (!this.shouldDisplayLargeDiff(this.props.filePatch)) {
      return _react2.default.createElement(
        'div',
        { className: 'github-PaneView pane-item large-file-patch' },
        _react2.default.createElement(
          'p',
          null,
          'This is a large diff. For performance reasons, it is not rendered by default.'
        ),
        _react2.default.createElement(
          'button',
          { className: 'btn btn-primary', onClick: this.handleShowDiffClick },
          'Show Diff'
        )
      );
    } else {
      // NOTE: Outer div is required for etch to render elements correctly
      const filePath = this.props.filePatch.getPath();
      const hasUndoHistory = this.props.repository ? this.hasUndoHistory() : false;
      return _react2.default.createElement(
        'div',
        { className: 'github-PaneView pane-item' },
        _react2.default.createElement(_filePatchView2.default, {
          ref: c => {
            this.filePatchView = c;
          },
          commandRegistry: this.props.commandRegistry,
          tooltips: this.props.tooltips,
          hunks: hunks,
          filePath: filePath,
          stagingStatus: this.props.stagingStatus,
          isPartiallyStaged: this.props.isPartiallyStaged,
          attemptLineStageOperation: this.attemptLineStageOperation,
          attemptHunkStageOperation: this.attemptHunkStageOperation,
          didSurfaceFile: this.didSurfaceFile,
          didDiveIntoCorrespondingFilePatch: this.diveIntoCorrespondingFilePatch,
          switchboard: this.props.switchboard,
          openCurrentFile: this.openCurrentFile,
          discardLines: this.props.discardLines,
          undoLastDiscard: this.undoLastDiscard,
          hasUndoHistory: hasUndoHistory
        })
      );
    }
  }

  shouldDisplayLargeDiff(filePatch) {
    const fullPath = _path2.default.join(this.props.repository.getWorkingDirectoryPath(), this.props.filePatch.getPath());
    if (FilePatchController.confirmedLargeFilePatches.has(fullPath)) {
      return true;
    }

    const lineCount = filePatch.getHunks().reduce((acc, hunk) => hunk.getLines().length, 0);
    return lineCount < this.props.largeDiffLineThreshold;
  }

  onDidChangeTitle(callback) {
    return this.emitter.on('did-change-title', callback);
  }

  onDidDestroy(callback) {
    return this.emitter.on('did-destroy', callback);
  }

  handleShowDiffClick() {
    if (this.props.repository) {
      const fullPath = _path2.default.join(this.props.repository.getWorkingDirectoryPath(), this.props.filePatch.getPath());
      FilePatchController.confirmedLargeFilePatches.add(fullPath);
      this.forceUpdate();
    }
  }

  stageHunk(hunk) {
    var _this = this;

    return _asyncToGenerator(function* () {
      _this.props.switchboard.didBeginStageOperation({ stage: true, hunk: true });

      yield _this.props.repository.applyPatchToIndex(_this.props.filePatch.getStagePatchForHunk(hunk));
      _this.props.switchboard.didFinishStageOperation({ stage: true, hunk: true });
    })();
  }

  unstageHunk(hunk) {
    var _this2 = this;

    return _asyncToGenerator(function* () {
      _this2.props.switchboard.didBeginStageOperation({ unstage: true, hunk: true });

      yield _this2.props.repository.applyPatchToIndex(_this2.props.filePatch.getUnstagePatchForHunk(hunk));

      _this2.props.switchboard.didFinishStageOperation({ unstage: true, hunk: true });
    })();
  }

  stageOrUnstageHunk(hunk) {
    if (this.props.stagingStatus === 'unstaged') {
      return this.stageHunk(hunk);
    } else if (this.props.stagingStatus === 'staged') {
      return this.unstageHunk(hunk);
    } else {
      throw new Error(`Unknown stagingStatus: ${this.props.stagingStatus}`);
    }
  }

  attemptHunkStageOperation(hunk) {
    if (this.stagingOperationInProgress) {
      return;
    }

    this.stagingOperationInProgress = true;
    this.props.switchboard.getChangePatchPromise().then(() => {
      this.stagingOperationInProgress = false;
    });

    this.stageOrUnstageHunk(hunk);
  }

  stageLines(lines) {
    var _this3 = this;

    return _asyncToGenerator(function* () {
      _this3.props.switchboard.didBeginStageOperation({ stage: true, line: true });

      yield _this3.props.repository.applyPatchToIndex(_this3.props.filePatch.getStagePatchForLines(lines));

      _this3.props.switchboard.didFinishStageOperation({ stage: true, line: true });
    })();
  }

  unstageLines(lines) {
    var _this4 = this;

    return _asyncToGenerator(function* () {
      _this4.props.switchboard.didBeginStageOperation({ unstage: true, line: true });

      yield _this4.props.repository.applyPatchToIndex(_this4.props.filePatch.getUnstagePatchForLines(lines));

      _this4.props.switchboard.didFinishStageOperation({ unstage: true, line: true });
    })();
  }

  stageOrUnstageLines(lines) {
    if (this.props.stagingStatus === 'unstaged') {
      return this.stageLines(lines);
    } else if (this.props.stagingStatus === 'staged') {
      return this.unstageLines(lines);
    } else {
      throw new Error(`Unknown stagingStatus: ${this.props.stagingStatus}`);
    }
  }

  attemptLineStageOperation(lines) {
    if (this.stagingOperationInProgress) {
      return;
    }

    this.stagingOperationInProgress = true;
    this.props.switchboard.getChangePatchPromise().then(() => {
      this.stagingOperationInProgress = false;
    });

    this.stageOrUnstageLines(lines);
  }

  getTitle() {
    let props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.props;

    let title = props.stagingStatus === 'staged' ? 'Staged' : 'Unstaged';
    title += ' Changes: ';
    title += props.filePatch.getPath();
    return title;
  }

  didSurfaceFile() {
    if (this.props.didSurfaceFile) {
      this.props.didSurfaceFile(this.props.filePatch.getPath(), this.props.stagingStatus);
    }
  }

  diveIntoCorrespondingFilePatch() {
    const filePath = this.props.filePatch.getPath();
    const stagingStatus = this.props.stagingStatus === 'staged' ? 'unstaged' : 'staged';
    this.props.quietlySelectItem(filePath, stagingStatus);
    return this.props.didDiveIntoFilePath(filePath, stagingStatus, { amending: this.props.isAmending });
  }

  focus() {
    if (this.filePatchView) {
      this.filePatchView.focus();
    }
  }

  wasActivated() {
    process.nextTick(() => this.focus());
  }

  openCurrentFile() {
    var _this5 = this;

    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    let lineNumber = _ref.lineNumber;
    return _asyncToGenerator(function* () {
      var _ref2 = yield _this5.props.openFiles([_this5.props.filePatch.getPath()]),
          _ref3 = _slicedToArray(_ref2, 1);

      const textEditor = _ref3[0];

      const position = new _atom.Point(lineNumber ? lineNumber - 1 : 0, 0);
      textEditor.scrollToBufferPosition(position, { center: true });
      textEditor.setCursorBufferPosition(position);
      return textEditor;
    })();
  }

  undoLastDiscard() {
    return this.props.undoLastDiscard(this.props.filePatch.getPath());
  }

  hasUndoHistory() {
    return this.props.repository.hasDiscardHistory(this.props.filePatch.getPath());
  }

  goToDiffLine(lineNumber) {
    return this.filePatchView.goToDiffLine(lineNumber);
  }

  /**
   * Used to detect the context when this PaneItem is active
   */
  getWorkingDirectory() {
    return this.props.activeWorkingDirectory;
  }

  destroy() {
    this.emitter.emit('did-destroy');
  }
}, _class2.propTypes = {
  largeDiffLineThreshold: _propTypes2.default.number,
  activeWorkingDirectory: _propTypes2.default.string,
  repository: _propTypes2.default.object.isRequired,
  commandRegistry: _propTypes2.default.object.isRequired,
  tooltips: _propTypes2.default.object.isRequired,
  filePatch: _propTypes2.default.object.isRequired,
  stagingStatus: _propTypes2.default.oneOf(['unstaged', 'staged']).isRequired,
  isPartiallyStaged: _propTypes2.default.bool.isRequired,
  isAmending: _propTypes2.default.bool.isRequired,
  discardLines: _propTypes2.default.func.isRequired,
  didSurfaceFile: _propTypes2.default.func.isRequired,
  didDiveIntoFilePath: _propTypes2.default.func.isRequired,
  quietlySelectItem: _propTypes2.default.func.isRequired,
  undoLastDiscard: _propTypes2.default.func.isRequired,
  openFiles: _propTypes2.default.func.isRequired,
  switchboard: _propTypes2.default.instanceOf(_switchboard2.default)
}, _class2.defaultProps = {
  largeDiffLineThreshold: 1000,
  switchboard: new _switchboard2.default()
}, _class2.confirmedLargeFilePatches = new Set(), _temp), (_applyDecoratedDescriptor(_class.prototype, 'handleShowDiffClick', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'handleShowDiffClick'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'attemptHunkStageOperation', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'attemptHunkStageOperation'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'attemptLineStageOperation', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'attemptLineStageOperation'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'didSurfaceFile', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'didSurfaceFile'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'diveIntoCorrespondingFilePatch', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'diveIntoCorrespondingFilePatch'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'openCurrentFile', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'openCurrentFile'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'undoLastDiscard', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'undoLastDiscard'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'hasUndoHistory', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'hasUndoHistory'), _class.prototype)), _class);
exports.default = FilePatchController;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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