'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _desc, _value, _class, _class2, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _electron = require('electron');

var _coreDecorators = require('core-decorators');

var _source = require('../models/conflicts/source');

var _decoration = require('../views/decoration');

var _decoration2 = _interopRequireDefault(_decoration);

var _octicon = require('../views/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

const Menu = _electron.remote.Menu,
      MenuItem = _electron.remote.MenuItem;
let ConflictController = (_class = (_temp = _class2 = class ConflictController extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);

    this.state = {
      chosenSide: this.props.conflict.getChosenSide()
    };
  }

  resolveAsSequence(sources) {
    this.props.resolveAsSequence(sources);

    this.setState({
      chosenSide: this.props.conflict.getChosenSide()
    });
  }

  revert(side) {
    side.isModified() && side.revert();
    side.isBannerModified() && side.revertBanner();
  }

  showResolveMenu(event) {
    event.preventDefault();

    const menu = new Menu();

    menu.append(new MenuItem({
      label: 'Resolve as Ours',
      click: this.resolveAsSequence.bind(this, [_source.OURS])
    }));

    if (this.props.conflict.getSide(_source.BASE)) {
      menu.append(new MenuItem({
        label: 'Resolve as Base',
        click: this.resolveAsSequence.bind(this, [_source.BASE])
      }));
    }

    menu.append(new MenuItem({
      label: 'Resolve as Theirs',
      click: this.resolveAsSequence.bind(this, [_source.THEIRS])
    }));

    menu.append(new MenuItem({ type: 'separator' }));

    menu.append(new MenuItem({
      label: 'Resolve as Ours Then Theirs',
      click: this.resolveAsSequence.bind(this, [_source.OURS, _source.THEIRS])
    }));
    menu.append(new MenuItem({
      label: 'Resolve as Theirs Then Ours',
      click: this.resolveAsSequence.bind(this, [_source.THEIRS, _source.OURS])
    }));

    menu.append(new MenuItem({ type: 'separator' }));

    menu.append(new MenuItem({
      label: 'Dismiss',
      click: this.props.dismiss
    }));

    menu.popup(_electron.remote.getCurrentWindow());
  }

  render() {
    if (!this.state.chosenSide) {
      const ours = this.props.conflict.getSide(_source.OURS);
      const base = this.props.conflict.getSide(_source.BASE);
      const theirs = this.props.conflict.getSide(_source.THEIRS);

      return _react2.default.createElement(
        'div',
        null,
        this.renderSide(ours),
        base && this.renderSide(base),
        _react2.default.createElement(_decoration2.default, {
          key: this.props.conflict.getSeparator().getMarker().id,
          editor: this.props.editor,
          marker: this.props.conflict.getSeparator().getMarker(),
          type: 'line',
          className: 'github-ConflictSeparator'
        }),
        this.renderSide(theirs)
      );
    } else if (!this.state.chosenSide.isEmpty()) {
      return _react2.default.createElement(_decoration2.default, {
        editor: this.props.editor,
        marker: this.state.chosenSide.getMarker(),
        type: 'line',
        className: 'github-ResolvedLines'
      });
    } else {
      return null;
    }
  }

  renderSide(side) {
    const source = side.getSource();

    return _react2.default.createElement(
      'div',
      null,
      _react2.default.createElement(_decoration2.default, {
        key: side.banner.marker.id,
        editor: this.props.editor,
        marker: side.getBannerMarker(),
        type: 'line',
        className: side.getBannerCSSClass()
      }),
      side.isBannerModified() || _react2.default.createElement(_decoration2.default, {
        key: 'banner-modified-' + side.banner.marker.id,
        editor: this.props.editor,
        marker: side.getBannerMarker(),
        type: 'line',
        className: 'github-ConflictUnmodifiedBanner'
      }),
      _react2.default.createElement(_decoration2.default, {
        key: side.marker.id,
        editor: this.props.editor,
        marker: side.getMarker(),
        type: 'line',
        className: side.getLineCSSClass()
      }),
      _react2.default.createElement(
        _decoration2.default,
        {
          key: 'block-' + side.marker.id,
          editor: this.props.editor,
          marker: side.getBlockMarker(),
          type: 'block',
          position: side.getBlockPosition() },
        _react2.default.createElement(
          'div',
          { className: side.getBlockCSSClasses() },
          _react2.default.createElement(
            'span',
            { className: 'github-ResolutionControls' },
            _react2.default.createElement(
              'button',
              { className: 'btn btn-sm inline-block', onClick: () => this.resolveAsSequence([source]) },
              'Use me'
            ),
            (side.isModified() || side.isBannerModified()) && _react2.default.createElement(
              'button',
              { className: 'btn btn-sm inline-block', onClick: () => this.revert(side) },
              'Revert'
            ),
            _react2.default.createElement(_octicon2.default, { icon: 'ellipses', className: 'inline-block', onClick: this.showResolveMenu })
          ),
          _react2.default.createElement(
            'span',
            { className: 'github-SideDescription' },
            source.toUIString()
          )
        )
      )
    );
  }
}, _class2.propTypes = {
  editor: _propTypes2.default.object.isRequired,
  conflict: _propTypes2.default.object.isRequired,
  resolveAsSequence: _propTypes2.default.func,
  dismiss: _propTypes2.default.func
}, _class2.defaultProps = {
  resolveAsSequence: sources => {},
  dismiss: () => {}
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'showResolveMenu', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'showResolveMenu'), _class.prototype)), _class);
exports.default = ConflictController;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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