'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let ContextMenuInterceptor = (_temp = _class = class ContextMenuInterceptor extends _react2.default.Component {

  static handle(event) {
    for (const _ref of ContextMenuInterceptor.registration) {
      var _ref2 = _slicedToArray(_ref, 2);

      const element = _ref2[0];
      const callback = _ref2[1];

      if (element.contains(event.target)) {
        callback(event);
      }
    }
  }

  static dispose() {
    document.removeEventListener('contextmenu', contextMenuHandler, { capture: true });
  }

  componentDidMount() {
    var _this = this;

    // Helpfully, addEventListener dedupes listeners for us.
    document.addEventListener('contextmenu', contextMenuHandler, { capture: true });
    ContextMenuInterceptor.registration.set(this.element, function () {
      return _this.props.onWillShowContextMenu(...arguments);
    });
  }

  render() {
    return _react2.default.createElement(
      'div',
      { ref: e => {
          this.element = e;
        } },
      this.props.children
    );
  }

  componentWillUnmount() {
    ContextMenuInterceptor.registration.delete(this.element);
  }
}, _class.propTypes = {
  onWillShowContextMenu: _propTypes2.default.func.isRequired,
  children: _propTypes2.default.element.isRequired
}, _class.registration = new Map(), _temp);
exports.default = ContextMenuInterceptor;


function contextMenuHandler(event) {
  ContextMenuInterceptor.handle(event);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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