'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrSelectionByUrl = undefined;

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _reactRelay2 = _interopRequireDefault(_reactRelay);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _prInfoContainer = require('./pr-info-container');

var _prInfoContainer2 = _interopRequireDefault(_prInfoContainer);

var _prUrlInputBox = require('../views/pr-url-input-box');

var _prUrlInputBox2 = _interopRequireDefault(_prUrlInputBox);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let PrSelectionByUrl = exports.PrSelectionByUrl = (_temp = _class = class PrSelectionByUrl extends _react2.default.Component {

  render() {
    // TODO: render a selector if multiple PRs
    const resource = this.props.query && this.props.query.resource;
    if (!resource || resource.__typename !== 'PullRequest') {
      // return <div>PR not found</div>;
      return _react2.default.createElement(
        'div',
        { className: 'github-PrUrlInputBox-Container' },
        _react2.default.createElement(
          _prUrlInputBox2.default,
          { onSubmit: this.props.onSelectPr },
          _react2.default.createElement(
            'p',
            null,
            _react2.default.createElement(
              'span',
              { style: { display: 'block' } },
              'This branch is pinned to the pull request at this URL:'
            ),
            _react2.default.createElement('input', { value: this.props.prUrl, style: { width: '100%' }, readOnly: true }),
            _react2.default.createElement(
              'span',
              { style: { display: 'block' } },
              'but we couldn\'t find a pull request at that URL.'
            )
          ),
          _react2.default.createElement(
            'p',
            null,
            'You can manually pin another GitHub pull request to the current branch by entering its URL:'
          )
        )
      );
    }
    return _react2.default.createElement(_prInfoContainer2.default, {
      pullRequest: resource,
      pinnedByUrl: true,
      onUnpinPr: this.props.onUnpinPr
    });
  }

  setPr(prLink) {
    this.props.onSelectPr(prLink);
  }
}, _class.propTypes = {
  query: _propTypes2.default.shape({
    resource: _propTypes2.default.object
  }),
  prUrl: _propTypes2.default.string,
  onSelectPr: _propTypes2.default.func.isRequired,
  onUnpinPr: _propTypes2.default.func.isRequired
}, _temp);
exports.default = _reactRelay2.default.createContainer(PrSelectionByUrl, {
  initialVariables: {
    prUrl: null
  },

  fragments: {
    query: () => function (RQL_0) {
      return {
        children: [{
          calls: [{
            kind: 'Call',
            metadata: {
              type: 'URI!'
            },
            name: 'url',
            value: {
              kind: 'CallVariable',
              callVariableName: 'prUrl'
            }
          }],
          children: [{
            fieldName: '__typename',
            kind: 'Field',
            metadata: {
              isRequisite: true
            },
            type: 'String'
          }, {
            children: [].concat.apply([], [{
              fieldName: 'id',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'ID'
            }, _reactRelay2.default.QL.__frag(RQL_0)]),
            id: _reactRelay2.default.QL.__id(),
            kind: 'Fragment',
            metadata: {},
            name: 'PullRequest',
            type: 'PullRequest'
          }, {
            children: [{
              fieldName: 'id',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'ID'
            }, {
              fieldName: '__typename',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'String'
            }],
            id: _reactRelay2.default.QL.__id(),
            kind: 'Fragment',
            metadata: {
              isAbstract: true
            },
            name: 'IdFragment',
            type: 'Node'
          }],
          fieldName: 'resource',
          kind: 'Field',
          metadata: {
            canHaveSubselections: true,
            inferredRootCallName: 'node',
            inferredPrimaryKey: 'id',
            isAbstract: true
          },
          type: 'UniformResourceLocatable'
        }],
        id: _reactRelay2.default.QL.__id(),
        kind: 'Fragment',
        metadata: {},
        name: 'Pr_QueryRelayQL',
        type: 'Query'
      };
    }(_prInfoContainer2.default.getFragment('pullRequest'))
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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