'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrInfo = undefined;

var _desc, _value, _class, _class2, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _reactRelay2 = _interopRequireDefault(_reactRelay);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _coreDecorators = require('core-decorators');

var _octicon = require('../views/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

const reactionTypeToEmoji = {
  THUMBS_UP: '👍',
  THUMBS_DOWN: '👎',
  LAUGH: '😆',
  HOORAY: '🎉',
  CONFUSED: '😕',
  HEART: '❤️'
};

const prStateToIcon = {
  OPEN: 'git-pull-request',
  CLOSED: 'git-pull-request',
  MERGED: 'git-merge'
};

let PrInfo = exports.PrInfo = (_class = (_temp = _class2 = class PrInfo extends _react2.default.Component {

  render() {
    const pr = this.props.pullRequest;
    const repo = pr.repository;
    return _react2.default.createElement(
      'div',
      { className: 'github-PrInfo' },
      this.props.pinnedByUrl && this.renderPinnedPr(),
      _react2.default.createElement(
        'div',
        { className: 'pr-badge-and-link' },
        _react2.default.createElement(
          'span',
          { className: (0, _classnames2.default)('pr-badge', 'badge', pr.state.toLowerCase()) },
          _react2.default.createElement(_octicon2.default, { icon: prStateToIcon[pr.state] }),
          pr.state.toLowerCase()
        ),
        _react2.default.createElement(
          'span',
          { className: 'pr-link' },
          _react2.default.createElement(
            'a',
            { className: 'pane-item-link', href: pr.url },
            repo.owner.login,
            '/',
            repo.name,
            '#',
            pr.number
          )
        )
      ),
      _react2.default.createElement(
        'div',
        { className: 'pr-avatar-and-title' },
        _react2.default.createElement(
          'a',
          { className: 'author-avatar-link', href: pr.author.url },
          _react2.default.createElement('img', { className: 'author-avatar', src: pr.author.avatarUrl, title: pr.author.login })
        ),
        _react2.default.createElement(
          'h3',
          { className: 'pr-title' },
          pr.title
        )
      ),
      _react2.default.createElement(
        'div',
        { className: 'conversation', onClick: this.handleClickPrLink },
        _react2.default.createElement(_octicon2.default, { icon: 'comment-discussion' }),
        'Conversation'
      ),
      _react2.default.createElement(
        'div',
        { className: 'commit-count' },
        _react2.default.createElement(_octicon2.default, { icon: 'git-commit' }),
        'Commits ',
        _react2.default.createElement(
          'span',
          { className: 'count-number' },
          pr.commits.totalCount
        )
      ),
      _react2.default.createElement(
        'div',
        { className: 'labels' },
        pr.labels.edges.map((_ref) => {
          let node = _ref.node;
          const name = node.name,
                color = node.color;

          const hex = `#${color}`;
          return _react2.default.createElement(
            'span',
            { key: name, className: 'label', style: { background: hex } },
            name
          );
        })
      ),
      _react2.default.createElement(
        'div',
        { className: 'reactions' },
        pr.reactionGroups.map(group => group.users.totalCount > 0 ? _react2.default.createElement(
          'span',
          { className: (0, _classnames2.default)('reaction-group', group.content.toLowerCase()), key: group.content },
          reactionTypeToEmoji[group.content],
          ' \xA0 ',
          group.users.totalCount
        ) : null)
      )
    );
  }

  renderPinnedPr() {
    return _react2.default.createElement(
      'div',
      { className: 'pinned-pr-info' },
      _react2.default.createElement(_octicon2.default, {
        title: 'This pull request has been manually pinned to this branch. Click here to select another PR.',
        icon: 'pin',
        className: 'pinned-by-url',
        onClick: this.handleUnpinClick
      }),
      _react2.default.createElement(
        'span',
        null,
        'This pull request has been manually pinned to the current branch. You may ',
        _react2.default.createElement(
          'a',
          { href: '#', onClick: this.handleUnpinClick },
          'unpin it'
        ),
        '.'
      )
    );
  }

  handleClickPrLink(event) {
    event.nativeEvent.preventDefault();
    event.nativeEvent.stopPropagation();
    const pr = this.props.pullRequest;
    const repo = pr.repository;
    atom.workspace.open(`atom-github://issueish/https://api.github.com/${repo.owner.login}/${repo.name}/${pr.number}`);
  }

  handleUnpinClick(event) {
    event.preventDefault();
    this.props.onUnpinPr && this.props.onUnpinPr();
  }
}, _class2.propTypes = {
  pinnedByUrl: _propTypes2.default.bool,
  onUnpinPr: _propTypes2.default.func,
  pullRequest: _propTypes2.default.shape({
    title: _propTypes2.default.string,
    bodyHTML: _propTypes2.default.string,
    number: _propTypes2.default.number,
    repository: _propTypes2.default.shape({
      name: _propTypes2.default.string.isRequired,
      owner: _propTypes2.default.shape({
        login: _propTypes2.default.string
      })
    }),
    state: _propTypes2.default.oneOf(['OPEN', 'CLOSED', 'MERGED']).isRequired,
    author: _propTypes2.default.shape({
      login: _propTypes2.default.string.isRequired,
      avatarUrl: _propTypes2.default.string.isRequired,
      url: _propTypes2.default.string.isRequired
    }).isRequired,
    reactionGroups: _propTypes2.default.arrayOf(_propTypes2.default.shape({
      content: _propTypes2.default.string.isRequired,
      users: _propTypes2.default.shape({
        totalCount: _propTypes2.default.number.isRequired
      }).isRequired
    })).isRequired
  }).isRequired
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'handleClickPrLink', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'handleClickPrLink'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'handleUnpinClick', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'handleUnpinClick'), _class.prototype)), _class);
exports.default = _reactRelay2.default.createContainer(PrInfo, {
  fragments: {
    pullRequest: () => function () {
      return {
        children: [{
          fieldName: 'url',
          kind: 'Field',
          metadata: {},
          type: 'URI'
        }, {
          fieldName: 'number',
          kind: 'Field',
          metadata: {},
          type: 'Int'
        }, {
          fieldName: 'title',
          kind: 'Field',
          metadata: {},
          type: 'String'
        }, {
          fieldName: 'state',
          kind: 'Field',
          metadata: {},
          type: 'PullRequestState'
        }, {
          fieldName: 'createdAt',
          kind: 'Field',
          metadata: {},
          type: 'DateTime'
        }, {
          children: [{
            fieldName: 'login',
            kind: 'Field',
            metadata: {},
            type: 'String'
          }, {
            fieldName: 'avatarUrl',
            kind: 'Field',
            metadata: {},
            type: 'URI'
          }, {
            fieldName: '__typename',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'String'
          }, {
            children: [{
              fieldName: 'url',
              kind: 'Field',
              metadata: {},
              type: 'URI'
            }, {
              fieldName: 'id',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'ID'
            }],
            id: _reactRelay2.default.QL.__id(),
            kind: 'Fragment',
            metadata: {},
            name: 'User',
            type: 'User'
          }, {
            children: [{
              fieldName: 'url',
              kind: 'Field',
              metadata: {},
              type: 'URI'
            }, {
              fieldName: 'id',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'ID'
            }],
            id: _reactRelay2.default.QL.__id(),
            kind: 'Fragment',
            metadata: {},
            name: 'Bot',
            type: 'Bot'
          }, {
            children: [{
              fieldName: 'id',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'ID'
            }, {
              fieldName: '__typename',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'String'
            }],
            id: _reactRelay2.default.QL.__id(),
            kind: 'Fragment',
            metadata: {
              isAbstract: true
            },
            name: 'IdFragment',
            type: 'Node'
          }],
          fieldName: 'author',
          kind: 'Field',
          metadata: {
            canHaveSubselections: true,
            inferredRootCallName: 'node',
            inferredPrimaryKey: 'id',
            isAbstract: true
          },
          type: 'Actor'
        }, {
          children: [{
            fieldName: 'name',
            kind: 'Field',
            metadata: {},
            type: 'String'
          }, {
            children: [{
              fieldName: 'login',
              kind: 'Field',
              metadata: {},
              type: 'String'
            }, {
              fieldName: 'id',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'ID'
            }, {
              fieldName: '__typename',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'String'
            }],
            fieldName: 'owner',
            kind: 'Field',
            metadata: {
              canHaveSubselections: true,
              inferredRootCallName: 'node',
              inferredPrimaryKey: 'id',
              isAbstract: true
            },
            type: 'RepositoryOwner'
          }, {
            fieldName: 'id',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'ID'
          }],
          fieldName: 'repository',
          kind: 'Field',
          metadata: {
            canHaveSubselections: true,
            inferredRootCallName: 'node',
            inferredPrimaryKey: 'id'
          },
          type: 'Repository'
        }, {
          children: [{
            fieldName: 'content',
            kind: 'Field',
            metadata: {},
            type: 'ReactionContent'
          }, {
            children: [{
              fieldName: 'totalCount',
              kind: 'Field',
              metadata: {},
              type: 'Int'
            }],
            fieldName: 'users',
            kind: 'Field',
            metadata: {
              canHaveSubselections: true,
              isConnection: true
            },
            type: 'ReactingUserConnection'
          }],
          fieldName: 'reactionGroups',
          kind: 'Field',
          metadata: {
            canHaveSubselections: true,
            isPlural: true
          },
          type: 'ReactionGroup'
        }, {
          children: [{
            fieldName: 'totalCount',
            kind: 'Field',
            metadata: {},
            type: 'Int'
          }],
          fieldName: 'commits',
          kind: 'Field',
          metadata: {
            canHaveSubselections: true,
            isConnection: true
          },
          type: 'PullRequestCommitConnection'
        }, {
          calls: [{
            kind: 'Call',
            metadata: {},
            name: 'first',
            value: {
              kind: 'CallValue',
              callValue: 100
            }
          }],
          children: [{
            children: [{
              children: [{
                fieldName: 'name',
                kind: 'Field',
                metadata: {},
                type: 'String'
              }, {
                fieldName: 'color',
                kind: 'Field',
                metadata: {},
                type: 'String'
              }, {
                fieldName: 'id',
                kind: 'Field',
                metadata: {
                  isGenerated: true,
                  isRequisite: true
                },
                type: 'ID'
              }],
              fieldName: 'node',
              kind: 'Field',
              metadata: {
                canHaveSubselections: true,
                inferredRootCallName: 'node',
                inferredPrimaryKey: 'id',
                isRequisite: true
              },
              type: 'Label'
            }, {
              fieldName: 'cursor',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'String'
            }],
            fieldName: 'edges',
            kind: 'Field',
            metadata: {
              canHaveSubselections: true,
              isPlural: true
            },
            type: 'LabelEdge'
          }, {
            children: [{
              fieldName: 'hasNextPage',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'Boolean'
            }, {
              fieldName: 'hasPreviousPage',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'Boolean'
            }],
            fieldName: 'pageInfo',
            kind: 'Field',
            metadata: {
              canHaveSubselections: true,
              isGenerated: true,
              isRequisite: true
            },
            type: 'PageInfo'
          }],
          fieldName: 'labels',
          kind: 'Field',
          metadata: {
            canHaveSubselections: true,
            isConnection: true
          },
          type: 'LabelConnection'
        }, {
          fieldName: 'id',
          kind: 'Field',
          metadata: {
            isGenerated: true,
            isRequisite: true
          },
          type: 'ID'
        }],
        id: _reactRelay2.default.QL.__id(),
        kind: 'Fragment',
        metadata: {},
        name: 'Pr_PullRequestRelayQL',
        type: 'PullRequest'
      };
    }()
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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