'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IssueishTimeline = undefined;

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _reactRelay2 = _interopRequireDefault(_reactRelay);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _commitsContainer = require('./timeline-items/commits-container.js');

var _commitsContainer2 = _interopRequireDefault(_commitsContainer);

var _issueCommentContainer = require('./timeline-items/issue-comment-container.js');

var _issueCommentContainer2 = _interopRequireDefault(_issueCommentContainer);

var _mergedEventContainer = require('./timeline-items/merged-event-container.js');

var _mergedEventContainer2 = _interopRequireDefault(_mergedEventContainer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const groupableTimelineItems = {
  Commit: _commitsContainer2.default
};

const nonGroupableTimelineItems = {
  IssueComment: _issueCommentContainer2.default,
  MergedEvent: _mergedEventContainer2.default
};

let IssueishTimeline = exports.IssueishTimeline = (_temp = _class = class IssueishTimeline extends _react2.default.Component {

  render() {
    const issueish = this.props.issue || this.props.pullRequest;
    const groupedEdges = this.groupEdges(issueish.timeline.edges);
    return _react2.default.createElement(
      'div',
      { className: 'github-PrTimeline' },
      groupedEdges.map((_ref) => {
        let type = _ref.type,
            edges = _ref.edges;

        if (groupableTimelineItems[type]) {
          return this.renderGroupableTimelineEvents(type, edges);
        } else if (nonGroupableTimelineItems[type]) {
          return this.renderNonGroupableTimelineEvents(type, edges);
        } else {
          // eslint-disable-next-line no-console
          console.warn(`unrecogized timeline event type: ${type}`);
          return null;
        }
      })
    );
  }

  renderGroupableTimelineEvents(type, edges) {
    const Component = groupableTimelineItems[type];
    return _react2.default.createElement(Component, {
      key: `${type}-${edges[0].cursor}`,
      nodes: edges.map(e => e.node),
      switchToIssueish: this.props.switchToIssueish
    });
  }

  renderNonGroupableTimelineEvents(type, edges) {
    const Component = nonGroupableTimelineItems[type];
    return edges.map((_ref2) => {
      let node = _ref2.node,
          cursor = _ref2.cursor;

      return _react2.default.createElement(Component, { key: `${type}-${cursor}`, item: node, switchToIssueish: this.props.switchToIssueish });
    });
  }

  groupEdges(edges) {
    let currentGroup;
    const groupedEdges = [];
    let lastEdgeType;
    edges.forEach((_ref3) => {
      let node = _ref3.node,
          cursor = _ref3.cursor;

      const currentEdgeType = node.__typename;
      if (currentEdgeType === lastEdgeType) {
        currentGroup.edges.push({ node, cursor });
      } else {
        currentGroup = {
          type: currentEdgeType,
          edges: [{ node, cursor }]
        };
        groupedEdges.push(currentGroup);
      }
      lastEdgeType = currentEdgeType;
    });
    return groupedEdges;
  }
}, _class.propTypes = {
  switchToIssueish: _propTypes2.default.func.isRequired,
  issue: _propTypes2.default.shape({
    timeline: _propTypes2.default.object.isRequired
  }),
  pullRequest: _propTypes2.default.shape({
    timeline: _propTypes2.default.object.isRequired
  })
}, _temp);
exports.default = _reactRelay2.default.createContainer(IssueishTimeline, {
  fragments: {
    issue: () => function (RQL_0, RQL_1) {
      return {
        children: [{
          calls: [{
            kind: 'Call',
            metadata: {},
            name: 'first',
            value: {
              kind: 'CallValue',
              callValue: 100
            }
          }],
          children: [{
            children: [{
              fieldName: 'cursor',
              kind: 'Field',
              metadata: {
                isRequisite: true
              },
              type: 'String'
            }, {
              children: [].concat.apply([], [{
                fieldName: '__typename',
                kind: 'Field',
                metadata: {
                  isRequisite: true
                },
                type: 'String'
              }, _reactRelay2.default.QL.__frag(RQL_0), _reactRelay2.default.QL.__frag(RQL_1), {
                children: [{
                  fieldName: 'id',
                  kind: 'Field',
                  metadata: {
                    isGenerated: true,
                    isRequisite: true
                  },
                  type: 'ID'
                }, {
                  fieldName: '__typename',
                  kind: 'Field',
                  metadata: {
                    isGenerated: true,
                    isRequisite: true
                  },
                  type: 'String'
                }],
                id: _reactRelay2.default.QL.__id(),
                kind: 'Fragment',
                metadata: {
                  isAbstract: true
                },
                name: 'IdFragment',
                type: 'Node'
              }]),
              fieldName: 'node',
              kind: 'Field',
              metadata: {
                canHaveSubselections: true,
                inferredRootCallName: 'node',
                inferredPrimaryKey: 'id',
                isAbstract: true,
                isRequisite: true
              },
              type: 'IssueTimelineItem'
            }],
            fieldName: 'edges',
            kind: 'Field',
            metadata: {
              canHaveSubselections: true,
              isPlural: true
            },
            type: 'IssueTimelineItemEdge'
          }, {
            children: [{
              fieldName: 'hasNextPage',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'Boolean'
            }, {
              fieldName: 'hasPreviousPage',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'Boolean'
            }],
            fieldName: 'pageInfo',
            kind: 'Field',
            metadata: {
              canHaveSubselections: true,
              isGenerated: true,
              isRequisite: true
            },
            type: 'PageInfo'
          }],
          fieldName: 'timeline',
          kind: 'Field',
          metadata: {
            canHaveSubselections: true,
            isConnection: true
          },
          type: 'IssueTimelineConnection'
        }, {
          fieldName: 'id',
          kind: 'Field',
          metadata: {
            isGenerated: true,
            isRequisite: true
          },
          type: 'ID'
        }],
        id: _reactRelay2.default.QL.__id(),
        kind: 'Fragment',
        metadata: {},
        name: 'Issueish_IssueRelayQL',
        type: 'Issue'
      };
    }(groupableTimelineItems.Commit.getFragment('nodes'), nonGroupableTimelineItems.IssueComment.getFragment('item')),
    pullRequest: () => function (RQL_0, RQL_1, RQL_2) {
      return {
        children: [{
          calls: [{
            kind: 'Call',
            metadata: {},
            name: 'first',
            value: {
              kind: 'CallValue',
              callValue: 100
            }
          }],
          children: [{
            children: [{
              fieldName: 'cursor',
              kind: 'Field',
              metadata: {
                isRequisite: true
              },
              type: 'String'
            }, {
              children: [].concat.apply([], [{
                fieldName: '__typename',
                kind: 'Field',
                metadata: {
                  isRequisite: true
                },
                type: 'String'
              }, _reactRelay2.default.QL.__frag(RQL_0), _reactRelay2.default.QL.__frag(RQL_1), _reactRelay2.default.QL.__frag(RQL_2), {
                children: [{
                  fieldName: 'id',
                  kind: 'Field',
                  metadata: {
                    isGenerated: true,
                    isRequisite: true
                  },
                  type: 'ID'
                }, {
                  fieldName: '__typename',
                  kind: 'Field',
                  metadata: {
                    isGenerated: true,
                    isRequisite: true
                  },
                  type: 'String'
                }],
                id: _reactRelay2.default.QL.__id(),
                kind: 'Fragment',
                metadata: {
                  isAbstract: true
                },
                name: 'IdFragment',
                type: 'Node'
              }]),
              fieldName: 'node',
              kind: 'Field',
              metadata: {
                canHaveSubselections: true,
                inferredRootCallName: 'node',
                inferredPrimaryKey: 'id',
                isAbstract: true,
                isRequisite: true
              },
              type: 'PullRequestTimelineItem'
            }],
            fieldName: 'edges',
            kind: 'Field',
            metadata: {
              canHaveSubselections: true,
              isPlural: true
            },
            type: 'PullRequestTimelineItemEdge'
          }, {
            children: [{
              fieldName: 'hasNextPage',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'Boolean'
            }, {
              fieldName: 'hasPreviousPage',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'Boolean'
            }],
            fieldName: 'pageInfo',
            kind: 'Field',
            metadata: {
              canHaveSubselections: true,
              isGenerated: true,
              isRequisite: true
            },
            type: 'PageInfo'
          }],
          fieldName: 'timeline',
          kind: 'Field',
          metadata: {
            canHaveSubselections: true,
            isConnection: true
          },
          type: 'PullRequestTimelineConnection'
        }, {
          fieldName: 'id',
          kind: 'Field',
          metadata: {
            isGenerated: true,
            isRequisite: true
          },
          type: 'ID'
        }],
        id: _reactRelay2.default.QL.__id(),
        kind: 'Fragment',
        metadata: {},
        name: 'Issueish_PullRequestRelayQL',
        type: 'PullRequest'
      };
    }(groupableTimelineItems.Commit.getFragment('nodes'), nonGroupableTimelineItems.IssueComment.getFragment('item'), nonGroupableTimelineItems.MergedEvent.getFragment('item'))
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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