'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IssueishPaneItemView = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _reactRelay2 = _interopRequireDefault(_reactRelay);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _issueishTimelineContainer = require('./issueish-timeline-container');

var _issueishTimelineContainer2 = _interopRequireDefault(_issueishTimelineContainer);

var _octicon = require('../views/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

var _githubDotcomMarkdown = require('../views/github-dotcom-markdown');

var _githubDotcomMarkdown2 = _interopRequireDefault(_githubDotcomMarkdown);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const reactionTypeToEmoji = {
  THUMBS_UP: '👍',
  THUMBS_DOWN: '👎',
  LAUGH: '😆',
  HOORAY: '🎉',
  CONFUSED: '😕',
  HEART: '❤️'
};

const typeAndStateToIcon = {
  Issue: {
    OPEN: 'issue-opened',
    CLOSED: 'issue-closed'
  },
  PullRequest: {
    OPEN: 'git-pull-request',
    CLOSED: 'git-pull-request',
    MERGED: 'git-merge'
  }
};

let IssueishPaneItemView = exports.IssueishPaneItemView = (_temp = _class = class IssueishPaneItemView extends _react2.default.Component {

  render() {
    const repo = this.props.repository;
    const issueish = this.props.issueish;
    const icons = typeAndStateToIcon[issueish.__typename] || {};
    const icon = icons[issueish.state] || '';
    const childProps = {
      issue: issueish.__typename === 'Issue' ? issueish : null,
      pullRequest: issueish.__typename === 'PullRequest' ? issueish : null
    };
    return _react2.default.createElement(
      'div',
      { className: 'github-PrPaneItem' },
      _react2.default.createElement(
        'div',
        { className: 'github-PrPaneItem-container' },
        _react2.default.createElement(
          'div',
          { className: 'issueish-badge-and-link' },
          _react2.default.createElement(
            'span',
            { className: (0, _classnames2.default)('issueish-badge', 'badge', issueish.state.toLowerCase()) },
            _react2.default.createElement(_octicon2.default, { icon: icon }),
            issueish.state.toLowerCase()
          ),
          _react2.default.createElement(
            'span',
            { className: 'issueish-link' },
            _react2.default.createElement(
              'a',
              { href: issueish.url },
              repo.owner.login,
              '/',
              repo.name,
              '#',
              issueish.number
            )
          )
        ),
        _react2.default.createElement(
          'div',
          { className: 'issueish-avatar-and-title' },
          _react2.default.createElement(
            'a',
            { className: 'author-avatar-link', href: issueish.author.url },
            _react2.default.createElement('img', { className: 'author-avatar', src: issueish.author.avatarUrl, title: issueish.author.login })
          ),
          _react2.default.createElement(
            'h3',
            { className: 'issueish-title' },
            issueish.title
          )
        ),
        _react2.default.createElement(_githubDotcomMarkdown2.default, {
          html: issueish.bodyHTML || '<em>No description provided.</em>',
          switchToIssueish: this.props.switchToIssueish
        }),
        _react2.default.createElement(
          'div',
          { className: 'reactions' },
          issueish.reactionGroups.map(group => group.users.totalCount > 0 ? _react2.default.createElement(
            'span',
            { className: (0, _classnames2.default)('reaction-group', group.content.toLowerCase()), key: group.content },
            reactionTypeToEmoji[group.content],
            ' \xA0 ',
            group.users.totalCount
          ) : null)
        ),
        _react2.default.createElement(_issueishTimelineContainer2.default, _extends({}, childProps, { switchToIssueish: this.props.switchToIssueish }))
      )
    );
  }
}, _class.propTypes = {
  switchToIssueish: _propTypes2.default.func.isRequired,
  repository: _propTypes2.default.shape({
    name: _propTypes2.default.string.isRequired,
    owner: _propTypes2.default.shape({
      login: _propTypes2.default.string
    })
  }),
  issueish: _propTypes2.default.shape({
    title: _propTypes2.default.string,
    bodyHTML: _propTypes2.default.string,
    number: _propTypes2.default.number,
    state: _propTypes2.default.oneOf(['OPEN', 'CLOSED', 'MERGED']).isRequired,
    author: _propTypes2.default.shape({
      login: _propTypes2.default.string.isRequired,
      avatarUrl: _propTypes2.default.string.isRequired,
      url: _propTypes2.default.string.isRequired
    }).isRequired,
    reactionGroups: _propTypes2.default.arrayOf(_propTypes2.default.shape({
      content: _propTypes2.default.string.isRequired,
      users: _propTypes2.default.shape({
        totalCount: _propTypes2.default.number.isRequired
      }).isRequired
    })).isRequired
  }).isRequired
}, _temp);
exports.default = _reactRelay2.default.createContainer(IssueishPaneItemView, {
  fragments: {
    repository: () => function () {
      return {
        children: [{
          fieldName: 'name',
          kind: 'Field',
          metadata: {},
          type: 'String'
        }, {
          children: [{
            fieldName: 'login',
            kind: 'Field',
            metadata: {},
            type: 'String'
          }, {
            fieldName: 'id',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'ID'
          }, {
            fieldName: '__typename',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'String'
          }],
          fieldName: 'owner',
          kind: 'Field',
          metadata: {
            canHaveSubselections: true,
            inferredRootCallName: 'node',
            inferredPrimaryKey: 'id',
            isAbstract: true
          },
          type: 'RepositoryOwner'
        }, {
          fieldName: 'id',
          kind: 'Field',
          metadata: {
            isGenerated: true,
            isRequisite: true
          },
          type: 'ID'
        }],
        id: _reactRelay2.default.QL.__id(),
        kind: 'Fragment',
        metadata: {},
        name: 'Issueish_RepositoryRelayQL',
        type: 'Repository'
      };
    }(),

    issueish: () => function (RQL_0, RQL_1) {
      return {
        children: [{
          fieldName: '__typename',
          kind: 'Field',
          metadata: {
            isRequisite: true
          },
          type: 'String'
        }, {
          children: [].concat.apply([], [{
            fieldName: 'state',
            kind: 'Field',
            metadata: {},
            type: 'IssueState'
          }, {
            fieldName: 'number',
            kind: 'Field',
            metadata: {},
            type: 'Int'
          }, {
            fieldName: 'title',
            kind: 'Field',
            metadata: {},
            type: 'String'
          }, {
            fieldName: 'bodyHTML',
            kind: 'Field',
            metadata: {},
            type: 'HTML'
          }, {
            children: [{
              fieldName: 'login',
              kind: 'Field',
              metadata: {},
              type: 'String'
            }, {
              fieldName: 'avatarUrl',
              kind: 'Field',
              metadata: {},
              type: 'URI'
            }, {
              fieldName: '__typename',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'String'
            }, {
              children: [{
                fieldName: 'url',
                kind: 'Field',
                metadata: {},
                type: 'URI'
              }, {
                fieldName: 'id',
                kind: 'Field',
                metadata: {
                  isGenerated: true,
                  isRequisite: true
                },
                type: 'ID'
              }],
              id: _reactRelay2.default.QL.__id(),
              kind: 'Fragment',
              metadata: {},
              name: 'User',
              type: 'User'
            }, {
              children: [{
                fieldName: 'url',
                kind: 'Field',
                metadata: {},
                type: 'URI'
              }, {
                fieldName: 'id',
                kind: 'Field',
                metadata: {
                  isGenerated: true,
                  isRequisite: true
                },
                type: 'ID'
              }],
              id: _reactRelay2.default.QL.__id(),
              kind: 'Fragment',
              metadata: {},
              name: 'Bot',
              type: 'Bot'
            }, {
              children: [{
                fieldName: 'id',
                kind: 'Field',
                metadata: {
                  isGenerated: true,
                  isRequisite: true
                },
                type: 'ID'
              }, {
                fieldName: '__typename',
                kind: 'Field',
                metadata: {
                  isGenerated: true,
                  isRequisite: true
                },
                type: 'String'
              }],
              id: _reactRelay2.default.QL.__id(),
              kind: 'Fragment',
              metadata: {
                isAbstract: true
              },
              name: 'IdFragment',
              type: 'Node'
            }],
            fieldName: 'author',
            kind: 'Field',
            metadata: {
              canHaveSubselections: true,
              inferredRootCallName: 'node',
              inferredPrimaryKey: 'id',
              isAbstract: true
            },
            type: 'Actor'
          }, {
            fieldName: 'id',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'ID'
          }, _reactRelay2.default.QL.__frag(RQL_0)]),
          id: _reactRelay2.default.QL.__id(),
          kind: 'Fragment',
          metadata: {},
          name: 'Issue',
          type: 'Issue'
        }, {
          children: [].concat.apply([], [{
            fieldName: 'state',
            kind: 'Field',
            metadata: {},
            type: 'PullRequestState'
          }, {
            fieldName: 'number',
            kind: 'Field',
            metadata: {},
            type: 'Int'
          }, {
            fieldName: 'title',
            kind: 'Field',
            metadata: {},
            type: 'String'
          }, {
            fieldName: 'bodyHTML',
            kind: 'Field',
            metadata: {},
            type: 'HTML'
          }, {
            children: [{
              fieldName: 'login',
              kind: 'Field',
              metadata: {},
              type: 'String'
            }, {
              fieldName: 'avatarUrl',
              kind: 'Field',
              metadata: {},
              type: 'URI'
            }, {
              fieldName: '__typename',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'String'
            }, {
              children: [{
                fieldName: 'url',
                kind: 'Field',
                metadata: {},
                type: 'URI'
              }, {
                fieldName: 'id',
                kind: 'Field',
                metadata: {
                  isGenerated: true,
                  isRequisite: true
                },
                type: 'ID'
              }],
              id: _reactRelay2.default.QL.__id(),
              kind: 'Fragment',
              metadata: {},
              name: 'User',
              type: 'User'
            }, {
              children: [{
                fieldName: 'url',
                kind: 'Field',
                metadata: {},
                type: 'URI'
              }, {
                fieldName: 'id',
                kind: 'Field',
                metadata: {
                  isGenerated: true,
                  isRequisite: true
                },
                type: 'ID'
              }],
              id: _reactRelay2.default.QL.__id(),
              kind: 'Fragment',
              metadata: {},
              name: 'Bot',
              type: 'Bot'
            }, {
              children: [{
                fieldName: 'id',
                kind: 'Field',
                metadata: {
                  isGenerated: true,
                  isRequisite: true
                },
                type: 'ID'
              }, {
                fieldName: '__typename',
                kind: 'Field',
                metadata: {
                  isGenerated: true,
                  isRequisite: true
                },
                type: 'String'
              }],
              id: _reactRelay2.default.QL.__id(),
              kind: 'Fragment',
              metadata: {
                isAbstract: true
              },
              name: 'IdFragment',
              type: 'Node'
            }],
            fieldName: 'author',
            kind: 'Field',
            metadata: {
              canHaveSubselections: true,
              inferredRootCallName: 'node',
              inferredPrimaryKey: 'id',
              isAbstract: true
            },
            type: 'Actor'
          }, {
            fieldName: 'id',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'ID'
          }, _reactRelay2.default.QL.__frag(RQL_1)]),
          id: _reactRelay2.default.QL.__id(),
          kind: 'Fragment',
          metadata: {},
          name: 'PullRequest',
          type: 'PullRequest'
        }, {
          children: [{
            fieldName: 'url',
            kind: 'Field',
            metadata: {},
            type: 'URI'
          }, {
            fieldName: '__typename',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'String'
          }, {
            children: [{
              fieldName: 'id',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'ID'
            }, {
              fieldName: '__typename',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'String'
            }],
            id: _reactRelay2.default.QL.__id(),
            kind: 'Fragment',
            metadata: {
              isAbstract: true
            },
            name: 'IdFragment',
            type: 'Node'
          }],
          id: _reactRelay2.default.QL.__id(),
          kind: 'Fragment',
          metadata: {
            isAbstract: true
          },
          name: 'UniformResourceLocatable',
          type: 'UniformResourceLocatable'
        }, {
          children: [{
            children: [{
              fieldName: 'content',
              kind: 'Field',
              metadata: {},
              type: 'ReactionContent'
            }, {
              children: [{
                fieldName: 'totalCount',
                kind: 'Field',
                metadata: {},
                type: 'Int'
              }],
              fieldName: 'users',
              kind: 'Field',
              metadata: {
                canHaveSubselections: true,
                isConnection: true
              },
              type: 'ReactingUserConnection'
            }],
            fieldName: 'reactionGroups',
            kind: 'Field',
            metadata: {
              canHaveSubselections: true,
              isPlural: true
            },
            type: 'ReactionGroup'
          }, {
            fieldName: 'id',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'ID'
          }, {
            fieldName: '__typename',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'String'
          }],
          id: _reactRelay2.default.QL.__id(),
          kind: 'Fragment',
          metadata: {
            isAbstract: true
          },
          name: 'Reactable',
          type: 'Reactable'
        }, {
          children: [{
            fieldName: 'id',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'ID'
          }, {
            fieldName: '__typename',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'String'
          }],
          id: _reactRelay2.default.QL.__id(),
          kind: 'Fragment',
          metadata: {
            isAbstract: true
          },
          name: 'IdFragment',
          type: 'Node'
        }],
        id: _reactRelay2.default.QL.__id(),
        kind: 'Fragment',
        metadata: {
          isAbstract: true
        },
        name: 'Issueish_IssueishRelayQL',
        type: 'IssueOrPullRequest'
      };
    }(_issueishTimelineContainer2.default.getFragment('issue'), _issueishTimelineContainer2.default.getFragment('pullRequest'))
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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