Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _atomSelectList = require('atom-select-list');

var _atomSelectList2 = _interopRequireDefault(_atomSelectList);

var _helpers = require('./helpers');

var DiffListView = (function () {
  function DiffListView() {
    var _this = this;

    _classCallCheck(this, DiffListView);

    this.selectListView = new _atomSelectList2['default']({
      emptyMessage: 'No diffs in file',
      items: [],
      filterKeyForItem: function filterKeyForItem(diff) {
        return diff.lineText;
      },
      elementForItem: function elementForItem(diff) {
        var li = document.createElement('li');
        li.classList.add('two-lines');

        var primaryLine = document.createElement('div');
        primaryLine.classList.add('primary-line');
        primaryLine.textContent = diff.lineText;
        li.appendChild(primaryLine);

        var secondaryLine = document.createElement('div');
        secondaryLine.classList.add('secondary-line');
        secondaryLine.textContent = '-' + diff.oldStart + ',' + diff.oldLines + ' +' + diff.newStart + ',' + diff.newLines;
        li.appendChild(secondaryLine);

        return li;
      },
      didConfirmSelection: function didConfirmSelection(diff) {
        _this.cancel();
        var bufferRow = diff.newStart > 0 ? diff.newStart - 1 : diff.newStart;
        _this.editor.setCursorBufferPosition([bufferRow, 0], { autoscroll: true });
        _this.editor.moveToFirstCharacterOfLine();
      },
      didCancelSelection: function didCancelSelection() {
        _this.cancel();
      }
    });
    this.selectListView.element.classList.add('diff-list-view');
    this.panel = atom.workspace.addModalPanel({ item: this.selectListView, visible: false });
  }

  _createClass(DiffListView, [{
    key: 'attach',
    value: function attach() {
      this.previouslyFocusedElement = document.activeElement;
      this.selectListView.reset();
      this.panel.show();
      this.selectListView.focus();
    }
  }, {
    key: 'cancel',
    value: function cancel() {
      this.panel.hide();
      if (this.previouslyFocusedElement) {
        this.previouslyFocusedElement.focus();
        this.previouslyFocusedElement = null;
      }
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      this.cancel();
      this.panel.destroy();
      return this.selectListView.destroy();
    }
  }, {
    key: 'toggle',
    value: _asyncToGenerator(function* () {
      var editor = atom.workspace.getActiveTextEditor();
      if (this.panel.isVisible()) {
        this.cancel();
      } else if (editor) {
        this.editor = editor;
        var repository = (0, _helpers.repositoryForPath)(this.editor.getPath());
        var diffs = repository ? repository.getLineDiffs(this.editor.getPath(), this.editor.getText()) : [];
        if (!diffs) {
          diffs = [];
        }
        for (var diff of diffs) {
          var bufferRow = diff.newStart > 0 ? diff.newStart - 1 : diff.newStart;
          var lineText = this.editor.lineTextForBufferRow(bufferRow);
          diff.lineText = lineText ? lineText.trim() : '';
        }

        yield this.selectListView.update({ items: diffs });
        this.attach();
      }
    })
  }]);

  return DiffListView;
})();

exports['default'] = DiffListView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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