var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

/** @babel */

var fs = require('fs');
var path = require('path');

module.exports = {
  enumerate: _asyncToGenerator(function* () {
    var resourcePath = atom.getLoadSettings().resourcePath;
    if (atom.inDevMode()) {
      return [];
    }

    var paths = atom.packages.getAvailablePackagePaths();
    var countsByPackageName = new Map();
    for (var i = 0; i < paths.length; i++) {
      var packagePath = paths[i];
      var realPath = yield this.realpath(packagePath);
      if (packagePath.includes(resourcePath) || realPath === packagePath) {
        var packageName = path.basename(packagePath);
        var counts = countsByPackageName.get(packageName) || 0;
        countsByPackageName.set(packageName, counts + 1);
      }
    }

    var duplicatePackages = [];
    for (var _ref3 of countsByPackageName) {
      var _ref2 = _slicedToArray(_ref3, 2);

      var packageName = _ref2[0];
      var count = _ref2[1];

      if (count > 1) {
        duplicatePackages.push(packageName);
      }
    }
    return duplicatePackages;
  }),

  realpath: function realpath(path) {
    return new Promise(function (resolve, reject) {
      fs.realpath(path, function (error, realpath) {
        if (error) {
          reject(error);
        } else {
          resolve(realpath);
        }
      });
    });
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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