Object.defineProperty(exports, '__esModule', {
  value: true
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _atomSlick = require('atom-slick');

var _atomSlick2 = _interopRequireDefault(_atomSlick);

'use babel';

var EscapeCharacterRegex = /[-!"#$%&'*+,/:;=?@|^~()<>{}[\]]/g;

var cachedMatchesBySelector = new WeakMap();

var getCachedMatch = function getCachedMatch(selector, scopeChain) {
  var cachedMatchesByScopeChain = cachedMatchesBySelector.get(selector);
  if (cachedMatchesByScopeChain) {
    return cachedMatchesByScopeChain[scopeChain];
  }
};

var setCachedMatch = function setCachedMatch(selector, scopeChain, match) {
  var cachedMatchesByScopeChain = cachedMatchesBySelector.get(selector);
  if (!cachedMatchesByScopeChain) {
    cachedMatchesByScopeChain = {};
    cachedMatchesBySelector.set(selector, cachedMatchesByScopeChain);
  }
  cachedMatchesByScopeChain[scopeChain] = match;
  cachedMatchesByScopeChain[scopeChain];
};

var parseScopeChain = function parseScopeChain(scopeChain) {
  scopeChain = scopeChain.replace(EscapeCharacterRegex, function (match) {
    return '\\' + match[0];
  });

  var parsed = _atomSlick2['default'].parse(scopeChain)[0];
  if (!parsed || parsed.length === 0) {
    return [];
  }

  var result = [];
  for (var i = 0; i < parsed.length; i++) {
    result.push(parsed[i]);
  }

  return result;
};

var selectorForScopeChain = function selectorForScopeChain(selectors, scopeChain) {
  for (var i = 0; i < selectors.length; i++) {
    var selector = selectors[i];
    var cachedMatch = getCachedMatch(selector, scopeChain);
    if (cachedMatch != null) {
      if (cachedMatch) {
        return selector;
      } else {
        continue;
      }
    } else {
      var scopes = parseScopeChain(scopeChain);
      while (scopes.length > 0) {
        if (selector.matches(scopes)) {
          setCachedMatch(selector, scopeChain, true);
          return selector;
        }
        scopes.pop();
      }
      setCachedMatch(selector, scopeChain, false);
    }
  }

  return null;
};

var selectorsMatchScopeChain = function selectorsMatchScopeChain(selectors, scopeChain) {
  return selectorForScopeChain(selectors, scopeChain) != null;
};

var buildScopeChainString = function buildScopeChainString(scopes) {
  return '.' + scopes.join(' .');
};

exports.selectorsMatchScopeChain = selectorsMatchScopeChain;
exports.selectorForScopeChain = selectorForScopeChain;
exports.buildScopeChainString = buildScopeChainString;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9ob21lL3RyYXZpcy9idWlsZC9hdG9tL2F0b20vb3V0L2FwcC9ub2RlX21vZHVsZXMvYXV0b2NvbXBsZXRlLXBsdXMvbGliL3Njb3BlLWhlbHBlcnMuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O3lCQUVrQixZQUFZOzs7O0FBRjlCLFdBQVcsQ0FBQTs7QUFJWCxJQUFNLG9CQUFvQixHQUFHLGtDQUFrQyxDQUFBOztBQUUvRCxJQUFNLHVCQUF1QixHQUFHLElBQUksT0FBTyxFQUFFLENBQUE7O0FBRTdDLElBQU0sY0FBYyxHQUFHLFNBQWpCLGNBQWMsQ0FBSSxRQUFRLEVBQUUsVUFBVSxFQUFLO0FBQy9DLE1BQU0seUJBQXlCLEdBQUcsdUJBQXVCLENBQUMsR0FBRyxDQUFDLFFBQVEsQ0FBQyxDQUFBO0FBQ3ZFLE1BQUkseUJBQXlCLEVBQUU7QUFDN0IsV0FBTyx5QkFBeUIsQ0FBQyxVQUFVLENBQUMsQ0FBQTtHQUM3QztDQUNGLENBQUE7O0FBRUQsSUFBTSxjQUFjLEdBQUcsU0FBakIsY0FBYyxDQUFJLFFBQVEsRUFBRSxVQUFVLEVBQUUsS0FBSyxFQUFLO0FBQ3RELE1BQUkseUJBQXlCLEdBQUcsdUJBQXVCLENBQUMsR0FBRyxDQUFDLFFBQVEsQ0FBQyxDQUFBO0FBQ3JFLE1BQUksQ0FBQyx5QkFBeUIsRUFBRTtBQUM5Qiw2QkFBeUIsR0FBRyxFQUFFLENBQUE7QUFDOUIsMkJBQXVCLENBQUMsR0FBRyxDQUFDLFFBQVEsRUFBRSx5QkFBeUIsQ0FBQyxDQUFBO0dBQ2pFO0FBQ0QsMkJBQXlCLENBQUMsVUFBVSxDQUFDLEdBQUcsS0FBSyxDQUFBO0FBQzdDLDJCQUF5QixDQUFDLFVBQVUsQ0FBQyxDQUFBO0NBQ3RDLENBQUE7O0FBRUQsSUFBTSxlQUFlLEdBQUcsU0FBbEIsZUFBZSxDQUFJLFVBQVUsRUFBSztBQUN0QyxZQUFVLEdBQUcsVUFBVSxDQUFDLE9BQU8sQ0FBQyxvQkFBb0IsRUFBRSxVQUFDLEtBQUssRUFBSztBQUMvRCxXQUFPLElBQUksR0FBRyxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUE7R0FDdkIsQ0FBQyxDQUFBOztBQUVGLE1BQU0sTUFBTSxHQUFHLHVCQUFNLEtBQUssQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQTtBQUN6QyxNQUFJLENBQUMsTUFBTSxJQUFJLE1BQU0sQ0FBQyxNQUFNLEtBQUssQ0FBQyxFQUFFO0FBQ2xDLFdBQU8sRUFBRSxDQUFBO0dBQ1Y7O0FBRUQsTUFBTSxNQUFNLEdBQUcsRUFBRSxDQUFBO0FBQ2pCLE9BQUssSUFBSSxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUMsR0FBRyxNQUFNLENBQUMsTUFBTSxFQUFFLENBQUMsRUFBRSxFQUFFO0FBQ3RDLFVBQU0sQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUE7R0FDdkI7O0FBRUQsU0FBTyxNQUFNLENBQUE7Q0FDZCxDQUFBOztBQUVELElBQU0scUJBQXFCLEdBQUcsU0FBeEIscUJBQXFCLENBQUksU0FBUyxFQUFFLFVBQVUsRUFBSztBQUN2RCxPQUFLLElBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDLEdBQUcsU0FBUyxDQUFDLE1BQU0sRUFBRSxDQUFDLEVBQUUsRUFBRTtBQUN6QyxRQUFNLFFBQVEsR0FBRyxTQUFTLENBQUMsQ0FBQyxDQUFDLENBQUE7QUFDN0IsUUFBTSxXQUFXLEdBQUcsY0FBYyxDQUFDLFFBQVEsRUFBRSxVQUFVLENBQUMsQ0FBQTtBQUN4RCxRQUFJLFdBQVcsSUFBSSxJQUFJLEVBQUU7QUFDdkIsVUFBSSxXQUFXLEVBQUU7QUFDZixlQUFPLFFBQVEsQ0FBQTtPQUNoQixNQUFNO0FBQ0wsaUJBQVE7T0FDVDtLQUNGLE1BQU07QUFDTCxVQUFNLE1BQU0sR0FBRyxlQUFlLENBQUMsVUFBVSxDQUFDLENBQUE7QUFDMUMsYUFBTyxNQUFNLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRTtBQUN4QixZQUFJLFFBQVEsQ0FBQyxPQUFPLENBQUMsTUFBTSxDQUFDLEVBQUU7QUFDNUIsd0JBQWMsQ0FBQyxRQUFRLEVBQUUsVUFBVSxFQUFFLElBQUksQ0FBQyxDQUFBO0FBQzFDLGlCQUFPLFFBQVEsQ0FBQTtTQUNoQjtBQUNELGNBQU0sQ0FBQyxHQUFHLEVBQUUsQ0FBQTtPQUNiO0FBQ0Qsb0JBQWMsQ0FBQyxRQUFRLEVBQUUsVUFBVSxFQUFFLEtBQUssQ0FBQyxDQUFBO0tBQzVDO0dBQ0Y7O0FBRUQsU0FBTyxJQUFJLENBQUE7Q0FDWixDQUFBOztBQUVELElBQU0sd0JBQXdCLEdBQUcsU0FBM0Isd0JBQXdCLENBQUksU0FBUyxFQUFFLFVBQVUsRUFBSztBQUFFLFNBQU8scUJBQXFCLENBQUMsU0FBUyxFQUFFLFVBQVUsQ0FBQyxJQUFJLElBQUksQ0FBQTtDQUFFLENBQUE7O0FBRTNILElBQU0scUJBQXFCLEdBQUcsU0FBeEIscUJBQXFCLENBQUksTUFBTSxFQUFLO0FBQUUsZUFBVyxNQUFNLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFFO0NBQUUsQ0FBQTs7UUFFbkUsd0JBQXdCLEdBQXhCLHdCQUF3QjtRQUFFLHFCQUFxQixHQUFyQixxQkFBcUI7UUFBRSxxQkFBcUIsR0FBckIscUJBQXFCIiwiZmlsZSI6Ii9ob21lL3RyYXZpcy9idWlsZC9hdG9tL2F0b20vb3V0L2FwcC9ub2RlX21vZHVsZXMvYXV0b2NvbXBsZXRlLXBsdXMvbGliL3Njb3BlLWhlbHBlcnMuanMiLCJzb3VyY2VzQ29udGVudCI6WyIndXNlIGJhYmVsJ1xuXG5pbXBvcnQgc2xpY2sgZnJvbSAnYXRvbS1zbGljaydcblxuY29uc3QgRXNjYXBlQ2hhcmFjdGVyUmVnZXggPSAvWy0hXCIjJCUmJyorLC86Oz0/QHxefigpPD57fVtcXF1dL2dcblxuY29uc3QgY2FjaGVkTWF0Y2hlc0J5U2VsZWN0b3IgPSBuZXcgV2Vha01hcCgpXG5cbmNvbnN0IGdldENhY2hlZE1hdGNoID0gKHNlbGVjdG9yLCBzY29wZUNoYWluKSA9PiB7XG4gIGNvbnN0IGNhY2hlZE1hdGNoZXNCeVNjb3BlQ2hhaW4gPSBjYWNoZWRNYXRjaGVzQnlTZWxlY3Rvci5nZXQoc2VsZWN0b3IpXG4gIGlmIChjYWNoZWRNYXRjaGVzQnlTY29wZUNoYWluKSB7XG4gICAgcmV0dXJuIGNhY2hlZE1hdGNoZXNCeVNjb3BlQ2hhaW5bc2NvcGVDaGFpbl1cbiAgfVxufVxuXG5jb25zdCBzZXRDYWNoZWRNYXRjaCA9IChzZWxlY3Rvciwgc2NvcGVDaGFpbiwgbWF0Y2gpID0+IHtcbiAgbGV0IGNhY2hlZE1hdGNoZXNCeVNjb3BlQ2hhaW4gPSBjYWNoZWRNYXRjaGVzQnlTZWxlY3Rvci5nZXQoc2VsZWN0b3IpXG4gIGlmICghY2FjaGVkTWF0Y2hlc0J5U2NvcGVDaGFpbikge1xuICAgIGNhY2hlZE1hdGNoZXNCeVNjb3BlQ2hhaW4gPSB7fVxuICAgIGNhY2hlZE1hdGNoZXNCeVNlbGVjdG9yLnNldChzZWxlY3RvciwgY2FjaGVkTWF0Y2hlc0J5U2NvcGVDaGFpbilcbiAgfVxuICBjYWNoZWRNYXRjaGVzQnlTY29wZUNoYWluW3Njb3BlQ2hhaW5dID0gbWF0Y2hcbiAgY2FjaGVkTWF0Y2hlc0J5U2NvcGVDaGFpbltzY29wZUNoYWluXVxufVxuXG5jb25zdCBwYXJzZVNjb3BlQ2hhaW4gPSAoc2NvcGVDaGFpbikgPT4ge1xuICBzY29wZUNoYWluID0gc2NvcGVDaGFpbi5yZXBsYWNlKEVzY2FwZUNoYXJhY3RlclJlZ2V4LCAobWF0Y2gpID0+IHtcbiAgICByZXR1cm4gJ1xcXFwnICsgbWF0Y2hbMF1cbiAgfSlcblxuICBjb25zdCBwYXJzZWQgPSBzbGljay5wYXJzZShzY29wZUNoYWluKVswXVxuICBpZiAoIXBhcnNlZCB8fCBwYXJzZWQubGVuZ3RoID09PSAwKSB7XG4gICAgcmV0dXJuIFtdXG4gIH1cblxuICBjb25zdCByZXN1bHQgPSBbXVxuICBmb3IgKGxldCBpID0gMDsgaSA8IHBhcnNlZC5sZW5ndGg7IGkrKykge1xuICAgIHJlc3VsdC5wdXNoKHBhcnNlZFtpXSlcbiAgfVxuXG4gIHJldHVybiByZXN1bHRcbn1cblxuY29uc3Qgc2VsZWN0b3JGb3JTY29wZUNoYWluID0gKHNlbGVjdG9ycywgc2NvcGVDaGFpbikgPT4ge1xuICBmb3IgKGxldCBpID0gMDsgaSA8IHNlbGVjdG9ycy5sZW5ndGg7IGkrKykge1xuICAgIGNvbnN0IHNlbGVjdG9yID0gc2VsZWN0b3JzW2ldXG4gICAgY29uc3QgY2FjaGVkTWF0Y2ggPSBnZXRDYWNoZWRNYXRjaChzZWxlY3Rvciwgc2NvcGVDaGFpbilcbiAgICBpZiAoY2FjaGVkTWF0Y2ggIT0gbnVsbCkge1xuICAgICAgaWYgKGNhY2hlZE1hdGNoKSB7XG4gICAgICAgIHJldHVybiBzZWxlY3RvclxuICAgICAgfSBlbHNlIHtcbiAgICAgICAgY29udGludWVcbiAgICAgIH1cbiAgICB9IGVsc2Uge1xuICAgICAgY29uc3Qgc2NvcGVzID0gcGFyc2VTY29wZUNoYWluKHNjb3BlQ2hhaW4pXG4gICAgICB3aGlsZSAoc2NvcGVzLmxlbmd0aCA+IDApIHtcbiAgICAgICAgaWYgKHNlbGVjdG9yLm1hdGNoZXMoc2NvcGVzKSkge1xuICAgICAgICAgIHNldENhY2hlZE1hdGNoKHNlbGVjdG9yLCBzY29wZUNoYWluLCB0cnVlKVxuICAgICAgICAgIHJldHVybiBzZWxlY3RvclxuICAgICAgICB9XG4gICAgICAgIHNjb3Blcy5wb3AoKVxuICAgICAgfVxuICAgICAgc2V0Q2FjaGVkTWF0Y2goc2VsZWN0b3IsIHNjb3BlQ2hhaW4sIGZhbHNlKVxuICAgIH1cbiAgfVxuXG4gIHJldHVybiBudWxsXG59XG5cbmNvbnN0IHNlbGVjdG9yc01hdGNoU2NvcGVDaGFpbiA9IChzZWxlY3RvcnMsIHNjb3BlQ2hhaW4pID0+IHsgcmV0dXJuIHNlbGVjdG9yRm9yU2NvcGVDaGFpbihzZWxlY3RvcnMsIHNjb3BlQ2hhaW4pICE9IG51bGwgfVxuXG5jb25zdCBidWlsZFNjb3BlQ2hhaW5TdHJpbmcgPSAoc2NvcGVzKSA9PiB7IHJldHVybiBgLiR7c2NvcGVzLmpvaW4oJyAuJyl9YCB9XG5cbmV4cG9ydCB7IHNlbGVjdG9yc01hdGNoU2NvcGVDaGFpbiwgc2VsZWN0b3JGb3JTY29wZUNoYWluLCBidWlsZFNjb3BlQ2hhaW5TdHJpbmcgfVxuIl19