(function() {
  var TagsURL, fetch, filterExcerpt, fs, mdnHTMLURL, mdnJSONAPI, path, request;

  path = require('path');

  fs = require('fs');

  request = require('request');

  mdnHTMLURL = 'https://developer.mozilla.org/en-US/docs/Web/HTML/Element';

  mdnJSONAPI = 'https://developer.mozilla.org/en-US/search.json?topic=html&highlight=false';

  TagsURL = 'https://raw.githubusercontent.com/adobe/brackets/master/src/extensions/default/HTMLCodeHints/HtmlTags.json';

  fetch = function() {
    var tagsPromise;
    tagsPromise = new Promise(function(resolve) {
      return request({
        json: true,
        url: TagsURL
      }, function(error, response, tags) {
        if (error != null) {
          console.error(error.message);
          resolve(null);
        }
        if (response.statusCode !== 200) {
          console.error("Request for HtmlTags.json failed: " + response.statusCode);
          resolve(null);
        }
        return resolve(tags);
      });
    });
    return tagsPromise.then(function(tags) {
      var MAX, docs, queue, running;
      if (tags == null) {
        return;
      }
      MAX = 10;
      queue = Object.keys(tags);
      running = [];
      docs = {};
      return new Promise(function(resolve) {
        var checkEnd, handleRequest, i, ref, removeRunning, run, runNext;
        checkEnd = function() {
          if (queue.length === 0 && running.length === 0) {
            return resolve(docs);
          }
        };
        removeRunning = function(tagName) {
          var index;
          index = running.indexOf(tagName);
          if (index > -1) {
            return running.splice(index, 1);
          }
        };
        runNext = function() {
          var tagName;
          checkEnd();
          if (queue.length !== 0) {
            tagName = queue.pop();
            running.push(tagName);
            return run(tagName);
          }
        };
        run = function(tagName) {
          var url;
          url = mdnJSONAPI + "&q=" + tagName;
          return request({
            json: true,
            url: url
          }, function(error, response, searchResults) {
            if ((error == null) && response.statusCode === 200) {
              handleRequest(tagName, searchResults);
            } else {
              console.error("Req failed " + url + "; " + response.statusCode + ", " + error);
            }
            removeRunning(tagName);
            return runNext();
          });
        };
        handleRequest = function(tagName, searchResults) {
          var doc, i, len, ref;
          if (searchResults.documents != null) {
            ref = searchResults.documents;
            for (i = 0, len = ref.length; i < len; i++) {
              doc = ref[i];
              if (doc.url === (mdnHTMLURL + "/" + tagName) || (/^h\d$/.test(tagName) && doc.url === (mdnHTMLURL + "/Heading_Elements"))) {
                if (doc.tags.includes('Obsolete')) {
                  docs[tagName] = "The " + tagName + " element is obsolete. Avoid using it and update existing code if possible.";
                } else if (doc.tags.includes('Deprecated')) {
                  docs[tagName] = "The " + tagName + " element is deprecated. Avoid using it and update existing code if possible.";
                } else {
                  docs[tagName] = filterExcerpt(tagName, doc.excerpt);
                }
                return;
              }
            }
          }
          return console.log("Could not find documentation for " + tagName);
        };
        for (i = 0, ref = MAX; 0 <= ref ? i <= ref : i >= ref; 0 <= ref ? i++ : i--) {
          runNext();
        }
      });
    });
  };

  filterExcerpt = function(tagName, excerpt) {
    var beginningPattern, periodIndex;
    beginningPattern = /^the html [a-z-]+ element (\([^)]+\) )?(is )?(\w+)/i;
    excerpt = excerpt.replace(beginningPattern, function(match) {
      var firstWord, matches;
      matches = beginningPattern.exec(match);
      firstWord = matches[3];
      return firstWord[0].toUpperCase() + firstWord.slice(1);
    });
    periodIndex = excerpt.indexOf('.');
    if (periodIndex > -1) {
      excerpt = excerpt.slice(0, periodIndex + 1);
    }
    return excerpt;
  };

  if (require.main === module) {
    fetch().then(function(docs) {
      if (docs != null) {
        return fs.writeFileSync(path.join(__dirname, 'tag-docs.json'), (JSON.stringify(docs, null, '  ')) + "\n");
      } else {
        return console.error('No docs');
      }
    });
  }

  module.exports = fetch;

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
