(function() {
  var ArchiveEditor, ArchiveEditorView, Disposable, Emitter, File, FileIcons, Serializable, fs, isPathSupported, path, ref,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  path = require('path');

  fs = require('fs-plus');

  Serializable = require('serializable');

  ref = require('atom'), Disposable = ref.Disposable, Emitter = ref.Emitter, File = ref.File;

  FileIcons = require('./file-icons');

  ArchiveEditorView = require('./archive-editor-view');

  isPathSupported = function(filePath) {
    switch (path.extname(filePath)) {
      case '.egg':
      case '.epub':
      case '.jar':
      case '.love':
      case '.nupkg':
      case '.tar':
      case '.tgz':
      case '.war':
      case '.whl':
      case '.xpi':
      case '.zip':
        return true;
      case '.gz':
        return path.extname(path.basename(filePath, '.gz')) === '.tar';
      default:
        return false;
    }
  };

  module.exports = ArchiveEditor = (function(superClass) {
    extend(ArchiveEditor, superClass);

    ArchiveEditor.activate = function() {
      return atom.workspace.addOpener(function(filePath) {
        if (filePath == null) {
          filePath = '';
        }
        if (isPathSupported(filePath) && fs.isFileSync(filePath)) {
          return new ArchiveEditor({
            path: filePath
          });
        }
      });
    };

    function ArchiveEditor(arg) {
      var path;
      path = arg.path;
      this.emitter = new Emitter();
      this.file = new File(path);
      this.view = new ArchiveEditorView(this);
      this.element = this.view.element;
    }

    ArchiveEditor.prototype.serializeParams = function() {
      return {
        path: this.getPath()
      };
    };

    ArchiveEditor.prototype.deserializeParams = function(params) {
      if (params == null) {
        params = {};
      }
      if (fs.isFileSync(params.path)) {
        return params;
      } else {
        return console.warn("Could not build archive editor for path '" + params.path + "' because that file no longer exists");
      }
    };

    ArchiveEditor.consumeFileIcons = function(service) {
      FileIcons.setService(service);
      return new Disposable(function() {
        return FileIcons.resetService();
      });
    };

    ArchiveEditor.prototype.getPath = function() {
      return this.file.getPath();
    };

    ArchiveEditor.prototype.destroy = function() {
      this.view.destroy();
      return this.emitter.emit('did-destroy');
    };

    ArchiveEditor.prototype.onDidDestroy = function(callback) {
      return this.emitter.on('did-destroy', callback);
    };

    ArchiveEditor.prototype.getTitle = function() {
      if (this.getPath() != null) {
        return path.basename(this.getPath());
      } else {
        return 'untitled';
      }
    };

    ArchiveEditor.prototype.getURI = function() {
      return this.getPath();
    };

    ArchiveEditor.prototype.isEqual = function(other) {
      return other instanceof ArchiveEditor && this.getURI() === other.getURI();
    };

    return ArchiveEditor;

  })(Serializable);

}).call(this);

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiL2hvbWUvdHJhdmlzL2J1aWxkL2F0b20vYXRvbS9vdXQvYXBwL25vZGVfbW9kdWxlcy9hcmNoaXZlLXZpZXcvbGliL2FyY2hpdmUtZWRpdG9yLmNvZmZlZSJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtBQUFBLE1BQUEsb0hBQUE7SUFBQTs7O0VBQUEsSUFBQSxHQUFPLE9BQUEsQ0FBUSxNQUFSOztFQUVQLEVBQUEsR0FBSyxPQUFBLENBQVEsU0FBUjs7RUFDTCxZQUFBLEdBQWUsT0FBQSxDQUFRLGNBQVI7O0VBQ2YsTUFBOEIsT0FBQSxDQUFRLE1BQVIsQ0FBOUIsRUFBQywyQkFBRCxFQUFhLHFCQUFiLEVBQXNCOztFQUN0QixTQUFBLEdBQVksT0FBQSxDQUFRLGNBQVI7O0VBQ1osaUJBQUEsR0FBb0IsT0FBQSxDQUFRLHVCQUFSOztFQUVwQixlQUFBLEdBQWtCLFNBQUMsUUFBRDtBQUNoQixZQUFPLElBQUksQ0FBQyxPQUFMLENBQWEsUUFBYixDQUFQO0FBQUEsV0FDTyxNQURQO0FBQUEsV0FDZSxPQURmO0FBQUEsV0FDd0IsTUFEeEI7QUFBQSxXQUNnQyxPQURoQztBQUFBLFdBQ3lDLFFBRHpDO0FBQUEsV0FDbUQsTUFEbkQ7QUFBQSxXQUMyRCxNQUQzRDtBQUFBLFdBQ21FLE1BRG5FO0FBQUEsV0FDMkUsTUFEM0U7QUFBQSxXQUNtRixNQURuRjtBQUFBLFdBQzJGLE1BRDNGO0FBRUksZUFBTztBQUZYLFdBR08sS0FIUDtBQUlJLGVBQU8sSUFBSSxDQUFDLE9BQUwsQ0FBYSxJQUFJLENBQUMsUUFBTCxDQUFjLFFBQWQsRUFBd0IsS0FBeEIsQ0FBYixDQUFBLEtBQWdEO0FBSjNEO0FBTUksZUFBTztBQU5YO0VBRGdCOztFQVNsQixNQUFNLENBQUMsT0FBUCxHQUNNOzs7SUFDSixhQUFDLENBQUEsUUFBRCxHQUFXLFNBQUE7YUFDVCxJQUFJLENBQUMsU0FBUyxDQUFDLFNBQWYsQ0FBeUIsU0FBQyxRQUFEOztVQUFDLFdBQVM7O1FBR2pDLElBQUcsZUFBQSxDQUFnQixRQUFoQixDQUFBLElBQThCLEVBQUUsQ0FBQyxVQUFILENBQWMsUUFBZCxDQUFqQztpQkFDTSxJQUFBLGFBQUEsQ0FBYztZQUFBLElBQUEsRUFBTSxRQUFOO1dBQWQsRUFETjs7TUFIdUIsQ0FBekI7SUFEUzs7SUFPRSx1QkFBQyxHQUFEO0FBQ1gsVUFBQTtNQURhLE9BQUQ7TUFDWixJQUFDLENBQUEsT0FBRCxHQUFlLElBQUEsT0FBQSxDQUFBO01BQ2YsSUFBQyxDQUFBLElBQUQsR0FBWSxJQUFBLElBQUEsQ0FBSyxJQUFMO01BQ1osSUFBQyxDQUFBLElBQUQsR0FBWSxJQUFBLGlCQUFBLENBQWtCLElBQWxCO01BQ1osSUFBQyxDQUFBLE9BQUQsR0FBVyxJQUFDLENBQUEsSUFBSSxDQUFDO0lBSk47OzRCQU1iLGVBQUEsR0FBaUIsU0FBQTthQUNmO1FBQUEsSUFBQSxFQUFNLElBQUMsQ0FBQSxPQUFELENBQUEsQ0FBTjs7SUFEZTs7NEJBR2pCLGlCQUFBLEdBQW1CLFNBQUMsTUFBRDs7UUFBQyxTQUFPOztNQUN6QixJQUFHLEVBQUUsQ0FBQyxVQUFILENBQWMsTUFBTSxDQUFDLElBQXJCLENBQUg7ZUFDRSxPQURGO09BQUEsTUFBQTtlQUdFLE9BQU8sQ0FBQyxJQUFSLENBQWEsMkNBQUEsR0FBNEMsTUFBTSxDQUFDLElBQW5ELEdBQXdELHNDQUFyRSxFQUhGOztJQURpQjs7SUFNbkIsYUFBQyxDQUFBLGdCQUFELEdBQW1CLFNBQUMsT0FBRDtNQUNqQixTQUFTLENBQUMsVUFBVixDQUFxQixPQUFyQjthQUNJLElBQUEsVUFBQSxDQUFXLFNBQUE7ZUFDYixTQUFTLENBQUMsWUFBVixDQUFBO01BRGEsQ0FBWDtJQUZhOzs0QkFLbkIsT0FBQSxHQUFTLFNBQUE7YUFDUCxJQUFDLENBQUEsSUFBSSxDQUFDLE9BQU4sQ0FBQTtJQURPOzs0QkFHVCxPQUFBLEdBQVMsU0FBQTtNQUNQLElBQUMsQ0FBQSxJQUFJLENBQUMsT0FBTixDQUFBO2FBQ0EsSUFBQyxDQUFBLE9BQU8sQ0FBQyxJQUFULENBQWMsYUFBZDtJQUZPOzs0QkFJVCxZQUFBLEdBQWMsU0FBQyxRQUFEO2FBQ1osSUFBQyxDQUFBLE9BQU8sQ0FBQyxFQUFULENBQVksYUFBWixFQUEyQixRQUEzQjtJQURZOzs0QkFHZCxRQUFBLEdBQVUsU0FBQTtNQUNSLElBQUcsc0JBQUg7ZUFDRSxJQUFJLENBQUMsUUFBTCxDQUFjLElBQUMsQ0FBQSxPQUFELENBQUEsQ0FBZCxFQURGO09BQUEsTUFBQTtlQUdFLFdBSEY7O0lBRFE7OzRCQU1WLE1BQUEsR0FBUSxTQUFBO2FBQUcsSUFBQyxDQUFBLE9BQUQsQ0FBQTtJQUFIOzs0QkFFUixPQUFBLEdBQVMsU0FBQyxLQUFEO2FBQ1AsS0FBQSxZQUFpQixhQUFqQixJQUFtQyxJQUFDLENBQUEsTUFBRCxDQUFBLENBQUEsS0FBYSxLQUFLLENBQUMsTUFBTixDQUFBO0lBRHpDOzs7O0tBOUNpQjtBQWxCNUIiLCJzb3VyY2VzQ29udGVudCI6WyJwYXRoID0gcmVxdWlyZSAncGF0aCdcblxuZnMgPSByZXF1aXJlICdmcy1wbHVzJ1xuU2VyaWFsaXphYmxlID0gcmVxdWlyZSAnc2VyaWFsaXphYmxlJ1xue0Rpc3Bvc2FibGUsIEVtaXR0ZXIsIEZpbGV9ID0gcmVxdWlyZSAnYXRvbSdcbkZpbGVJY29ucyA9IHJlcXVpcmUgJy4vZmlsZS1pY29ucydcbkFyY2hpdmVFZGl0b3JWaWV3ID0gcmVxdWlyZSAnLi9hcmNoaXZlLWVkaXRvci12aWV3J1xuXG5pc1BhdGhTdXBwb3J0ZWQgPSAoZmlsZVBhdGgpIC0+XG4gIHN3aXRjaCBwYXRoLmV4dG5hbWUoZmlsZVBhdGgpXG4gICAgd2hlbiAnLmVnZycsICcuZXB1YicsICcuamFyJywgJy5sb3ZlJywgJy5udXBrZycsICcudGFyJywgJy50Z3onLCAnLndhcicsICcud2hsJywgJy54cGknLCAnLnppcCdcbiAgICAgIHJldHVybiB0cnVlXG4gICAgd2hlbiAnLmd6J1xuICAgICAgcmV0dXJuIHBhdGguZXh0bmFtZShwYXRoLmJhc2VuYW1lKGZpbGVQYXRoLCAnLmd6JykpIGlzICcudGFyJ1xuICAgIGVsc2VcbiAgICAgIHJldHVybiBmYWxzZVxuXG5tb2R1bGUuZXhwb3J0cz1cbmNsYXNzIEFyY2hpdmVFZGl0b3IgZXh0ZW5kcyBTZXJpYWxpemFibGVcbiAgQGFjdGl2YXRlOiAtPlxuICAgIGF0b20ud29ya3NwYWNlLmFkZE9wZW5lciAoZmlsZVBhdGg9JycpIC0+XG4gICAgICAjIENoZWNrIHRoYXQgdGhlIGZpbGUgcGF0aCBleGlzdHMgYmVmb3JlIG9wZW5pbmcgaW4gY2FzZSBzb21ldGhpbmcgbGlrZVxuICAgICAgIyBhbiBodHRwOiBVUkkgaXMgYmVpbmcgb3BlbmVkLlxuICAgICAgaWYgaXNQYXRoU3VwcG9ydGVkKGZpbGVQYXRoKSBhbmQgZnMuaXNGaWxlU3luYyhmaWxlUGF0aClcbiAgICAgICAgbmV3IEFyY2hpdmVFZGl0b3IocGF0aDogZmlsZVBhdGgpXG5cbiAgY29uc3RydWN0b3I6ICh7cGF0aH0pIC0+XG4gICAgQGVtaXR0ZXIgPSBuZXcgRW1pdHRlcigpXG4gICAgQGZpbGUgPSBuZXcgRmlsZShwYXRoKVxuICAgIEB2aWV3ID0gbmV3IEFyY2hpdmVFZGl0b3JWaWV3KHRoaXMpXG4gICAgQGVsZW1lbnQgPSBAdmlldy5lbGVtZW50XG5cbiAgc2VyaWFsaXplUGFyYW1zOiAtPlxuICAgIHBhdGg6IEBnZXRQYXRoKClcblxuICBkZXNlcmlhbGl6ZVBhcmFtczogKHBhcmFtcz17fSkgLT5cbiAgICBpZiBmcy5pc0ZpbGVTeW5jKHBhcmFtcy5wYXRoKVxuICAgICAgcGFyYW1zXG4gICAgZWxzZVxuICAgICAgY29uc29sZS53YXJuIFwiQ291bGQgbm90IGJ1aWxkIGFyY2hpdmUgZWRpdG9yIGZvciBwYXRoICcje3BhcmFtcy5wYXRofScgYmVjYXVzZSB0aGF0IGZpbGUgbm8gbG9uZ2VyIGV4aXN0c1wiXG5cbiAgQGNvbnN1bWVGaWxlSWNvbnM6IChzZXJ2aWNlKSAtPlxuICAgIEZpbGVJY29ucy5zZXRTZXJ2aWNlKHNlcnZpY2UpXG4gICAgbmV3IERpc3Bvc2FibGUgLT5cbiAgICAgIEZpbGVJY29ucy5yZXNldFNlcnZpY2UoKVxuXG4gIGdldFBhdGg6IC0+XG4gICAgQGZpbGUuZ2V0UGF0aCgpXG5cbiAgZGVzdHJveTogLT5cbiAgICBAdmlldy5kZXN0cm95KClcbiAgICBAZW1pdHRlci5lbWl0ICdkaWQtZGVzdHJveSdcblxuICBvbkRpZERlc3Ryb3k6IChjYWxsYmFjaykgLT5cbiAgICBAZW1pdHRlci5vbiAnZGlkLWRlc3Ryb3knLCBjYWxsYmFja1xuXG4gIGdldFRpdGxlOiAtPlxuICAgIGlmIEBnZXRQYXRoKCk/XG4gICAgICBwYXRoLmJhc2VuYW1lKEBnZXRQYXRoKCkpXG4gICAgZWxzZVxuICAgICAgJ3VudGl0bGVkJ1xuXG4gIGdldFVSSTogLT4gQGdldFBhdGgoKVxuXG4gIGlzRXF1YWw6IChvdGhlcikgLT5cbiAgICBvdGhlciBpbnN0YW5jZW9mIEFyY2hpdmVFZGl0b3IgYW5kIEBnZXRVUkkoKSBpcyBvdGhlci5nZXRVUkkoKVxuIl19
