(function() {
  var IsJapaneseKanaCharacter, hasPairedCharacter, isCJKCharacter, isCJKUnifiedIdeograph, isCombinedCharacter, isCombiningCharacter, isDoubleWidthCharacter, isFullWidthForm, isHalfWidthCharacter, isHighSurrogate, isKoreanCharacter, isLowSurrogate, isPairedCharacter, isSurrogatePair, isVariationSelector, isVariationSequence, isWordStart, isWrapBoundary;

  isHighSurrogate = function(charCode) {
    return (0xD800 <= charCode && charCode <= 0xDBFF);
  };

  isLowSurrogate = function(charCode) {
    return (0xDC00 <= charCode && charCode <= 0xDFFF);
  };

  isVariationSelector = function(charCode) {
    return (0xFE00 <= charCode && charCode <= 0xFE0F);
  };

  isCombiningCharacter = function(charCode) {
    return (0x0300 <= charCode && charCode <= 0x036F) || (0x1AB0 <= charCode && charCode <= 0x1AFF) || (0x1DC0 <= charCode && charCode <= 0x1DFF) || (0x20D0 <= charCode && charCode <= 0x20FF) || (0xFE20 <= charCode && charCode <= 0xFE2F);
  };

  isSurrogatePair = function(charCodeA, charCodeB) {
    return isHighSurrogate(charCodeA) && isLowSurrogate(charCodeB);
  };

  isVariationSequence = function(charCodeA, charCodeB) {
    return !isVariationSelector(charCodeA) && isVariationSelector(charCodeB);
  };

  isCombinedCharacter = function(charCodeA, charCodeB) {
    return !isCombiningCharacter(charCodeA) && isCombiningCharacter(charCodeB);
  };

  isPairedCharacter = function(string, index) {
    var charCodeA, charCodeB;
    if (index == null) {
      index = 0;
    }
    charCodeA = string.charCodeAt(index);
    charCodeB = string.charCodeAt(index + 1);
    return isSurrogatePair(charCodeA, charCodeB) || isVariationSequence(charCodeA, charCodeB) || isCombinedCharacter(charCodeA, charCodeB);
  };

  IsJapaneseKanaCharacter = function(charCode) {
    return (0x3000 <= charCode && charCode <= 0x30FF);
  };

  isCJKUnifiedIdeograph = function(charCode) {
    return (0x4E00 <= charCode && charCode <= 0x9FFF);
  };

  isFullWidthForm = function(charCode) {
    return (0xFF01 <= charCode && charCode <= 0xFF5E) || (0xFFE0 <= charCode && charCode <= 0xFFE6);
  };

  isDoubleWidthCharacter = function(character) {
    var charCode;
    charCode = character.charCodeAt(0);
    return IsJapaneseKanaCharacter(charCode) || isCJKUnifiedIdeograph(charCode) || isFullWidthForm(charCode);
  };

  isHalfWidthCharacter = function(character) {
    var charCode;
    charCode = character.charCodeAt(0);
    return (0xFF65 <= charCode && charCode <= 0xFFDC) || (0xFFE8 <= charCode && charCode <= 0xFFEE);
  };

  isKoreanCharacter = function(character) {
    var charCode;
    charCode = character.charCodeAt(0);
    return (0xAC00 <= charCode && charCode <= 0xD7A3) || (0x1100 <= charCode && charCode <= 0x11FF) || (0x3130 <= charCode && charCode <= 0x318F) || (0xA960 <= charCode && charCode <= 0xA97F) || (0xD7B0 <= charCode && charCode <= 0xD7FF);
  };

  isCJKCharacter = function(character) {
    return isDoubleWidthCharacter(character) || isHalfWidthCharacter(character) || isKoreanCharacter(character);
  };

  isWordStart = function(previousCharacter, character) {
    return (previousCharacter === ' ' || previousCharacter === '\t') && (character !== ' ' && character !== '\t');
  };

  isWrapBoundary = function(previousCharacter, character) {
    return isWordStart(previousCharacter, character) || isCJKCharacter(character);
  };

  hasPairedCharacter = function(string) {
    var index;
    index = 0;
    while (index < string.length) {
      if (isPairedCharacter(string, index)) {
        return true;
      }
      index++;
    }
    return false;
  };

  module.exports = {
    isPairedCharacter: isPairedCharacter,
    hasPairedCharacter: hasPairedCharacter,
    isDoubleWidthCharacter: isDoubleWidthCharacter,
    isHalfWidthCharacter: isHalfWidthCharacter,
    isKoreanCharacter: isKoreanCharacter,
    isWrapBoundary: isWrapBoundary
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
