Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _eventKit = require('event-kit');

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var ReopenProjectMenuManager = (function () {
  function ReopenProjectMenuManager(_ref) {
    var _this = this;

    var menu = _ref.menu;
    var commands = _ref.commands;
    var history = _ref.history;
    var config = _ref.config;
    var open = _ref.open;

    _classCallCheck(this, ReopenProjectMenuManager);

    this.menuManager = menu;
    this.historyManager = history;
    this.config = config;
    this.open = open;
    this.projects = [];

    this.subscriptions = new _eventKit.CompositeDisposable();
    this.subscriptions.add(history.onDidChangeProjects(this.update.bind(this)), config.onDidChange('core.reopenProjectMenuCount', function (_ref2) {
      var oldValue = _ref2.oldValue;
      var newValue = _ref2.newValue;

      _this.update();
    }), commands.add('atom-workspace', { 'application:reopen-project': this.reopenProjectCommand.bind(this) }));

    this.applyWindowsJumpListRemovals();
  }

  _createClass(ReopenProjectMenuManager, [{
    key: 'reopenProjectCommand',
    value: function reopenProjectCommand(e) {
      if (e.detail != null && e.detail.index != null) {
        this.open(this.projects[e.detail.index].paths);
      } else {
        this.createReopenProjectListView();
      }
    }
  }, {
    key: 'createReopenProjectListView',
    value: function createReopenProjectListView() {
      var _this2 = this;

      if (this.reopenProjectListView == null) {
        var ReopenProjectListView = require('./reopen-project-list-view');
        this.reopenProjectListView = new ReopenProjectListView(function (paths) {
          if (paths != null) {
            _this2.open(paths);
          }
        });
      }
      this.reopenProjectListView.toggle();
    }
  }, {
    key: 'update',
    value: function update() {
      this.disposeProjectMenu();
      this.projects = this.historyManager.getProjects().slice(0, this.config.get('core.reopenProjectMenuCount'));
      var newMenu = ReopenProjectMenuManager.createProjectsMenu(this.projects);
      this.lastProjectMenu = this.menuManager.add([newMenu]);
      this.updateWindowsJumpList();
    }
  }, {
    key: 'applyWindowsJumpListRemovals',

    // Windows users can right-click Atom taskbar and remove project from the jump list.
    // We have to honor that or the group stops working. As we only get a partial list
    // each time we remove them from history entirely.
    value: _asyncToGenerator(function* () {
      if (process.platform !== 'win32') return;
      if (this.app === undefined) {
        this.app = require('remote').app;
      }

      var removed = this.app.getJumpListSettings().removedItems.map(function (i) {
        return i.description;
      });
      if (removed.length === 0) return;
      for (var project of this.historyManager.getProjects()) {
        if (removed.includes(ReopenProjectMenuManager.taskDescription(project.paths))) {
          yield this.historyManager.removeProject(project.paths);
        }
      }
    })
  }, {
    key: 'updateWindowsJumpList',
    value: function updateWindowsJumpList() {
      if (process.platform !== 'win32') return;
      if (this.app === undefined) {
        this.app = require('remote').app;
      }

      this.app.setJumpList([{
        type: 'custom',
        name: 'Recent Projects',
        items: this.projects.map(function (project) {
          return {
            type: 'task',
            title: project.paths.map(ReopenProjectMenuManager.betterBaseName).join(', '),
            description: ReopenProjectMenuManager.taskDescription(project.paths),
            program: process.execPath,
            args: project.paths.map(function (path) {
              return '"' + path + '"';
            }).join(' '),
            iconPath: _path2['default'].join(_path2['default'].dirname(process.execPath), 'resources', 'cli', 'folder.ico'),
            iconIndex: 0
          };
        })
      }, { type: 'recent' }, { items: [{ type: 'task', title: 'New Window', program: process.execPath, args: '--new-window', description: 'Opens a new Atom window' }] }]);
    }
  }, {
    key: 'dispose',
    value: function dispose() {
      this.subscriptions.dispose();
      this.disposeProjectMenu();
      if (this.reopenProjectListView != null) {
        this.reopenProjectListView.dispose();
      }
    }
  }, {
    key: 'disposeProjectMenu',
    value: function disposeProjectMenu() {
      if (this.lastProjectMenu) {
        this.lastProjectMenu.dispose();
        this.lastProjectMenu = null;
      }
    }
  }], [{
    key: 'taskDescription',
    value: function taskDescription(paths) {
      return paths.map(function (path) {
        return ReopenProjectMenuManager.betterBaseName(path) + ' (' + path + ')';
      }).join(' ');
    }
  }, {
    key: 'createProjectsMenu',
    value: function createProjectsMenu(projects) {
      var _this3 = this;

      return {
        label: 'File',
        submenu: [{
          label: 'Reopen Project',
          submenu: projects.map(function (project, index) {
            return {
              label: _this3.createLabel(project),
              command: 'application:reopen-project',
              commandDetail: { index: index }
            };
          })
        }]
      };
    }
  }, {
    key: 'createLabel',
    value: function createLabel(project) {
      return project.paths.length === 1 ? project.paths[0] : project.paths.map(this.betterBaseName).join(', ');
    }
  }, {
    key: 'betterBaseName',
    value: function betterBaseName(directory) {
      // Handles Windows roots better than path.basename which returns '' for 'd:' and 'd:\'
      var match = directory.match(/^([a-z]:)[\\]?$/i);
      return match ? match[1] + '\\' : _path2['default'].basename(directory);
    }
  }]);

  return ReopenProjectMenuManager;
})();

exports['default'] = ReopenProjectMenuManager;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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