Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _atomSelectList = require('atom-select-list');

var _atomSelectList2 = _interopRequireDefault(_atomSelectList);

var ReopenProjectListView = (function () {
  function ReopenProjectListView(callback) {
    var _this = this;

    _classCallCheck(this, ReopenProjectListView);

    this.callback = callback;
    this.selectListView = new _atomSelectList2['default']({
      emptyMessage: 'No projects in history.',
      itemsClassList: ['mark-active'],
      items: [],
      filterKeyForItem: function filterKeyForItem(project) {
        return project.name;
      },
      elementForItem: function elementForItem(project) {
        var element = document.createElement('li');
        if (project.name === _this.currentProjectName) {
          element.classList.add('active');
        }
        element.textContent = project.name;
        return element;
      },
      didConfirmSelection: function didConfirmSelection(project) {
        _this.cancel();
        _this.callback(project.value);
      },
      didCancelSelection: function didCancelSelection() {
        _this.cancel();
      }
    });
    this.selectListView.element.classList.add('reopen-project');
  }

  _createClass(ReopenProjectListView, [{
    key: 'dispose',
    value: function dispose() {
      this.cancel();
      return this.selectListView.destroy();
    }
  }, {
    key: 'cancel',
    value: function cancel() {
      if (this.panel != null) {
        this.panel.destroy();
      }
      this.panel = null;
      this.currentProjectName = null;
      if (this.previouslyFocusedElement) {
        this.previouslyFocusedElement.focus();
        this.previouslyFocusedElement = null;
      }
    }
  }, {
    key: 'attach',
    value: function attach() {
      this.previouslyFocusedElement = document.activeElement;
      if (this.panel == null) {
        this.panel = atom.workspace.addModalPanel({ item: this });
      }
      this.selectListView.focus();
      this.selectListView.reset();
    }
  }, {
    key: 'toggle',
    value: _asyncToGenerator(function* () {
      var _this2 = this;

      if (this.panel != null) {
        this.cancel();
      } else {
        this.currentProjectName = atom.project != null ? this.makeName(atom.project.getPaths()) : null;
        var projects = atom.history.getProjects().map(function (p) {
          return { name: _this2.makeName(p.paths), value: p.paths };
        });
        yield this.selectListView.update({ items: projects });
        this.attach();
      }
    })
  }, {
    key: 'makeName',
    value: function makeName(paths) {
      return paths.join(', ');
    }
  }, {
    key: 'element',
    get: function get() {
      return this.selectListView.element;
    }
  }]);

  return ReopenProjectListView;
})();

exports['default'] = ReopenProjectListView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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