(function() {
  var CompositeDisposable, PaneContainerElement, _,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  CompositeDisposable = require('event-kit').CompositeDisposable;

  _ = require('underscore-plus');

  module.exports = PaneContainerElement = (function(superClass) {
    extend(PaneContainerElement, superClass);

    function PaneContainerElement() {
      return PaneContainerElement.__super__.constructor.apply(this, arguments);
    }

    PaneContainerElement.prototype.createdCallback = function() {
      this.subscriptions = new CompositeDisposable;
      return this.classList.add('panes');
    };

    PaneContainerElement.prototype.initialize = function(model, arg) {
      this.model = model;
      this.views = arg.views;
      if (this.views == null) {
        throw new Error("Must pass a views parameter when initializing PaneContainerElements");
      }
      this.subscriptions.add(this.model.observeRoot(this.rootChanged.bind(this)));
      return this;
    };

    PaneContainerElement.prototype.rootChanged = function(root) {
      var focusedElement, ref, view;
      if (this.hasFocus()) {
        focusedElement = document.activeElement;
      }
      if ((ref = this.firstChild) != null) {
        ref.remove();
      }
      if (root != null) {
        view = this.views.getView(root);
        this.appendChild(view);
        return focusedElement != null ? focusedElement.focus() : void 0;
      }
    };

    PaneContainerElement.prototype.hasFocus = function() {
      return this === document.activeElement || this.contains(document.activeElement);
    };

    return PaneContainerElement;

  })(HTMLElement);

  module.exports = PaneContainerElement = document.registerElement('atom-pane-container', {
    prototype: PaneContainerElement.prototype
  });

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
