(function() {
  var LessCache, LessCompileCache, path;

  path = require('path');

  LessCache = require('less-cache');

  module.exports = LessCompileCache = (function() {
    function LessCompileCache(arg) {
      var cacheDir, importPaths, importedFilePathsByRelativeImportPath, lessSourcesByRelativeFilePath, resourcePath;
      resourcePath = arg.resourcePath, importPaths = arg.importPaths, lessSourcesByRelativeFilePath = arg.lessSourcesByRelativeFilePath, importedFilePathsByRelativeImportPath = arg.importedFilePathsByRelativeImportPath;
      cacheDir = path.join(process.env.ATOM_HOME, 'compile-cache', 'less');
      this.lessSearchPaths = [path.join(resourcePath, 'static', 'variables'), path.join(resourcePath, 'static')];
      if (importPaths != null) {
        importPaths = importPaths.concat(this.lessSearchPaths);
      } else {
        importPaths = this.lessSearchPaths;
      }
      this.cache = new LessCache({
        importPaths: importPaths,
        resourcePath: resourcePath,
        lessSourcesByRelativeFilePath: lessSourcesByRelativeFilePath,
        importedFilePathsByRelativeImportPath: importedFilePathsByRelativeImportPath,
        cacheDir: cacheDir,
        fallbackDir: path.join(resourcePath, 'less-compile-cache')
      });
    }

    LessCompileCache.prototype.setImportPaths = function(importPaths) {
      if (importPaths == null) {
        importPaths = [];
      }
      return this.cache.setImportPaths(importPaths.concat(this.lessSearchPaths));
    };

    LessCompileCache.prototype.read = function(stylesheetPath) {
      return this.cache.readFileSync(stylesheetPath);
    };

    LessCompileCache.prototype.cssForFile = function(stylesheetPath, lessContent, digest) {
      return this.cache.cssForFile(stylesheetPath, lessContent, digest);
    };

    return LessCompileCache;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
