Object.defineProperty(exports, '__esModule', {
  value: true
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

/** @babel */

var _electron = require('electron');

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _ipcHelpers = require('./ipc-helpers');

var _ipcHelpers2 = _interopRequireDefault(_ipcHelpers);

var _util = require('util');

var _util2 = _interopRequireDefault(_util);

exports['default'] = _asyncToGenerator(function* () {
  var getWindowLoadSettings = require('./get-window-load-settings');

  var _getWindowLoadSettings = getWindowLoadSettings();

  var test = _getWindowLoadSettings.test;
  var headless = _getWindowLoadSettings.headless;
  var resourcePath = _getWindowLoadSettings.resourcePath;
  var benchmarkPaths = _getWindowLoadSettings.benchmarkPaths;

  try {
    yield* (function* () {
      var Clipboard = require('../src/clipboard');
      var ApplicationDelegate = require('../src/application-delegate');
      var AtomEnvironment = require('../src/atom-environment');
      var TextEditor = require('../src/text-editor');
      require('./electron-shims');

      var exportsPath = _path2['default'].join(resourcePath, 'exports');
      require('module').globalPaths.push(exportsPath); // Add 'exports' to module search path.
      process.env.NODE_PATH = exportsPath; // Set NODE_PATH env variable since tasks may need it.

      document.title = 'Benchmarks';
      // Allow `document.title` to be assigned in benchmarks without actually changing the window title.
      var documentTitle = null;
      Object.defineProperty(document, 'title', {
        get: function get() {
          return documentTitle;
        },
        set: function set(title) {
          documentTitle = title;
        }
      });

      window.addEventListener('keydown', function (event) {
        // Reload: cmd-r / ctrl-r
        if ((event.metaKey || event.ctrlKey) && event.keyCode === 82) {
          _ipcHelpers2['default'].call('window-method', 'reload');
        }

        // Toggle Dev Tools: cmd-alt-i (Mac) / ctrl-shift-i (Linux/Windows)
        if (event.keyCode === 73) {
          var isDarwin = process.platform === 'darwin';
          if (isDarwin && event.metaKey && event.altKey || !isDarwin && event.ctrlKey && event.shiftKey) {
            _ipcHelpers2['default'].call('window-method', 'toggleDevTools');
          }
        }

        // Close: cmd-w / ctrl-w
        if ((event.metaKey || event.ctrlKey) && event.keyCode === 87) {
          _ipcHelpers2['default'].call('window-method', 'close');
        }

        // Copy: cmd-c / ctrl-c
        if ((event.metaKey || event.ctrlKey) && event.keyCode === 67) {
          _ipcHelpers2['default'].call('window-method', 'copy');
        }
      }, true);

      var clipboard = new Clipboard();
      TextEditor.setClipboard(clipboard);
      TextEditor.viewForItem = function (item) {
        return atom.views.getView(item);
      };

      var applicationDelegate = new ApplicationDelegate();
      var environmentParams = {
        applicationDelegate: applicationDelegate,
        window: window,
        document: document,
        clipboard: clipboard,
        configDirPath: process.env.ATOM_HOME,
        enablePersistence: false
      };
      global.atom = new AtomEnvironment(environmentParams);
      global.atom.initialize(environmentParams);

      // Prevent benchmarks from modifying application menus
      global.atom.menu.sendToBrowserProcess = function () {};

      if (headless) {
        Object.defineProperties(process, {
          stdout: { value: _electron.remote.process.stdout },
          stderr: { value: _electron.remote.process.stderr }
        });

        console.log = function () {
          var formatted = _util2['default'].format.apply(_util2['default'], arguments);
          process.stdout.write(formatted + '\n');
        };
        console.warn = function () {
          var formatted = _util2['default'].format.apply(_util2['default'], arguments);
          process.stderr.write(formatted + '\n');
        };
        console.error = function () {
          var formatted = _util2['default'].format.apply(_util2['default'], arguments);
          process.stderr.write(formatted + '\n');
        };
      } else {
        _electron.remote.getCurrentWindow().show();
      }

      var benchmarkRunner = require('../benchmarks/benchmark-runner');
      var statusCode = yield benchmarkRunner({ test: test, benchmarkPaths: benchmarkPaths });
      if (headless) {
        exitWithStatusCode(statusCode);
      }
    })();
  } catch (error) {
    if (headless) {
      console.error(error.stack || error);
      exitWithStatusCode(1);
    } else {
      _ipcHelpers2['default'].call('window-method', 'openDevTools');
      throw error;
    }
  }
});

function exitWithStatusCode(statusCode) {
  _electron.remote.app.emit('will-quit');
  _electron.remote.process.exit(statusCode);
}
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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