(function() {
  var CustomGutterComponent, DefaultPriority, Emitter, Gutter;

  Emitter = require('event-kit').Emitter;

  CustomGutterComponent = null;

  DefaultPriority = -100;

  module.exports = Gutter = (function() {
    function Gutter(gutterContainer, options) {
      var ref, ref1;
      this.gutterContainer = gutterContainer;
      this.name = options != null ? options.name : void 0;
      this.priority = (ref = options != null ? options.priority : void 0) != null ? ref : DefaultPriority;
      this.visible = (ref1 = options != null ? options.visible : void 0) != null ? ref1 : true;
      this.emitter = new Emitter;
    }


    /*
    Section: Gutter Destruction
     */

    Gutter.prototype.destroy = function() {
      if (this.name === 'line-number') {
        throw new Error('The line-number gutter cannot be destroyed.');
      } else {
        this.gutterContainer.removeGutter(this);
        this.emitter.emit('did-destroy');
        return this.emitter.dispose();
      }
    };


    /*
    Section: Event Subscription
     */

    Gutter.prototype.onDidChangeVisible = function(callback) {
      return this.emitter.on('did-change-visible', callback);
    };

    Gutter.prototype.onDidDestroy = function(callback) {
      return this.emitter.on('did-destroy', callback);
    };


    /*
    Section: Visibility
     */

    Gutter.prototype.hide = function() {
      if (this.visible) {
        this.visible = false;
        this.gutterContainer.scheduleComponentUpdate();
        return this.emitter.emit('did-change-visible', this);
      }
    };

    Gutter.prototype.show = function() {
      if (!this.visible) {
        this.visible = true;
        this.gutterContainer.scheduleComponentUpdate();
        return this.emitter.emit('did-change-visible', this);
      }
    };

    Gutter.prototype.isVisible = function() {
      return this.visible;
    };

    Gutter.prototype.decorateMarker = function(marker, options) {
      return this.gutterContainer.addGutterDecoration(this, marker, options);
    };

    Gutter.prototype.getElement = function() {
      return this.element != null ? this.element : this.element = document.createElement('div');
    };

    return Gutter;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
