(function() {
  var Emitter, Gutter, GutterContainer;

  Emitter = require('event-kit').Emitter;

  Gutter = require('./gutter');

  module.exports = GutterContainer = (function() {
    function GutterContainer(textEditor) {
      this.gutters = [];
      this.textEditor = textEditor;
      this.emitter = new Emitter;
    }

    GutterContainer.prototype.scheduleComponentUpdate = function() {
      return this.textEditor.scheduleComponentUpdate();
    };

    GutterContainer.prototype.destroy = function() {
      var gutter, guttersToDestroy, j, len;
      guttersToDestroy = this.gutters.slice(0);
      for (j = 0, len = guttersToDestroy.length; j < len; j++) {
        gutter = guttersToDestroy[j];
        if (gutter.name !== 'line-number') {
          gutter.destroy();
        }
      }
      this.gutters = [];
      return this.emitter.dispose();
    };

    GutterContainer.prototype.addGutter = function(options) {
      var gutterName, i, inserted, j, newGutter, ref;
      options = options != null ? options : {};
      gutterName = options.name;
      if (gutterName === null) {
        throw new Error('A name is required to create a gutter.');
      }
      if (this.gutterWithName(gutterName)) {
        throw new Error('Tried to create a gutter with a name that is already in use.');
      }
      newGutter = new Gutter(this, options);
      inserted = false;
      for (i = j = 0, ref = this.gutters.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
        if (this.gutters[i].priority >= newGutter.priority) {
          this.gutters.splice(i, 0, newGutter);
          inserted = true;
          break;
        }
      }
      if (!inserted) {
        this.gutters.push(newGutter);
      }
      this.scheduleComponentUpdate();
      this.emitter.emit('did-add-gutter', newGutter);
      return newGutter;
    };

    GutterContainer.prototype.getGutters = function() {
      return this.gutters.slice();
    };

    GutterContainer.prototype.gutterWithName = function(name) {
      var gutter, j, len, ref;
      ref = this.gutters;
      for (j = 0, len = ref.length; j < len; j++) {
        gutter = ref[j];
        if (gutter.name === name) {
          return gutter;
        }
      }
      return null;
    };

    GutterContainer.prototype.observeGutters = function(callback) {
      var gutter, j, len, ref;
      ref = this.getGutters();
      for (j = 0, len = ref.length; j < len; j++) {
        gutter = ref[j];
        callback(gutter);
      }
      return this.onDidAddGutter(callback);
    };

    GutterContainer.prototype.onDidAddGutter = function(callback) {
      return this.emitter.on('did-add-gutter', callback);
    };

    GutterContainer.prototype.onDidRemoveGutter = function(callback) {
      return this.emitter.on('did-remove-gutter', callback);
    };


    /*
    Section: Private Methods
     */

    GutterContainer.prototype.removeGutter = function(gutter) {
      var index;
      index = this.gutters.indexOf(gutter);
      if (index > -1) {
        this.gutters.splice(index, 1);
        this.scheduleComponentUpdate();
        return this.emitter.emit('did-remove-gutter', gutter.name);
      } else {
        throw new Error('The given gutter cannot be removed because it is not ' + 'within this GutterContainer.');
      }
    };

    GutterContainer.prototype.addGutterDecoration = function(gutter, marker, options) {
      if (gutter.name === 'line-number') {
        options.type = 'line-number';
      } else {
        options.type = 'gutter';
      }
      options.gutterName = gutter.name;
      return this.textEditor.decorateMarker(marker, options);
    };

    return GutterContainer;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
