(function() {
  var AtomEnvironment, AutoUpdateManager, CommandInstaller, CommandRegistry, CompositeDisposable, Config, ConfigSchema, ContextMenuManager, DeserializerManager, Disposable, Dock, Emitter, GrammarRegistry, Gutter, HistoryManager, HistoryProject, KeymapManager, MenuManager, Model, NotificationManager, PackageManager, Pane, PaneAxis, PaneContainer, Panel, PanelContainer, Project, ReopenProjectMenuManager, StateStore, StorageFolder, StyleManager, TextBuffer, TextEditor, TextEditorRegistry, ThemeManager, TitleBar, TooltipManager, ViewRegistry, WindowEventHandler, Workspace, _, crypto, deprecate, fs, ipcRenderer, mapSourcePosition, path, ref, ref1, registerDefaultCommands, updateProcessEnv,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty,
    slice = [].slice,
    indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  crypto = require('crypto');

  path = require('path');

  ipcRenderer = require('electron').ipcRenderer;

  _ = require('underscore-plus');

  deprecate = require('grim').deprecate;

  ref = require('event-kit'), CompositeDisposable = ref.CompositeDisposable, Disposable = ref.Disposable, Emitter = ref.Emitter;

  fs = require('fs-plus');

  mapSourcePosition = require('@atom/source-map-support').mapSourcePosition;

  Model = require('./model');

  WindowEventHandler = require('./window-event-handler');

  StateStore = require('./state-store');

  StorageFolder = require('./storage-folder');

  registerDefaultCommands = require('./register-default-commands');

  updateProcessEnv = require('./update-process-env').updateProcessEnv;

  ConfigSchema = require('./config-schema');

  DeserializerManager = require('./deserializer-manager');

  ViewRegistry = require('./view-registry');

  NotificationManager = require('./notification-manager');

  Config = require('./config');

  KeymapManager = require('./keymap-extensions');

  TooltipManager = require('./tooltip-manager');

  CommandRegistry = require('./command-registry');

  GrammarRegistry = require('./grammar-registry');

  ref1 = require('./history-manager'), HistoryManager = ref1.HistoryManager, HistoryProject = ref1.HistoryProject;

  ReopenProjectMenuManager = require('./reopen-project-menu-manager');

  StyleManager = require('./style-manager');

  PackageManager = require('./package-manager');

  ThemeManager = require('./theme-manager');

  MenuManager = require('./menu-manager');

  ContextMenuManager = require('./context-menu-manager');

  CommandInstaller = require('./command-installer');

  Project = require('./project');

  TitleBar = require('./title-bar');

  Workspace = require('./workspace');

  PanelContainer = require('./panel-container');

  Panel = require('./panel');

  PaneContainer = require('./pane-container');

  PaneAxis = require('./pane-axis');

  Pane = require('./pane');

  Dock = require('./dock');

  Project = require('./project');

  TextEditor = require('./text-editor');

  TextBuffer = require('text-buffer');

  Gutter = require('./gutter');

  TextEditorRegistry = require('./text-editor-registry');

  AutoUpdateManager = require('./auto-update-manager');

  module.exports = AtomEnvironment = (function(superClass) {
    extend(AtomEnvironment, superClass);

    AtomEnvironment.version = 1;

    AtomEnvironment.prototype.lastUncaughtError = null;


    /*
    Section: Properties
     */

    AtomEnvironment.prototype.commands = null;

    AtomEnvironment.prototype.config = null;

    AtomEnvironment.prototype.clipboard = null;

    AtomEnvironment.prototype.contextMenu = null;

    AtomEnvironment.prototype.menu = null;

    AtomEnvironment.prototype.keymaps = null;

    AtomEnvironment.prototype.tooltips = null;

    AtomEnvironment.prototype.notifications = null;

    AtomEnvironment.prototype.project = null;

    AtomEnvironment.prototype.grammars = null;

    AtomEnvironment.prototype.history = null;

    AtomEnvironment.prototype.packages = null;

    AtomEnvironment.prototype.themes = null;

    AtomEnvironment.prototype.styles = null;

    AtomEnvironment.prototype.deserializers = null;

    AtomEnvironment.prototype.views = null;

    AtomEnvironment.prototype.workspace = null;

    AtomEnvironment.prototype.textEditors = null;

    AtomEnvironment.prototype.autoUpdater = null;

    AtomEnvironment.prototype.saveStateDebounceInterval = 1000;


    /*
    Section: Construction and Destruction
     */

    function AtomEnvironment(params) {
      var onlyLoadBaseStyleSheets;
      if (params == null) {
        params = {};
      }
      this.applicationDelegate = params.applicationDelegate, this.clipboard = params.clipboard, this.enablePersistence = params.enablePersistence, onlyLoadBaseStyleSheets = params.onlyLoadBaseStyleSheets, this.updateProcessEnv = params.updateProcessEnv;
      this.nextProxyRequestId = 0;
      this.unloaded = false;
      this.loadTime = null;
      this.emitter = new Emitter;
      this.disposables = new CompositeDisposable;
      this.deserializers = new DeserializerManager(this);
      this.deserializeTimings = {};
      this.views = new ViewRegistry(this);
      TextEditor.setScheduler(this.views);
      this.notifications = new NotificationManager;
      if (this.updateProcessEnv == null) {
        this.updateProcessEnv = updateProcessEnv;
      }
      this.stateStore = new StateStore('AtomEnvironments', 1);
      this.config = new Config({
        notificationManager: this.notifications,
        enablePersistence: this.enablePersistence
      });
      this.config.setSchema(null, {
        type: 'object',
        properties: _.clone(ConfigSchema)
      });
      this.keymaps = new KeymapManager({
        notificationManager: this.notifications
      });
      this.tooltips = new TooltipManager({
        keymapManager: this.keymaps,
        viewRegistry: this.views
      });
      this.commands = new CommandRegistry;
      this.grammars = new GrammarRegistry({
        config: this.config
      });
      this.styles = new StyleManager();
      this.packages = new PackageManager({
        config: this.config,
        styleManager: this.styles,
        commandRegistry: this.commands,
        keymapManager: this.keymaps,
        notificationManager: this.notifications,
        grammarRegistry: this.grammars,
        deserializerManager: this.deserializers,
        viewRegistry: this.views
      });
      this.themes = new ThemeManager({
        packageManager: this.packages,
        config: this.config,
        styleManager: this.styles,
        notificationManager: this.notifications,
        viewRegistry: this.views
      });
      this.menu = new MenuManager({
        keymapManager: this.keymaps,
        packageManager: this.packages
      });
      this.contextMenu = new ContextMenuManager({
        keymapManager: this.keymaps
      });
      this.packages.setMenuManager(this.menu);
      this.packages.setContextMenuManager(this.contextMenu);
      this.packages.setThemeManager(this.themes);
      this.project = new Project({
        notificationManager: this.notifications,
        packageManager: this.packages,
        config: this.config,
        applicationDelegate: this.applicationDelegate
      });
      this.commandInstaller = new CommandInstaller(this.applicationDelegate);
      this.textEditors = new TextEditorRegistry({
        config: this.config,
        grammarRegistry: this.grammars,
        assert: this.assert.bind(this),
        packageManager: this.packages
      });
      this.workspace = new Workspace({
        config: this.config,
        project: this.project,
        packageManager: this.packages,
        grammarRegistry: this.grammars,
        deserializerManager: this.deserializers,
        notificationManager: this.notifications,
        applicationDelegate: this.applicationDelegate,
        viewRegistry: this.views,
        assert: this.assert.bind(this),
        textEditorRegistry: this.textEditors,
        styleManager: this.styles,
        enablePersistence: this.enablePersistence
      });
      this.themes.workspace = this.workspace;
      this.autoUpdater = new AutoUpdateManager({
        applicationDelegate: this.applicationDelegate
      });
      if (this.keymaps.canLoadBundledKeymapsFromMemory()) {
        this.keymaps.loadBundledKeymaps();
      }
      this.registerDefaultCommands();
      this.registerDefaultOpeners();
      this.registerDefaultDeserializers();
      this.windowEventHandler = new WindowEventHandler({
        atomEnvironment: this,
        applicationDelegate: this.applicationDelegate
      });
      this.history = new HistoryManager({
        project: this.project,
        commands: this.commands,
        stateStore: this.stateStore
      });
      this.disposables.add(this.history.onDidChangeProjects((function(_this) {
        return function(e) {
          if (!e.reloaded) {
            return _this.applicationDelegate.didChangeHistoryManager();
          }
        };
      })(this)));
    }

    AtomEnvironment.prototype.initialize = function(params) {
      var clearWindowState, devMode, didChangeStyles, onlyLoadBaseStyleSheets, ref2, resourcePath, safeMode;
      if (params == null) {
        params = {};
      }
      require('./text-editor-element');
      this.window = params.window, this.document = params.document, this.blobStore = params.blobStore, this.configDirPath = params.configDirPath, onlyLoadBaseStyleSheets = params.onlyLoadBaseStyleSheets;
      ref2 = this.getLoadSettings(), devMode = ref2.devMode, safeMode = ref2.safeMode, resourcePath = ref2.resourcePath, clearWindowState = ref2.clearWindowState;
      if (clearWindowState) {
        this.getStorageFolder().clear();
        this.stateStore.clear();
      }
      ConfigSchema.projectHome = {
        type: 'string',
        "default": path.join(fs.getHomeDirectory(), 'github'),
        description: 'The directory where projects are assumed to be located. Packages created using the Package Generator will be stored here by default.'
      };
      this.config.initialize({
        configDirPath: this.configDirPath,
        resourcePath: resourcePath,
        projectHomeSchema: ConfigSchema.projectHome
      });
      this.menu.initialize({
        resourcePath: resourcePath
      });
      this.contextMenu.initialize({
        resourcePath: resourcePath,
        devMode: devMode
      });
      this.keymaps.configDirPath = this.configDirPath;
      this.keymaps.resourcePath = resourcePath;
      this.keymaps.devMode = devMode;
      if (!this.keymaps.canLoadBundledKeymapsFromMemory()) {
        this.keymaps.loadBundledKeymaps();
      }
      this.commands.attach(this.window);
      this.styles.initialize({
        configDirPath: this.configDirPath
      });
      this.packages.initialize({
        devMode: devMode,
        configDirPath: this.configDirPath,
        resourcePath: resourcePath,
        safeMode: safeMode
      });
      this.themes.initialize({
        configDirPath: this.configDirPath,
        resourcePath: resourcePath,
        safeMode: safeMode,
        devMode: devMode
      });
      this.commandInstaller.initialize(this.getVersion());
      this.autoUpdater.initialize();
      this.config.load();
      this.themes.loadBaseStylesheets();
      this.initialStyleElements = this.styles.getSnapshot();
      if (onlyLoadBaseStyleSheets) {
        this.themes.initialLoadComplete = true;
      }
      this.setBodyPlatformClass();
      this.stylesElement = this.styles.buildStylesElement();
      this.document.head.appendChild(this.stylesElement);
      this.keymaps.subscribeToFileReadFailure();
      this.installUncaughtErrorHandler();
      this.attachSaveStateListeners();
      this.windowEventHandler.initialize(this.window, this.document);
      didChangeStyles = this.didChangeStyles.bind(this);
      this.disposables.add(this.styles.onDidAddStyleElement(didChangeStyles));
      this.disposables.add(this.styles.onDidUpdateStyleElement(didChangeStyles));
      this.disposables.add(this.styles.onDidRemoveStyleElement(didChangeStyles));
      this.observeAutoHideMenuBar();
      return this.disposables.add(this.applicationDelegate.onDidChangeHistoryManager((function(_this) {
        return function() {
          return _this.history.loadState();
        };
      })(this)));
    };

    AtomEnvironment.prototype.preloadPackages = function() {
      return this.packages.preloadPackages();
    };

    AtomEnvironment.prototype.attachSaveStateListeners = function() {
      var saveState;
      saveState = _.debounce(((function(_this) {
        return function() {
          return _this.window.requestIdleCallback(function() {
            if (!_this.unloaded) {
              return _this.saveState({
                isUnloading: false
              });
            }
          });
        };
      })(this)), this.saveStateDebounceInterval);
      this.document.addEventListener('mousedown', saveState, true);
      this.document.addEventListener('keydown', saveState, true);
      return this.disposables.add(new Disposable((function(_this) {
        return function() {
          _this.document.removeEventListener('mousedown', saveState, true);
          return _this.document.removeEventListener('keydown', saveState, true);
        };
      })(this)));
    };

    AtomEnvironment.prototype.registerDefaultDeserializers = function() {
      this.deserializers.add(Workspace);
      this.deserializers.add(PaneContainer);
      this.deserializers.add(PaneAxis);
      this.deserializers.add(Pane);
      this.deserializers.add(Dock);
      this.deserializers.add(Project);
      this.deserializers.add(TextEditor);
      return this.deserializers.add(TextBuffer);
    };

    AtomEnvironment.prototype.registerDefaultCommands = function() {
      return registerDefaultCommands({
        commandRegistry: this.commands,
        config: this.config,
        commandInstaller: this.commandInstaller,
        notificationManager: this.notifications,
        project: this.project,
        clipboard: this.clipboard
      });
    };

    AtomEnvironment.prototype.registerDefaultOpeners = function() {
      return this.workspace.addOpener((function(_this) {
        return function(uri) {
          switch (uri) {
            case 'atom://.atom/stylesheet':
              return _this.workspace.openTextFile(_this.styles.getUserStyleSheetPath());
            case 'atom://.atom/keymap':
              return _this.workspace.openTextFile(_this.keymaps.getUserKeymapPath());
            case 'atom://.atom/config':
              return _this.workspace.openTextFile(_this.config.getUserConfigPath());
            case 'atom://.atom/init-script':
              return _this.workspace.openTextFile(_this.getUserInitScriptPath());
          }
        };
      })(this));
    };

    AtomEnvironment.prototype.registerDefaultTargetForKeymaps = function() {
      return this.keymaps.defaultTarget = this.workspace.getElement();
    };

    AtomEnvironment.prototype.observeAutoHideMenuBar = function() {
      this.disposables.add(this.config.onDidChange('core.autoHideMenuBar', (function(_this) {
        return function(arg1) {
          var newValue;
          newValue = arg1.newValue;
          return _this.setAutoHideMenuBar(newValue);
        };
      })(this)));
      if (this.config.get('core.autoHideMenuBar')) {
        return this.setAutoHideMenuBar(true);
      }
    };

    AtomEnvironment.prototype.reset = function() {
      this.deserializers.clear();
      this.registerDefaultDeserializers();
      this.config.clear();
      this.config.setSchema(null, {
        type: 'object',
        properties: _.clone(ConfigSchema)
      });
      this.keymaps.clear();
      this.keymaps.loadBundledKeymaps();
      this.commands.clear();
      this.registerDefaultCommands();
      this.styles.restoreSnapshot(this.initialStyleElements);
      this.menu.clear();
      this.clipboard.reset();
      this.notifications.clear();
      this.contextMenu.clear();
      this.packages.reset();
      this.workspace.reset(this.packages);
      this.registerDefaultOpeners();
      this.project.reset(this.packages);
      this.workspace.subscribeToEvents();
      this.grammars.clear();
      this.textEditors.clear();
      return this.views.clear();
    };

    AtomEnvironment.prototype.destroy = function() {
      var ref2, ref3;
      if (!this.project) {
        return;
      }
      this.disposables.dispose();
      if ((ref2 = this.workspace) != null) {
        ref2.destroy();
      }
      this.workspace = null;
      this.themes.workspace = null;
      if ((ref3 = this.project) != null) {
        ref3.destroy();
      }
      this.project = null;
      this.commands.clear();
      this.stylesElement.remove();
      this.config.unobserveUserConfig();
      this.autoUpdater.destroy();
      return this.uninstallWindowEventHandler();
    };


    /*
    Section: Event Subscription
     */

    AtomEnvironment.prototype.onDidBeep = function(callback) {
      return this.emitter.on('did-beep', callback);
    };

    AtomEnvironment.prototype.onWillThrowError = function(callback) {
      return this.emitter.on('will-throw-error', callback);
    };

    AtomEnvironment.prototype.onDidThrowError = function(callback) {
      return this.emitter.on('did-throw-error', callback);
    };

    AtomEnvironment.prototype.onDidFailAssertion = function(callback) {
      return this.emitter.on('did-fail-assertion', callback);
    };

    AtomEnvironment.prototype.whenShellEnvironmentLoaded = function(callback) {
      if (this.shellEnvironmentLoaded) {
        callback();
        return new Disposable();
      } else {
        return this.emitter.once('loaded-shell-environment', callback);
      }
    };


    /*
    Section: Atom Details
     */

    AtomEnvironment.prototype.inDevMode = function() {
      return this.devMode != null ? this.devMode : this.devMode = this.getLoadSettings().devMode;
    };

    AtomEnvironment.prototype.inSafeMode = function() {
      return this.safeMode != null ? this.safeMode : this.safeMode = this.getLoadSettings().safeMode;
    };

    AtomEnvironment.prototype.inSpecMode = function() {
      return this.specMode != null ? this.specMode : this.specMode = this.getLoadSettings().isSpec;
    };

    AtomEnvironment.prototype.isFirstLoad = function() {
      return this.firstLoad != null ? this.firstLoad : this.firstLoad = this.getLoadSettings().firstLoad;
    };

    AtomEnvironment.prototype.getVersion = function() {
      return this.appVersion != null ? this.appVersion : this.appVersion = this.getLoadSettings().appVersion;
    };

    AtomEnvironment.prototype.getReleaseChannel = function() {
      var version;
      version = this.getVersion();
      if (version.indexOf('beta') > -1) {
        return 'beta';
      } else if (version.indexOf('dev') > -1) {
        return 'dev';
      } else {
        return 'stable';
      }
    };

    AtomEnvironment.prototype.isReleasedVersion = function() {
      return !/\w{7}/.test(this.getVersion());
    };

    AtomEnvironment.prototype.getWindowLoadTime = function() {
      return this.loadTime;
    };

    AtomEnvironment.prototype.getLoadSettings = function() {
      return this.applicationDelegate.getWindowLoadSettings();
    };


    /*
    Section: Managing The Atom Window
     */

    AtomEnvironment.prototype.open = function(params) {
      return this.applicationDelegate.open(params);
    };

    AtomEnvironment.prototype.pickFolder = function(callback) {
      return this.applicationDelegate.pickFolder(callback);
    };

    AtomEnvironment.prototype.close = function() {
      return this.applicationDelegate.closeWindow();
    };

    AtomEnvironment.prototype.getSize = function() {
      return this.applicationDelegate.getWindowSize();
    };

    AtomEnvironment.prototype.setSize = function(width, height) {
      return this.applicationDelegate.setWindowSize(width, height);
    };

    AtomEnvironment.prototype.getPosition = function() {
      return this.applicationDelegate.getWindowPosition();
    };

    AtomEnvironment.prototype.setPosition = function(x, y) {
      return this.applicationDelegate.setWindowPosition(x, y);
    };

    AtomEnvironment.prototype.getCurrentWindow = function() {
      return this.applicationDelegate.getCurrentWindow();
    };

    AtomEnvironment.prototype.center = function() {
      return this.applicationDelegate.centerWindow();
    };

    AtomEnvironment.prototype.focus = function() {
      this.applicationDelegate.focusWindow();
      return this.window.focus();
    };

    AtomEnvironment.prototype.show = function() {
      return this.applicationDelegate.showWindow();
    };

    AtomEnvironment.prototype.hide = function() {
      return this.applicationDelegate.hideWindow();
    };

    AtomEnvironment.prototype.reload = function() {
      return this.applicationDelegate.reloadWindow();
    };

    AtomEnvironment.prototype.restartApplication = function() {
      return this.applicationDelegate.restartApplication();
    };

    AtomEnvironment.prototype.isMaximized = function() {
      return this.applicationDelegate.isWindowMaximized();
    };

    AtomEnvironment.prototype.maximize = function() {
      return this.applicationDelegate.maximizeWindow();
    };

    AtomEnvironment.prototype.isFullScreen = function() {
      return this.applicationDelegate.isWindowFullScreen();
    };

    AtomEnvironment.prototype.setFullScreen = function(fullScreen) {
      if (fullScreen == null) {
        fullScreen = false;
      }
      return this.applicationDelegate.setWindowFullScreen(fullScreen);
    };

    AtomEnvironment.prototype.toggleFullScreen = function() {
      return this.setFullScreen(!this.isFullScreen());
    };

    AtomEnvironment.prototype.displayWindow = function() {
      return this.restoreWindowDimensions().then((function(_this) {
        return function() {
          var ref2, ref3, steps;
          steps = [_this.restoreWindowBackground(), _this.show(), _this.focus()];
          if ((ref2 = _this.windowDimensions) != null ? ref2.fullScreen : void 0) {
            steps.push(_this.setFullScreen(true));
          }
          if (((ref3 = _this.windowDimensions) != null ? ref3.maximized : void 0) && process.platform !== 'darwin') {
            steps.push(_this.maximize());
          }
          return Promise.all(steps);
        };
      })(this));
    };

    AtomEnvironment.prototype.getWindowDimensions = function() {
      var browserWindow, height, maximized, ref2, ref3, width, x, y;
      browserWindow = this.getCurrentWindow();
      ref2 = browserWindow.getPosition(), x = ref2[0], y = ref2[1];
      ref3 = browserWindow.getSize(), width = ref3[0], height = ref3[1];
      maximized = browserWindow.isMaximized();
      return {
        x: x,
        y: y,
        width: width,
        height: height,
        maximized: maximized
      };
    };

    AtomEnvironment.prototype.setWindowDimensions = function(arg1) {
      var height, steps, width, x, y;
      x = arg1.x, y = arg1.y, width = arg1.width, height = arg1.height;
      steps = [];
      if ((width != null) && (height != null)) {
        steps.push(this.setSize(width, height));
      }
      if ((x != null) && (y != null)) {
        steps.push(this.setPosition(x, y));
      } else {
        steps.push(this.center());
      }
      return Promise.all(steps);
    };

    AtomEnvironment.prototype.isValidDimensions = function(arg1) {
      var height, ref2, width, x, y;
      ref2 = arg1 != null ? arg1 : {}, x = ref2.x, y = ref2.y, width = ref2.width, height = ref2.height;
      return width > 0 && height > 0 && x + width > 0 && y + height > 0;
    };

    AtomEnvironment.prototype.storeWindowDimensions = function() {
      this.windowDimensions = this.getWindowDimensions();
      if (this.isValidDimensions(this.windowDimensions)) {
        return localStorage.setItem("defaultWindowDimensions", JSON.stringify(this.windowDimensions));
      }
    };

    AtomEnvironment.prototype.getDefaultWindowDimensions = function() {
      var dimensions, error, height, ref2, width, windowDimensions;
      windowDimensions = this.getLoadSettings().windowDimensions;
      if (windowDimensions != null) {
        return windowDimensions;
      }
      dimensions = null;
      try {
        dimensions = JSON.parse(localStorage.getItem("defaultWindowDimensions"));
      } catch (error1) {
        error = error1;
        console.warn("Error parsing default window dimensions", error);
        localStorage.removeItem("defaultWindowDimensions");
      }
      if (this.isValidDimensions(dimensions)) {
        return dimensions;
      } else {
        ref2 = this.applicationDelegate.getPrimaryDisplayWorkAreaSize(), width = ref2.width, height = ref2.height;
        return {
          x: 0,
          y: 0,
          width: Math.min(1024, width),
          height: height
        };
      }
    };

    AtomEnvironment.prototype.restoreWindowDimensions = function() {
      if (!((this.windowDimensions != null) && this.isValidDimensions(this.windowDimensions))) {
        this.windowDimensions = this.getDefaultWindowDimensions();
      }
      return this.setWindowDimensions(this.windowDimensions).then((function(_this) {
        return function() {
          return _this.windowDimensions;
        };
      })(this));
    };

    AtomEnvironment.prototype.restoreWindowBackground = function() {
      var backgroundColor;
      if (backgroundColor = window.localStorage.getItem('atom:window-background-color')) {
        this.backgroundStylesheet = document.createElement('style');
        this.backgroundStylesheet.type = 'text/css';
        this.backgroundStylesheet.innerText = 'html, body { background: ' + backgroundColor + ' !important; }';
        return document.head.appendChild(this.backgroundStylesheet);
      }
    };

    AtomEnvironment.prototype.storeWindowBackground = function() {
      var backgroundColor;
      if (this.inSpecMode()) {
        return;
      }
      backgroundColor = this.window.getComputedStyle(this.workspace.getElement())['background-color'];
      return this.window.localStorage.setItem('atom:window-background-color', backgroundColor);
    };

    AtomEnvironment.prototype.startEditorWindow = function() {
      var loadHistoryPromise, loadStatePromise, updateProcessEnvPromise;
      this.unloaded = false;
      updateProcessEnvPromise = this.updateProcessEnvAndTriggerHooks();
      loadStatePromise = this.loadState().then((function(_this) {
        return function(state) {
          _this.windowDimensions = state != null ? state.windowDimensions : void 0;
          return _this.displayWindow().then(function() {
            var startTime;
            _this.commandInstaller.installAtomCommand(false, function(error) {
              if (error != null) {
                return console.warn(error.message);
              }
            });
            _this.commandInstaller.installApmCommand(false, function(error) {
              if (error != null) {
                return console.warn(error.message);
              }
            });
            _this.disposables.add(_this.applicationDelegate.onDidOpenLocations(_this.openLocations.bind(_this)));
            _this.disposables.add(_this.applicationDelegate.onApplicationMenuCommand(_this.dispatchApplicationMenuCommand.bind(_this)));
            _this.disposables.add(_this.applicationDelegate.onContextMenuCommand(_this.dispatchContextMenuCommand.bind(_this)));
            _this.disposables.add(_this.applicationDelegate.onDidRequestUnload(function() {
              return _this.saveState({
                isUnloading: true
              })["catch"](console.error).then(function() {
                var ref2;
                return (ref2 = _this.workspace) != null ? ref2.confirmClose({
                  windowCloseRequested: true,
                  projectHasPaths: _this.project.getPaths().length > 0
                }) : void 0;
              });
            }));
            _this.listenForUpdates();
            _this.registerDefaultTargetForKeymaps();
            _this.packages.loadPackages();
            startTime = Date.now();
            return _this.deserialize(state).then(function() {
              var ref2;
              _this.deserializeTimings.atom = Date.now() - startTime;
              if (process.platform === 'darwin' && _this.config.get('core.titleBar') === 'custom') {
                _this.workspace.addHeaderPanel({
                  item: new TitleBar({
                    workspace: _this.workspace,
                    themes: _this.themes,
                    applicationDelegate: _this.applicationDelegate
                  })
                });
                _this.document.body.classList.add('custom-title-bar');
              }
              if (process.platform === 'darwin' && _this.config.get('core.titleBar') === 'custom-inset') {
                _this.workspace.addHeaderPanel({
                  item: new TitleBar({
                    workspace: _this.workspace,
                    themes: _this.themes,
                    applicationDelegate: _this.applicationDelegate
                  })
                });
                _this.document.body.classList.add('custom-inset-title-bar');
              }
              if (process.platform === 'darwin' && _this.config.get('core.titleBar') === 'hidden') {
                _this.document.body.classList.add('hidden-title-bar');
              }
              _this.document.body.appendChild(_this.workspace.getElement());
              if ((ref2 = _this.backgroundStylesheet) != null) {
                ref2.remove();
              }
              _this.watchProjectPaths();
              _this.packages.activate();
              _this.keymaps.loadUserKeymap();
              if (!_this.getLoadSettings().safeMode) {
                _this.requireUserInitScript();
              }
              _this.menu.update();
              return _this.openInitialEmptyEditorIfNecessary();
            });
          });
        };
      })(this));
      loadHistoryPromise = this.history.loadState().then((function(_this) {
        return function() {
          _this.reopenProjectMenuManager = new ReopenProjectMenuManager({
            menu: _this.menu,
            commands: _this.commands,
            history: _this.history,
            config: _this.config,
            open: function(paths) {
              return _this.open({
                pathsToOpen: paths
              });
            }
          });
          return _this.reopenProjectMenuManager.update();
        };
      })(this));
      return Promise.all([loadStatePromise, loadHistoryPromise, updateProcessEnvPromise]);
    };

    AtomEnvironment.prototype.serialize = function(options) {
      return {
        version: this.constructor.version,
        project: this.project.serialize(options),
        workspace: this.workspace.serialize(),
        packageStates: this.packages.serialize(),
        grammars: {
          grammarOverridesByPath: this.grammars.grammarOverridesByPath
        },
        fullScreen: this.isFullScreen(),
        windowDimensions: this.windowDimensions,
        textEditors: this.textEditors.serialize()
      };
    };

    AtomEnvironment.prototype.unloadEditorWindow = function() {
      if (!this.project) {
        return;
      }
      this.storeWindowBackground();
      this.packages.deactivatePackages();
      this.saveBlobStoreSync();
      return this.unloaded = true;
    };

    AtomEnvironment.prototype.saveBlobStoreSync = function() {
      if (this.enablePersistence) {
        return this.blobStore.save();
      }
    };

    AtomEnvironment.prototype.openInitialEmptyEditorIfNecessary = function() {
      var ref2;
      if (!this.config.get('core.openEmptyEditorOnStart')) {
        return;
      }
      if (((ref2 = this.getLoadSettings().initialPaths) != null ? ref2.length : void 0) === 0 && this.workspace.getPaneItems().length === 0) {
        return this.workspace.open(null);
      }
    };

    AtomEnvironment.prototype.installUncaughtErrorHandler = function() {
      this.previousWindowErrorHandler = this.window.onerror;
      return this.window.onerror = (function(_this) {
        return function() {
          var column, eventObject, line, message, openDevTools, originalError, ref2, ref3, source, url;
          _this.lastUncaughtError = Array.prototype.slice.call(arguments);
          ref2 = _this.lastUncaughtError, message = ref2[0], url = ref2[1], line = ref2[2], column = ref2[3], originalError = ref2[4];
          ref3 = mapSourcePosition({
            source: url,
            line: line,
            column: column
          }), line = ref3.line, column = ref3.column, source = ref3.source;
          if (url === '<embedded>') {
            url = source;
          }
          eventObject = {
            message: message,
            url: url,
            line: line,
            column: column,
            originalError: originalError
          };
          openDevTools = true;
          eventObject.preventDefault = function() {
            return openDevTools = false;
          };
          _this.emitter.emit('will-throw-error', eventObject);
          if (openDevTools) {
            _this.openDevTools().then(function() {
              return _this.executeJavaScriptInDevTools('DevToolsAPI.showPanel("console")');
            });
          }
          return _this.emitter.emit('did-throw-error', {
            message: message,
            url: url,
            line: line,
            column: column,
            originalError: originalError
          });
        };
      })(this);
    };

    AtomEnvironment.prototype.uninstallUncaughtErrorHandler = function() {
      return this.window.onerror = this.previousWindowErrorHandler;
    };

    AtomEnvironment.prototype.installWindowEventHandler = function() {
      this.windowEventHandler = new WindowEventHandler({
        atomEnvironment: this,
        applicationDelegate: this.applicationDelegate
      });
      return this.windowEventHandler.initialize(this.window, this.document);
    };

    AtomEnvironment.prototype.uninstallWindowEventHandler = function() {
      var ref2;
      if ((ref2 = this.windowEventHandler) != null) {
        ref2.unsubscribe();
      }
      return this.windowEventHandler = null;
    };

    AtomEnvironment.prototype.didChangeStyles = function(styleElement) {
      TextEditor.didUpdateStyles();
      if (styleElement.textContent.indexOf('scrollbar') >= 0) {
        return TextEditor.didUpdateScrollbarStyles();
      }
    };

    AtomEnvironment.prototype.updateProcessEnvAndTriggerHooks = function() {
      return this.updateProcessEnv(this.getLoadSettings().env).then((function(_this) {
        return function() {
          _this.shellEnvironmentLoaded = true;
          _this.emitter.emit('loaded-shell-environment');
          return _this.packages.triggerActivationHook('core:loaded-shell-environment');
        };
      })(this));
    };


    /*
    Section: Messaging the User
     */

    AtomEnvironment.prototype.beep = function() {
      if (this.config.get('core.audioBeep')) {
        this.applicationDelegate.playBeepSound();
      }
      return this.emitter.emit('did-beep');
    };

    AtomEnvironment.prototype.confirm = function(params) {
      if (params == null) {
        params = {};
      }
      return this.applicationDelegate.confirm(params);
    };


    /*
    Section: Managing the Dev Tools
     */

    AtomEnvironment.prototype.openDevTools = function() {
      return this.applicationDelegate.openWindowDevTools();
    };

    AtomEnvironment.prototype.toggleDevTools = function() {
      return this.applicationDelegate.toggleWindowDevTools();
    };

    AtomEnvironment.prototype.executeJavaScriptInDevTools = function(code) {
      return this.applicationDelegate.executeJavaScriptInWindowDevTools(code);
    };


    /*
    Section: Private
     */

    AtomEnvironment.prototype.assert = function(condition, message, callbackOrMetadata) {
      var error;
      if (condition) {
        return true;
      }
      error = new Error("Assertion failed: " + message);
      Error.captureStackTrace(error, this.assert);
      if (callbackOrMetadata != null) {
        if (typeof callbackOrMetadata === 'function') {
          if (typeof callbackOrMetadata === "function") {
            callbackOrMetadata(error);
          }
        } else {
          error.metadata = callbackOrMetadata;
        }
      }
      this.emitter.emit('did-fail-assertion', error);
      if (!this.isReleasedVersion()) {
        throw error;
      }
      return false;
    };

    AtomEnvironment.prototype.loadThemes = function() {
      return this.themes.load();
    };

    AtomEnvironment.prototype.watchProjectPaths = function() {
      return this.disposables.add(this.project.onDidChangePaths((function(_this) {
        return function() {
          return _this.applicationDelegate.setRepresentedDirectoryPaths(_this.project.getPaths());
        };
      })(this)));
    };

    AtomEnvironment.prototype.setDocumentEdited = function(edited) {
      var base;
      return typeof (base = this.applicationDelegate).setWindowDocumentEdited === "function" ? base.setWindowDocumentEdited(edited) : void 0;
    };

    AtomEnvironment.prototype.setRepresentedFilename = function(filename) {
      var base;
      return typeof (base = this.applicationDelegate).setWindowRepresentedFilename === "function" ? base.setWindowRepresentedFilename(filename) : void 0;
    };

    AtomEnvironment.prototype.addProjectFolder = function() {
      return this.pickFolder((function(_this) {
        return function(selectedPaths) {
          if (selectedPaths == null) {
            selectedPaths = [];
          }
          return _this.addToProject(selectedPaths);
        };
      })(this));
    };

    AtomEnvironment.prototype.addToProject = function(projectPaths) {
      return this.loadState(this.getStateKey(projectPaths)).then((function(_this) {
        return function(state) {
          var folder, i, len, results;
          if (state && _this.project.getPaths().length === 0) {
            return _this.attemptRestoreProjectStateForPaths(state, projectPaths);
          } else {
            results = [];
            for (i = 0, len = projectPaths.length; i < len; i++) {
              folder = projectPaths[i];
              results.push(_this.project.addPath(folder));
            }
            return results;
          }
        };
      })(this));
    };

    AtomEnvironment.prototype.attemptRestoreProjectStateForPaths = function(state, projectPaths, filesToOpen) {
      var btn, center, file, i, len, nouns, selectedPath, windowIsUnused;
      if (filesToOpen == null) {
        filesToOpen = [];
      }
      center = this.workspace.getCenter();
      windowIsUnused = (function(_this) {
        return function() {
          var container, i, item, j, len, len1, ref2, ref3;
          ref2 = _this.workspace.getPaneContainers();
          for (i = 0, len = ref2.length; i < len; i++) {
            container = ref2[i];
            ref3 = container.getPaneItems();
            for (j = 0, len1 = ref3.length; j < len1; j++) {
              item = ref3[j];
              if (item instanceof TextEditor) {
                if (item.getPath() || item.isModified()) {
                  return false;
                }
              } else {
                if (container === center) {
                  return false;
                }
              }
            }
          }
          return true;
        };
      })(this);
      if (windowIsUnused()) {
        this.restoreStateIntoThisEnvironment(state);
        return Promise.all((function() {
          var i, len, results;
          results = [];
          for (i = 0, len = filesToOpen.length; i < len; i++) {
            file = filesToOpen[i];
            results.push(this.workspace.open(file));
          }
          return results;
        }).call(this));
      } else {
        nouns = projectPaths.length === 1 ? 'folder' : 'folders';
        btn = this.confirm({
          message: 'Previous automatically-saved project state detected',
          detailedMessage: ("There is previously saved state for the selected " + nouns + ". ") + ("Would you like to add the " + nouns + " to this window, permanently discarding the saved state, ") + ("or open the " + nouns + " in a new window, restoring the saved state?"),
          buttons: ['Open in new window and recover state', 'Add to this window and discard state']
        });
        if (btn === 0) {
          this.open({
            pathsToOpen: projectPaths.concat(filesToOpen),
            newWindow: true,
            devMode: this.inDevMode(),
            safeMode: this.inSafeMode()
          });
          return Promise.resolve(null);
        } else if (btn === 1) {
          for (i = 0, len = projectPaths.length; i < len; i++) {
            selectedPath = projectPaths[i];
            this.project.addPath(selectedPath);
          }
          return Promise.all((function() {
            var j, len1, results;
            results = [];
            for (j = 0, len1 = filesToOpen.length; j < len1; j++) {
              file = filesToOpen[j];
              results.push(this.workspace.open(file));
            }
            return results;
          }).call(this));
        }
      }
    };

    AtomEnvironment.prototype.restoreStateIntoThisEnvironment = function(state) {
      var i, len, pane, ref2;
      state.fullScreen = this.isFullScreen();
      ref2 = this.workspace.getPanes();
      for (i = 0, len = ref2.length; i < len; i++) {
        pane = ref2[i];
        pane.destroy();
      }
      return this.deserialize(state);
    };

    AtomEnvironment.prototype.showSaveDialog = function(callback) {
      return callback(this.showSaveDialogSync());
    };

    AtomEnvironment.prototype.showSaveDialogSync = function(options) {
      if (options == null) {
        options = {};
      }
      return this.applicationDelegate.showSaveDialog(options);
    };

    AtomEnvironment.prototype.saveState = function(options, storageKey) {
      return new Promise((function(_this) {
        return function(resolve, reject) {
          var ref2, savePromise, state;
          if (_this.enablePersistence && _this.project) {
            state = _this.serialize(options);
            savePromise = (storageKey != null ? storageKey : storageKey = _this.getStateKey((ref2 = _this.project) != null ? ref2.getPaths() : void 0)) ? _this.stateStore.save(storageKey, state) : _this.applicationDelegate.setTemporaryWindowState(state);
            return savePromise["catch"](reject).then(resolve);
          } else {
            return resolve();
          }
        };
      })(this));
    };

    AtomEnvironment.prototype.loadState = function(stateKey) {
      if (this.enablePersistence) {
        if (stateKey != null ? stateKey : stateKey = this.getStateKey(this.getLoadSettings().initialPaths)) {
          return this.stateStore.load(stateKey).then((function(_this) {
            return function(state) {
              if (state) {
                return state;
              } else {
                return _this.getStorageFolder().load(stateKey);
              }
            };
          })(this));
        } else {
          return this.applicationDelegate.getTemporaryWindowState();
        }
      } else {
        return Promise.resolve(null);
      }
    };

    AtomEnvironment.prototype.deserialize = function(state) {
      var grammarOverridesByPath, projectPromise, ref2, ref3, startTime;
      if (state == null) {
        return Promise.resolve();
      }
      if (grammarOverridesByPath = (ref2 = state.grammars) != null ? ref2.grammarOverridesByPath : void 0) {
        this.grammars.grammarOverridesByPath = grammarOverridesByPath;
      }
      this.setFullScreen(state.fullScreen);
      this.packages.packageStates = (ref3 = state.packageStates) != null ? ref3 : {};
      startTime = Date.now();
      if (state.project != null) {
        projectPromise = this.project.deserialize(state.project, this.deserializers);
      } else {
        projectPromise = Promise.resolve();
      }
      return projectPromise.then((function(_this) {
        return function() {
          _this.deserializeTimings.project = Date.now() - startTime;
          if (state.textEditors) {
            _this.textEditors.deserialize(state.textEditors);
          }
          startTime = Date.now();
          if (state.workspace != null) {
            _this.workspace.deserialize(state.workspace, _this.deserializers);
          }
          return _this.deserializeTimings.workspace = Date.now() - startTime;
        };
      })(this));
    };

    AtomEnvironment.prototype.getStateKey = function(paths) {
      var sha1;
      if ((paths != null ? paths.length : void 0) > 0) {
        sha1 = crypto.createHash('sha1').update(paths.slice().sort().join("\n")).digest('hex');
        return "editor-" + sha1;
      } else {
        return null;
      }
    };

    AtomEnvironment.prototype.getStorageFolder = function() {
      return this.storageFolder != null ? this.storageFolder : this.storageFolder = new StorageFolder(this.getConfigDirPath());
    };

    AtomEnvironment.prototype.getConfigDirPath = function() {
      return this.configDirPath != null ? this.configDirPath : this.configDirPath = process.env.ATOM_HOME;
    };

    AtomEnvironment.prototype.getUserInitScriptPath = function() {
      var initScriptPath;
      initScriptPath = fs.resolve(this.getConfigDirPath(), 'init', ['js', 'coffee']);
      return initScriptPath != null ? initScriptPath : path.join(this.getConfigDirPath(), 'init.coffee');
    };

    AtomEnvironment.prototype.requireUserInitScript = function() {
      var error, userInitScriptPath;
      if (userInitScriptPath = this.getUserInitScriptPath()) {
        try {
          if (fs.isFileSync(userInitScriptPath)) {
            return require(userInitScriptPath);
          }
        } catch (error1) {
          error = error1;
          return this.notifications.addError("Failed to load `" + userInitScriptPath + "`", {
            detail: error.message,
            dismissable: true
          });
        }
      }
    };

    AtomEnvironment.prototype.onUpdateAvailable = function(callback) {
      return this.emitter.on('update-available', callback);
    };

    AtomEnvironment.prototype.updateAvailable = function(details) {
      return this.emitter.emit('update-available', details);
    };

    AtomEnvironment.prototype.listenForUpdates = function() {
      return this.disposables.add(this.autoUpdater.onDidCompleteDownloadingUpdate(this.updateAvailable.bind(this)));
    };

    AtomEnvironment.prototype.setBodyPlatformClass = function() {
      return this.document.body.classList.add("platform-" + process.platform);
    };

    AtomEnvironment.prototype.setAutoHideMenuBar = function(autoHide) {
      this.applicationDelegate.setAutoHideWindowMenuBar(autoHide);
      return this.applicationDelegate.setWindowMenuBarVisibility(!autoHide);
    };

    AtomEnvironment.prototype.dispatchApplicationMenuCommand = function(command, arg) {
      var activeElement;
      activeElement = this.document.activeElement;
      if (activeElement === this.document.body) {
        activeElement = this.workspace.getElement();
      }
      return this.commands.dispatch(activeElement, command, arg);
    };

    AtomEnvironment.prototype.dispatchContextMenuCommand = function() {
      var args, command;
      command = arguments[0], args = 2 <= arguments.length ? slice.call(arguments, 1) : [];
      return this.commands.dispatch(this.contextMenu.activeElement, command, args);
    };

    AtomEnvironment.prototype.openLocations = function(locations) {
      var fileLocationsToOpen, foldersToAddToProject, forceAddToWindow, i, initialColumn, initialLine, j, len, len1, needsProjectPaths, pathToOpen, promise, promises, pushFolderToOpen, ref2, ref3, ref4, ref5;
      needsProjectPaths = ((ref2 = this.project) != null ? ref2.getPaths().length : void 0) === 0;
      foldersToAddToProject = [];
      fileLocationsToOpen = [];
      pushFolderToOpen = function(folder) {
        if (indexOf.call(foldersToAddToProject, folder) < 0) {
          return foldersToAddToProject.push(folder);
        }
      };
      for (i = 0, len = locations.length; i < len; i++) {
        ref3 = locations[i], pathToOpen = ref3.pathToOpen, initialLine = ref3.initialLine, initialColumn = ref3.initialColumn, forceAddToWindow = ref3.forceAddToWindow;
        if ((pathToOpen != null) && (needsProjectPaths || forceAddToWindow)) {
          if (fs.existsSync(pathToOpen)) {
            pushFolderToOpen(this.project.getDirectoryForProjectPath(pathToOpen).getPath());
          } else if (fs.existsSync(path.dirname(pathToOpen))) {
            pushFolderToOpen(this.project.getDirectoryForProjectPath(path.dirname(pathToOpen)).getPath());
          } else {
            pushFolderToOpen(this.project.getDirectoryForProjectPath(pathToOpen).getPath());
          }
        }
        if (!fs.isDirectorySync(pathToOpen)) {
          fileLocationsToOpen.push({
            pathToOpen: pathToOpen,
            initialLine: initialLine,
            initialColumn: initialColumn
          });
        }
      }
      promise = Promise.resolve(null);
      if (foldersToAddToProject.length > 0) {
        promise = this.loadState(this.getStateKey(foldersToAddToProject)).then((function(_this) {
          return function(state) {
            var files, folder, j, k, len1, len2, location, promises, ref4, ref5;
            if (state && needsProjectPaths) {
              files = (function() {
                var j, len1, results;
                results = [];
                for (j = 0, len1 = fileLocationsToOpen.length; j < len1; j++) {
                  location = fileLocationsToOpen[j];
                  results.push(location.pathToOpen);
                }
                return results;
              })();
              return _this.attemptRestoreProjectStateForPaths(state, foldersToAddToProject, files);
            } else {
              promises = [];
              for (j = 0, len1 = foldersToAddToProject.length; j < len1; j++) {
                folder = foldersToAddToProject[j];
                _this.project.addPath(folder);
              }
              for (k = 0, len2 = fileLocationsToOpen.length; k < len2; k++) {
                ref4 = fileLocationsToOpen[k], pathToOpen = ref4.pathToOpen, initialLine = ref4.initialLine, initialColumn = ref4.initialColumn;
                promises.push((ref5 = _this.workspace) != null ? ref5.open(pathToOpen, {
                  initialLine: initialLine,
                  initialColumn: initialColumn
                }) : void 0);
              }
              return Promise.all(promises);
            }
          };
        })(this));
      } else {
        promises = [];
        for (j = 0, len1 = fileLocationsToOpen.length; j < len1; j++) {
          ref4 = fileLocationsToOpen[j], pathToOpen = ref4.pathToOpen, initialLine = ref4.initialLine, initialColumn = ref4.initialColumn;
          promises.push((ref5 = this.workspace) != null ? ref5.open(pathToOpen, {
            initialLine: initialLine,
            initialColumn: initialColumn
          }) : void 0);
        }
        promise = Promise.all(promises);
      }
      return promise.then(function() {
        return ipcRenderer.send('window-command', 'window:locations-opened');
      });
    };

    AtomEnvironment.prototype.resolveProxy = function(url) {
      return new Promise((function(_this) {
        return function(resolve, reject) {
          var disposable, requestId;
          requestId = _this.nextProxyRequestId++;
          disposable = _this.applicationDelegate.onDidResolveProxy(function(id, proxy) {
            if (id === requestId) {
              disposable.dispose();
              return resolve(proxy);
            }
          });
          return _this.applicationDelegate.resolveProxy(requestId, url);
        };
      })(this));
    };

    return AtomEnvironment;

  })(Model);

  Promise.prototype.done = function(callback) {
    deprecate("Atom now uses ES6 Promises instead of Q. Call promise.then instead of promise.done");
    return this.then(callback);
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiL2hvbWUvdHJhdmlzL2J1aWxkL2F0b20vYXRvbS9vdXQvYXBwL3NyYy9hdG9tLWVudmlyb25tZW50LmNvZmZlZSJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtBQUFBLE1BQUEsOHFCQUFBO0lBQUE7Ozs7O0VBQUEsTUFBQSxHQUFTLE9BQUEsQ0FBUSxRQUFSOztFQUNULElBQUEsR0FBTyxPQUFBLENBQVEsTUFBUjs7RUFDTixjQUFlLE9BQUEsQ0FBUSxVQUFSOztFQUVoQixDQUFBLEdBQUksT0FBQSxDQUFRLGlCQUFSOztFQUNILFlBQWEsT0FBQSxDQUFRLE1BQVI7O0VBQ2QsTUFBNkMsT0FBQSxDQUFRLFdBQVIsQ0FBN0MsRUFBQyw2Q0FBRCxFQUFzQiwyQkFBdEIsRUFBa0M7O0VBQ2xDLEVBQUEsR0FBSyxPQUFBLENBQVEsU0FBUjs7RUFDSixvQkFBcUIsT0FBQSxDQUFRLDBCQUFSOztFQUN0QixLQUFBLEdBQVEsT0FBQSxDQUFRLFNBQVI7O0VBQ1Isa0JBQUEsR0FBcUIsT0FBQSxDQUFRLHdCQUFSOztFQUNyQixVQUFBLEdBQWEsT0FBQSxDQUFRLGVBQVI7O0VBQ2IsYUFBQSxHQUFnQixPQUFBLENBQVEsa0JBQVI7O0VBQ2hCLHVCQUFBLEdBQTBCLE9BQUEsQ0FBUSw2QkFBUjs7RUFDekIsbUJBQW9CLE9BQUEsQ0FBUSxzQkFBUjs7RUFDckIsWUFBQSxHQUFlLE9BQUEsQ0FBUSxpQkFBUjs7RUFFZixtQkFBQSxHQUFzQixPQUFBLENBQVEsd0JBQVI7O0VBQ3RCLFlBQUEsR0FBZSxPQUFBLENBQVEsaUJBQVI7O0VBQ2YsbUJBQUEsR0FBc0IsT0FBQSxDQUFRLHdCQUFSOztFQUN0QixNQUFBLEdBQVMsT0FBQSxDQUFRLFVBQVI7O0VBQ1QsYUFBQSxHQUFnQixPQUFBLENBQVEscUJBQVI7O0VBQ2hCLGNBQUEsR0FBaUIsT0FBQSxDQUFRLG1CQUFSOztFQUNqQixlQUFBLEdBQWtCLE9BQUEsQ0FBUSxvQkFBUjs7RUFDbEIsZUFBQSxHQUFrQixPQUFBLENBQVEsb0JBQVI7O0VBQ2xCLE9BQW1DLE9BQUEsQ0FBUSxtQkFBUixDQUFuQyxFQUFDLG9DQUFELEVBQWlCOztFQUNqQix3QkFBQSxHQUEyQixPQUFBLENBQVEsK0JBQVI7O0VBQzNCLFlBQUEsR0FBZSxPQUFBLENBQVEsaUJBQVI7O0VBQ2YsY0FBQSxHQUFpQixPQUFBLENBQVEsbUJBQVI7O0VBQ2pCLFlBQUEsR0FBZSxPQUFBLENBQVEsaUJBQVI7O0VBQ2YsV0FBQSxHQUFjLE9BQUEsQ0FBUSxnQkFBUjs7RUFDZCxrQkFBQSxHQUFxQixPQUFBLENBQVEsd0JBQVI7O0VBQ3JCLGdCQUFBLEdBQW1CLE9BQUEsQ0FBUSxxQkFBUjs7RUFDbkIsT0FBQSxHQUFVLE9BQUEsQ0FBUSxXQUFSOztFQUNWLFFBQUEsR0FBVyxPQUFBLENBQVEsYUFBUjs7RUFDWCxTQUFBLEdBQVksT0FBQSxDQUFRLGFBQVI7O0VBQ1osY0FBQSxHQUFpQixPQUFBLENBQVEsbUJBQVI7O0VBQ2pCLEtBQUEsR0FBUSxPQUFBLENBQVEsU0FBUjs7RUFDUixhQUFBLEdBQWdCLE9BQUEsQ0FBUSxrQkFBUjs7RUFDaEIsUUFBQSxHQUFXLE9BQUEsQ0FBUSxhQUFSOztFQUNYLElBQUEsR0FBTyxPQUFBLENBQVEsUUFBUjs7RUFDUCxJQUFBLEdBQU8sT0FBQSxDQUFRLFFBQVI7O0VBQ1AsT0FBQSxHQUFVLE9BQUEsQ0FBUSxXQUFSOztFQUNWLFVBQUEsR0FBYSxPQUFBLENBQVEsZUFBUjs7RUFDYixVQUFBLEdBQWEsT0FBQSxDQUFRLGFBQVI7O0VBQ2IsTUFBQSxHQUFTLE9BQUEsQ0FBUSxVQUFSOztFQUNULGtCQUFBLEdBQXFCLE9BQUEsQ0FBUSx3QkFBUjs7RUFDckIsaUJBQUEsR0FBb0IsT0FBQSxDQUFRLHVCQUFSOztFQUtwQixNQUFNLENBQUMsT0FBUCxHQUNNOzs7SUFDSixlQUFDLENBQUEsT0FBRCxHQUFVOzs4QkFFVixpQkFBQSxHQUFtQjs7O0FBRW5COzs7OzhCQUtBLFFBQUEsR0FBVTs7OEJBR1YsTUFBQSxHQUFROzs4QkFHUixTQUFBLEdBQVc7OzhCQUdYLFdBQUEsR0FBYTs7OEJBR2IsSUFBQSxHQUFNOzs4QkFHTixPQUFBLEdBQVM7OzhCQUdULFFBQUEsR0FBVTs7OEJBR1YsYUFBQSxHQUFlOzs4QkFHZixPQUFBLEdBQVM7OzhCQUdULFFBQUEsR0FBVTs7OEJBR1YsT0FBQSxHQUFTOzs4QkFHVCxRQUFBLEdBQVU7OzhCQUdWLE1BQUEsR0FBUTs7OEJBR1IsTUFBQSxHQUFROzs4QkFHUixhQUFBLEdBQWU7OzhCQUdmLEtBQUEsR0FBTzs7OEJBR1AsU0FBQSxHQUFXOzs4QkFHWCxXQUFBLEdBQWE7OzhCQUdiLFdBQUEsR0FBYTs7OEJBRWIseUJBQUEsR0FBMkI7OztBQUUzQjs7OztJQUthLHlCQUFDLE1BQUQ7QUFDWCxVQUFBOztRQURZLFNBQU87O01BQ2xCLElBQUMsQ0FBQSw2QkFBQSxtQkFBRixFQUF1QixJQUFDLENBQUEsbUJBQUEsU0FBeEIsRUFBbUMsSUFBQyxDQUFBLDJCQUFBLGlCQUFwQyxFQUF1RCx3REFBdkQsRUFBZ0YsSUFBQyxDQUFBLDBCQUFBO01BRWpGLElBQUMsQ0FBQSxrQkFBRCxHQUFzQjtNQUN0QixJQUFDLENBQUEsUUFBRCxHQUFZO01BQ1osSUFBQyxDQUFBLFFBQUQsR0FBWTtNQUNaLElBQUMsQ0FBQSxPQUFELEdBQVcsSUFBSTtNQUNmLElBQUMsQ0FBQSxXQUFELEdBQWUsSUFBSTtNQUNuQixJQUFDLENBQUEsYUFBRCxHQUFxQixJQUFBLG1CQUFBLENBQW9CLElBQXBCO01BQ3JCLElBQUMsQ0FBQSxrQkFBRCxHQUFzQjtNQUN0QixJQUFDLENBQUEsS0FBRCxHQUFhLElBQUEsWUFBQSxDQUFhLElBQWI7TUFDYixVQUFVLENBQUMsWUFBWCxDQUF3QixJQUFDLENBQUEsS0FBekI7TUFDQSxJQUFDLENBQUEsYUFBRCxHQUFpQixJQUFJOztRQUNyQixJQUFDLENBQUEsbUJBQW9COztNQUVyQixJQUFDLENBQUEsVUFBRCxHQUFrQixJQUFBLFVBQUEsQ0FBVyxrQkFBWCxFQUErQixDQUEvQjtNQUVsQixJQUFDLENBQUEsTUFBRCxHQUFjLElBQUEsTUFBQSxDQUFPO1FBQUMsbUJBQUEsRUFBcUIsSUFBQyxDQUFBLGFBQXZCO1FBQXVDLG1CQUFELElBQUMsQ0FBQSxpQkFBdkM7T0FBUDtNQUNkLElBQUMsQ0FBQSxNQUFNLENBQUMsU0FBUixDQUFrQixJQUFsQixFQUF3QjtRQUFDLElBQUEsRUFBTSxRQUFQO1FBQWlCLFVBQUEsRUFBWSxDQUFDLENBQUMsS0FBRixDQUFRLFlBQVIsQ0FBN0I7T0FBeEI7TUFFQSxJQUFDLENBQUEsT0FBRCxHQUFlLElBQUEsYUFBQSxDQUFjO1FBQUMsbUJBQUEsRUFBcUIsSUFBQyxDQUFBLGFBQXZCO09BQWQ7TUFDZixJQUFDLENBQUEsUUFBRCxHQUFnQixJQUFBLGNBQUEsQ0FBZTtRQUFBLGFBQUEsRUFBZSxJQUFDLENBQUEsT0FBaEI7UUFBeUIsWUFBQSxFQUFjLElBQUMsQ0FBQSxLQUF4QztPQUFmO01BQ2hCLElBQUMsQ0FBQSxRQUFELEdBQVksSUFBSTtNQUNoQixJQUFDLENBQUEsUUFBRCxHQUFnQixJQUFBLGVBQUEsQ0FBZ0I7UUFBRSxRQUFELElBQUMsQ0FBQSxNQUFGO09BQWhCO01BQ2hCLElBQUMsQ0FBQSxNQUFELEdBQWMsSUFBQSxZQUFBLENBQUE7TUFDZCxJQUFDLENBQUEsUUFBRCxHQUFnQixJQUFBLGNBQUEsQ0FBZTtRQUM1QixRQUFELElBQUMsQ0FBQSxNQUQ0QjtRQUNwQixZQUFBLEVBQWMsSUFBQyxDQUFBLE1BREs7UUFFN0IsZUFBQSxFQUFpQixJQUFDLENBQUEsUUFGVztRQUVELGFBQUEsRUFBZSxJQUFDLENBQUEsT0FGZjtRQUV3QixtQkFBQSxFQUFxQixJQUFDLENBQUEsYUFGOUM7UUFHN0IsZUFBQSxFQUFpQixJQUFDLENBQUEsUUFIVztRQUdELG1CQUFBLEVBQXFCLElBQUMsQ0FBQSxhQUhyQjtRQUdvQyxZQUFBLEVBQWMsSUFBQyxDQUFBLEtBSG5EO09BQWY7TUFLaEIsSUFBQyxDQUFBLE1BQUQsR0FBYyxJQUFBLFlBQUEsQ0FBYTtRQUN6QixjQUFBLEVBQWdCLElBQUMsQ0FBQSxRQURRO1FBQ0csUUFBRCxJQUFDLENBQUEsTUFESDtRQUNXLFlBQUEsRUFBYyxJQUFDLENBQUEsTUFEMUI7UUFFekIsbUJBQUEsRUFBcUIsSUFBQyxDQUFBLGFBRkc7UUFFWSxZQUFBLEVBQWMsSUFBQyxDQUFBLEtBRjNCO09BQWI7TUFJZCxJQUFDLENBQUEsSUFBRCxHQUFZLElBQUEsV0FBQSxDQUFZO1FBQUMsYUFBQSxFQUFlLElBQUMsQ0FBQSxPQUFqQjtRQUEwQixjQUFBLEVBQWdCLElBQUMsQ0FBQSxRQUEzQztPQUFaO01BQ1osSUFBQyxDQUFBLFdBQUQsR0FBbUIsSUFBQSxrQkFBQSxDQUFtQjtRQUFDLGFBQUEsRUFBZSxJQUFDLENBQUEsT0FBakI7T0FBbkI7TUFDbkIsSUFBQyxDQUFBLFFBQVEsQ0FBQyxjQUFWLENBQXlCLElBQUMsQ0FBQSxJQUExQjtNQUNBLElBQUMsQ0FBQSxRQUFRLENBQUMscUJBQVYsQ0FBZ0MsSUFBQyxDQUFBLFdBQWpDO01BQ0EsSUFBQyxDQUFBLFFBQVEsQ0FBQyxlQUFWLENBQTBCLElBQUMsQ0FBQSxNQUEzQjtNQUVBLElBQUMsQ0FBQSxPQUFELEdBQWUsSUFBQSxPQUFBLENBQVE7UUFBQyxtQkFBQSxFQUFxQixJQUFDLENBQUEsYUFBdkI7UUFBc0MsY0FBQSxFQUFnQixJQUFDLENBQUEsUUFBdkQ7UUFBa0UsUUFBRCxJQUFDLENBQUEsTUFBbEU7UUFBMkUscUJBQUQsSUFBQyxDQUFBLG1CQUEzRTtPQUFSO01BQ2YsSUFBQyxDQUFBLGdCQUFELEdBQXdCLElBQUEsZ0JBQUEsQ0FBaUIsSUFBQyxDQUFBLG1CQUFsQjtNQUV4QixJQUFDLENBQUEsV0FBRCxHQUFtQixJQUFBLGtCQUFBLENBQW1CO1FBQ25DLFFBQUQsSUFBQyxDQUFBLE1BRG1DO1FBQzNCLGVBQUEsRUFBaUIsSUFBQyxDQUFBLFFBRFM7UUFDQyxNQUFBLEVBQVEsSUFBQyxDQUFBLE1BQU0sQ0FBQyxJQUFSLENBQWEsSUFBYixDQURUO1FBRXBDLGNBQUEsRUFBZ0IsSUFBQyxDQUFBLFFBRm1CO09BQW5CO01BS25CLElBQUMsQ0FBQSxTQUFELEdBQWlCLElBQUEsU0FBQSxDQUFVO1FBQ3hCLFFBQUQsSUFBQyxDQUFBLE1BRHdCO1FBQ2YsU0FBRCxJQUFDLENBQUEsT0FEZTtRQUNOLGNBQUEsRUFBZ0IsSUFBQyxDQUFBLFFBRFg7UUFDcUIsZUFBQSxFQUFpQixJQUFDLENBQUEsUUFEdkM7UUFDaUQsbUJBQUEsRUFBcUIsSUFBQyxDQUFBLGFBRHZFO1FBRXpCLG1CQUFBLEVBQXFCLElBQUMsQ0FBQSxhQUZHO1FBRWEscUJBQUQsSUFBQyxDQUFBLG1CQUZiO1FBRWtDLFlBQUEsRUFBYyxJQUFDLENBQUEsS0FGakQ7UUFFd0QsTUFBQSxFQUFRLElBQUMsQ0FBQSxNQUFNLENBQUMsSUFBUixDQUFhLElBQWIsQ0FGaEU7UUFHekIsa0JBQUEsRUFBb0IsSUFBQyxDQUFBLFdBSEk7UUFHUyxZQUFBLEVBQWMsSUFBQyxDQUFBLE1BSHhCO1FBR2lDLG1CQUFELElBQUMsQ0FBQSxpQkFIakM7T0FBVjtNQU1qQixJQUFDLENBQUEsTUFBTSxDQUFDLFNBQVIsR0FBb0IsSUFBQyxDQUFBO01BRXJCLElBQUMsQ0FBQSxXQUFELEdBQW1CLElBQUEsaUJBQUEsQ0FBa0I7UUFBRSxxQkFBRCxJQUFDLENBQUEsbUJBQUY7T0FBbEI7TUFFbkIsSUFBRyxJQUFDLENBQUEsT0FBTyxDQUFDLCtCQUFULENBQUEsQ0FBSDtRQUNFLElBQUMsQ0FBQSxPQUFPLENBQUMsa0JBQVQsQ0FBQSxFQURGOztNQUdBLElBQUMsQ0FBQSx1QkFBRCxDQUFBO01BQ0EsSUFBQyxDQUFBLHNCQUFELENBQUE7TUFDQSxJQUFDLENBQUEsNEJBQUQsQ0FBQTtNQUVBLElBQUMsQ0FBQSxrQkFBRCxHQUEwQixJQUFBLGtCQUFBLENBQW1CO1FBQUMsZUFBQSxFQUFpQixJQUFsQjtRQUF5QixxQkFBRCxJQUFDLENBQUEsbUJBQXpCO09BQW5CO01BRTFCLElBQUMsQ0FBQSxPQUFELEdBQWUsSUFBQSxjQUFBLENBQWU7UUFBRSxTQUFELElBQUMsQ0FBQSxPQUFGO1FBQVksVUFBRCxJQUFDLENBQUEsUUFBWjtRQUF1QixZQUFELElBQUMsQ0FBQSxVQUF2QjtPQUFmO01BRWYsSUFBQyxDQUFBLFdBQVcsQ0FBQyxHQUFiLENBQWlCLElBQUMsQ0FBQSxPQUFPLENBQUMsbUJBQVQsQ0FBNkIsQ0FBQSxTQUFBLEtBQUE7ZUFBQSxTQUFDLENBQUQ7VUFDNUMsSUFBQSxDQUFzRCxDQUFDLENBQUMsUUFBeEQ7bUJBQUEsS0FBQyxDQUFBLG1CQUFtQixDQUFDLHVCQUFyQixDQUFBLEVBQUE7O1FBRDRDO01BQUEsQ0FBQSxDQUFBLENBQUEsSUFBQSxDQUE3QixDQUFqQjtJQXJFVzs7OEJBd0ViLFVBQUEsR0FBWSxTQUFDLE1BQUQ7QUFJVixVQUFBOztRQUpXLFNBQU87O01BSWxCLE9BQUEsQ0FBUSx1QkFBUjtNQUVDLElBQUMsQ0FBQSxnQkFBQSxNQUFGLEVBQVUsSUFBQyxDQUFBLGtCQUFBLFFBQVgsRUFBcUIsSUFBQyxDQUFBLG1CQUFBLFNBQXRCLEVBQWlDLElBQUMsQ0FBQSx1QkFBQSxhQUFsQyxFQUFpRDtNQUNqRCxPQUFzRCxJQUFDLENBQUEsZUFBRCxDQUFBLENBQXRELEVBQUMsc0JBQUQsRUFBVSx3QkFBVixFQUFvQixnQ0FBcEIsRUFBa0M7TUFFbEMsSUFBRyxnQkFBSDtRQUNFLElBQUMsQ0FBQSxnQkFBRCxDQUFBLENBQW1CLENBQUMsS0FBcEIsQ0FBQTtRQUNBLElBQUMsQ0FBQSxVQUFVLENBQUMsS0FBWixDQUFBLEVBRkY7O01BSUEsWUFBWSxDQUFDLFdBQWIsR0FBMkI7UUFDekIsSUFBQSxFQUFNLFFBRG1CO1FBRXpCLENBQUEsT0FBQSxDQUFBLEVBQVMsSUFBSSxDQUFDLElBQUwsQ0FBVSxFQUFFLENBQUMsZ0JBQUgsQ0FBQSxDQUFWLEVBQWlDLFFBQWpDLENBRmdCO1FBR3pCLFdBQUEsRUFBYSxzSUFIWTs7TUFLM0IsSUFBQyxDQUFBLE1BQU0sQ0FBQyxVQUFSLENBQW1CO1FBQUUsZUFBRCxJQUFDLENBQUEsYUFBRjtRQUFpQixjQUFBLFlBQWpCO1FBQStCLGlCQUFBLEVBQW1CLFlBQVksQ0FBQyxXQUEvRDtPQUFuQjtNQUVBLElBQUMsQ0FBQSxJQUFJLENBQUMsVUFBTixDQUFpQjtRQUFDLGNBQUEsWUFBRDtPQUFqQjtNQUNBLElBQUMsQ0FBQSxXQUFXLENBQUMsVUFBYixDQUF3QjtRQUFDLGNBQUEsWUFBRDtRQUFlLFNBQUEsT0FBZjtPQUF4QjtNQUVBLElBQUMsQ0FBQSxPQUFPLENBQUMsYUFBVCxHQUF5QixJQUFDLENBQUE7TUFDMUIsSUFBQyxDQUFBLE9BQU8sQ0FBQyxZQUFULEdBQXdCO01BQ3hCLElBQUMsQ0FBQSxPQUFPLENBQUMsT0FBVCxHQUFtQjtNQUNuQixJQUFBLENBQU8sSUFBQyxDQUFBLE9BQU8sQ0FBQywrQkFBVCxDQUFBLENBQVA7UUFDRSxJQUFDLENBQUEsT0FBTyxDQUFDLGtCQUFULENBQUEsRUFERjs7TUFHQSxJQUFDLENBQUEsUUFBUSxDQUFDLE1BQVYsQ0FBaUIsSUFBQyxDQUFBLE1BQWxCO01BRUEsSUFBQyxDQUFBLE1BQU0sQ0FBQyxVQUFSLENBQW1CO1FBQUUsZUFBRCxJQUFDLENBQUEsYUFBRjtPQUFuQjtNQUNBLElBQUMsQ0FBQSxRQUFRLENBQUMsVUFBVixDQUFxQjtRQUFDLFNBQUEsT0FBRDtRQUFXLGVBQUQsSUFBQyxDQUFBLGFBQVg7UUFBMEIsY0FBQSxZQUExQjtRQUF3QyxVQUFBLFFBQXhDO09BQXJCO01BQ0EsSUFBQyxDQUFBLE1BQU0sQ0FBQyxVQUFSLENBQW1CO1FBQUUsZUFBRCxJQUFDLENBQUEsYUFBRjtRQUFpQixjQUFBLFlBQWpCO1FBQStCLFVBQUEsUUFBL0I7UUFBeUMsU0FBQSxPQUF6QztPQUFuQjtNQUVBLElBQUMsQ0FBQSxnQkFBZ0IsQ0FBQyxVQUFsQixDQUE2QixJQUFDLENBQUEsVUFBRCxDQUFBLENBQTdCO01BQ0EsSUFBQyxDQUFBLFdBQVcsQ0FBQyxVQUFiLENBQUE7TUFFQSxJQUFDLENBQUEsTUFBTSxDQUFDLElBQVIsQ0FBQTtNQUVBLElBQUMsQ0FBQSxNQUFNLENBQUMsbUJBQVIsQ0FBQTtNQUNBLElBQUMsQ0FBQSxvQkFBRCxHQUF3QixJQUFDLENBQUEsTUFBTSxDQUFDLFdBQVIsQ0FBQTtNQUN4QixJQUFzQyx1QkFBdEM7UUFBQSxJQUFDLENBQUEsTUFBTSxDQUFDLG1CQUFSLEdBQThCLEtBQTlCOztNQUNBLElBQUMsQ0FBQSxvQkFBRCxDQUFBO01BRUEsSUFBQyxDQUFBLGFBQUQsR0FBaUIsSUFBQyxDQUFBLE1BQU0sQ0FBQyxrQkFBUixDQUFBO01BQ2pCLElBQUMsQ0FBQSxRQUFRLENBQUMsSUFBSSxDQUFDLFdBQWYsQ0FBMkIsSUFBQyxDQUFBLGFBQTVCO01BRUEsSUFBQyxDQUFBLE9BQU8sQ0FBQywwQkFBVCxDQUFBO01BRUEsSUFBQyxDQUFBLDJCQUFELENBQUE7TUFDQSxJQUFDLENBQUEsd0JBQUQsQ0FBQTtNQUNBLElBQUMsQ0FBQSxrQkFBa0IsQ0FBQyxVQUFwQixDQUErQixJQUFDLENBQUEsTUFBaEMsRUFBd0MsSUFBQyxDQUFBLFFBQXpDO01BRUEsZUFBQSxHQUFrQixJQUFDLENBQUEsZUFBZSxDQUFDLElBQWpCLENBQXNCLElBQXRCO01BQ2xCLElBQUMsQ0FBQSxXQUFXLENBQUMsR0FBYixDQUFpQixJQUFDLENBQUEsTUFBTSxDQUFDLG9CQUFSLENBQTZCLGVBQTdCLENBQWpCO01BQ0EsSUFBQyxDQUFBLFdBQVcsQ0FBQyxHQUFiLENBQWlCLElBQUMsQ0FBQSxNQUFNLENBQUMsdUJBQVIsQ0FBZ0MsZUFBaEMsQ0FBakI7TUFDQSxJQUFDLENBQUEsV0FBVyxDQUFDLEdBQWIsQ0FBaUIsSUFBQyxDQUFBLE1BQU0sQ0FBQyx1QkFBUixDQUFnQyxlQUFoQyxDQUFqQjtNQUVBLElBQUMsQ0FBQSxzQkFBRCxDQUFBO2FBRUEsSUFBQyxDQUFBLFdBQVcsQ0FBQyxHQUFiLENBQWlCLElBQUMsQ0FBQSxtQkFBbUIsQ0FBQyx5QkFBckIsQ0FBK0MsQ0FBQSxTQUFBLEtBQUE7ZUFBQSxTQUFBO2lCQUFHLEtBQUMsQ0FBQSxPQUFPLENBQUMsU0FBVCxDQUFBO1FBQUg7TUFBQSxDQUFBLENBQUEsQ0FBQSxJQUFBLENBQS9DLENBQWpCO0lBN0RVOzs4QkErRFosZUFBQSxHQUFpQixTQUFBO2FBQ2YsSUFBQyxDQUFBLFFBQVEsQ0FBQyxlQUFWLENBQUE7SUFEZTs7OEJBR2pCLHdCQUFBLEdBQTBCLFNBQUE7QUFDeEIsVUFBQTtNQUFBLFNBQUEsR0FBWSxDQUFDLENBQUMsUUFBRixDQUFXLENBQUMsQ0FBQSxTQUFBLEtBQUE7ZUFBQSxTQUFBO2lCQUN0QixLQUFDLENBQUEsTUFBTSxDQUFDLG1CQUFSLENBQTRCLFNBQUE7WUFBRyxJQUFBLENBQXdDLEtBQUMsQ0FBQSxRQUF6QztxQkFBQSxLQUFDLENBQUEsU0FBRCxDQUFXO2dCQUFDLFdBQUEsRUFBYSxLQUFkO2VBQVgsRUFBQTs7VUFBSCxDQUE1QjtRQURzQjtNQUFBLENBQUEsQ0FBQSxDQUFBLElBQUEsQ0FBRCxDQUFYLEVBRVQsSUFBQyxDQUFBLHlCQUZRO01BR1osSUFBQyxDQUFBLFFBQVEsQ0FBQyxnQkFBVixDQUEyQixXQUEzQixFQUF3QyxTQUF4QyxFQUFtRCxJQUFuRDtNQUNBLElBQUMsQ0FBQSxRQUFRLENBQUMsZ0JBQVYsQ0FBMkIsU0FBM0IsRUFBc0MsU0FBdEMsRUFBaUQsSUFBakQ7YUFDQSxJQUFDLENBQUEsV0FBVyxDQUFDLEdBQWIsQ0FBcUIsSUFBQSxVQUFBLENBQVcsQ0FBQSxTQUFBLEtBQUE7ZUFBQSxTQUFBO1VBQzlCLEtBQUMsQ0FBQSxRQUFRLENBQUMsbUJBQVYsQ0FBOEIsV0FBOUIsRUFBMkMsU0FBM0MsRUFBc0QsSUFBdEQ7aUJBQ0EsS0FBQyxDQUFBLFFBQVEsQ0FBQyxtQkFBVixDQUE4QixTQUE5QixFQUF5QyxTQUF6QyxFQUFvRCxJQUFwRDtRQUY4QjtNQUFBLENBQUEsQ0FBQSxDQUFBLElBQUEsQ0FBWCxDQUFyQjtJQU53Qjs7OEJBVTFCLDRCQUFBLEdBQThCLFNBQUE7TUFDNUIsSUFBQyxDQUFBLGFBQWEsQ0FBQyxHQUFmLENBQW1CLFNBQW5CO01BQ0EsSUFBQyxDQUFBLGFBQWEsQ0FBQyxHQUFmLENBQW1CLGFBQW5CO01BQ0EsSUFBQyxDQUFBLGFBQWEsQ0FBQyxHQUFmLENBQW1CLFFBQW5CO01BQ0EsSUFBQyxDQUFBLGFBQWEsQ0FBQyxHQUFmLENBQW1CLElBQW5CO01BQ0EsSUFBQyxDQUFBLGFBQWEsQ0FBQyxHQUFmLENBQW1CLElBQW5CO01BQ0EsSUFBQyxDQUFBLGFBQWEsQ0FBQyxHQUFmLENBQW1CLE9BQW5CO01BQ0EsSUFBQyxDQUFBLGFBQWEsQ0FBQyxHQUFmLENBQW1CLFVBQW5CO2FBQ0EsSUFBQyxDQUFBLGFBQWEsQ0FBQyxHQUFmLENBQW1CLFVBQW5CO0lBUjRCOzs4QkFVOUIsdUJBQUEsR0FBeUIsU0FBQTthQUN2Qix1QkFBQSxDQUF3QjtRQUFDLGVBQUEsRUFBaUIsSUFBQyxDQUFBLFFBQW5CO1FBQThCLFFBQUQsSUFBQyxDQUFBLE1BQTlCO1FBQXVDLGtCQUFELElBQUMsQ0FBQSxnQkFBdkM7UUFBeUQsbUJBQUEsRUFBcUIsSUFBQyxDQUFBLGFBQS9FO1FBQStGLFNBQUQsSUFBQyxDQUFBLE9BQS9GO1FBQXlHLFdBQUQsSUFBQyxDQUFBLFNBQXpHO09BQXhCO0lBRHVCOzs4QkFHekIsc0JBQUEsR0FBd0IsU0FBQTthQUN0QixJQUFDLENBQUEsU0FBUyxDQUFDLFNBQVgsQ0FBcUIsQ0FBQSxTQUFBLEtBQUE7ZUFBQSxTQUFDLEdBQUQ7QUFDbkIsa0JBQU8sR0FBUDtBQUFBLGlCQUNPLHlCQURQO3FCQUVJLEtBQUMsQ0FBQSxTQUFTLENBQUMsWUFBWCxDQUF3QixLQUFDLENBQUEsTUFBTSxDQUFDLHFCQUFSLENBQUEsQ0FBeEI7QUFGSixpQkFHTyxxQkFIUDtxQkFJSSxLQUFDLENBQUEsU0FBUyxDQUFDLFlBQVgsQ0FBd0IsS0FBQyxDQUFBLE9BQU8sQ0FBQyxpQkFBVCxDQUFBLENBQXhCO0FBSkosaUJBS08scUJBTFA7cUJBTUksS0FBQyxDQUFBLFNBQVMsQ0FBQyxZQUFYLENBQXdCLEtBQUMsQ0FBQSxNQUFNLENBQUMsaUJBQVIsQ0FBQSxDQUF4QjtBQU5KLGlCQU9PLDBCQVBQO3FCQVFJLEtBQUMsQ0FBQSxTQUFTLENBQUMsWUFBWCxDQUF3QixLQUFDLENBQUEscUJBQUQsQ0FBQSxDQUF4QjtBQVJKO1FBRG1CO01BQUEsQ0FBQSxDQUFBLENBQUEsSUFBQSxDQUFyQjtJQURzQjs7OEJBWXhCLCtCQUFBLEdBQWlDLFNBQUE7YUFDL0IsSUFBQyxDQUFBLE9BQU8sQ0FBQyxhQUFULEdBQXlCLElBQUMsQ0FBQSxTQUFTLENBQUMsVUFBWCxDQUFBO0lBRE07OzhCQUdqQyxzQkFBQSxHQUF3QixTQUFBO01BQ3RCLElBQUMsQ0FBQSxXQUFXLENBQUMsR0FBYixDQUFpQixJQUFDLENBQUEsTUFBTSxDQUFDLFdBQVIsQ0FBb0Isc0JBQXBCLEVBQTRDLENBQUEsU0FBQSxLQUFBO2VBQUEsU0FBQyxJQUFEO0FBQzNELGNBQUE7VUFENkQsV0FBRDtpQkFDNUQsS0FBQyxDQUFBLGtCQUFELENBQW9CLFFBQXBCO1FBRDJEO01BQUEsQ0FBQSxDQUFBLENBQUEsSUFBQSxDQUE1QyxDQUFqQjtNQUVBLElBQTZCLElBQUMsQ0FBQSxNQUFNLENBQUMsR0FBUixDQUFZLHNCQUFaLENBQTdCO2VBQUEsSUFBQyxDQUFBLGtCQUFELENBQW9CLElBQXBCLEVBQUE7O0lBSHNCOzs4QkFLeEIsS0FBQSxHQUFPLFNBQUE7TUFDTCxJQUFDLENBQUEsYUFBYSxDQUFDLEtBQWYsQ0FBQTtNQUNBLElBQUMsQ0FBQSw0QkFBRCxDQUFBO01BRUEsSUFBQyxDQUFBLE1BQU0sQ0FBQyxLQUFSLENBQUE7TUFDQSxJQUFDLENBQUEsTUFBTSxDQUFDLFNBQVIsQ0FBa0IsSUFBbEIsRUFBd0I7UUFBQyxJQUFBLEVBQU0sUUFBUDtRQUFpQixVQUFBLEVBQVksQ0FBQyxDQUFDLEtBQUYsQ0FBUSxZQUFSLENBQTdCO09BQXhCO01BRUEsSUFBQyxDQUFBLE9BQU8sQ0FBQyxLQUFULENBQUE7TUFDQSxJQUFDLENBQUEsT0FBTyxDQUFDLGtCQUFULENBQUE7TUFFQSxJQUFDLENBQUEsUUFBUSxDQUFDLEtBQVYsQ0FBQTtNQUNBLElBQUMsQ0FBQSx1QkFBRCxDQUFBO01BRUEsSUFBQyxDQUFBLE1BQU0sQ0FBQyxlQUFSLENBQXdCLElBQUMsQ0FBQSxvQkFBekI7TUFFQSxJQUFDLENBQUEsSUFBSSxDQUFDLEtBQU4sQ0FBQTtNQUVBLElBQUMsQ0FBQSxTQUFTLENBQUMsS0FBWCxDQUFBO01BRUEsSUFBQyxDQUFBLGFBQWEsQ0FBQyxLQUFmLENBQUE7TUFFQSxJQUFDLENBQUEsV0FBVyxDQUFDLEtBQWIsQ0FBQTtNQUVBLElBQUMsQ0FBQSxRQUFRLENBQUMsS0FBVixDQUFBO01BRUEsSUFBQyxDQUFBLFNBQVMsQ0FBQyxLQUFYLENBQWlCLElBQUMsQ0FBQSxRQUFsQjtNQUNBLElBQUMsQ0FBQSxzQkFBRCxDQUFBO01BRUEsSUFBQyxDQUFBLE9BQU8sQ0FBQyxLQUFULENBQWUsSUFBQyxDQUFBLFFBQWhCO01BRUEsSUFBQyxDQUFBLFNBQVMsQ0FBQyxpQkFBWCxDQUFBO01BRUEsSUFBQyxDQUFBLFFBQVEsQ0FBQyxLQUFWLENBQUE7TUFFQSxJQUFDLENBQUEsV0FBVyxDQUFDLEtBQWIsQ0FBQTthQUVBLElBQUMsQ0FBQSxLQUFLLENBQUMsS0FBUCxDQUFBO0lBcENLOzs4QkFzQ1AsT0FBQSxHQUFTLFNBQUE7QUFDUCxVQUFBO01BQUEsSUFBVSxDQUFJLElBQUMsQ0FBQSxPQUFmO0FBQUEsZUFBQTs7TUFFQSxJQUFDLENBQUEsV0FBVyxDQUFDLE9BQWIsQ0FBQTs7WUFDVSxDQUFFLE9BQVosQ0FBQTs7TUFDQSxJQUFDLENBQUEsU0FBRCxHQUFhO01BQ2IsSUFBQyxDQUFBLE1BQU0sQ0FBQyxTQUFSLEdBQW9COztZQUNaLENBQUUsT0FBVixDQUFBOztNQUNBLElBQUMsQ0FBQSxPQUFELEdBQVc7TUFDWCxJQUFDLENBQUEsUUFBUSxDQUFDLEtBQVYsQ0FBQTtNQUNBLElBQUMsQ0FBQSxhQUFhLENBQUMsTUFBZixDQUFBO01BQ0EsSUFBQyxDQUFBLE1BQU0sQ0FBQyxtQkFBUixDQUFBO01BQ0EsSUFBQyxDQUFBLFdBQVcsQ0FBQyxPQUFiLENBQUE7YUFFQSxJQUFDLENBQUEsMkJBQUQsQ0FBQTtJQWRPOzs7QUFnQlQ7Ozs7OEJBU0EsU0FBQSxHQUFXLFNBQUMsUUFBRDthQUNULElBQUMsQ0FBQSxPQUFPLENBQUMsRUFBVCxDQUFZLFVBQVosRUFBd0IsUUFBeEI7SUFEUzs7OEJBZ0JYLGdCQUFBLEdBQWtCLFNBQUMsUUFBRDthQUNoQixJQUFDLENBQUEsT0FBTyxDQUFDLEVBQVQsQ0FBWSxrQkFBWixFQUFnQyxRQUFoQztJQURnQjs7OEJBY2xCLGVBQUEsR0FBaUIsU0FBQyxRQUFEO2FBQ2YsSUFBQyxDQUFBLE9BQU8sQ0FBQyxFQUFULENBQVksaUJBQVosRUFBK0IsUUFBL0I7SUFEZTs7OEJBTWpCLGtCQUFBLEdBQW9CLFNBQUMsUUFBRDthQUNsQixJQUFDLENBQUEsT0FBTyxDQUFDLEVBQVQsQ0FBWSxvQkFBWixFQUFrQyxRQUFsQztJQURrQjs7OEJBT3BCLDBCQUFBLEdBQTRCLFNBQUMsUUFBRDtNQUMxQixJQUFHLElBQUMsQ0FBQSxzQkFBSjtRQUNFLFFBQUEsQ0FBQTtlQUNJLElBQUEsVUFBQSxDQUFBLEVBRk47T0FBQSxNQUFBO2VBSUUsSUFBQyxDQUFBLE9BQU8sQ0FBQyxJQUFULENBQWMsMEJBQWQsRUFBMEMsUUFBMUMsRUFKRjs7SUFEMEI7OztBQU81Qjs7Ozs4QkFLQSxTQUFBLEdBQVcsU0FBQTtvQ0FDVCxJQUFDLENBQUEsVUFBRCxJQUFDLENBQUEsVUFBVyxJQUFDLENBQUEsZUFBRCxDQUFBLENBQWtCLENBQUM7SUFEdEI7OzhCQUlYLFVBQUEsR0FBWSxTQUFBO3FDQUNWLElBQUMsQ0FBQSxXQUFELElBQUMsQ0FBQSxXQUFZLElBQUMsQ0FBQSxlQUFELENBQUEsQ0FBa0IsQ0FBQztJQUR0Qjs7OEJBSVosVUFBQSxHQUFZLFNBQUE7cUNBQ1YsSUFBQyxDQUFBLFdBQUQsSUFBQyxDQUFBLFdBQVksSUFBQyxDQUFBLGVBQUQsQ0FBQSxDQUFrQixDQUFDO0lBRHRCOzs4QkFLWixXQUFBLEdBQWEsU0FBQTtzQ0FDWCxJQUFDLENBQUEsWUFBRCxJQUFDLENBQUEsWUFBYSxJQUFDLENBQUEsZUFBRCxDQUFBLENBQWtCLENBQUM7SUFEdEI7OzhCQU1iLFVBQUEsR0FBWSxTQUFBO3VDQUNWLElBQUMsQ0FBQSxhQUFELElBQUMsQ0FBQSxhQUFjLElBQUMsQ0FBQSxlQUFELENBQUEsQ0FBa0IsQ0FBQztJQUR4Qjs7OEJBSVosaUJBQUEsR0FBbUIsU0FBQTtBQUNqQixVQUFBO01BQUEsT0FBQSxHQUFVLElBQUMsQ0FBQSxVQUFELENBQUE7TUFDVixJQUFHLE9BQU8sQ0FBQyxPQUFSLENBQWdCLE1BQWhCLENBQUEsR0FBMEIsQ0FBQyxDQUE5QjtlQUNFLE9BREY7T0FBQSxNQUVLLElBQUcsT0FBTyxDQUFDLE9BQVIsQ0FBZ0IsS0FBaEIsQ0FBQSxHQUF5QixDQUFDLENBQTdCO2VBQ0gsTUFERztPQUFBLE1BQUE7ZUFHSCxTQUhHOztJQUpZOzs4QkFVbkIsaUJBQUEsR0FBbUIsU0FBQTthQUNqQixDQUFJLE9BQU8sQ0FBQyxJQUFSLENBQWEsSUFBQyxDQUFBLFVBQUQsQ0FBQSxDQUFiO0lBRGE7OzhCQVVuQixpQkFBQSxHQUFtQixTQUFBO2FBQ2pCLElBQUMsQ0FBQTtJQURnQjs7OEJBTW5CLGVBQUEsR0FBaUIsU0FBQTthQUNmLElBQUMsQ0FBQSxtQkFBbUIsQ0FBQyxxQkFBckIsQ0FBQTtJQURlOzs7QUFHakI7Ozs7OEJBa0JBLElBQUEsR0FBTSxTQUFDLE1BQUQ7YUFDSixJQUFDLENBQUEsbUJBQW1CLENBQUMsSUFBckIsQ0FBMEIsTUFBMUI7SUFESTs7OEJBUU4sVUFBQSxHQUFZLFNBQUMsUUFBRDthQUNWLElBQUMsQ0FBQSxtQkFBbUIsQ0FBQyxVQUFyQixDQUFnQyxRQUFoQztJQURVOzs4QkFJWixLQUFBLEdBQU8sU0FBQTthQUNMLElBQUMsQ0FBQSxtQkFBbUIsQ0FBQyxXQUFyQixDQUFBO0lBREs7OzhCQU1QLE9BQUEsR0FBUyxTQUFBO2FBQ1AsSUFBQyxDQUFBLG1CQUFtQixDQUFDLGFBQXJCLENBQUE7SUFETzs7OEJBT1QsT0FBQSxHQUFTLFNBQUMsS0FBRCxFQUFRLE1BQVI7YUFDUCxJQUFDLENBQUEsbUJBQW1CLENBQUMsYUFBckIsQ0FBbUMsS0FBbkMsRUFBMEMsTUFBMUM7SUFETzs7OEJBTVQsV0FBQSxHQUFhLFNBQUE7YUFDWCxJQUFDLENBQUEsbUJBQW1CLENBQUMsaUJBQXJCLENBQUE7SUFEVzs7OEJBT2IsV0FBQSxHQUFhLFNBQUMsQ0FBRCxFQUFJLENBQUo7YUFDWCxJQUFDLENBQUEsbUJBQW1CLENBQUMsaUJBQXJCLENBQXVDLENBQXZDLEVBQTBDLENBQTFDO0lBRFc7OzhCQUliLGdCQUFBLEdBQWtCLFNBQUE7YUFDaEIsSUFBQyxDQUFBLG1CQUFtQixDQUFDLGdCQUFyQixDQUFBO0lBRGdCOzs4QkFJbEIsTUFBQSxHQUFRLFNBQUE7YUFDTixJQUFDLENBQUEsbUJBQW1CLENBQUMsWUFBckIsQ0FBQTtJQURNOzs4QkFJUixLQUFBLEdBQU8sU0FBQTtNQUNMLElBQUMsQ0FBQSxtQkFBbUIsQ0FBQyxXQUFyQixDQUFBO2FBQ0EsSUFBQyxDQUFBLE1BQU0sQ0FBQyxLQUFSLENBQUE7SUFGSzs7OEJBS1AsSUFBQSxHQUFNLFNBQUE7YUFDSixJQUFDLENBQUEsbUJBQW1CLENBQUMsVUFBckIsQ0FBQTtJQURJOzs4QkFJTixJQUFBLEdBQU0sU0FBQTthQUNKLElBQUMsQ0FBQSxtQkFBbUIsQ0FBQyxVQUFyQixDQUFBO0lBREk7OzhCQUlOLE1BQUEsR0FBUSxTQUFBO2FBQ04sSUFBQyxDQUFBLG1CQUFtQixDQUFDLFlBQXJCLENBQUE7SUFETTs7OEJBSVIsa0JBQUEsR0FBb0IsU0FBQTthQUNsQixJQUFDLENBQUEsbUJBQW1CLENBQUMsa0JBQXJCLENBQUE7SUFEa0I7OzhCQUlwQixXQUFBLEdBQWEsU0FBQTthQUNYLElBQUMsQ0FBQSxtQkFBbUIsQ0FBQyxpQkFBckIsQ0FBQTtJQURXOzs4QkFHYixRQUFBLEdBQVUsU0FBQTthQUNSLElBQUMsQ0FBQSxtQkFBbUIsQ0FBQyxjQUFyQixDQUFBO0lBRFE7OzhCQUlWLFlBQUEsR0FBYyxTQUFBO2FBQ1osSUFBQyxDQUFBLG1CQUFtQixDQUFDLGtCQUFyQixDQUFBO0lBRFk7OzhCQUlkLGFBQUEsR0FBZSxTQUFDLFVBQUQ7O1FBQUMsYUFBVzs7YUFDekIsSUFBQyxDQUFBLG1CQUFtQixDQUFDLG1CQUFyQixDQUF5QyxVQUF6QztJQURhOzs4QkFJZixnQkFBQSxHQUFrQixTQUFBO2FBQ2hCLElBQUMsQ0FBQSxhQUFELENBQWUsQ0FBSSxJQUFDLENBQUEsWUFBRCxDQUFBLENBQW5CO0lBRGdCOzs4QkFPbEIsYUFBQSxHQUFlLFNBQUE7YUFDYixJQUFDLENBQUEsdUJBQUQsQ0FBQSxDQUEwQixDQUFDLElBQTNCLENBQWdDLENBQUEsU0FBQSxLQUFBO2VBQUEsU0FBQTtBQUM5QixjQUFBO1VBQUEsS0FBQSxHQUFRLENBQ04sS0FBQyxDQUFBLHVCQUFELENBQUEsQ0FETSxFQUVOLEtBQUMsQ0FBQSxJQUFELENBQUEsQ0FGTSxFQUdOLEtBQUMsQ0FBQSxLQUFELENBQUEsQ0FITTtVQUtSLGtEQUFxRCxDQUFFLG1CQUF2RDtZQUFBLEtBQUssQ0FBQyxJQUFOLENBQVcsS0FBQyxDQUFBLGFBQUQsQ0FBZSxJQUFmLENBQVgsRUFBQTs7VUFDQSxtREFBNEMsQ0FBRSxtQkFBbkIsSUFBaUMsT0FBTyxDQUFDLFFBQVIsS0FBc0IsUUFBbEY7WUFBQSxLQUFLLENBQUMsSUFBTixDQUFXLEtBQUMsQ0FBQSxRQUFELENBQUEsQ0FBWCxFQUFBOztpQkFDQSxPQUFPLENBQUMsR0FBUixDQUFZLEtBQVo7UUFSOEI7TUFBQSxDQUFBLENBQUEsQ0FBQSxJQUFBLENBQWhDO0lBRGE7OzhCQWtCZixtQkFBQSxHQUFxQixTQUFBO0FBQ25CLFVBQUE7TUFBQSxhQUFBLEdBQWdCLElBQUMsQ0FBQSxnQkFBRCxDQUFBO01BQ2hCLE9BQVMsYUFBYSxDQUFDLFdBQWQsQ0FBQSxDQUFULEVBQUMsV0FBRCxFQUFJO01BQ0osT0FBa0IsYUFBYSxDQUFDLE9BQWQsQ0FBQSxDQUFsQixFQUFDLGVBQUQsRUFBUTtNQUNSLFNBQUEsR0FBWSxhQUFhLENBQUMsV0FBZCxDQUFBO2FBQ1o7UUFBQyxHQUFBLENBQUQ7UUFBSSxHQUFBLENBQUo7UUFBTyxPQUFBLEtBQVA7UUFBYyxRQUFBLE1BQWQ7UUFBc0IsV0FBQSxTQUF0Qjs7SUFMbUI7OzhCQWtCckIsbUJBQUEsR0FBcUIsU0FBQyxJQUFEO0FBQ25CLFVBQUE7TUFEcUIsWUFBRyxZQUFHLG9CQUFPO01BQ2xDLEtBQUEsR0FBUTtNQUNSLElBQUcsZUFBQSxJQUFXLGdCQUFkO1FBQ0UsS0FBSyxDQUFDLElBQU4sQ0FBVyxJQUFDLENBQUEsT0FBRCxDQUFTLEtBQVQsRUFBZ0IsTUFBaEIsQ0FBWCxFQURGOztNQUVBLElBQUcsV0FBQSxJQUFPLFdBQVY7UUFDRSxLQUFLLENBQUMsSUFBTixDQUFXLElBQUMsQ0FBQSxXQUFELENBQWEsQ0FBYixFQUFnQixDQUFoQixDQUFYLEVBREY7T0FBQSxNQUFBO1FBR0UsS0FBSyxDQUFDLElBQU4sQ0FBVyxJQUFDLENBQUEsTUFBRCxDQUFBLENBQVgsRUFIRjs7YUFJQSxPQUFPLENBQUMsR0FBUixDQUFZLEtBQVo7SUFSbUI7OzhCQVlyQixpQkFBQSxHQUFtQixTQUFDLElBQUQ7QUFDakIsVUFBQTs0QkFEa0IsT0FBc0IsSUFBckIsWUFBRyxZQUFHLG9CQUFPO2FBQ2hDLEtBQUEsR0FBUSxDQUFSLElBQWMsTUFBQSxHQUFTLENBQXZCLElBQTZCLENBQUEsR0FBSSxLQUFKLEdBQVksQ0FBekMsSUFBK0MsQ0FBQSxHQUFJLE1BQUosR0FBYTtJQUQzQzs7OEJBR25CLHFCQUFBLEdBQXVCLFNBQUE7TUFDckIsSUFBQyxDQUFBLGdCQUFELEdBQW9CLElBQUMsQ0FBQSxtQkFBRCxDQUFBO01BQ3BCLElBQUcsSUFBQyxDQUFBLGlCQUFELENBQW1CLElBQUMsQ0FBQSxnQkFBcEIsQ0FBSDtlQUNFLFlBQVksQ0FBQyxPQUFiLENBQXFCLHlCQUFyQixFQUFnRCxJQUFJLENBQUMsU0FBTCxDQUFlLElBQUMsQ0FBQSxnQkFBaEIsQ0FBaEQsRUFERjs7SUFGcUI7OzhCQUt2QiwwQkFBQSxHQUE0QixTQUFBO0FBQzFCLFVBQUE7TUFBQyxtQkFBb0IsSUFBQyxDQUFBLGVBQUQsQ0FBQTtNQUNyQixJQUEyQix3QkFBM0I7QUFBQSxlQUFPLGlCQUFQOztNQUVBLFVBQUEsR0FBYTtBQUNiO1FBQ0UsVUFBQSxHQUFhLElBQUksQ0FBQyxLQUFMLENBQVcsWUFBWSxDQUFDLE9BQWIsQ0FBcUIseUJBQXJCLENBQVgsRUFEZjtPQUFBLGNBQUE7UUFFTTtRQUNKLE9BQU8sQ0FBQyxJQUFSLENBQWEseUNBQWIsRUFBd0QsS0FBeEQ7UUFDQSxZQUFZLENBQUMsVUFBYixDQUF3Qix5QkFBeEIsRUFKRjs7TUFNQSxJQUFHLElBQUMsQ0FBQSxpQkFBRCxDQUFtQixVQUFuQixDQUFIO2VBQ0UsV0FERjtPQUFBLE1BQUE7UUFHRSxPQUFrQixJQUFDLENBQUEsbUJBQW1CLENBQUMsNkJBQXJCLENBQUEsQ0FBbEIsRUFBQyxrQkFBRCxFQUFRO2VBQ1I7VUFBQyxDQUFBLEVBQUcsQ0FBSjtVQUFPLENBQUEsRUFBRyxDQUFWO1VBQWEsS0FBQSxFQUFPLElBQUksQ0FBQyxHQUFMLENBQVMsSUFBVCxFQUFlLEtBQWYsQ0FBcEI7VUFBMkMsUUFBQSxNQUEzQztVQUpGOztJQVgwQjs7OEJBaUI1Qix1QkFBQSxHQUF5QixTQUFBO01BQ3ZCLElBQUEsQ0FBQSxDQUFPLCtCQUFBLElBQXVCLElBQUMsQ0FBQSxpQkFBRCxDQUFtQixJQUFDLENBQUEsZ0JBQXBCLENBQTlCLENBQUE7UUFDRSxJQUFDLENBQUEsZ0JBQUQsR0FBb0IsSUFBQyxDQUFBLDBCQUFELENBQUEsRUFEdEI7O2FBRUEsSUFBQyxDQUFBLG1CQUFELENBQXFCLElBQUMsQ0FBQSxnQkFBdEIsQ0FBdUMsQ0FBQyxJQUF4QyxDQUE2QyxDQUFBLFNBQUEsS0FBQTtlQUFBLFNBQUE7aUJBQUcsS0FBQyxDQUFBO1FBQUo7TUFBQSxDQUFBLENBQUEsQ0FBQSxJQUFBLENBQTdDO0lBSHVCOzs4QkFLekIsdUJBQUEsR0FBeUIsU0FBQTtBQUN2QixVQUFBO01BQUEsSUFBRyxlQUFBLEdBQWtCLE1BQU0sQ0FBQyxZQUFZLENBQUMsT0FBcEIsQ0FBNEIsOEJBQTVCLENBQXJCO1FBQ0UsSUFBQyxDQUFBLG9CQUFELEdBQXdCLFFBQVEsQ0FBQyxhQUFULENBQXVCLE9BQXZCO1FBQ3hCLElBQUMsQ0FBQSxvQkFBb0IsQ0FBQyxJQUF0QixHQUE2QjtRQUM3QixJQUFDLENBQUEsb0JBQW9CLENBQUMsU0FBdEIsR0FBa0MsMkJBQUEsR0FBOEIsZUFBOUIsR0FBZ0Q7ZUFDbEYsUUFBUSxDQUFDLElBQUksQ0FBQyxXQUFkLENBQTBCLElBQUMsQ0FBQSxvQkFBM0IsRUFKRjs7SUFEdUI7OzhCQU96QixxQkFBQSxHQUF1QixTQUFBO0FBQ3JCLFVBQUE7TUFBQSxJQUFVLElBQUMsQ0FBQSxVQUFELENBQUEsQ0FBVjtBQUFBLGVBQUE7O01BRUEsZUFBQSxHQUFrQixJQUFDLENBQUEsTUFBTSxDQUFDLGdCQUFSLENBQXlCLElBQUMsQ0FBQSxTQUFTLENBQUMsVUFBWCxDQUFBLENBQXpCLENBQWtELENBQUEsa0JBQUE7YUFDcEUsSUFBQyxDQUFBLE1BQU0sQ0FBQyxZQUFZLENBQUMsT0FBckIsQ0FBNkIsOEJBQTdCLEVBQTZELGVBQTdEO0lBSnFCOzs4QkFPdkIsaUJBQUEsR0FBbUIsU0FBQTtBQUNqQixVQUFBO01BQUEsSUFBQyxDQUFBLFFBQUQsR0FBWTtNQUVaLHVCQUFBLEdBQTBCLElBQUMsQ0FBQSwrQkFBRCxDQUFBO01BRTFCLGdCQUFBLEdBQW1CLElBQUMsQ0FBQSxTQUFELENBQUEsQ0FBWSxDQUFDLElBQWIsQ0FBa0IsQ0FBQSxTQUFBLEtBQUE7ZUFBQSxTQUFDLEtBQUQ7VUFDbkMsS0FBQyxDQUFBLGdCQUFELG1CQUFvQixLQUFLLENBQUU7aUJBQzNCLEtBQUMsQ0FBQSxhQUFELENBQUEsQ0FBZ0IsQ0FBQyxJQUFqQixDQUFzQixTQUFBO0FBQ3BCLGdCQUFBO1lBQUEsS0FBQyxDQUFBLGdCQUFnQixDQUFDLGtCQUFsQixDQUFxQyxLQUFyQyxFQUE0QyxTQUFDLEtBQUQ7Y0FDMUMsSUFBOEIsYUFBOUI7dUJBQUEsT0FBTyxDQUFDLElBQVIsQ0FBYSxLQUFLLENBQUMsT0FBbkIsRUFBQTs7WUFEMEMsQ0FBNUM7WUFFQSxLQUFDLENBQUEsZ0JBQWdCLENBQUMsaUJBQWxCLENBQW9DLEtBQXBDLEVBQTJDLFNBQUMsS0FBRDtjQUN6QyxJQUE4QixhQUE5Qjt1QkFBQSxPQUFPLENBQUMsSUFBUixDQUFhLEtBQUssQ0FBQyxPQUFuQixFQUFBOztZQUR5QyxDQUEzQztZQUdBLEtBQUMsQ0FBQSxXQUFXLENBQUMsR0FBYixDQUFpQixLQUFDLENBQUEsbUJBQW1CLENBQUMsa0JBQXJCLENBQXdDLEtBQUMsQ0FBQSxhQUFhLENBQUMsSUFBZixDQUFvQixLQUFwQixDQUF4QyxDQUFqQjtZQUNBLEtBQUMsQ0FBQSxXQUFXLENBQUMsR0FBYixDQUFpQixLQUFDLENBQUEsbUJBQW1CLENBQUMsd0JBQXJCLENBQThDLEtBQUMsQ0FBQSw4QkFBOEIsQ0FBQyxJQUFoQyxDQUFxQyxLQUFyQyxDQUE5QyxDQUFqQjtZQUNBLEtBQUMsQ0FBQSxXQUFXLENBQUMsR0FBYixDQUFpQixLQUFDLENBQUEsbUJBQW1CLENBQUMsb0JBQXJCLENBQTBDLEtBQUMsQ0FBQSwwQkFBMEIsQ0FBQyxJQUE1QixDQUFpQyxLQUFqQyxDQUExQyxDQUFqQjtZQUNBLEtBQUMsQ0FBQSxXQUFXLENBQUMsR0FBYixDQUFpQixLQUFDLENBQUEsbUJBQW1CLENBQUMsa0JBQXJCLENBQXdDLFNBQUE7cUJBQ3ZELEtBQUMsQ0FBQSxTQUFELENBQVc7Z0JBQUMsV0FBQSxFQUFhLElBQWQ7ZUFBWCxDQUNFLEVBQUMsS0FBRCxFQURGLENBQ1MsT0FBTyxDQUFDLEtBRGpCLENBRUUsQ0FBQyxJQUZILENBRVEsU0FBQTtBQUNKLG9CQUFBOzhEQUFVLENBQUUsWUFBWixDQUF5QjtrQkFDdkIsb0JBQUEsRUFBc0IsSUFEQztrQkFFdkIsZUFBQSxFQUFpQixLQUFDLENBQUEsT0FBTyxDQUFDLFFBQVQsQ0FBQSxDQUFtQixDQUFDLE1BQXBCLEdBQTZCLENBRnZCO2lCQUF6QjtjQURJLENBRlI7WUFEdUQsQ0FBeEMsQ0FBakI7WUFTQSxLQUFDLENBQUEsZ0JBQUQsQ0FBQTtZQUVBLEtBQUMsQ0FBQSwrQkFBRCxDQUFBO1lBRUEsS0FBQyxDQUFBLFFBQVEsQ0FBQyxZQUFWLENBQUE7WUFFQSxTQUFBLEdBQVksSUFBSSxDQUFDLEdBQUwsQ0FBQTttQkFDWixLQUFDLENBQUEsV0FBRCxDQUFhLEtBQWIsQ0FBbUIsQ0FBQyxJQUFwQixDQUF5QixTQUFBO0FBQ3ZCLGtCQUFBO2NBQUEsS0FBQyxDQUFBLGtCQUFrQixDQUFDLElBQXBCLEdBQTJCLElBQUksQ0FBQyxHQUFMLENBQUEsQ0FBQSxHQUFhO2NBRXhDLElBQUcsT0FBTyxDQUFDLFFBQVIsS0FBb0IsUUFBcEIsSUFBaUMsS0FBQyxDQUFBLE1BQU0sQ0FBQyxHQUFSLENBQVksZUFBWixDQUFBLEtBQWdDLFFBQXBFO2dCQUNFLEtBQUMsQ0FBQSxTQUFTLENBQUMsY0FBWCxDQUEwQjtrQkFBQyxJQUFBLEVBQVUsSUFBQSxRQUFBLENBQVM7b0JBQUUsV0FBRCxLQUFDLENBQUEsU0FBRjtvQkFBYyxRQUFELEtBQUMsQ0FBQSxNQUFkO29CQUF1QixxQkFBRCxLQUFDLENBQUEsbUJBQXZCO21CQUFULENBQVg7aUJBQTFCO2dCQUNBLEtBQUMsQ0FBQSxRQUFRLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxHQUF6QixDQUE2QixrQkFBN0IsRUFGRjs7Y0FHQSxJQUFHLE9BQU8sQ0FBQyxRQUFSLEtBQW9CLFFBQXBCLElBQWlDLEtBQUMsQ0FBQSxNQUFNLENBQUMsR0FBUixDQUFZLGVBQVosQ0FBQSxLQUFnQyxjQUFwRTtnQkFDRSxLQUFDLENBQUEsU0FBUyxDQUFDLGNBQVgsQ0FBMEI7a0JBQUMsSUFBQSxFQUFVLElBQUEsUUFBQSxDQUFTO29CQUFFLFdBQUQsS0FBQyxDQUFBLFNBQUY7b0JBQWMsUUFBRCxLQUFDLENBQUEsTUFBZDtvQkFBdUIscUJBQUQsS0FBQyxDQUFBLG1CQUF2QjttQkFBVCxDQUFYO2lCQUExQjtnQkFDQSxLQUFDLENBQUEsUUFBUSxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsR0FBekIsQ0FBNkIsd0JBQTdCLEVBRkY7O2NBR0EsSUFBRyxPQUFPLENBQUMsUUFBUixLQUFvQixRQUFwQixJQUFpQyxLQUFDLENBQUEsTUFBTSxDQUFDLEdBQVIsQ0FBWSxlQUFaLENBQUEsS0FBZ0MsUUFBcEU7Z0JBQ0UsS0FBQyxDQUFBLFFBQVEsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLEdBQXpCLENBQTZCLGtCQUE3QixFQURGOztjQUdBLEtBQUMsQ0FBQSxRQUFRLENBQUMsSUFBSSxDQUFDLFdBQWYsQ0FBMkIsS0FBQyxDQUFBLFNBQVMsQ0FBQyxVQUFYLENBQUEsQ0FBM0I7O29CQUNxQixDQUFFLE1BQXZCLENBQUE7O2NBRUEsS0FBQyxDQUFBLGlCQUFELENBQUE7Y0FFQSxLQUFDLENBQUEsUUFBUSxDQUFDLFFBQVYsQ0FBQTtjQUNBLEtBQUMsQ0FBQSxPQUFPLENBQUMsY0FBVCxDQUFBO2NBQ0EsSUFBQSxDQUFnQyxLQUFDLENBQUEsZUFBRCxDQUFBLENBQWtCLENBQUMsUUFBbkQ7Z0JBQUEsS0FBQyxDQUFBLHFCQUFELENBQUEsRUFBQTs7Y0FFQSxLQUFDLENBQUEsSUFBSSxDQUFDLE1BQU4sQ0FBQTtxQkFFQSxLQUFDLENBQUEsaUNBQUQsQ0FBQTtZQXZCdUIsQ0FBekI7VUF6Qm9CLENBQXRCO1FBRm1DO01BQUEsQ0FBQSxDQUFBLENBQUEsSUFBQSxDQUFsQjtNQW9EbkIsa0JBQUEsR0FBcUIsSUFBQyxDQUFBLE9BQU8sQ0FBQyxTQUFULENBQUEsQ0FBb0IsQ0FBQyxJQUFyQixDQUEwQixDQUFBLFNBQUEsS0FBQTtlQUFBLFNBQUE7VUFDN0MsS0FBQyxDQUFBLHdCQUFELEdBQWdDLElBQUEsd0JBQUEsQ0FBeUI7WUFDdEQsTUFBRCxLQUFDLENBQUEsSUFEc0Q7WUFDL0MsVUFBRCxLQUFDLENBQUEsUUFEK0M7WUFDcEMsU0FBRCxLQUFDLENBQUEsT0FEb0M7WUFDMUIsUUFBRCxLQUFDLENBQUEsTUFEMEI7WUFFdkQsSUFBQSxFQUFNLFNBQUMsS0FBRDtxQkFBVyxLQUFDLENBQUEsSUFBRCxDQUFNO2dCQUFBLFdBQUEsRUFBYSxLQUFiO2VBQU47WUFBWCxDQUZpRDtXQUF6QjtpQkFJaEMsS0FBQyxDQUFBLHdCQUF3QixDQUFDLE1BQTFCLENBQUE7UUFMNkM7TUFBQSxDQUFBLENBQUEsQ0FBQSxJQUFBLENBQTFCO2FBT3JCLE9BQU8sQ0FBQyxHQUFSLENBQVksQ0FBQyxnQkFBRCxFQUFtQixrQkFBbkIsRUFBdUMsdUJBQXZDLENBQVo7SUFoRWlCOzs4QkFrRW5CLFNBQUEsR0FBVyxTQUFDLE9BQUQ7YUFDVDtRQUFBLE9BQUEsRUFBUyxJQUFDLENBQUEsV0FBVyxDQUFDLE9BQXRCO1FBQ0EsT0FBQSxFQUFTLElBQUMsQ0FBQSxPQUFPLENBQUMsU0FBVCxDQUFtQixPQUFuQixDQURUO1FBRUEsU0FBQSxFQUFXLElBQUMsQ0FBQSxTQUFTLENBQUMsU0FBWCxDQUFBLENBRlg7UUFHQSxhQUFBLEVBQWUsSUFBQyxDQUFBLFFBQVEsQ0FBQyxTQUFWLENBQUEsQ0FIZjtRQUlBLFFBQUEsRUFBVTtVQUFDLHNCQUFBLEVBQXdCLElBQUMsQ0FBQSxRQUFRLENBQUMsc0JBQW5DO1NBSlY7UUFLQSxVQUFBLEVBQVksSUFBQyxDQUFBLFlBQUQsQ0FBQSxDQUxaO1FBTUEsZ0JBQUEsRUFBa0IsSUFBQyxDQUFBLGdCQU5uQjtRQU9BLFdBQUEsRUFBYSxJQUFDLENBQUEsV0FBVyxDQUFDLFNBQWIsQ0FBQSxDQVBiOztJQURTOzs4QkFVWCxrQkFBQSxHQUFvQixTQUFBO01BQ2xCLElBQVUsQ0FBSSxJQUFDLENBQUEsT0FBZjtBQUFBLGVBQUE7O01BRUEsSUFBQyxDQUFBLHFCQUFELENBQUE7TUFDQSxJQUFDLENBQUEsUUFBUSxDQUFDLGtCQUFWLENBQUE7TUFDQSxJQUFDLENBQUEsaUJBQUQsQ0FBQTthQUNBLElBQUMsQ0FBQSxRQUFELEdBQVk7SUFOTTs7OEJBUXBCLGlCQUFBLEdBQW1CLFNBQUE7TUFDakIsSUFBRyxJQUFDLENBQUEsaUJBQUo7ZUFDRSxJQUFDLENBQUEsU0FBUyxDQUFDLElBQVgsQ0FBQSxFQURGOztJQURpQjs7OEJBSW5CLGlDQUFBLEdBQW1DLFNBQUE7QUFDakMsVUFBQTtNQUFBLElBQUEsQ0FBYyxJQUFDLENBQUEsTUFBTSxDQUFDLEdBQVIsQ0FBWSw2QkFBWixDQUFkO0FBQUEsZUFBQTs7TUFDQSxnRUFBa0MsQ0FBRSxnQkFBakMsS0FBMkMsQ0FBM0MsSUFBaUQsSUFBQyxDQUFBLFNBQVMsQ0FBQyxZQUFYLENBQUEsQ0FBeUIsQ0FBQyxNQUExQixLQUFvQyxDQUF4RjtlQUNFLElBQUMsQ0FBQSxTQUFTLENBQUMsSUFBWCxDQUFnQixJQUFoQixFQURGOztJQUZpQzs7OEJBS25DLDJCQUFBLEdBQTZCLFNBQUE7TUFDM0IsSUFBQyxDQUFBLDBCQUFELEdBQThCLElBQUMsQ0FBQSxNQUFNLENBQUM7YUFDdEMsSUFBQyxDQUFBLE1BQU0sQ0FBQyxPQUFSLEdBQWtCLENBQUEsU0FBQSxLQUFBO2VBQUEsU0FBQTtBQUNoQixjQUFBO1VBQUEsS0FBQyxDQUFBLGlCQUFELEdBQXFCLEtBQUssQ0FBQSxTQUFFLENBQUEsS0FBSyxDQUFDLElBQWIsQ0FBa0IsU0FBbEI7VUFDckIsT0FBOEMsS0FBQyxDQUFBLGlCQUEvQyxFQUFDLGlCQUFELEVBQVUsYUFBVixFQUFlLGNBQWYsRUFBcUIsZ0JBQXJCLEVBQTZCO1VBRTdCLE9BQXlCLGlCQUFBLENBQWtCO1lBQUMsTUFBQSxFQUFRLEdBQVQ7WUFBYyxNQUFBLElBQWQ7WUFBb0IsUUFBQSxNQUFwQjtXQUFsQixDQUF6QixFQUFDLGdCQUFELEVBQU8sb0JBQVAsRUFBZTtVQUVmLElBQUcsR0FBQSxLQUFPLFlBQVY7WUFDRSxHQUFBLEdBQU0sT0FEUjs7VUFHQSxXQUFBLEdBQWM7WUFBQyxTQUFBLE9BQUQ7WUFBVSxLQUFBLEdBQVY7WUFBZSxNQUFBLElBQWY7WUFBcUIsUUFBQSxNQUFyQjtZQUE2QixlQUFBLGFBQTdCOztVQUVkLFlBQUEsR0FBZTtVQUNmLFdBQVcsQ0FBQyxjQUFaLEdBQTZCLFNBQUE7bUJBQUcsWUFBQSxHQUFlO1VBQWxCO1VBRTdCLEtBQUMsQ0FBQSxPQUFPLENBQUMsSUFBVCxDQUFjLGtCQUFkLEVBQWtDLFdBQWxDO1VBRUEsSUFBRyxZQUFIO1lBQ0UsS0FBQyxDQUFBLFlBQUQsQ0FBQSxDQUFlLENBQUMsSUFBaEIsQ0FBcUIsU0FBQTtxQkFBRyxLQUFDLENBQUEsMkJBQUQsQ0FBNkIsa0NBQTdCO1lBQUgsQ0FBckIsRUFERjs7aUJBR0EsS0FBQyxDQUFBLE9BQU8sQ0FBQyxJQUFULENBQWMsaUJBQWQsRUFBaUM7WUFBQyxTQUFBLE9BQUQ7WUFBVSxLQUFBLEdBQVY7WUFBZSxNQUFBLElBQWY7WUFBcUIsUUFBQSxNQUFyQjtZQUE2QixlQUFBLGFBQTdCO1dBQWpDO1FBbkJnQjtNQUFBLENBQUEsQ0FBQSxDQUFBLElBQUE7SUFGUzs7OEJBdUI3Qiw2QkFBQSxHQUErQixTQUFBO2FBQzdCLElBQUMsQ0FBQSxNQUFNLENBQUMsT0FBUixHQUFrQixJQUFDLENBQUE7SUFEVTs7OEJBRy9CLHlCQUFBLEdBQTJCLFNBQUE7TUFDekIsSUFBQyxDQUFBLGtCQUFELEdBQTBCLElBQUEsa0JBQUEsQ0FBbUI7UUFBQyxlQUFBLEVBQWlCLElBQWxCO1FBQXlCLHFCQUFELElBQUMsQ0FBQSxtQkFBekI7T0FBbkI7YUFDMUIsSUFBQyxDQUFBLGtCQUFrQixDQUFDLFVBQXBCLENBQStCLElBQUMsQ0FBQSxNQUFoQyxFQUF3QyxJQUFDLENBQUEsUUFBekM7SUFGeUI7OzhCQUkzQiwyQkFBQSxHQUE2QixTQUFBO0FBQzNCLFVBQUE7O1lBQW1CLENBQUUsV0FBckIsQ0FBQTs7YUFDQSxJQUFDLENBQUEsa0JBQUQsR0FBc0I7SUFGSzs7OEJBSTdCLGVBQUEsR0FBaUIsU0FBQyxZQUFEO01BQ2YsVUFBVSxDQUFDLGVBQVgsQ0FBQTtNQUNBLElBQUcsWUFBWSxDQUFDLFdBQVcsQ0FBQyxPQUF6QixDQUFpQyxXQUFqQyxDQUFBLElBQWlELENBQXBEO2VBQ0UsVUFBVSxDQUFDLHdCQUFYLENBQUEsRUFERjs7SUFGZTs7OEJBS2pCLCtCQUFBLEdBQWlDLFNBQUE7YUFDL0IsSUFBQyxDQUFBLGdCQUFELENBQWtCLElBQUMsQ0FBQSxlQUFELENBQUEsQ0FBa0IsQ0FBQyxHQUFyQyxDQUF5QyxDQUFDLElBQTFDLENBQStDLENBQUEsU0FBQSxLQUFBO2VBQUEsU0FBQTtVQUM3QyxLQUFDLENBQUEsc0JBQUQsR0FBMEI7VUFDMUIsS0FBQyxDQUFBLE9BQU8sQ0FBQyxJQUFULENBQWMsMEJBQWQ7aUJBQ0EsS0FBQyxDQUFBLFFBQVEsQ0FBQyxxQkFBVixDQUFnQywrQkFBaEM7UUFINkM7TUFBQSxDQUFBLENBQUEsQ0FBQSxJQUFBLENBQS9DO0lBRCtCOzs7QUFNakM7Ozs7OEJBS0EsSUFBQSxHQUFNLFNBQUE7TUFDSixJQUF3QyxJQUFDLENBQUEsTUFBTSxDQUFDLEdBQVIsQ0FBWSxnQkFBWixDQUF4QztRQUFBLElBQUMsQ0FBQSxtQkFBbUIsQ0FBQyxhQUFyQixDQUFBLEVBQUE7O2FBQ0EsSUFBQyxDQUFBLE9BQU8sQ0FBQyxJQUFULENBQWMsVUFBZDtJQUZJOzs4QkF3Qk4sT0FBQSxHQUFTLFNBQUMsTUFBRDs7UUFBQyxTQUFPOzthQUNmLElBQUMsQ0FBQSxtQkFBbUIsQ0FBQyxPQUFyQixDQUE2QixNQUE3QjtJQURPOzs7QUFHVDs7Ozs4QkFPQSxZQUFBLEdBQWMsU0FBQTthQUNaLElBQUMsQ0FBQSxtQkFBbUIsQ0FBQyxrQkFBckIsQ0FBQTtJQURZOzs4QkFPZCxjQUFBLEdBQWdCLFNBQUE7YUFDZCxJQUFDLENBQUEsbUJBQW1CLENBQUMsb0JBQXJCLENBQUE7SUFEYzs7OEJBSWhCLDJCQUFBLEdBQTZCLFNBQUMsSUFBRDthQUMzQixJQUFDLENBQUEsbUJBQW1CLENBQUMsaUNBQXJCLENBQXVELElBQXZEO0lBRDJCOzs7QUFHN0I7Ozs7OEJBSUEsTUFBQSxHQUFRLFNBQUMsU0FBRCxFQUFZLE9BQVosRUFBcUIsa0JBQXJCO0FBQ04sVUFBQTtNQUFBLElBQWUsU0FBZjtBQUFBLGVBQU8sS0FBUDs7TUFFQSxLQUFBLEdBQVksSUFBQSxLQUFBLENBQU0sb0JBQUEsR0FBcUIsT0FBM0I7TUFDWixLQUFLLENBQUMsaUJBQU4sQ0FBd0IsS0FBeEIsRUFBK0IsSUFBQyxDQUFBLE1BQWhDO01BRUEsSUFBRywwQkFBSDtRQUNFLElBQUcsT0FBTyxrQkFBUCxLQUE2QixVQUFoQzs7WUFDRSxtQkFBb0I7V0FEdEI7U0FBQSxNQUFBO1VBR0UsS0FBSyxDQUFDLFFBQU4sR0FBaUIsbUJBSG5CO1NBREY7O01BTUEsSUFBQyxDQUFBLE9BQU8sQ0FBQyxJQUFULENBQWMsb0JBQWQsRUFBb0MsS0FBcEM7TUFDQSxJQUFBLENBQU8sSUFBQyxDQUFBLGlCQUFELENBQUEsQ0FBUDtBQUNFLGNBQU0sTUFEUjs7YUFHQTtJQWhCTTs7OEJBa0JSLFVBQUEsR0FBWSxTQUFBO2FBQ1YsSUFBQyxDQUFBLE1BQU0sQ0FBQyxJQUFSLENBQUE7SUFEVTs7OEJBSVosaUJBQUEsR0FBbUIsU0FBQTthQUNqQixJQUFDLENBQUEsV0FBVyxDQUFDLEdBQWIsQ0FBaUIsSUFBQyxDQUFBLE9BQU8sQ0FBQyxnQkFBVCxDQUEwQixDQUFBLFNBQUEsS0FBQTtlQUFBLFNBQUE7aUJBQ3pDLEtBQUMsQ0FBQSxtQkFBbUIsQ0FBQyw0QkFBckIsQ0FBa0QsS0FBQyxDQUFBLE9BQU8sQ0FBQyxRQUFULENBQUEsQ0FBbEQ7UUFEeUM7TUFBQSxDQUFBLENBQUEsQ0FBQSxJQUFBLENBQTFCLENBQWpCO0lBRGlCOzs4QkFJbkIsaUJBQUEsR0FBbUIsU0FBQyxNQUFEO0FBQ2pCLFVBQUE7bUdBQW9CLENBQUMsd0JBQXlCO0lBRDdCOzs4QkFHbkIsc0JBQUEsR0FBd0IsU0FBQyxRQUFEO0FBQ3RCLFVBQUE7d0dBQW9CLENBQUMsNkJBQThCO0lBRDdCOzs4QkFHeEIsZ0JBQUEsR0FBa0IsU0FBQTthQUNoQixJQUFDLENBQUEsVUFBRCxDQUFZLENBQUEsU0FBQSxLQUFBO2VBQUEsU0FBQyxhQUFEOztZQUFDLGdCQUFnQjs7aUJBQzNCLEtBQUMsQ0FBQSxZQUFELENBQWMsYUFBZDtRQURVO01BQUEsQ0FBQSxDQUFBLENBQUEsSUFBQSxDQUFaO0lBRGdCOzs4QkFJbEIsWUFBQSxHQUFjLFNBQUMsWUFBRDthQUNaLElBQUMsQ0FBQSxTQUFELENBQVcsSUFBQyxDQUFBLFdBQUQsQ0FBYSxZQUFiLENBQVgsQ0FBc0MsQ0FBQyxJQUF2QyxDQUE0QyxDQUFBLFNBQUEsS0FBQTtlQUFBLFNBQUMsS0FBRDtBQUMxQyxjQUFBO1VBQUEsSUFBRyxLQUFBLElBQVUsS0FBQyxDQUFBLE9BQU8sQ0FBQyxRQUFULENBQUEsQ0FBbUIsQ0FBQyxNQUFwQixLQUE4QixDQUEzQzttQkFDRSxLQUFDLENBQUEsa0NBQUQsQ0FBb0MsS0FBcEMsRUFBMkMsWUFBM0MsRUFERjtXQUFBLE1BQUE7QUFHRTtpQkFBQSw4Q0FBQTs7MkJBQUEsS0FBQyxDQUFBLE9BQU8sQ0FBQyxPQUFULENBQWlCLE1BQWpCO0FBQUE7MkJBSEY7O1FBRDBDO01BQUEsQ0FBQSxDQUFBLENBQUEsSUFBQSxDQUE1QztJQURZOzs4QkFPZCxrQ0FBQSxHQUFvQyxTQUFDLEtBQUQsRUFBUSxZQUFSLEVBQXNCLFdBQXRCO0FBQ2xDLFVBQUE7O1FBRHdELGNBQWM7O01BQ3RFLE1BQUEsR0FBUyxJQUFDLENBQUEsU0FBUyxDQUFDLFNBQVgsQ0FBQTtNQUNULGNBQUEsR0FBaUIsQ0FBQSxTQUFBLEtBQUE7ZUFBQSxTQUFBO0FBQ2YsY0FBQTtBQUFBO0FBQUEsZUFBQSxzQ0FBQTs7QUFDRTtBQUFBLGlCQUFBLHdDQUFBOztjQUNFLElBQUcsSUFBQSxZQUFnQixVQUFuQjtnQkFDRSxJQUFnQixJQUFJLENBQUMsT0FBTCxDQUFBLENBQUEsSUFBa0IsSUFBSSxDQUFDLFVBQUwsQ0FBQSxDQUFsQztBQUFBLHlCQUFPLE1BQVA7aUJBREY7ZUFBQSxNQUFBO2dCQUdFLElBQWdCLFNBQUEsS0FBYSxNQUE3QjtBQUFBLHlCQUFPLE1BQVA7aUJBSEY7O0FBREY7QUFERjtpQkFNQTtRQVBlO01BQUEsQ0FBQSxDQUFBLENBQUEsSUFBQTtNQVNqQixJQUFHLGNBQUEsQ0FBQSxDQUFIO1FBQ0UsSUFBQyxDQUFBLCtCQUFELENBQWlDLEtBQWpDO2VBQ0EsT0FBTyxDQUFDLEdBQVI7O0FBQWE7ZUFBQSw2Q0FBQTs7eUJBQUEsSUFBQyxDQUFBLFNBQVMsQ0FBQyxJQUFYLENBQWdCLElBQWhCO0FBQUE7O3FCQUFiLEVBRkY7T0FBQSxNQUFBO1FBSUUsS0FBQSxHQUFXLFlBQVksQ0FBQyxNQUFiLEtBQXVCLENBQTFCLEdBQWlDLFFBQWpDLEdBQStDO1FBQ3ZELEdBQUEsR0FBTSxJQUFDLENBQUEsT0FBRCxDQUNKO1VBQUEsT0FBQSxFQUFTLHFEQUFUO1VBQ0EsZUFBQSxFQUFpQixDQUFBLG1EQUFBLEdBQW9ELEtBQXBELEdBQTBELElBQTFELENBQUEsR0FDZixDQUFBLDRCQUFBLEdBQTZCLEtBQTdCLEdBQW1DLDJEQUFuQyxDQURlLEdBRWYsQ0FBQSxjQUFBLEdBQWUsS0FBZixHQUFxQiw4Q0FBckIsQ0FIRjtVQUlBLE9BQUEsRUFBUyxDQUNQLHNDQURPLEVBRVAsc0NBRk8sQ0FKVDtTQURJO1FBU04sSUFBRyxHQUFBLEtBQU8sQ0FBVjtVQUNFLElBQUMsQ0FBQSxJQUFELENBQ0U7WUFBQSxXQUFBLEVBQWEsWUFBWSxDQUFDLE1BQWIsQ0FBb0IsV0FBcEIsQ0FBYjtZQUNBLFNBQUEsRUFBVyxJQURYO1lBRUEsT0FBQSxFQUFTLElBQUMsQ0FBQSxTQUFELENBQUEsQ0FGVDtZQUdBLFFBQUEsRUFBVSxJQUFDLENBQUEsVUFBRCxDQUFBLENBSFY7V0FERjtpQkFLQSxPQUFPLENBQUMsT0FBUixDQUFnQixJQUFoQixFQU5GO1NBQUEsTUFPSyxJQUFHLEdBQUEsS0FBTyxDQUFWO0FBQ0gsZUFBQSw4Q0FBQTs7WUFBQSxJQUFDLENBQUEsT0FBTyxDQUFDLE9BQVQsQ0FBaUIsWUFBakI7QUFBQTtpQkFDQSxPQUFPLENBQUMsR0FBUjs7QUFBYTtpQkFBQSwrQ0FBQTs7MkJBQUEsSUFBQyxDQUFBLFNBQVMsQ0FBQyxJQUFYLENBQWdCLElBQWhCO0FBQUE7O3VCQUFiLEVBRkc7U0FyQlA7O0lBWGtDOzs4QkFvQ3BDLCtCQUFBLEdBQWlDLFNBQUMsS0FBRDtBQUMvQixVQUFBO01BQUEsS0FBSyxDQUFDLFVBQU4sR0FBbUIsSUFBQyxDQUFBLFlBQUQsQ0FBQTtBQUNuQjtBQUFBLFdBQUEsc0NBQUE7O1FBQUEsSUFBSSxDQUFDLE9BQUwsQ0FBQTtBQUFBO2FBQ0EsSUFBQyxDQUFBLFdBQUQsQ0FBYSxLQUFiO0lBSCtCOzs4QkFLakMsY0FBQSxHQUFnQixTQUFDLFFBQUQ7YUFDZCxRQUFBLENBQVMsSUFBQyxDQUFBLGtCQUFELENBQUEsQ0FBVDtJQURjOzs4QkFHaEIsa0JBQUEsR0FBb0IsU0FBQyxPQUFEOztRQUFDLFVBQVE7O2FBQzNCLElBQUMsQ0FBQSxtQkFBbUIsQ0FBQyxjQUFyQixDQUFvQyxPQUFwQztJQURrQjs7OEJBR3BCLFNBQUEsR0FBVyxTQUFDLE9BQUQsRUFBVSxVQUFWO2FBQ0wsSUFBQSxPQUFBLENBQVEsQ0FBQSxTQUFBLEtBQUE7ZUFBQSxTQUFDLE9BQUQsRUFBVSxNQUFWO0FBQ1YsY0FBQTtVQUFBLElBQUcsS0FBQyxDQUFBLGlCQUFELElBQXVCLEtBQUMsQ0FBQSxPQUEzQjtZQUNFLEtBQUEsR0FBUSxLQUFDLENBQUEsU0FBRCxDQUFXLE9BQVg7WUFDUixXQUFBLHlCQUNLLGFBQUEsYUFBYyxLQUFDLENBQUEsV0FBRCxzQ0FBcUIsQ0FBRSxRQUFWLENBQUEsVUFBYixFQUFqQixHQUNFLEtBQUMsQ0FBQSxVQUFVLENBQUMsSUFBWixDQUFpQixVQUFqQixFQUE2QixLQUE3QixDQURGLEdBR0UsS0FBQyxDQUFBLG1CQUFtQixDQUFDLHVCQUFyQixDQUE2QyxLQUE3QzttQkFDSixXQUFXLEVBQUMsS0FBRCxFQUFYLENBQWtCLE1BQWxCLENBQXlCLENBQUMsSUFBMUIsQ0FBK0IsT0FBL0IsRUFQRjtXQUFBLE1BQUE7bUJBU0UsT0FBQSxDQUFBLEVBVEY7O1FBRFU7TUFBQSxDQUFBLENBQUEsQ0FBQSxJQUFBLENBQVI7SUFESzs7OEJBYVgsU0FBQSxHQUFXLFNBQUMsUUFBRDtNQUNULElBQUcsSUFBQyxDQUFBLGlCQUFKO1FBQ0UsdUJBQUcsV0FBQSxXQUFZLElBQUMsQ0FBQSxXQUFELENBQWEsSUFBQyxDQUFBLGVBQUQsQ0FBQSxDQUFrQixDQUFDLFlBQWhDLENBQWY7aUJBQ0UsSUFBQyxDQUFBLFVBQVUsQ0FBQyxJQUFaLENBQWlCLFFBQWpCLENBQTBCLENBQUMsSUFBM0IsQ0FBZ0MsQ0FBQSxTQUFBLEtBQUE7bUJBQUEsU0FBQyxLQUFEO2NBQzlCLElBQUcsS0FBSDt1QkFDRSxNQURGO2VBQUEsTUFBQTt1QkFJRSxLQUFDLENBQUEsZ0JBQUQsQ0FBQSxDQUFtQixDQUFDLElBQXBCLENBQXlCLFFBQXpCLEVBSkY7O1lBRDhCO1VBQUEsQ0FBQSxDQUFBLENBQUEsSUFBQSxDQUFoQyxFQURGO1NBQUEsTUFBQTtpQkFRRSxJQUFDLENBQUEsbUJBQW1CLENBQUMsdUJBQXJCLENBQUEsRUFSRjtTQURGO09BQUEsTUFBQTtlQVdFLE9BQU8sQ0FBQyxPQUFSLENBQWdCLElBQWhCLEVBWEY7O0lBRFM7OzhCQWNYLFdBQUEsR0FBYSxTQUFDLEtBQUQ7QUFDWCxVQUFBO01BQUEsSUFBZ0MsYUFBaEM7QUFBQSxlQUFPLE9BQU8sQ0FBQyxPQUFSLENBQUEsRUFBUDs7TUFFQSxJQUFHLHNCQUFBLHlDQUF1QyxDQUFFLCtCQUE1QztRQUNFLElBQUMsQ0FBQSxRQUFRLENBQUMsc0JBQVYsR0FBbUMsdUJBRHJDOztNQUdBLElBQUMsQ0FBQSxhQUFELENBQWUsS0FBSyxDQUFDLFVBQXJCO01BRUEsSUFBQyxDQUFBLFFBQVEsQ0FBQyxhQUFWLGlEQUFnRDtNQUVoRCxTQUFBLEdBQVksSUFBSSxDQUFDLEdBQUwsQ0FBQTtNQUNaLElBQUcscUJBQUg7UUFDRSxjQUFBLEdBQWlCLElBQUMsQ0FBQSxPQUFPLENBQUMsV0FBVCxDQUFxQixLQUFLLENBQUMsT0FBM0IsRUFBb0MsSUFBQyxDQUFBLGFBQXJDLEVBRG5CO09BQUEsTUFBQTtRQUdFLGNBQUEsR0FBaUIsT0FBTyxDQUFDLE9BQVIsQ0FBQSxFQUhuQjs7YUFLQSxjQUFjLENBQUMsSUFBZixDQUFvQixDQUFBLFNBQUEsS0FBQTtlQUFBLFNBQUE7VUFDbEIsS0FBQyxDQUFBLGtCQUFrQixDQUFDLE9BQXBCLEdBQThCLElBQUksQ0FBQyxHQUFMLENBQUEsQ0FBQSxHQUFhO1VBRTNDLElBQStDLEtBQUssQ0FBQyxXQUFyRDtZQUFBLEtBQUMsQ0FBQSxXQUFXLENBQUMsV0FBYixDQUF5QixLQUFLLENBQUMsV0FBL0IsRUFBQTs7VUFFQSxTQUFBLEdBQVksSUFBSSxDQUFDLEdBQUwsQ0FBQTtVQUNaLElBQTJELHVCQUEzRDtZQUFBLEtBQUMsQ0FBQSxTQUFTLENBQUMsV0FBWCxDQUF1QixLQUFLLENBQUMsU0FBN0IsRUFBd0MsS0FBQyxDQUFBLGFBQXpDLEVBQUE7O2lCQUNBLEtBQUMsQ0FBQSxrQkFBa0IsQ0FBQyxTQUFwQixHQUFnQyxJQUFJLENBQUMsR0FBTCxDQUFBLENBQUEsR0FBYTtRQVAzQjtNQUFBLENBQUEsQ0FBQSxDQUFBLElBQUEsQ0FBcEI7SUFoQlc7OzhCQXlCYixXQUFBLEdBQWEsU0FBQyxLQUFEO0FBQ1gsVUFBQTtNQUFBLHFCQUFHLEtBQUssQ0FBRSxnQkFBUCxHQUFnQixDQUFuQjtRQUNFLElBQUEsR0FBTyxNQUFNLENBQUMsVUFBUCxDQUFrQixNQUFsQixDQUF5QixDQUFDLE1BQTFCLENBQWlDLEtBQUssQ0FBQyxLQUFOLENBQUEsQ0FBYSxDQUFDLElBQWQsQ0FBQSxDQUFvQixDQUFDLElBQXJCLENBQTBCLElBQTFCLENBQWpDLENBQWlFLENBQUMsTUFBbEUsQ0FBeUUsS0FBekU7ZUFDUCxTQUFBLEdBQVUsS0FGWjtPQUFBLE1BQUE7ZUFJRSxLQUpGOztJQURXOzs4QkFPYixnQkFBQSxHQUFrQixTQUFBOzBDQUNoQixJQUFDLENBQUEsZ0JBQUQsSUFBQyxDQUFBLGdCQUFxQixJQUFBLGFBQUEsQ0FBYyxJQUFDLENBQUEsZ0JBQUQsQ0FBQSxDQUFkO0lBRE47OzhCQUdsQixnQkFBQSxHQUFrQixTQUFBOzBDQUNoQixJQUFDLENBQUEsZ0JBQUQsSUFBQyxDQUFBLGdCQUFpQixPQUFPLENBQUMsR0FBRyxDQUFDO0lBRGQ7OzhCQUdsQixxQkFBQSxHQUF1QixTQUFBO0FBQ3JCLFVBQUE7TUFBQSxjQUFBLEdBQWlCLEVBQUUsQ0FBQyxPQUFILENBQVcsSUFBQyxDQUFBLGdCQUFELENBQUEsQ0FBWCxFQUFnQyxNQUFoQyxFQUF3QyxDQUFDLElBQUQsRUFBTyxRQUFQLENBQXhDO3NDQUNqQixpQkFBaUIsSUFBSSxDQUFDLElBQUwsQ0FBVSxJQUFDLENBQUEsZ0JBQUQsQ0FBQSxDQUFWLEVBQStCLGFBQS9CO0lBRkk7OzhCQUl2QixxQkFBQSxHQUF1QixTQUFBO0FBQ3JCLFVBQUE7TUFBQSxJQUFHLGtCQUFBLEdBQXFCLElBQUMsQ0FBQSxxQkFBRCxDQUFBLENBQXhCO0FBQ0U7VUFDRSxJQUErQixFQUFFLENBQUMsVUFBSCxDQUFjLGtCQUFkLENBQS9CO21CQUFBLE9BQUEsQ0FBUSxrQkFBUixFQUFBO1dBREY7U0FBQSxjQUFBO1VBRU07aUJBQ0osSUFBQyxDQUFBLGFBQWEsQ0FBQyxRQUFmLENBQXdCLGtCQUFBLEdBQW1CLGtCQUFuQixHQUFzQyxHQUE5RCxFQUNFO1lBQUEsTUFBQSxFQUFRLEtBQUssQ0FBQyxPQUFkO1lBQ0EsV0FBQSxFQUFhLElBRGI7V0FERixFQUhGO1NBREY7O0lBRHFCOzs4QkFVdkIsaUJBQUEsR0FBbUIsU0FBQyxRQUFEO2FBQ2pCLElBQUMsQ0FBQSxPQUFPLENBQUMsRUFBVCxDQUFZLGtCQUFaLEVBQWdDLFFBQWhDO0lBRGlCOzs4QkFHbkIsZUFBQSxHQUFpQixTQUFDLE9BQUQ7YUFDZixJQUFDLENBQUEsT0FBTyxDQUFDLElBQVQsQ0FBYyxrQkFBZCxFQUFrQyxPQUFsQztJQURlOzs4QkFHakIsZ0JBQUEsR0FBa0IsU0FBQTthQUVoQixJQUFDLENBQUEsV0FBVyxDQUFDLEdBQWIsQ0FBaUIsSUFBQyxDQUFBLFdBQVcsQ0FBQyw4QkFBYixDQUE0QyxJQUFDLENBQUEsZUFBZSxDQUFDLElBQWpCLENBQXNCLElBQXRCLENBQTVDLENBQWpCO0lBRmdCOzs4QkFJbEIsb0JBQUEsR0FBc0IsU0FBQTthQUNwQixJQUFDLENBQUEsUUFBUSxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsR0FBekIsQ0FBNkIsV0FBQSxHQUFZLE9BQU8sQ0FBQyxRQUFqRDtJQURvQjs7OEJBR3RCLGtCQUFBLEdBQW9CLFNBQUMsUUFBRDtNQUNsQixJQUFDLENBQUEsbUJBQW1CLENBQUMsd0JBQXJCLENBQThDLFFBQTlDO2FBQ0EsSUFBQyxDQUFBLG1CQUFtQixDQUFDLDBCQUFyQixDQUFnRCxDQUFJLFFBQXBEO0lBRmtCOzs4QkFJcEIsOEJBQUEsR0FBZ0MsU0FBQyxPQUFELEVBQVUsR0FBVjtBQUM5QixVQUFBO01BQUEsYUFBQSxHQUFnQixJQUFDLENBQUEsUUFBUSxDQUFDO01BRTFCLElBQUcsYUFBQSxLQUFpQixJQUFDLENBQUEsUUFBUSxDQUFDLElBQTlCO1FBQ0UsYUFBQSxHQUFnQixJQUFDLENBQUEsU0FBUyxDQUFDLFVBQVgsQ0FBQSxFQURsQjs7YUFFQSxJQUFDLENBQUEsUUFBUSxDQUFDLFFBQVYsQ0FBbUIsYUFBbkIsRUFBa0MsT0FBbEMsRUFBMkMsR0FBM0M7SUFMOEI7OzhCQU9oQywwQkFBQSxHQUE0QixTQUFBO0FBQzFCLFVBQUE7TUFEMkIsd0JBQVM7YUFDcEMsSUFBQyxDQUFBLFFBQVEsQ0FBQyxRQUFWLENBQW1CLElBQUMsQ0FBQSxXQUFXLENBQUMsYUFBaEMsRUFBK0MsT0FBL0MsRUFBd0QsSUFBeEQ7SUFEMEI7OzhCQUc1QixhQUFBLEdBQWUsU0FBQyxTQUFEO0FBQ2IsVUFBQTtNQUFBLGlCQUFBLHdDQUE0QixDQUFFLFFBQVYsQ0FBQSxDQUFvQixDQUFDLGdCQUFyQixLQUErQjtNQUVuRCxxQkFBQSxHQUF3QjtNQUN4QixtQkFBQSxHQUFzQjtNQUV0QixnQkFBQSxHQUFtQixTQUFDLE1BQUQ7UUFDakIsSUFBRyxhQUFjLHFCQUFkLEVBQUEsTUFBQSxLQUFIO2lCQUNFLHFCQUFxQixDQUFDLElBQXRCLENBQTJCLE1BQTNCLEVBREY7O01BRGlCO0FBSW5CLFdBQUEsMkNBQUE7NkJBQUssOEJBQVksZ0NBQWEsb0NBQWU7UUFDM0MsSUFBRyxvQkFBQSxJQUFnQixDQUFDLGlCQUFBLElBQXFCLGdCQUF0QixDQUFuQjtVQUNFLElBQUcsRUFBRSxDQUFDLFVBQUgsQ0FBYyxVQUFkLENBQUg7WUFDRSxnQkFBQSxDQUFpQixJQUFDLENBQUEsT0FBTyxDQUFDLDBCQUFULENBQW9DLFVBQXBDLENBQStDLENBQUMsT0FBaEQsQ0FBQSxDQUFqQixFQURGO1dBQUEsTUFFSyxJQUFHLEVBQUUsQ0FBQyxVQUFILENBQWMsSUFBSSxDQUFDLE9BQUwsQ0FBYSxVQUFiLENBQWQsQ0FBSDtZQUNILGdCQUFBLENBQWlCLElBQUMsQ0FBQSxPQUFPLENBQUMsMEJBQVQsQ0FBb0MsSUFBSSxDQUFDLE9BQUwsQ0FBYSxVQUFiLENBQXBDLENBQTZELENBQUMsT0FBOUQsQ0FBQSxDQUFqQixFQURHO1dBQUEsTUFBQTtZQUdILGdCQUFBLENBQWlCLElBQUMsQ0FBQSxPQUFPLENBQUMsMEJBQVQsQ0FBb0MsVUFBcEMsQ0FBK0MsQ0FBQyxPQUFoRCxDQUFBLENBQWpCLEVBSEc7V0FIUDs7UUFRQSxJQUFBLENBQU8sRUFBRSxDQUFDLGVBQUgsQ0FBbUIsVUFBbkIsQ0FBUDtVQUNFLG1CQUFtQixDQUFDLElBQXBCLENBQXlCO1lBQUMsWUFBQSxVQUFEO1lBQWEsYUFBQSxXQUFiO1lBQTBCLGVBQUEsYUFBMUI7V0FBekIsRUFERjs7QUFURjtNQVlBLE9BQUEsR0FBVSxPQUFPLENBQUMsT0FBUixDQUFnQixJQUFoQjtNQUNWLElBQUcscUJBQXFCLENBQUMsTUFBdEIsR0FBK0IsQ0FBbEM7UUFDRSxPQUFBLEdBQVUsSUFBQyxDQUFBLFNBQUQsQ0FBVyxJQUFDLENBQUEsV0FBRCxDQUFhLHFCQUFiLENBQVgsQ0FBK0MsQ0FBQyxJQUFoRCxDQUFxRCxDQUFBLFNBQUEsS0FBQTtpQkFBQSxTQUFDLEtBQUQ7QUFDN0QsZ0JBQUE7WUFBQSxJQUFHLEtBQUEsSUFBVSxpQkFBYjtjQUNFLEtBQUE7O0FBQVM7cUJBQUEsdURBQUE7OytCQUFBLFFBQVEsQ0FBQztBQUFUOzs7cUJBQ1QsS0FBQyxDQUFBLGtDQUFELENBQW9DLEtBQXBDLEVBQTJDLHFCQUEzQyxFQUFrRSxLQUFsRSxFQUZGO2FBQUEsTUFBQTtjQUlFLFFBQUEsR0FBVztBQUNYLG1CQUFBLHlEQUFBOztnQkFBQSxLQUFDLENBQUEsT0FBTyxDQUFDLE9BQVQsQ0FBaUIsTUFBakI7QUFBQTtBQUNBLG1CQUFBLHVEQUFBOytDQUFLLDhCQUFZLGdDQUFhO2dCQUM1QixRQUFRLENBQUMsSUFBVCx3Q0FBd0IsQ0FBRSxJQUFaLENBQWlCLFVBQWpCLEVBQTZCO2tCQUFDLGFBQUEsV0FBRDtrQkFBYyxlQUFBLGFBQWQ7aUJBQTdCLFVBQWQ7QUFERjtxQkFFQSxPQUFPLENBQUMsR0FBUixDQUFZLFFBQVosRUFSRjs7VUFENkQ7UUFBQSxDQUFBLENBQUEsQ0FBQSxJQUFBLENBQXJELEVBRFo7T0FBQSxNQUFBO1FBWUUsUUFBQSxHQUFXO0FBQ1gsYUFBQSx1REFBQTt5Q0FBSyw4QkFBWSxnQ0FBYTtVQUM1QixRQUFRLENBQUMsSUFBVCx1Q0FBd0IsQ0FBRSxJQUFaLENBQWlCLFVBQWpCLEVBQTZCO1lBQUMsYUFBQSxXQUFEO1lBQWMsZUFBQSxhQUFkO1dBQTdCLFVBQWQ7QUFERjtRQUVBLE9BQUEsR0FBVSxPQUFPLENBQUMsR0FBUixDQUFZLFFBQVosRUFmWjs7YUFpQkEsT0FBTyxDQUFDLElBQVIsQ0FBYSxTQUFBO2VBQ1gsV0FBVyxDQUFDLElBQVosQ0FBaUIsZ0JBQWpCLEVBQW1DLHlCQUFuQztNQURXLENBQWI7SUF4Q2E7OzhCQTJDZixZQUFBLEdBQWMsU0FBQyxHQUFEO0FBQ1osYUFBVyxJQUFBLE9BQUEsQ0FBUSxDQUFBLFNBQUEsS0FBQTtlQUFBLFNBQUMsT0FBRCxFQUFVLE1BQVY7QUFDakIsY0FBQTtVQUFBLFNBQUEsR0FBWSxLQUFDLENBQUEsa0JBQUQ7VUFDWixVQUFBLEdBQWEsS0FBQyxDQUFBLG1CQUFtQixDQUFDLGlCQUFyQixDQUF1QyxTQUFDLEVBQUQsRUFBSyxLQUFMO1lBQ2xELElBQUcsRUFBQSxLQUFNLFNBQVQ7Y0FDRSxVQUFVLENBQUMsT0FBWCxDQUFBO3FCQUNBLE9BQUEsQ0FBUSxLQUFSLEVBRkY7O1VBRGtELENBQXZDO2lCQUtiLEtBQUMsQ0FBQSxtQkFBbUIsQ0FBQyxZQUFyQixDQUFrQyxTQUFsQyxFQUE2QyxHQUE3QztRQVBpQjtNQUFBLENBQUEsQ0FBQSxDQUFBLElBQUEsQ0FBUjtJQURDOzs7O0tBcmlDYzs7RUFnakM5QixPQUFPLENBQUMsU0FBUyxDQUFDLElBQWxCLEdBQXlCLFNBQUMsUUFBRDtJQUN2QixTQUFBLENBQVUsb0ZBQVY7V0FDQSxJQUFDLENBQUEsSUFBRCxDQUFNLFFBQU47RUFGdUI7QUFybUN6QiIsInNvdXJjZXNDb250ZW50IjpbImNyeXB0byA9IHJlcXVpcmUgJ2NyeXB0bydcbnBhdGggPSByZXF1aXJlICdwYXRoJ1xue2lwY1JlbmRlcmVyfSA9IHJlcXVpcmUgJ2VsZWN0cm9uJ1xuXG5fID0gcmVxdWlyZSAndW5kZXJzY29yZS1wbHVzJ1xue2RlcHJlY2F0ZX0gPSByZXF1aXJlICdncmltJ1xue0NvbXBvc2l0ZURpc3Bvc2FibGUsIERpc3Bvc2FibGUsIEVtaXR0ZXJ9ID0gcmVxdWlyZSAnZXZlbnQta2l0J1xuZnMgPSByZXF1aXJlICdmcy1wbHVzJ1xue21hcFNvdXJjZVBvc2l0aW9ufSA9IHJlcXVpcmUgJ0BhdG9tL3NvdXJjZS1tYXAtc3VwcG9ydCdcbk1vZGVsID0gcmVxdWlyZSAnLi9tb2RlbCdcbldpbmRvd0V2ZW50SGFuZGxlciA9IHJlcXVpcmUgJy4vd2luZG93LWV2ZW50LWhhbmRsZXInXG5TdGF0ZVN0b3JlID0gcmVxdWlyZSAnLi9zdGF0ZS1zdG9yZSdcblN0b3JhZ2VGb2xkZXIgPSByZXF1aXJlICcuL3N0b3JhZ2UtZm9sZGVyJ1xucmVnaXN0ZXJEZWZhdWx0Q29tbWFuZHMgPSByZXF1aXJlICcuL3JlZ2lzdGVyLWRlZmF1bHQtY29tbWFuZHMnXG57dXBkYXRlUHJvY2Vzc0Vudn0gPSByZXF1aXJlICcuL3VwZGF0ZS1wcm9jZXNzLWVudidcbkNvbmZpZ1NjaGVtYSA9IHJlcXVpcmUgJy4vY29uZmlnLXNjaGVtYSdcblxuRGVzZXJpYWxpemVyTWFuYWdlciA9IHJlcXVpcmUgJy4vZGVzZXJpYWxpemVyLW1hbmFnZXInXG5WaWV3UmVnaXN0cnkgPSByZXF1aXJlICcuL3ZpZXctcmVnaXN0cnknXG5Ob3RpZmljYXRpb25NYW5hZ2VyID0gcmVxdWlyZSAnLi9ub3RpZmljYXRpb24tbWFuYWdlcidcbkNvbmZpZyA9IHJlcXVpcmUgJy4vY29uZmlnJ1xuS2V5bWFwTWFuYWdlciA9IHJlcXVpcmUgJy4va2V5bWFwLWV4dGVuc2lvbnMnXG5Ub29sdGlwTWFuYWdlciA9IHJlcXVpcmUgJy4vdG9vbHRpcC1tYW5hZ2VyJ1xuQ29tbWFuZFJlZ2lzdHJ5ID0gcmVxdWlyZSAnLi9jb21tYW5kLXJlZ2lzdHJ5J1xuR3JhbW1hclJlZ2lzdHJ5ID0gcmVxdWlyZSAnLi9ncmFtbWFyLXJlZ2lzdHJ5J1xue0hpc3RvcnlNYW5hZ2VyLCBIaXN0b3J5UHJvamVjdH0gPSByZXF1aXJlICcuL2hpc3RvcnktbWFuYWdlcidcblJlb3BlblByb2plY3RNZW51TWFuYWdlciA9IHJlcXVpcmUgJy4vcmVvcGVuLXByb2plY3QtbWVudS1tYW5hZ2VyJ1xuU3R5bGVNYW5hZ2VyID0gcmVxdWlyZSAnLi9zdHlsZS1tYW5hZ2VyJ1xuUGFja2FnZU1hbmFnZXIgPSByZXF1aXJlICcuL3BhY2thZ2UtbWFuYWdlcidcblRoZW1lTWFuYWdlciA9IHJlcXVpcmUgJy4vdGhlbWUtbWFuYWdlcidcbk1lbnVNYW5hZ2VyID0gcmVxdWlyZSAnLi9tZW51LW1hbmFnZXInXG5Db250ZXh0TWVudU1hbmFnZXIgPSByZXF1aXJlICcuL2NvbnRleHQtbWVudS1tYW5hZ2VyJ1xuQ29tbWFuZEluc3RhbGxlciA9IHJlcXVpcmUgJy4vY29tbWFuZC1pbnN0YWxsZXInXG5Qcm9qZWN0ID0gcmVxdWlyZSAnLi9wcm9qZWN0J1xuVGl0bGVCYXIgPSByZXF1aXJlICcuL3RpdGxlLWJhcidcbldvcmtzcGFjZSA9IHJlcXVpcmUgJy4vd29ya3NwYWNlJ1xuUGFuZWxDb250YWluZXIgPSByZXF1aXJlICcuL3BhbmVsLWNvbnRhaW5lcidcblBhbmVsID0gcmVxdWlyZSAnLi9wYW5lbCdcblBhbmVDb250YWluZXIgPSByZXF1aXJlICcuL3BhbmUtY29udGFpbmVyJ1xuUGFuZUF4aXMgPSByZXF1aXJlICcuL3BhbmUtYXhpcydcblBhbmUgPSByZXF1aXJlICcuL3BhbmUnXG5Eb2NrID0gcmVxdWlyZSAnLi9kb2NrJ1xuUHJvamVjdCA9IHJlcXVpcmUgJy4vcHJvamVjdCdcblRleHRFZGl0b3IgPSByZXF1aXJlICcuL3RleHQtZWRpdG9yJ1xuVGV4dEJ1ZmZlciA9IHJlcXVpcmUgJ3RleHQtYnVmZmVyJ1xuR3V0dGVyID0gcmVxdWlyZSAnLi9ndXR0ZXInXG5UZXh0RWRpdG9yUmVnaXN0cnkgPSByZXF1aXJlICcuL3RleHQtZWRpdG9yLXJlZ2lzdHJ5J1xuQXV0b1VwZGF0ZU1hbmFnZXIgPSByZXF1aXJlICcuL2F1dG8tdXBkYXRlLW1hbmFnZXInXG5cbiMgRXNzZW50aWFsOiBBdG9tIGdsb2JhbCBmb3IgZGVhbGluZyB3aXRoIHBhY2thZ2VzLCB0aGVtZXMsIG1lbnVzLCBhbmQgdGhlIHdpbmRvdy5cbiNcbiMgQW4gaW5zdGFuY2Ugb2YgdGhpcyBjbGFzcyBpcyBhbHdheXMgYXZhaWxhYmxlIGFzIHRoZSBgYXRvbWAgZ2xvYmFsLlxubW9kdWxlLmV4cG9ydHMgPVxuY2xhc3MgQXRvbUVudmlyb25tZW50IGV4dGVuZHMgTW9kZWxcbiAgQHZlcnNpb246IDEgICMgSW5jcmVtZW50IHRoaXMgd2hlbiB0aGUgc2VyaWFsaXphdGlvbiBmb3JtYXQgY2hhbmdlc1xuXG4gIGxhc3RVbmNhdWdodEVycm9yOiBudWxsXG5cbiAgIyMjXG4gIFNlY3Rpb246IFByb3BlcnRpZXNcbiAgIyMjXG5cbiAgIyBQdWJsaWM6IEEge0NvbW1hbmRSZWdpc3RyeX0gaW5zdGFuY2VcbiAgY29tbWFuZHM6IG51bGxcblxuICAjIFB1YmxpYzogQSB7Q29uZmlnfSBpbnN0YW5jZVxuICBjb25maWc6IG51bGxcblxuICAjIFB1YmxpYzogQSB7Q2xpcGJvYXJkfSBpbnN0YW5jZVxuICBjbGlwYm9hcmQ6IG51bGxcblxuICAjIFB1YmxpYzogQSB7Q29udGV4dE1lbnVNYW5hZ2VyfSBpbnN0YW5jZVxuICBjb250ZXh0TWVudTogbnVsbFxuXG4gICMgUHVibGljOiBBIHtNZW51TWFuYWdlcn0gaW5zdGFuY2VcbiAgbWVudTogbnVsbFxuXG4gICMgUHVibGljOiBBIHtLZXltYXBNYW5hZ2VyfSBpbnN0YW5jZVxuICBrZXltYXBzOiBudWxsXG5cbiAgIyBQdWJsaWM6IEEge1Rvb2x0aXBNYW5hZ2VyfSBpbnN0YW5jZVxuICB0b29sdGlwczogbnVsbFxuXG4gICMgUHVibGljOiBBIHtOb3RpZmljYXRpb25NYW5hZ2VyfSBpbnN0YW5jZVxuICBub3RpZmljYXRpb25zOiBudWxsXG5cbiAgIyBQdWJsaWM6IEEge1Byb2plY3R9IGluc3RhbmNlXG4gIHByb2plY3Q6IG51bGxcblxuICAjIFB1YmxpYzogQSB7R3JhbW1hclJlZ2lzdHJ5fSBpbnN0YW5jZVxuICBncmFtbWFyczogbnVsbFxuXG4gICMgUHVibGljOiBBIHtIaXN0b3J5TWFuYWdlcn0gaW5zdGFuY2VcbiAgaGlzdG9yeTogbnVsbFxuXG4gICMgUHVibGljOiBBIHtQYWNrYWdlTWFuYWdlcn0gaW5zdGFuY2VcbiAgcGFja2FnZXM6IG51bGxcblxuICAjIFB1YmxpYzogQSB7VGhlbWVNYW5hZ2VyfSBpbnN0YW5jZVxuICB0aGVtZXM6IG51bGxcblxuICAjIFB1YmxpYzogQSB7U3R5bGVNYW5hZ2VyfSBpbnN0YW5jZVxuICBzdHlsZXM6IG51bGxcblxuICAjIFB1YmxpYzogQSB7RGVzZXJpYWxpemVyTWFuYWdlcn0gaW5zdGFuY2VcbiAgZGVzZXJpYWxpemVyczogbnVsbFxuXG4gICMgUHVibGljOiBBIHtWaWV3UmVnaXN0cnl9IGluc3RhbmNlXG4gIHZpZXdzOiBudWxsXG5cbiAgIyBQdWJsaWM6IEEge1dvcmtzcGFjZX0gaW5zdGFuY2VcbiAgd29ya3NwYWNlOiBudWxsXG5cbiAgIyBQdWJsaWM6IEEge1RleHRFZGl0b3JSZWdpc3RyeX0gaW5zdGFuY2VcbiAgdGV4dEVkaXRvcnM6IG51bGxcblxuICAjIFByaXZhdGU6IEFuIHtBdXRvVXBkYXRlTWFuYWdlcn0gaW5zdGFuY2VcbiAgYXV0b1VwZGF0ZXI6IG51bGxcblxuICBzYXZlU3RhdGVEZWJvdW5jZUludGVydmFsOiAxMDAwXG5cbiAgIyMjXG4gIFNlY3Rpb246IENvbnN0cnVjdGlvbiBhbmQgRGVzdHJ1Y3Rpb25cbiAgIyMjXG5cbiAgIyBDYWxsIC5sb2FkT3JDcmVhdGUgaW5zdGVhZFxuICBjb25zdHJ1Y3RvcjogKHBhcmFtcz17fSkgLT5cbiAgICB7QGFwcGxpY2F0aW9uRGVsZWdhdGUsIEBjbGlwYm9hcmQsIEBlbmFibGVQZXJzaXN0ZW5jZSwgb25seUxvYWRCYXNlU3R5bGVTaGVldHMsIEB1cGRhdGVQcm9jZXNzRW52fSA9IHBhcmFtc1xuXG4gICAgQG5leHRQcm94eVJlcXVlc3RJZCA9IDBcbiAgICBAdW5sb2FkZWQgPSBmYWxzZVxuICAgIEBsb2FkVGltZSA9IG51bGxcbiAgICBAZW1pdHRlciA9IG5ldyBFbWl0dGVyXG4gICAgQGRpc3Bvc2FibGVzID0gbmV3IENvbXBvc2l0ZURpc3Bvc2FibGVcbiAgICBAZGVzZXJpYWxpemVycyA9IG5ldyBEZXNlcmlhbGl6ZXJNYW5hZ2VyKHRoaXMpXG4gICAgQGRlc2VyaWFsaXplVGltaW5ncyA9IHt9XG4gICAgQHZpZXdzID0gbmV3IFZpZXdSZWdpc3RyeSh0aGlzKVxuICAgIFRleHRFZGl0b3Iuc2V0U2NoZWR1bGVyKEB2aWV3cylcbiAgICBAbm90aWZpY2F0aW9ucyA9IG5ldyBOb3RpZmljYXRpb25NYW5hZ2VyXG4gICAgQHVwZGF0ZVByb2Nlc3NFbnYgPz0gdXBkYXRlUHJvY2Vzc0VudiAjIEZvciB0ZXN0aW5nXG5cbiAgICBAc3RhdGVTdG9yZSA9IG5ldyBTdGF0ZVN0b3JlKCdBdG9tRW52aXJvbm1lbnRzJywgMSlcblxuICAgIEBjb25maWcgPSBuZXcgQ29uZmlnKHtub3RpZmljYXRpb25NYW5hZ2VyOiBAbm90aWZpY2F0aW9ucywgQGVuYWJsZVBlcnNpc3RlbmNlfSlcbiAgICBAY29uZmlnLnNldFNjaGVtYSBudWxsLCB7dHlwZTogJ29iamVjdCcsIHByb3BlcnRpZXM6IF8uY2xvbmUoQ29uZmlnU2NoZW1hKX1cblxuICAgIEBrZXltYXBzID0gbmV3IEtleW1hcE1hbmFnZXIoe25vdGlmaWNhdGlvbk1hbmFnZXI6IEBub3RpZmljYXRpb25zfSlcbiAgICBAdG9vbHRpcHMgPSBuZXcgVG9vbHRpcE1hbmFnZXIoa2V5bWFwTWFuYWdlcjogQGtleW1hcHMsIHZpZXdSZWdpc3RyeTogQHZpZXdzKVxuICAgIEBjb21tYW5kcyA9IG5ldyBDb21tYW5kUmVnaXN0cnlcbiAgICBAZ3JhbW1hcnMgPSBuZXcgR3JhbW1hclJlZ2lzdHJ5KHtAY29uZmlnfSlcbiAgICBAc3R5bGVzID0gbmV3IFN0eWxlTWFuYWdlcigpXG4gICAgQHBhY2thZ2VzID0gbmV3IFBhY2thZ2VNYW5hZ2VyKHtcbiAgICAgIEBjb25maWcsIHN0eWxlTWFuYWdlcjogQHN0eWxlcyxcbiAgICAgIGNvbW1hbmRSZWdpc3RyeTogQGNvbW1hbmRzLCBrZXltYXBNYW5hZ2VyOiBAa2V5bWFwcywgbm90aWZpY2F0aW9uTWFuYWdlcjogQG5vdGlmaWNhdGlvbnMsXG4gICAgICBncmFtbWFyUmVnaXN0cnk6IEBncmFtbWFycywgZGVzZXJpYWxpemVyTWFuYWdlcjogQGRlc2VyaWFsaXplcnMsIHZpZXdSZWdpc3RyeTogQHZpZXdzXG4gICAgfSlcbiAgICBAdGhlbWVzID0gbmV3IFRoZW1lTWFuYWdlcih7XG4gICAgICBwYWNrYWdlTWFuYWdlcjogQHBhY2thZ2VzLCBAY29uZmlnLCBzdHlsZU1hbmFnZXI6IEBzdHlsZXMsXG4gICAgICBub3RpZmljYXRpb25NYW5hZ2VyOiBAbm90aWZpY2F0aW9ucywgdmlld1JlZ2lzdHJ5OiBAdmlld3NcbiAgICB9KVxuICAgIEBtZW51ID0gbmV3IE1lbnVNYW5hZ2VyKHtrZXltYXBNYW5hZ2VyOiBAa2V5bWFwcywgcGFja2FnZU1hbmFnZXI6IEBwYWNrYWdlc30pXG4gICAgQGNvbnRleHRNZW51ID0gbmV3IENvbnRleHRNZW51TWFuYWdlcih7a2V5bWFwTWFuYWdlcjogQGtleW1hcHN9KVxuICAgIEBwYWNrYWdlcy5zZXRNZW51TWFuYWdlcihAbWVudSlcbiAgICBAcGFja2FnZXMuc2V0Q29udGV4dE1lbnVNYW5hZ2VyKEBjb250ZXh0TWVudSlcbiAgICBAcGFja2FnZXMuc2V0VGhlbWVNYW5hZ2VyKEB0aGVtZXMpXG5cbiAgICBAcHJvamVjdCA9IG5ldyBQcm9qZWN0KHtub3RpZmljYXRpb25NYW5hZ2VyOiBAbm90aWZpY2F0aW9ucywgcGFja2FnZU1hbmFnZXI6IEBwYWNrYWdlcywgQGNvbmZpZywgQGFwcGxpY2F0aW9uRGVsZWdhdGV9KVxuICAgIEBjb21tYW5kSW5zdGFsbGVyID0gbmV3IENvbW1hbmRJbnN0YWxsZXIoQGFwcGxpY2F0aW9uRGVsZWdhdGUpXG5cbiAgICBAdGV4dEVkaXRvcnMgPSBuZXcgVGV4dEVkaXRvclJlZ2lzdHJ5KHtcbiAgICAgIEBjb25maWcsIGdyYW1tYXJSZWdpc3RyeTogQGdyYW1tYXJzLCBhc3NlcnQ6IEBhc3NlcnQuYmluZCh0aGlzKSxcbiAgICAgIHBhY2thZ2VNYW5hZ2VyOiBAcGFja2FnZXNcbiAgICB9KVxuXG4gICAgQHdvcmtzcGFjZSA9IG5ldyBXb3Jrc3BhY2Uoe1xuICAgICAgQGNvbmZpZywgQHByb2plY3QsIHBhY2thZ2VNYW5hZ2VyOiBAcGFja2FnZXMsIGdyYW1tYXJSZWdpc3RyeTogQGdyYW1tYXJzLCBkZXNlcmlhbGl6ZXJNYW5hZ2VyOiBAZGVzZXJpYWxpemVycyxcbiAgICAgIG5vdGlmaWNhdGlvbk1hbmFnZXI6IEBub3RpZmljYXRpb25zLCBAYXBwbGljYXRpb25EZWxlZ2F0ZSwgdmlld1JlZ2lzdHJ5OiBAdmlld3MsIGFzc2VydDogQGFzc2VydC5iaW5kKHRoaXMpLFxuICAgICAgdGV4dEVkaXRvclJlZ2lzdHJ5OiBAdGV4dEVkaXRvcnMsIHN0eWxlTWFuYWdlcjogQHN0eWxlcywgQGVuYWJsZVBlcnNpc3RlbmNlXG4gICAgfSlcblxuICAgIEB0aGVtZXMud29ya3NwYWNlID0gQHdvcmtzcGFjZVxuXG4gICAgQGF1dG9VcGRhdGVyID0gbmV3IEF1dG9VcGRhdGVNYW5hZ2VyKHtAYXBwbGljYXRpb25EZWxlZ2F0ZX0pXG5cbiAgICBpZiBAa2V5bWFwcy5jYW5Mb2FkQnVuZGxlZEtleW1hcHNGcm9tTWVtb3J5KClcbiAgICAgIEBrZXltYXBzLmxvYWRCdW5kbGVkS2V5bWFwcygpXG5cbiAgICBAcmVnaXN0ZXJEZWZhdWx0Q29tbWFuZHMoKVxuICAgIEByZWdpc3RlckRlZmF1bHRPcGVuZXJzKClcbiAgICBAcmVnaXN0ZXJEZWZhdWx0RGVzZXJpYWxpemVycygpXG5cbiAgICBAd2luZG93RXZlbnRIYW5kbGVyID0gbmV3IFdpbmRvd0V2ZW50SGFuZGxlcih7YXRvbUVudmlyb25tZW50OiB0aGlzLCBAYXBwbGljYXRpb25EZWxlZ2F0ZX0pXG5cbiAgICBAaGlzdG9yeSA9IG5ldyBIaXN0b3J5TWFuYWdlcih7QHByb2plY3QsIEBjb21tYW5kcywgQHN0YXRlU3RvcmV9KVxuICAgICMgS2VlcCBpbnN0YW5jZXMgb2YgSGlzdG9yeU1hbmFnZXIgaW4gc3luY1xuICAgIEBkaXNwb3NhYmxlcy5hZGQgQGhpc3Rvcnkub25EaWRDaGFuZ2VQcm9qZWN0cyAoZSkgPT5cbiAgICAgIEBhcHBsaWNhdGlvbkRlbGVnYXRlLmRpZENoYW5nZUhpc3RvcnlNYW5hZ2VyKCkgdW5sZXNzIGUucmVsb2FkZWRcblxuICBpbml0aWFsaXplOiAocGFyYW1zPXt9KSAtPlxuICAgICMgVGhpcyB3aWxsIGZvcmNlIFRleHRFZGl0b3JFbGVtZW50IHRvIHJlZ2lzdGVyIHRoZSBjdXN0b20gZWxlbWVudCwgc28gdGhhdFxuICAgICMgdXNpbmcgYGRvY3VtZW50LmNyZWF0ZUVsZW1lbnQoJ2F0b20tdGV4dC1lZGl0b3InKWAgd29ya3MgaWYgaXQncyBjYWxsZWRcbiAgICAjIGJlZm9yZSBvcGVuaW5nIGEgYnVmZmVyLlxuICAgIHJlcXVpcmUgJy4vdGV4dC1lZGl0b3ItZWxlbWVudCdcblxuICAgIHtAd2luZG93LCBAZG9jdW1lbnQsIEBibG9iU3RvcmUsIEBjb25maWdEaXJQYXRoLCBvbmx5TG9hZEJhc2VTdHlsZVNoZWV0c30gPSBwYXJhbXNcbiAgICB7ZGV2TW9kZSwgc2FmZU1vZGUsIHJlc291cmNlUGF0aCwgY2xlYXJXaW5kb3dTdGF0ZX0gPSBAZ2V0TG9hZFNldHRpbmdzKClcblxuICAgIGlmIGNsZWFyV2luZG93U3RhdGVcbiAgICAgIEBnZXRTdG9yYWdlRm9sZGVyKCkuY2xlYXIoKVxuICAgICAgQHN0YXRlU3RvcmUuY2xlYXIoKVxuXG4gICAgQ29uZmlnU2NoZW1hLnByb2plY3RIb21lID0ge1xuICAgICAgdHlwZTogJ3N0cmluZycsXG4gICAgICBkZWZhdWx0OiBwYXRoLmpvaW4oZnMuZ2V0SG9tZURpcmVjdG9yeSgpLCAnZ2l0aHViJyksXG4gICAgICBkZXNjcmlwdGlvbjogJ1RoZSBkaXJlY3Rvcnkgd2hlcmUgcHJvamVjdHMgYXJlIGFzc3VtZWQgdG8gYmUgbG9jYXRlZC4gUGFja2FnZXMgY3JlYXRlZCB1c2luZyB0aGUgUGFja2FnZSBHZW5lcmF0b3Igd2lsbCBiZSBzdG9yZWQgaGVyZSBieSBkZWZhdWx0LidcbiAgICB9XG4gICAgQGNvbmZpZy5pbml0aWFsaXplKHtAY29uZmlnRGlyUGF0aCwgcmVzb3VyY2VQYXRoLCBwcm9qZWN0SG9tZVNjaGVtYTogQ29uZmlnU2NoZW1hLnByb2plY3RIb21lfSlcblxuICAgIEBtZW51LmluaXRpYWxpemUoe3Jlc291cmNlUGF0aH0pXG4gICAgQGNvbnRleHRNZW51LmluaXRpYWxpemUoe3Jlc291cmNlUGF0aCwgZGV2TW9kZX0pXG5cbiAgICBAa2V5bWFwcy5jb25maWdEaXJQYXRoID0gQGNvbmZpZ0RpclBhdGhcbiAgICBAa2V5bWFwcy5yZXNvdXJjZVBhdGggPSByZXNvdXJjZVBhdGhcbiAgICBAa2V5bWFwcy5kZXZNb2RlID0gZGV2TW9kZVxuICAgIHVubGVzcyBAa2V5bWFwcy5jYW5Mb2FkQnVuZGxlZEtleW1hcHNGcm9tTWVtb3J5KClcbiAgICAgIEBrZXltYXBzLmxvYWRCdW5kbGVkS2V5bWFwcygpXG5cbiAgICBAY29tbWFuZHMuYXR0YWNoKEB3aW5kb3cpXG5cbiAgICBAc3R5bGVzLmluaXRpYWxpemUoe0Bjb25maWdEaXJQYXRofSlcbiAgICBAcGFja2FnZXMuaW5pdGlhbGl6ZSh7ZGV2TW9kZSwgQGNvbmZpZ0RpclBhdGgsIHJlc291cmNlUGF0aCwgc2FmZU1vZGV9KVxuICAgIEB0aGVtZXMuaW5pdGlhbGl6ZSh7QGNvbmZpZ0RpclBhdGgsIHJlc291cmNlUGF0aCwgc2FmZU1vZGUsIGRldk1vZGV9KVxuXG4gICAgQGNvbW1hbmRJbnN0YWxsZXIuaW5pdGlhbGl6ZShAZ2V0VmVyc2lvbigpKVxuICAgIEBhdXRvVXBkYXRlci5pbml0aWFsaXplKClcblxuICAgIEBjb25maWcubG9hZCgpXG5cbiAgICBAdGhlbWVzLmxvYWRCYXNlU3R5bGVzaGVldHMoKVxuICAgIEBpbml0aWFsU3R5bGVFbGVtZW50cyA9IEBzdHlsZXMuZ2V0U25hcHNob3QoKVxuICAgIEB0aGVtZXMuaW5pdGlhbExvYWRDb21wbGV0ZSA9IHRydWUgaWYgb25seUxvYWRCYXNlU3R5bGVTaGVldHNcbiAgICBAc2V0Qm9keVBsYXRmb3JtQ2xhc3MoKVxuXG4gICAgQHN0eWxlc0VsZW1lbnQgPSBAc3R5bGVzLmJ1aWxkU3R5bGVzRWxlbWVudCgpXG4gICAgQGRvY3VtZW50LmhlYWQuYXBwZW5kQ2hpbGQoQHN0eWxlc0VsZW1lbnQpXG5cbiAgICBAa2V5bWFwcy5zdWJzY3JpYmVUb0ZpbGVSZWFkRmFpbHVyZSgpXG5cbiAgICBAaW5zdGFsbFVuY2F1Z2h0RXJyb3JIYW5kbGVyKClcbiAgICBAYXR0YWNoU2F2ZVN0YXRlTGlzdGVuZXJzKClcbiAgICBAd2luZG93RXZlbnRIYW5kbGVyLmluaXRpYWxpemUoQHdpbmRvdywgQGRvY3VtZW50KVxuXG4gICAgZGlkQ2hhbmdlU3R5bGVzID0gQGRpZENoYW5nZVN0eWxlcy5iaW5kKHRoaXMpXG4gICAgQGRpc3Bvc2FibGVzLmFkZChAc3R5bGVzLm9uRGlkQWRkU3R5bGVFbGVtZW50KGRpZENoYW5nZVN0eWxlcykpXG4gICAgQGRpc3Bvc2FibGVzLmFkZChAc3R5bGVzLm9uRGlkVXBkYXRlU3R5bGVFbGVtZW50KGRpZENoYW5nZVN0eWxlcykpXG4gICAgQGRpc3Bvc2FibGVzLmFkZChAc3R5bGVzLm9uRGlkUmVtb3ZlU3R5bGVFbGVtZW50KGRpZENoYW5nZVN0eWxlcykpXG5cbiAgICBAb2JzZXJ2ZUF1dG9IaWRlTWVudUJhcigpXG5cbiAgICBAZGlzcG9zYWJsZXMuYWRkIEBhcHBsaWNhdGlvbkRlbGVnYXRlLm9uRGlkQ2hhbmdlSGlzdG9yeU1hbmFnZXIoPT4gQGhpc3RvcnkubG9hZFN0YXRlKCkpXG5cbiAgcHJlbG9hZFBhY2thZ2VzOiAtPlxuICAgIEBwYWNrYWdlcy5wcmVsb2FkUGFja2FnZXMoKVxuXG4gIGF0dGFjaFNhdmVTdGF0ZUxpc3RlbmVyczogLT5cbiAgICBzYXZlU3RhdGUgPSBfLmRlYm91bmNlKCg9PlxuICAgICAgQHdpbmRvdy5yZXF1ZXN0SWRsZUNhbGxiYWNrID0+IEBzYXZlU3RhdGUoe2lzVW5sb2FkaW5nOiBmYWxzZX0pIHVubGVzcyBAdW5sb2FkZWRcbiAgICApLCBAc2F2ZVN0YXRlRGVib3VuY2VJbnRlcnZhbClcbiAgICBAZG9jdW1lbnQuYWRkRXZlbnRMaXN0ZW5lcignbW91c2Vkb3duJywgc2F2ZVN0YXRlLCB0cnVlKVxuICAgIEBkb2N1bWVudC5hZGRFdmVudExpc3RlbmVyKCdrZXlkb3duJywgc2F2ZVN0YXRlLCB0cnVlKVxuICAgIEBkaXNwb3NhYmxlcy5hZGQgbmV3IERpc3Bvc2FibGUgPT5cbiAgICAgIEBkb2N1bWVudC5yZW1vdmVFdmVudExpc3RlbmVyKCdtb3VzZWRvd24nLCBzYXZlU3RhdGUsIHRydWUpXG4gICAgICBAZG9jdW1lbnQucmVtb3ZlRXZlbnRMaXN0ZW5lcigna2V5ZG93bicsIHNhdmVTdGF0ZSwgdHJ1ZSlcblxuICByZWdpc3RlckRlZmF1bHREZXNlcmlhbGl6ZXJzOiAtPlxuICAgIEBkZXNlcmlhbGl6ZXJzLmFkZChXb3Jrc3BhY2UpXG4gICAgQGRlc2VyaWFsaXplcnMuYWRkKFBhbmVDb250YWluZXIpXG4gICAgQGRlc2VyaWFsaXplcnMuYWRkKFBhbmVBeGlzKVxuICAgIEBkZXNlcmlhbGl6ZXJzLmFkZChQYW5lKVxuICAgIEBkZXNlcmlhbGl6ZXJzLmFkZChEb2NrKVxuICAgIEBkZXNlcmlhbGl6ZXJzLmFkZChQcm9qZWN0KVxuICAgIEBkZXNlcmlhbGl6ZXJzLmFkZChUZXh0RWRpdG9yKVxuICAgIEBkZXNlcmlhbGl6ZXJzLmFkZChUZXh0QnVmZmVyKVxuXG4gIHJlZ2lzdGVyRGVmYXVsdENvbW1hbmRzOiAtPlxuICAgIHJlZ2lzdGVyRGVmYXVsdENvbW1hbmRzKHtjb21tYW5kUmVnaXN0cnk6IEBjb21tYW5kcywgQGNvbmZpZywgQGNvbW1hbmRJbnN0YWxsZXIsIG5vdGlmaWNhdGlvbk1hbmFnZXI6IEBub3RpZmljYXRpb25zLCBAcHJvamVjdCwgQGNsaXBib2FyZH0pXG5cbiAgcmVnaXN0ZXJEZWZhdWx0T3BlbmVyczogLT5cbiAgICBAd29ya3NwYWNlLmFkZE9wZW5lciAodXJpKSA9PlxuICAgICAgc3dpdGNoIHVyaVxuICAgICAgICB3aGVuICdhdG9tOi8vLmF0b20vc3R5bGVzaGVldCdcbiAgICAgICAgICBAd29ya3NwYWNlLm9wZW5UZXh0RmlsZShAc3R5bGVzLmdldFVzZXJTdHlsZVNoZWV0UGF0aCgpKVxuICAgICAgICB3aGVuICdhdG9tOi8vLmF0b20va2V5bWFwJ1xuICAgICAgICAgIEB3b3Jrc3BhY2Uub3BlblRleHRGaWxlKEBrZXltYXBzLmdldFVzZXJLZXltYXBQYXRoKCkpXG4gICAgICAgIHdoZW4gJ2F0b206Ly8uYXRvbS9jb25maWcnXG4gICAgICAgICAgQHdvcmtzcGFjZS5vcGVuVGV4dEZpbGUoQGNvbmZpZy5nZXRVc2VyQ29uZmlnUGF0aCgpKVxuICAgICAgICB3aGVuICdhdG9tOi8vLmF0b20vaW5pdC1zY3JpcHQnXG4gICAgICAgICAgQHdvcmtzcGFjZS5vcGVuVGV4dEZpbGUoQGdldFVzZXJJbml0U2NyaXB0UGF0aCgpKVxuXG4gIHJlZ2lzdGVyRGVmYXVsdFRhcmdldEZvcktleW1hcHM6IC0+XG4gICAgQGtleW1hcHMuZGVmYXVsdFRhcmdldCA9IEB3b3Jrc3BhY2UuZ2V0RWxlbWVudCgpXG5cbiAgb2JzZXJ2ZUF1dG9IaWRlTWVudUJhcjogLT5cbiAgICBAZGlzcG9zYWJsZXMuYWRkIEBjb25maWcub25EaWRDaGFuZ2UgJ2NvcmUuYXV0b0hpZGVNZW51QmFyJywgKHtuZXdWYWx1ZX0pID0+XG4gICAgICBAc2V0QXV0b0hpZGVNZW51QmFyKG5ld1ZhbHVlKVxuICAgIEBzZXRBdXRvSGlkZU1lbnVCYXIodHJ1ZSkgaWYgQGNvbmZpZy5nZXQoJ2NvcmUuYXV0b0hpZGVNZW51QmFyJylcblxuICByZXNldDogLT5cbiAgICBAZGVzZXJpYWxpemVycy5jbGVhcigpXG4gICAgQHJlZ2lzdGVyRGVmYXVsdERlc2VyaWFsaXplcnMoKVxuXG4gICAgQGNvbmZpZy5jbGVhcigpXG4gICAgQGNvbmZpZy5zZXRTY2hlbWEgbnVsbCwge3R5cGU6ICdvYmplY3QnLCBwcm9wZXJ0aWVzOiBfLmNsb25lKENvbmZpZ1NjaGVtYSl9XG5cbiAgICBAa2V5bWFwcy5jbGVhcigpXG4gICAgQGtleW1hcHMubG9hZEJ1bmRsZWRLZXltYXBzKClcblxuICAgIEBjb21tYW5kcy5jbGVhcigpXG4gICAgQHJlZ2lzdGVyRGVmYXVsdENvbW1hbmRzKClcblxuICAgIEBzdHlsZXMucmVzdG9yZVNuYXBzaG90KEBpbml0aWFsU3R5bGVFbGVtZW50cylcblxuICAgIEBtZW51LmNsZWFyKClcblxuICAgIEBjbGlwYm9hcmQucmVzZXQoKVxuXG4gICAgQG5vdGlmaWNhdGlvbnMuY2xlYXIoKVxuXG4gICAgQGNvbnRleHRNZW51LmNsZWFyKClcblxuICAgIEBwYWNrYWdlcy5yZXNldCgpXG5cbiAgICBAd29ya3NwYWNlLnJlc2V0KEBwYWNrYWdlcylcbiAgICBAcmVnaXN0ZXJEZWZhdWx0T3BlbmVycygpXG5cbiAgICBAcHJvamVjdC5yZXNldChAcGFja2FnZXMpXG5cbiAgICBAd29ya3NwYWNlLnN1YnNjcmliZVRvRXZlbnRzKClcblxuICAgIEBncmFtbWFycy5jbGVhcigpXG5cbiAgICBAdGV4dEVkaXRvcnMuY2xlYXIoKVxuXG4gICAgQHZpZXdzLmNsZWFyKClcblxuICBkZXN0cm95OiAtPlxuICAgIHJldHVybiBpZiBub3QgQHByb2plY3RcblxuICAgIEBkaXNwb3NhYmxlcy5kaXNwb3NlKClcbiAgICBAd29ya3NwYWNlPy5kZXN0cm95KClcbiAgICBAd29ya3NwYWNlID0gbnVsbFxuICAgIEB0aGVtZXMud29ya3NwYWNlID0gbnVsbFxuICAgIEBwcm9qZWN0Py5kZXN0cm95KClcbiAgICBAcHJvamVjdCA9IG51bGxcbiAgICBAY29tbWFuZHMuY2xlYXIoKVxuICAgIEBzdHlsZXNFbGVtZW50LnJlbW92ZSgpXG4gICAgQGNvbmZpZy51bm9ic2VydmVVc2VyQ29uZmlnKClcbiAgICBAYXV0b1VwZGF0ZXIuZGVzdHJveSgpXG5cbiAgICBAdW5pbnN0YWxsV2luZG93RXZlbnRIYW5kbGVyKClcblxuICAjIyNcbiAgU2VjdGlvbjogRXZlbnQgU3Vic2NyaXB0aW9uXG4gICMjI1xuXG4gICMgRXh0ZW5kZWQ6IEludm9rZSB0aGUgZ2l2ZW4gY2FsbGJhY2sgd2hlbmV2ZXIgezo6YmVlcH0gaXMgY2FsbGVkLlxuICAjXG4gICMgKiBgY2FsbGJhY2tgIHtGdW5jdGlvbn0gdG8gYmUgY2FsbGVkIHdoZW5ldmVyIHs6OmJlZXB9IGlzIGNhbGxlZC5cbiAgI1xuICAjIFJldHVybnMgYSB7RGlzcG9zYWJsZX0gb24gd2hpY2ggYC5kaXNwb3NlKClgIGNhbiBiZSBjYWxsZWQgdG8gdW5zdWJzY3JpYmUuXG4gIG9uRGlkQmVlcDogKGNhbGxiYWNrKSAtPlxuICAgIEBlbWl0dGVyLm9uICdkaWQtYmVlcCcsIGNhbGxiYWNrXG5cbiAgIyBFeHRlbmRlZDogSW52b2tlIHRoZSBnaXZlbiBjYWxsYmFjayB3aGVuIHRoZXJlIGlzIGFuIHVuaGFuZGxlZCBlcnJvciwgYnV0XG4gICMgYmVmb3JlIHRoZSBkZXZ0b29scyBwb3Agb3BlblxuICAjXG4gICMgKiBgY2FsbGJhY2tgIHtGdW5jdGlvbn0gdG8gYmUgY2FsbGVkIHdoZW5ldmVyIHRoZXJlIGlzIGFuIHVuaGFuZGxlZCBlcnJvclxuICAjICAgKiBgZXZlbnRgIHtPYmplY3R9XG4gICMgICAgICogYG9yaWdpbmFsRXJyb3JgIHtPYmplY3R9IHRoZSBvcmlnaW5hbCBlcnJvciBvYmplY3RcbiAgIyAgICAgKiBgbWVzc2FnZWAge1N0cmluZ30gdGhlIG9yaWdpbmFsIGVycm9yIG9iamVjdFxuICAjICAgICAqIGB1cmxgIHtTdHJpbmd9IFVybCB0byB0aGUgZmlsZSB3aGVyZSB0aGUgZXJyb3Igb3JpZ2luYXRlZC5cbiAgIyAgICAgKiBgbGluZWAge051bWJlcn1cbiAgIyAgICAgKiBgY29sdW1uYCB7TnVtYmVyfVxuICAjICAgICAqIGBwcmV2ZW50RGVmYXVsdGAge0Z1bmN0aW9ufSBjYWxsIHRoaXMgdG8gYXZvaWQgcG9wcGluZyB1cCB0aGUgZGV2IHRvb2xzLlxuICAjXG4gICMgUmV0dXJucyBhIHtEaXNwb3NhYmxlfSBvbiB3aGljaCBgLmRpc3Bvc2UoKWAgY2FuIGJlIGNhbGxlZCB0byB1bnN1YnNjcmliZS5cbiAgb25XaWxsVGhyb3dFcnJvcjogKGNhbGxiYWNrKSAtPlxuICAgIEBlbWl0dGVyLm9uICd3aWxsLXRocm93LWVycm9yJywgY2FsbGJhY2tcblxuICAjIEV4dGVuZGVkOiBJbnZva2UgdGhlIGdpdmVuIGNhbGxiYWNrIHdoZW5ldmVyIHRoZXJlIGlzIGFuIHVuaGFuZGxlZCBlcnJvci5cbiAgI1xuICAjICogYGNhbGxiYWNrYCB7RnVuY3Rpb259IHRvIGJlIGNhbGxlZCB3aGVuZXZlciB0aGVyZSBpcyBhbiB1bmhhbmRsZWQgZXJyb3JcbiAgIyAgICogYGV2ZW50YCB7T2JqZWN0fVxuICAjICAgICAqIGBvcmlnaW5hbEVycm9yYCB7T2JqZWN0fSB0aGUgb3JpZ2luYWwgZXJyb3Igb2JqZWN0XG4gICMgICAgICogYG1lc3NhZ2VgIHtTdHJpbmd9IHRoZSBvcmlnaW5hbCBlcnJvciBvYmplY3RcbiAgIyAgICAgKiBgdXJsYCB7U3RyaW5nfSBVcmwgdG8gdGhlIGZpbGUgd2hlcmUgdGhlIGVycm9yIG9yaWdpbmF0ZWQuXG4gICMgICAgICogYGxpbmVgIHtOdW1iZXJ9XG4gICMgICAgICogYGNvbHVtbmAge051bWJlcn1cbiAgI1xuICAjIFJldHVybnMgYSB7RGlzcG9zYWJsZX0gb24gd2hpY2ggYC5kaXNwb3NlKClgIGNhbiBiZSBjYWxsZWQgdG8gdW5zdWJzY3JpYmUuXG4gIG9uRGlkVGhyb3dFcnJvcjogKGNhbGxiYWNrKSAtPlxuICAgIEBlbWl0dGVyLm9uICdkaWQtdGhyb3ctZXJyb3InLCBjYWxsYmFja1xuXG4gICMgVE9ETzogTWFrZSB0aGlzIHBhcnQgb2YgdGhlIHB1YmxpYyBBUEkuIFdlIHNob3VsZCBtYWtlIG9uRGlkVGhyb3dFcnJvclxuICAjIG1hdGNoIHRoZSBpbnRlcmZhY2UgYnkgb25seSB5aWVsZGluZyBhbiBleGNlcHRpb24gb2JqZWN0IHRvIHRoZSBoYW5kbGVyXG4gICMgYW5kIGRlcHJlY2F0aW5nIHRoZSBvbGQgYmVoYXZpb3IuXG4gIG9uRGlkRmFpbEFzc2VydGlvbjogKGNhbGxiYWNrKSAtPlxuICAgIEBlbWl0dGVyLm9uICdkaWQtZmFpbC1hc3NlcnRpb24nLCBjYWxsYmFja1xuXG4gICMgRXh0ZW5kZWQ6IEludm9rZSB0aGUgZ2l2ZW4gY2FsbGJhY2sgYXMgc29vbiBhcyB0aGUgc2hlbGwgZW52aXJvbm1lbnQgaXNcbiAgIyBsb2FkZWQgKG9yIGltbWVkaWF0ZWx5IGlmIGl0IHdhcyBhbHJlYWR5IGxvYWRlZCkuXG4gICNcbiAgIyAqIGBjYWxsYmFja2Age0Z1bmN0aW9ufSB0byBiZSBjYWxsZWQgd2hlbmV2ZXIgdGhlcmUgaXMgYW4gdW5oYW5kbGVkIGVycm9yXG4gIHdoZW5TaGVsbEVudmlyb25tZW50TG9hZGVkOiAoY2FsbGJhY2spIC0+XG4gICAgaWYgQHNoZWxsRW52aXJvbm1lbnRMb2FkZWRcbiAgICAgIGNhbGxiYWNrKClcbiAgICAgIG5ldyBEaXNwb3NhYmxlKClcbiAgICBlbHNlXG4gICAgICBAZW1pdHRlci5vbmNlICdsb2FkZWQtc2hlbGwtZW52aXJvbm1lbnQnLCBjYWxsYmFja1xuXG4gICMjI1xuICBTZWN0aW9uOiBBdG9tIERldGFpbHNcbiAgIyMjXG5cbiAgIyBQdWJsaWM6IFJldHVybnMgYSB7Qm9vbGVhbn0gdGhhdCBpcyBgdHJ1ZWAgaWYgdGhlIGN1cnJlbnQgd2luZG93IGlzIGluIGRldmVsb3BtZW50IG1vZGUuXG4gIGluRGV2TW9kZTogLT5cbiAgICBAZGV2TW9kZSA/PSBAZ2V0TG9hZFNldHRpbmdzKCkuZGV2TW9kZVxuXG4gICMgUHVibGljOiBSZXR1cm5zIGEge0Jvb2xlYW59IHRoYXQgaXMgYHRydWVgIGlmIHRoZSBjdXJyZW50IHdpbmRvdyBpcyBpbiBzYWZlIG1vZGUuXG4gIGluU2FmZU1vZGU6IC0+XG4gICAgQHNhZmVNb2RlID89IEBnZXRMb2FkU2V0dGluZ3MoKS5zYWZlTW9kZVxuXG4gICMgUHVibGljOiBSZXR1cm5zIGEge0Jvb2xlYW59IHRoYXQgaXMgYHRydWVgIGlmIHRoZSBjdXJyZW50IHdpbmRvdyBpcyBydW5uaW5nIHNwZWNzLlxuICBpblNwZWNNb2RlOiAtPlxuICAgIEBzcGVjTW9kZSA/PSBAZ2V0TG9hZFNldHRpbmdzKCkuaXNTcGVjXG5cbiAgIyBSZXR1cm5zIGEge0Jvb2xlYW59IGluZGljYXRpbmcgd2hldGhlciB0aGlzIHRoZSBmaXJzdCB0aW1lIHRoZSB3aW5kb3cncyBiZWVuXG4gICMgbG9hZGVkLlxuICBpc0ZpcnN0TG9hZDogLT5cbiAgICBAZmlyc3RMb2FkID89IEBnZXRMb2FkU2V0dGluZ3MoKS5maXJzdExvYWRcblxuICAjIFB1YmxpYzogR2V0IHRoZSB2ZXJzaW9uIG9mIHRoZSBBdG9tIGFwcGxpY2F0aW9uLlxuICAjXG4gICMgUmV0dXJucyB0aGUgdmVyc2lvbiB0ZXh0IHtTdHJpbmd9LlxuICBnZXRWZXJzaW9uOiAtPlxuICAgIEBhcHBWZXJzaW9uID89IEBnZXRMb2FkU2V0dGluZ3MoKS5hcHBWZXJzaW9uXG5cbiAgIyBSZXR1cm5zIHRoZSByZWxlYXNlIGNoYW5uZWwgYXMgYSB7U3RyaW5nfS4gV2lsbCByZXR1cm4gb25lIG9mIGAnZGV2JywgJ2JldGEnLCAnc3RhYmxlJ2BcbiAgZ2V0UmVsZWFzZUNoYW5uZWw6IC0+XG4gICAgdmVyc2lvbiA9IEBnZXRWZXJzaW9uKClcbiAgICBpZiB2ZXJzaW9uLmluZGV4T2YoJ2JldGEnKSA+IC0xXG4gICAgICAnYmV0YSdcbiAgICBlbHNlIGlmIHZlcnNpb24uaW5kZXhPZignZGV2JykgPiAtMVxuICAgICAgJ2RldidcbiAgICBlbHNlXG4gICAgICAnc3RhYmxlJ1xuXG4gICMgUHVibGljOiBSZXR1cm5zIGEge0Jvb2xlYW59IHRoYXQgaXMgYHRydWVgIGlmIHRoZSBjdXJyZW50IHZlcnNpb24gaXMgYW4gb2ZmaWNpYWwgcmVsZWFzZS5cbiAgaXNSZWxlYXNlZFZlcnNpb246IC0+XG4gICAgbm90IC9cXHd7N30vLnRlc3QoQGdldFZlcnNpb24oKSkgIyBDaGVjayBpZiB0aGUgcmVsZWFzZSBpcyBhIDctY2hhcmFjdGVyIFNIQSBwcmVmaXhcblxuICAjIFB1YmxpYzogR2V0IHRoZSB0aW1lIHRha2VuIHRvIGNvbXBsZXRlbHkgbG9hZCB0aGUgY3VycmVudCB3aW5kb3cuXG4gICNcbiAgIyBUaGlzIHRpbWUgaW5jbHVkZSB0aGluZ3MgbGlrZSBsb2FkaW5nIGFuZCBhY3RpdmF0aW5nIHBhY2thZ2VzLCBjcmVhdGluZ1xuICAjIERPTSBlbGVtZW50cyBmb3IgdGhlIGVkaXRvciwgYW5kIHJlYWRpbmcgdGhlIGNvbmZpZy5cbiAgI1xuICAjIFJldHVybnMgdGhlIHtOdW1iZXJ9IG9mIG1pbGxpc2Vjb25kcyB0YWtlbiB0byBsb2FkIHRoZSB3aW5kb3cgb3IgbnVsbFxuICAjIGlmIHRoZSB3aW5kb3cgaGFzbid0IGZpbmlzaGVkIGxvYWRpbmcgeWV0LlxuICBnZXRXaW5kb3dMb2FkVGltZTogLT5cbiAgICBAbG9hZFRpbWVcblxuICAjIFB1YmxpYzogR2V0IHRoZSBsb2FkIHNldHRpbmdzIGZvciB0aGUgY3VycmVudCB3aW5kb3cuXG4gICNcbiAgIyBSZXR1cm5zIGFuIHtPYmplY3R9IGNvbnRhaW5pbmcgYWxsIHRoZSBsb2FkIHNldHRpbmcga2V5L3ZhbHVlIHBhaXJzLlxuICBnZXRMb2FkU2V0dGluZ3M6IC0+XG4gICAgQGFwcGxpY2F0aW9uRGVsZWdhdGUuZ2V0V2luZG93TG9hZFNldHRpbmdzKClcblxuICAjIyNcbiAgU2VjdGlvbjogTWFuYWdpbmcgVGhlIEF0b20gV2luZG93XG4gICMjI1xuXG4gICMgRXNzZW50aWFsOiBPcGVuIGEgbmV3IEF0b20gd2luZG93IHVzaW5nIHRoZSBnaXZlbiBvcHRpb25zLlxuICAjXG4gICMgQ2FsbGluZyB0aGlzIG1ldGhvZCB3aXRob3V0IGFuIG9wdGlvbnMgcGFyYW1ldGVyIHdpbGwgb3BlbiBhIHByb21wdCB0byBwaWNrXG4gICMgYSBmaWxlL2ZvbGRlciB0byBvcGVuIGluIHRoZSBuZXcgd2luZG93LlxuICAjXG4gICMgKiBgcGFyYW1zYCBBbiB7T2JqZWN0fSB3aXRoIHRoZSBmb2xsb3dpbmcga2V5czpcbiAgIyAgICogYHBhdGhzVG9PcGVuYCAgQW4ge0FycmF5fSBvZiB7U3RyaW5nfSBwYXRocyB0byBvcGVuLlxuICAjICAgKiBgbmV3V2luZG93YCBBIHtCb29sZWFufSwgdHJ1ZSB0byBhbHdheXMgb3BlbiBhIG5ldyB3aW5kb3cgaW5zdGVhZCBvZlxuICAjICAgICByZXVzaW5nIGV4aXN0aW5nIHdpbmRvd3MgZGVwZW5kaW5nIG9uIHRoZSBwYXRocyB0byBvcGVuLlxuICAjICAgKiBgZGV2TW9kZWAgQSB7Qm9vbGVhbn0sIHRydWUgdG8gb3BlbiB0aGUgd2luZG93IGluIGRldmVsb3BtZW50IG1vZGUuXG4gICMgICAgIERldmVsb3BtZW50IG1vZGUgbG9hZHMgdGhlIEF0b20gc291cmNlIGZyb20gdGhlIGxvY2FsbHkgY2xvbmVkXG4gICMgICAgIHJlcG9zaXRvcnkgYW5kIGFsc28gbG9hZHMgYWxsIHRoZSBwYWNrYWdlcyBpbiB+Ly5hdG9tL2Rldi9wYWNrYWdlc1xuICAjICAgKiBgc2FmZU1vZGVgIEEge0Jvb2xlYW59LCB0cnVlIHRvIG9wZW4gdGhlIHdpbmRvdyBpbiBzYWZlIG1vZGUuIFNhZmVcbiAgIyAgICAgbW9kZSBwcmV2ZW50cyBhbGwgcGFja2FnZXMgaW5zdGFsbGVkIHRvIH4vLmF0b20vcGFja2FnZXMgZnJvbSBsb2FkaW5nLlxuICBvcGVuOiAocGFyYW1zKSAtPlxuICAgIEBhcHBsaWNhdGlvbkRlbGVnYXRlLm9wZW4ocGFyYW1zKVxuXG4gICMgRXh0ZW5kZWQ6IFByb21wdCB0aGUgdXNlciB0byBzZWxlY3Qgb25lIG9yIG1vcmUgZm9sZGVycy5cbiAgI1xuICAjICogYGNhbGxiYWNrYCBBIHtGdW5jdGlvbn0gdG8gY2FsbCBvbmNlIHRoZSB1c2VyIGhhcyBjb25maXJtZWQgdGhlIHNlbGVjdGlvbi5cbiAgIyAgICogYHBhdGhzYCBBbiB7QXJyYXl9IG9mIHtTdHJpbmd9IHBhdGhzIHRoYXQgdGhlIHVzZXIgc2VsZWN0ZWQsIG9yIGBudWxsYFxuICAjICAgICBpZiB0aGUgdXNlciBkaXNtaXNzZWQgdGhlIGRpYWxvZy5cbiAgcGlja0ZvbGRlcjogKGNhbGxiYWNrKSAtPlxuICAgIEBhcHBsaWNhdGlvbkRlbGVnYXRlLnBpY2tGb2xkZXIoY2FsbGJhY2spXG5cbiAgIyBFc3NlbnRpYWw6IENsb3NlIHRoZSBjdXJyZW50IHdpbmRvdy5cbiAgY2xvc2U6IC0+XG4gICAgQGFwcGxpY2F0aW9uRGVsZWdhdGUuY2xvc2VXaW5kb3coKVxuXG4gICMgRXNzZW50aWFsOiBHZXQgdGhlIHNpemUgb2YgY3VycmVudCB3aW5kb3cuXG4gICNcbiAgIyBSZXR1cm5zIGFuIHtPYmplY3R9IGluIHRoZSBmb3JtYXQgYHt3aWR0aDogMTAwMCwgaGVpZ2h0OiA3MDB9YFxuICBnZXRTaXplOiAtPlxuICAgIEBhcHBsaWNhdGlvbkRlbGVnYXRlLmdldFdpbmRvd1NpemUoKVxuXG4gICMgRXNzZW50aWFsOiBTZXQgdGhlIHNpemUgb2YgY3VycmVudCB3aW5kb3cuXG4gICNcbiAgIyAqIGB3aWR0aGAgVGhlIHtOdW1iZXJ9IG9mIHBpeGVscy5cbiAgIyAqIGBoZWlnaHRgIFRoZSB7TnVtYmVyfSBvZiBwaXhlbHMuXG4gIHNldFNpemU6ICh3aWR0aCwgaGVpZ2h0KSAtPlxuICAgIEBhcHBsaWNhdGlvbkRlbGVnYXRlLnNldFdpbmRvd1NpemUod2lkdGgsIGhlaWdodClcblxuICAjIEVzc2VudGlhbDogR2V0IHRoZSBwb3NpdGlvbiBvZiBjdXJyZW50IHdpbmRvdy5cbiAgI1xuICAjIFJldHVybnMgYW4ge09iamVjdH0gaW4gdGhlIGZvcm1hdCBge3g6IDEwLCB5OiAyMH1gXG4gIGdldFBvc2l0aW9uOiAtPlxuICAgIEBhcHBsaWNhdGlvbkRlbGVnYXRlLmdldFdpbmRvd1Bvc2l0aW9uKClcblxuICAjIEVzc2VudGlhbDogU2V0IHRoZSBwb3NpdGlvbiBvZiBjdXJyZW50IHdpbmRvdy5cbiAgI1xuICAjICogYHhgIFRoZSB7TnVtYmVyfSBvZiBwaXhlbHMuXG4gICMgKiBgeWAgVGhlIHtOdW1iZXJ9IG9mIHBpeGVscy5cbiAgc2V0UG9zaXRpb246ICh4LCB5KSAtPlxuICAgIEBhcHBsaWNhdGlvbkRlbGVnYXRlLnNldFdpbmRvd1Bvc2l0aW9uKHgsIHkpXG5cbiAgIyBFeHRlbmRlZDogR2V0IHRoZSBjdXJyZW50IHdpbmRvd1xuICBnZXRDdXJyZW50V2luZG93OiAtPlxuICAgIEBhcHBsaWNhdGlvbkRlbGVnYXRlLmdldEN1cnJlbnRXaW5kb3coKVxuXG4gICMgRXh0ZW5kZWQ6IE1vdmUgY3VycmVudCB3aW5kb3cgdG8gdGhlIGNlbnRlciBvZiB0aGUgc2NyZWVuLlxuICBjZW50ZXI6IC0+XG4gICAgQGFwcGxpY2F0aW9uRGVsZWdhdGUuY2VudGVyV2luZG93KClcblxuICAjIEV4dGVuZGVkOiBGb2N1cyB0aGUgY3VycmVudCB3aW5kb3cuXG4gIGZvY3VzOiAtPlxuICAgIEBhcHBsaWNhdGlvbkRlbGVnYXRlLmZvY3VzV2luZG93KClcbiAgICBAd2luZG93LmZvY3VzKClcblxuICAjIEV4dGVuZGVkOiBTaG93IHRoZSBjdXJyZW50IHdpbmRvdy5cbiAgc2hvdzogLT5cbiAgICBAYXBwbGljYXRpb25EZWxlZ2F0ZS5zaG93V2luZG93KClcblxuICAjIEV4dGVuZGVkOiBIaWRlIHRoZSBjdXJyZW50IHdpbmRvdy5cbiAgaGlkZTogLT5cbiAgICBAYXBwbGljYXRpb25EZWxlZ2F0ZS5oaWRlV2luZG93KClcblxuICAjIEV4dGVuZGVkOiBSZWxvYWQgdGhlIGN1cnJlbnQgd2luZG93LlxuICByZWxvYWQ6IC0+XG4gICAgQGFwcGxpY2F0aW9uRGVsZWdhdGUucmVsb2FkV2luZG93KClcblxuICAjIEV4dGVuZGVkOiBSZWxhdW5jaCB0aGUgZW50aXJlIGFwcGxpY2F0aW9uLlxuICByZXN0YXJ0QXBwbGljYXRpb246IC0+XG4gICAgQGFwcGxpY2F0aW9uRGVsZWdhdGUucmVzdGFydEFwcGxpY2F0aW9uKClcblxuICAjIEV4dGVuZGVkOiBSZXR1cm5zIGEge0Jvb2xlYW59IHRoYXQgaXMgYHRydWVgIGlmIHRoZSBjdXJyZW50IHdpbmRvdyBpcyBtYXhpbWl6ZWQuXG4gIGlzTWF4aW1pemVkOiAtPlxuICAgIEBhcHBsaWNhdGlvbkRlbGVnYXRlLmlzV2luZG93TWF4aW1pemVkKClcblxuICBtYXhpbWl6ZTogLT5cbiAgICBAYXBwbGljYXRpb25EZWxlZ2F0ZS5tYXhpbWl6ZVdpbmRvdygpXG5cbiAgIyBFeHRlbmRlZDogUmV0dXJucyBhIHtCb29sZWFufSB0aGF0IGlzIGB0cnVlYCBpZiB0aGUgY3VycmVudCB3aW5kb3cgaXMgaW4gZnVsbCBzY3JlZW4gbW9kZS5cbiAgaXNGdWxsU2NyZWVuOiAtPlxuICAgIEBhcHBsaWNhdGlvbkRlbGVnYXRlLmlzV2luZG93RnVsbFNjcmVlbigpXG5cbiAgIyBFeHRlbmRlZDogU2V0IHRoZSBmdWxsIHNjcmVlbiBzdGF0ZSBvZiB0aGUgY3VycmVudCB3aW5kb3cuXG4gIHNldEZ1bGxTY3JlZW46IChmdWxsU2NyZWVuPWZhbHNlKSAtPlxuICAgIEBhcHBsaWNhdGlvbkRlbGVnYXRlLnNldFdpbmRvd0Z1bGxTY3JlZW4oZnVsbFNjcmVlbilcblxuICAjIEV4dGVuZGVkOiBUb2dnbGUgdGhlIGZ1bGwgc2NyZWVuIHN0YXRlIG9mIHRoZSBjdXJyZW50IHdpbmRvdy5cbiAgdG9nZ2xlRnVsbFNjcmVlbjogLT5cbiAgICBAc2V0RnVsbFNjcmVlbihub3QgQGlzRnVsbFNjcmVlbigpKVxuXG4gICMgUmVzdG9yZSB0aGUgd2luZG93IHRvIGl0cyBwcmV2aW91cyBkaW1lbnNpb25zIGFuZCBzaG93IGl0LlxuICAjXG4gICMgUmVzdG9yZXMgdGhlIGZ1bGwgc2NyZWVuIGFuZCBtYXhpbWl6ZWQgc3RhdGUgYWZ0ZXIgdGhlIHdpbmRvdyBoYXMgcmVzaXplZCB0b1xuICAjIHByZXZlbnQgcmVzaXplIGdsaXRjaGVzLlxuICBkaXNwbGF5V2luZG93OiAtPlxuICAgIEByZXN0b3JlV2luZG93RGltZW5zaW9ucygpLnRoZW4gPT5cbiAgICAgIHN0ZXBzID0gW1xuICAgICAgICBAcmVzdG9yZVdpbmRvd0JhY2tncm91bmQoKSxcbiAgICAgICAgQHNob3coKSxcbiAgICAgICAgQGZvY3VzKClcbiAgICAgIF1cbiAgICAgIHN0ZXBzLnB1c2goQHNldEZ1bGxTY3JlZW4odHJ1ZSkpIGlmIEB3aW5kb3dEaW1lbnNpb25zPy5mdWxsU2NyZWVuXG4gICAgICBzdGVwcy5wdXNoKEBtYXhpbWl6ZSgpKSBpZiBAd2luZG93RGltZW5zaW9ucz8ubWF4aW1pemVkIGFuZCBwcm9jZXNzLnBsYXRmb3JtIGlzbnQgJ2RhcndpbidcbiAgICAgIFByb21pc2UuYWxsKHN0ZXBzKVxuXG4gICMgR2V0IHRoZSBkaW1lbnNpb25zIG9mIHRoaXMgd2luZG93LlxuICAjXG4gICMgUmV0dXJucyBhbiB7T2JqZWN0fSB3aXRoIHRoZSBmb2xsb3dpbmcga2V5czpcbiAgIyAgICogYHhgICAgICAgVGhlIHdpbmRvdydzIHgtcG9zaXRpb24ge051bWJlcn0uXG4gICMgICAqIGB5YCAgICAgIFRoZSB3aW5kb3cncyB5LXBvc2l0aW9uIHtOdW1iZXJ9LlxuICAjICAgKiBgd2lkdGhgICBUaGUgd2luZG93J3Mgd2lkdGgge051bWJlcn0uXG4gICMgICAqIGBoZWlnaHRgIFRoZSB3aW5kb3cncyBoZWlnaHQge051bWJlcn0uXG4gIGdldFdpbmRvd0RpbWVuc2lvbnM6IC0+XG4gICAgYnJvd3NlcldpbmRvdyA9IEBnZXRDdXJyZW50V2luZG93KClcbiAgICBbeCwgeV0gPSBicm93c2VyV2luZG93LmdldFBvc2l0aW9uKClcbiAgICBbd2lkdGgsIGhlaWdodF0gPSBicm93c2VyV2luZG93LmdldFNpemUoKVxuICAgIG1heGltaXplZCA9IGJyb3dzZXJXaW5kb3cuaXNNYXhpbWl6ZWQoKVxuICAgIHt4LCB5LCB3aWR0aCwgaGVpZ2h0LCBtYXhpbWl6ZWR9XG5cbiAgIyBTZXQgdGhlIGRpbWVuc2lvbnMgb2YgdGhlIHdpbmRvdy5cbiAgI1xuICAjIFRoZSB3aW5kb3cgd2lsbCBiZSBjZW50ZXJlZCBpZiBlaXRoZXIgdGhlIHggb3IgeSBjb29yZGluYXRlIGlzIG5vdCBzZXRcbiAgIyBpbiB0aGUgZGltZW5zaW9ucyBwYXJhbWV0ZXIuIElmIHggb3IgeSBhcmUgb21pdHRlZCB0aGUgd2luZG93IHdpbGwgYmVcbiAgIyBjZW50ZXJlZC4gSWYgaGVpZ2h0IG9yIHdpZHRoIGFyZSBvbWl0dGVkIG9ubHkgdGhlIHBvc2l0aW9uIHdpbGwgYmUgY2hhbmdlZC5cbiAgI1xuICAjICogYGRpbWVuc2lvbnNgIEFuIHtPYmplY3R9IHdpdGggdGhlIGZvbGxvd2luZyBrZXlzOlxuICAjICAgKiBgeGAgVGhlIG5ldyB4IGNvb3JkaW5hdGUuXG4gICMgICAqIGB5YCBUaGUgbmV3IHkgY29vcmRpbmF0ZS5cbiAgIyAgICogYHdpZHRoYCBUaGUgbmV3IHdpZHRoLlxuICAjICAgKiBgaGVpZ2h0YCBUaGUgbmV3IGhlaWdodC5cbiAgc2V0V2luZG93RGltZW5zaW9uczogKHt4LCB5LCB3aWR0aCwgaGVpZ2h0fSkgLT5cbiAgICBzdGVwcyA9IFtdXG4gICAgaWYgd2lkdGg/IGFuZCBoZWlnaHQ/XG4gICAgICBzdGVwcy5wdXNoKEBzZXRTaXplKHdpZHRoLCBoZWlnaHQpKVxuICAgIGlmIHg/IGFuZCB5P1xuICAgICAgc3RlcHMucHVzaChAc2V0UG9zaXRpb24oeCwgeSkpXG4gICAgZWxzZVxuICAgICAgc3RlcHMucHVzaChAY2VudGVyKCkpXG4gICAgUHJvbWlzZS5hbGwoc3RlcHMpXG5cbiAgIyBSZXR1cm5zIHRydWUgaWYgdGhlIGRpbWVuc2lvbnMgYXJlIHVzZWFibGUsIGZhbHNlIGlmIHRoZXkgc2hvdWxkIGJlIGlnbm9yZWQuXG4gICMgV29yayBhcm91bmQgZm9yIGh0dHBzOi8vZ2l0aHViLmNvbS9hdG9tL2F0b20tc2hlbGwvaXNzdWVzLzQ3M1xuICBpc1ZhbGlkRGltZW5zaW9uczogKHt4LCB5LCB3aWR0aCwgaGVpZ2h0fT17fSkgLT5cbiAgICB3aWR0aCA+IDAgYW5kIGhlaWdodCA+IDAgYW5kIHggKyB3aWR0aCA+IDAgYW5kIHkgKyBoZWlnaHQgPiAwXG5cbiAgc3RvcmVXaW5kb3dEaW1lbnNpb25zOiAtPlxuICAgIEB3aW5kb3dEaW1lbnNpb25zID0gQGdldFdpbmRvd0RpbWVuc2lvbnMoKVxuICAgIGlmIEBpc1ZhbGlkRGltZW5zaW9ucyhAd2luZG93RGltZW5zaW9ucylcbiAgICAgIGxvY2FsU3RvcmFnZS5zZXRJdGVtKFwiZGVmYXVsdFdpbmRvd0RpbWVuc2lvbnNcIiwgSlNPTi5zdHJpbmdpZnkoQHdpbmRvd0RpbWVuc2lvbnMpKVxuXG4gIGdldERlZmF1bHRXaW5kb3dEaW1lbnNpb25zOiAtPlxuICAgIHt3aW5kb3dEaW1lbnNpb25zfSA9IEBnZXRMb2FkU2V0dGluZ3MoKVxuICAgIHJldHVybiB3aW5kb3dEaW1lbnNpb25zIGlmIHdpbmRvd0RpbWVuc2lvbnM/XG5cbiAgICBkaW1lbnNpb25zID0gbnVsbFxuICAgIHRyeVxuICAgICAgZGltZW5zaW9ucyA9IEpTT04ucGFyc2UobG9jYWxTdG9yYWdlLmdldEl0ZW0oXCJkZWZhdWx0V2luZG93RGltZW5zaW9uc1wiKSlcbiAgICBjYXRjaCBlcnJvclxuICAgICAgY29uc29sZS53YXJuIFwiRXJyb3IgcGFyc2luZyBkZWZhdWx0IHdpbmRvdyBkaW1lbnNpb25zXCIsIGVycm9yXG4gICAgICBsb2NhbFN0b3JhZ2UucmVtb3ZlSXRlbShcImRlZmF1bHRXaW5kb3dEaW1lbnNpb25zXCIpXG5cbiAgICBpZiBAaXNWYWxpZERpbWVuc2lvbnMoZGltZW5zaW9ucylcbiAgICAgIGRpbWVuc2lvbnNcbiAgICBlbHNlXG4gICAgICB7d2lkdGgsIGhlaWdodH0gPSBAYXBwbGljYXRpb25EZWxlZ2F0ZS5nZXRQcmltYXJ5RGlzcGxheVdvcmtBcmVhU2l6ZSgpXG4gICAgICB7eDogMCwgeTogMCwgd2lkdGg6IE1hdGgubWluKDEwMjQsIHdpZHRoKSwgaGVpZ2h0fVxuXG4gIHJlc3RvcmVXaW5kb3dEaW1lbnNpb25zOiAtPlxuICAgIHVubGVzcyBAd2luZG93RGltZW5zaW9ucz8gYW5kIEBpc1ZhbGlkRGltZW5zaW9ucyhAd2luZG93RGltZW5zaW9ucylcbiAgICAgIEB3aW5kb3dEaW1lbnNpb25zID0gQGdldERlZmF1bHRXaW5kb3dEaW1lbnNpb25zKClcbiAgICBAc2V0V2luZG93RGltZW5zaW9ucyhAd2luZG93RGltZW5zaW9ucykudGhlbiA9PiBAd2luZG93RGltZW5zaW9uc1xuXG4gIHJlc3RvcmVXaW5kb3dCYWNrZ3JvdW5kOiAtPlxuICAgIGlmIGJhY2tncm91bmRDb2xvciA9IHdpbmRvdy5sb2NhbFN0b3JhZ2UuZ2V0SXRlbSgnYXRvbTp3aW5kb3ctYmFja2dyb3VuZC1jb2xvcicpXG4gICAgICBAYmFja2dyb3VuZFN0eWxlc2hlZXQgPSBkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdzdHlsZScpXG4gICAgICBAYmFja2dyb3VuZFN0eWxlc2hlZXQudHlwZSA9ICd0ZXh0L2NzcydcbiAgICAgIEBiYWNrZ3JvdW5kU3R5bGVzaGVldC5pbm5lclRleHQgPSAnaHRtbCwgYm9keSB7IGJhY2tncm91bmQ6ICcgKyBiYWNrZ3JvdW5kQ29sb3IgKyAnICFpbXBvcnRhbnQ7IH0nXG4gICAgICBkb2N1bWVudC5oZWFkLmFwcGVuZENoaWxkKEBiYWNrZ3JvdW5kU3R5bGVzaGVldClcblxuICBzdG9yZVdpbmRvd0JhY2tncm91bmQ6IC0+XG4gICAgcmV0dXJuIGlmIEBpblNwZWNNb2RlKClcblxuICAgIGJhY2tncm91bmRDb2xvciA9IEB3aW5kb3cuZ2V0Q29tcHV0ZWRTdHlsZShAd29ya3NwYWNlLmdldEVsZW1lbnQoKSlbJ2JhY2tncm91bmQtY29sb3InXVxuICAgIEB3aW5kb3cubG9jYWxTdG9yYWdlLnNldEl0ZW0oJ2F0b206d2luZG93LWJhY2tncm91bmQtY29sb3InLCBiYWNrZ3JvdW5kQ29sb3IpXG5cbiAgIyBDYWxsIHRoaXMgbWV0aG9kIHdoZW4gZXN0YWJsaXNoaW5nIGEgcmVhbCBhcHBsaWNhdGlvbiB3aW5kb3cuXG4gIHN0YXJ0RWRpdG9yV2luZG93OiAtPlxuICAgIEB1bmxvYWRlZCA9IGZhbHNlXG5cbiAgICB1cGRhdGVQcm9jZXNzRW52UHJvbWlzZSA9IEB1cGRhdGVQcm9jZXNzRW52QW5kVHJpZ2dlckhvb2tzKClcblxuICAgIGxvYWRTdGF0ZVByb21pc2UgPSBAbG9hZFN0YXRlKCkudGhlbiAoc3RhdGUpID0+XG4gICAgICBAd2luZG93RGltZW5zaW9ucyA9IHN0YXRlPy53aW5kb3dEaW1lbnNpb25zXG4gICAgICBAZGlzcGxheVdpbmRvdygpLnRoZW4gPT5cbiAgICAgICAgQGNvbW1hbmRJbnN0YWxsZXIuaW5zdGFsbEF0b21Db21tYW5kIGZhbHNlLCAoZXJyb3IpIC0+XG4gICAgICAgICAgY29uc29sZS53YXJuIGVycm9yLm1lc3NhZ2UgaWYgZXJyb3I/XG4gICAgICAgIEBjb21tYW5kSW5zdGFsbGVyLmluc3RhbGxBcG1Db21tYW5kIGZhbHNlLCAoZXJyb3IpIC0+XG4gICAgICAgICAgY29uc29sZS53YXJuIGVycm9yLm1lc3NhZ2UgaWYgZXJyb3I/XG5cbiAgICAgICAgQGRpc3Bvc2FibGVzLmFkZChAYXBwbGljYXRpb25EZWxlZ2F0ZS5vbkRpZE9wZW5Mb2NhdGlvbnMoQG9wZW5Mb2NhdGlvbnMuYmluZCh0aGlzKSkpXG4gICAgICAgIEBkaXNwb3NhYmxlcy5hZGQoQGFwcGxpY2F0aW9uRGVsZWdhdGUub25BcHBsaWNhdGlvbk1lbnVDb21tYW5kKEBkaXNwYXRjaEFwcGxpY2F0aW9uTWVudUNvbW1hbmQuYmluZCh0aGlzKSkpXG4gICAgICAgIEBkaXNwb3NhYmxlcy5hZGQoQGFwcGxpY2F0aW9uRGVsZWdhdGUub25Db250ZXh0TWVudUNvbW1hbmQoQGRpc3BhdGNoQ29udGV4dE1lbnVDb21tYW5kLmJpbmQodGhpcykpKVxuICAgICAgICBAZGlzcG9zYWJsZXMuYWRkIEBhcHBsaWNhdGlvbkRlbGVnYXRlLm9uRGlkUmVxdWVzdFVubG9hZCA9PlxuICAgICAgICAgIEBzYXZlU3RhdGUoe2lzVW5sb2FkaW5nOiB0cnVlfSlcbiAgICAgICAgICAgIC5jYXRjaChjb25zb2xlLmVycm9yKVxuICAgICAgICAgICAgLnRoZW4gPT5cbiAgICAgICAgICAgICAgQHdvcmtzcGFjZT8uY29uZmlybUNsb3NlKHtcbiAgICAgICAgICAgICAgICB3aW5kb3dDbG9zZVJlcXVlc3RlZDogdHJ1ZSxcbiAgICAgICAgICAgICAgICBwcm9qZWN0SGFzUGF0aHM6IEBwcm9qZWN0LmdldFBhdGhzKCkubGVuZ3RoID4gMFxuICAgICAgICAgICAgICB9KVxuXG4gICAgICAgIEBsaXN0ZW5Gb3JVcGRhdGVzKClcblxuICAgICAgICBAcmVnaXN0ZXJEZWZhdWx0VGFyZ2V0Rm9yS2V5bWFwcygpXG5cbiAgICAgICAgQHBhY2thZ2VzLmxvYWRQYWNrYWdlcygpXG5cbiAgICAgICAgc3RhcnRUaW1lID0gRGF0ZS5ub3coKVxuICAgICAgICBAZGVzZXJpYWxpemUoc3RhdGUpLnRoZW4gPT5cbiAgICAgICAgICBAZGVzZXJpYWxpemVUaW1pbmdzLmF0b20gPSBEYXRlLm5vdygpIC0gc3RhcnRUaW1lXG5cbiAgICAgICAgICBpZiBwcm9jZXNzLnBsYXRmb3JtIGlzICdkYXJ3aW4nIGFuZCBAY29uZmlnLmdldCgnY29yZS50aXRsZUJhcicpIGlzICdjdXN0b20nXG4gICAgICAgICAgICBAd29ya3NwYWNlLmFkZEhlYWRlclBhbmVsKHtpdGVtOiBuZXcgVGl0bGVCYXIoe0B3b3Jrc3BhY2UsIEB0aGVtZXMsIEBhcHBsaWNhdGlvbkRlbGVnYXRlfSl9KVxuICAgICAgICAgICAgQGRvY3VtZW50LmJvZHkuY2xhc3NMaXN0LmFkZCgnY3VzdG9tLXRpdGxlLWJhcicpXG4gICAgICAgICAgaWYgcHJvY2Vzcy5wbGF0Zm9ybSBpcyAnZGFyd2luJyBhbmQgQGNvbmZpZy5nZXQoJ2NvcmUudGl0bGVCYXInKSBpcyAnY3VzdG9tLWluc2V0J1xuICAgICAgICAgICAgQHdvcmtzcGFjZS5hZGRIZWFkZXJQYW5lbCh7aXRlbTogbmV3IFRpdGxlQmFyKHtAd29ya3NwYWNlLCBAdGhlbWVzLCBAYXBwbGljYXRpb25EZWxlZ2F0ZX0pfSlcbiAgICAgICAgICAgIEBkb2N1bWVudC5ib2R5LmNsYXNzTGlzdC5hZGQoJ2N1c3RvbS1pbnNldC10aXRsZS1iYXInKVxuICAgICAgICAgIGlmIHByb2Nlc3MucGxhdGZvcm0gaXMgJ2RhcndpbicgYW5kIEBjb25maWcuZ2V0KCdjb3JlLnRpdGxlQmFyJykgaXMgJ2hpZGRlbidcbiAgICAgICAgICAgIEBkb2N1bWVudC5ib2R5LmNsYXNzTGlzdC5hZGQoJ2hpZGRlbi10aXRsZS1iYXInKVxuXG4gICAgICAgICAgQGRvY3VtZW50LmJvZHkuYXBwZW5kQ2hpbGQoQHdvcmtzcGFjZS5nZXRFbGVtZW50KCkpXG4gICAgICAgICAgQGJhY2tncm91bmRTdHlsZXNoZWV0Py5yZW1vdmUoKVxuXG4gICAgICAgICAgQHdhdGNoUHJvamVjdFBhdGhzKClcblxuICAgICAgICAgIEBwYWNrYWdlcy5hY3RpdmF0ZSgpXG4gICAgICAgICAgQGtleW1hcHMubG9hZFVzZXJLZXltYXAoKVxuICAgICAgICAgIEByZXF1aXJlVXNlckluaXRTY3JpcHQoKSB1bmxlc3MgQGdldExvYWRTZXR0aW5ncygpLnNhZmVNb2RlXG5cbiAgICAgICAgICBAbWVudS51cGRhdGUoKVxuXG4gICAgICAgICAgQG9wZW5Jbml0aWFsRW1wdHlFZGl0b3JJZk5lY2Vzc2FyeSgpXG5cbiAgICBsb2FkSGlzdG9yeVByb21pc2UgPSBAaGlzdG9yeS5sb2FkU3RhdGUoKS50aGVuID0+XG4gICAgICBAcmVvcGVuUHJvamVjdE1lbnVNYW5hZ2VyID0gbmV3IFJlb3BlblByb2plY3RNZW51TWFuYWdlcih7XG4gICAgICAgIEBtZW51LCBAY29tbWFuZHMsIEBoaXN0b3J5LCBAY29uZmlnLFxuICAgICAgICBvcGVuOiAocGF0aHMpID0+IEBvcGVuKHBhdGhzVG9PcGVuOiBwYXRocylcbiAgICAgIH0pXG4gICAgICBAcmVvcGVuUHJvamVjdE1lbnVNYW5hZ2VyLnVwZGF0ZSgpXG5cbiAgICBQcm9taXNlLmFsbChbbG9hZFN0YXRlUHJvbWlzZSwgbG9hZEhpc3RvcnlQcm9taXNlLCB1cGRhdGVQcm9jZXNzRW52UHJvbWlzZV0pXG5cbiAgc2VyaWFsaXplOiAob3B0aW9ucykgLT5cbiAgICB2ZXJzaW9uOiBAY29uc3RydWN0b3IudmVyc2lvblxuICAgIHByb2plY3Q6IEBwcm9qZWN0LnNlcmlhbGl6ZShvcHRpb25zKVxuICAgIHdvcmtzcGFjZTogQHdvcmtzcGFjZS5zZXJpYWxpemUoKVxuICAgIHBhY2thZ2VTdGF0ZXM6IEBwYWNrYWdlcy5zZXJpYWxpemUoKVxuICAgIGdyYW1tYXJzOiB7Z3JhbW1hck92ZXJyaWRlc0J5UGF0aDogQGdyYW1tYXJzLmdyYW1tYXJPdmVycmlkZXNCeVBhdGh9XG4gICAgZnVsbFNjcmVlbjogQGlzRnVsbFNjcmVlbigpXG4gICAgd2luZG93RGltZW5zaW9uczogQHdpbmRvd0RpbWVuc2lvbnNcbiAgICB0ZXh0RWRpdG9yczogQHRleHRFZGl0b3JzLnNlcmlhbGl6ZSgpXG5cbiAgdW5sb2FkRWRpdG9yV2luZG93OiAtPlxuICAgIHJldHVybiBpZiBub3QgQHByb2plY3RcblxuICAgIEBzdG9yZVdpbmRvd0JhY2tncm91bmQoKVxuICAgIEBwYWNrYWdlcy5kZWFjdGl2YXRlUGFja2FnZXMoKVxuICAgIEBzYXZlQmxvYlN0b3JlU3luYygpXG4gICAgQHVubG9hZGVkID0gdHJ1ZVxuXG4gIHNhdmVCbG9iU3RvcmVTeW5jOiAtPlxuICAgIGlmIEBlbmFibGVQZXJzaXN0ZW5jZVxuICAgICAgQGJsb2JTdG9yZS5zYXZlKClcblxuICBvcGVuSW5pdGlhbEVtcHR5RWRpdG9ySWZOZWNlc3Nhcnk6IC0+XG4gICAgcmV0dXJuIHVubGVzcyBAY29uZmlnLmdldCgnY29yZS5vcGVuRW1wdHlFZGl0b3JPblN0YXJ0JylcbiAgICBpZiBAZ2V0TG9hZFNldHRpbmdzKCkuaW5pdGlhbFBhdGhzPy5sZW5ndGggaXMgMCBhbmQgQHdvcmtzcGFjZS5nZXRQYW5lSXRlbXMoKS5sZW5ndGggaXMgMFxuICAgICAgQHdvcmtzcGFjZS5vcGVuKG51bGwpXG5cbiAgaW5zdGFsbFVuY2F1Z2h0RXJyb3JIYW5kbGVyOiAtPlxuICAgIEBwcmV2aW91c1dpbmRvd0Vycm9ySGFuZGxlciA9IEB3aW5kb3cub25lcnJvclxuICAgIEB3aW5kb3cub25lcnJvciA9ID0+XG4gICAgICBAbGFzdFVuY2F1Z2h0RXJyb3IgPSBBcnJheTo6c2xpY2UuY2FsbChhcmd1bWVudHMpXG4gICAgICBbbWVzc2FnZSwgdXJsLCBsaW5lLCBjb2x1bW4sIG9yaWdpbmFsRXJyb3JdID0gQGxhc3RVbmNhdWdodEVycm9yXG5cbiAgICAgIHtsaW5lLCBjb2x1bW4sIHNvdXJjZX0gPSBtYXBTb3VyY2VQb3NpdGlvbih7c291cmNlOiB1cmwsIGxpbmUsIGNvbHVtbn0pXG5cbiAgICAgIGlmIHVybCBpcyAnPGVtYmVkZGVkPidcbiAgICAgICAgdXJsID0gc291cmNlXG5cbiAgICAgIGV2ZW50T2JqZWN0ID0ge21lc3NhZ2UsIHVybCwgbGluZSwgY29sdW1uLCBvcmlnaW5hbEVycm9yfVxuXG4gICAgICBvcGVuRGV2VG9vbHMgPSB0cnVlXG4gICAgICBldmVudE9iamVjdC5wcmV2ZW50RGVmYXVsdCA9IC0+IG9wZW5EZXZUb29scyA9IGZhbHNlXG5cbiAgICAgIEBlbWl0dGVyLmVtaXQgJ3dpbGwtdGhyb3ctZXJyb3InLCBldmVudE9iamVjdFxuXG4gICAgICBpZiBvcGVuRGV2VG9vbHNcbiAgICAgICAgQG9wZW5EZXZUb29scygpLnRoZW4gPT4gQGV4ZWN1dGVKYXZhU2NyaXB0SW5EZXZUb29scygnRGV2VG9vbHNBUEkuc2hvd1BhbmVsKFwiY29uc29sZVwiKScpXG5cbiAgICAgIEBlbWl0dGVyLmVtaXQgJ2RpZC10aHJvdy1lcnJvcicsIHttZXNzYWdlLCB1cmwsIGxpbmUsIGNvbHVtbiwgb3JpZ2luYWxFcnJvcn1cblxuICB1bmluc3RhbGxVbmNhdWdodEVycm9ySGFuZGxlcjogLT5cbiAgICBAd2luZG93Lm9uZXJyb3IgPSBAcHJldmlvdXNXaW5kb3dFcnJvckhhbmRsZXJcblxuICBpbnN0YWxsV2luZG93RXZlbnRIYW5kbGVyOiAtPlxuICAgIEB3aW5kb3dFdmVudEhhbmRsZXIgPSBuZXcgV2luZG93RXZlbnRIYW5kbGVyKHthdG9tRW52aXJvbm1lbnQ6IHRoaXMsIEBhcHBsaWNhdGlvbkRlbGVnYXRlfSlcbiAgICBAd2luZG93RXZlbnRIYW5kbGVyLmluaXRpYWxpemUoQHdpbmRvdywgQGRvY3VtZW50KVxuXG4gIHVuaW5zdGFsbFdpbmRvd0V2ZW50SGFuZGxlcjogLT5cbiAgICBAd2luZG93RXZlbnRIYW5kbGVyPy51bnN1YnNjcmliZSgpXG4gICAgQHdpbmRvd0V2ZW50SGFuZGxlciA9IG51bGxcblxuICBkaWRDaGFuZ2VTdHlsZXM6IChzdHlsZUVsZW1lbnQpIC0+XG4gICAgVGV4dEVkaXRvci5kaWRVcGRhdGVTdHlsZXMoKVxuICAgIGlmIHN0eWxlRWxlbWVudC50ZXh0Q29udGVudC5pbmRleE9mKCdzY3JvbGxiYXInKSA+PSAwXG4gICAgICBUZXh0RWRpdG9yLmRpZFVwZGF0ZVNjcm9sbGJhclN0eWxlcygpXG5cbiAgdXBkYXRlUHJvY2Vzc0VudkFuZFRyaWdnZXJIb29rczogLT5cbiAgICBAdXBkYXRlUHJvY2Vzc0VudihAZ2V0TG9hZFNldHRpbmdzKCkuZW52KS50aGVuID0+XG4gICAgICBAc2hlbGxFbnZpcm9ubWVudExvYWRlZCA9IHRydWVcbiAgICAgIEBlbWl0dGVyLmVtaXQoJ2xvYWRlZC1zaGVsbC1lbnZpcm9ubWVudCcpXG4gICAgICBAcGFja2FnZXMudHJpZ2dlckFjdGl2YXRpb25Ib29rKCdjb3JlOmxvYWRlZC1zaGVsbC1lbnZpcm9ubWVudCcpXG5cbiAgIyMjXG4gIFNlY3Rpb246IE1lc3NhZ2luZyB0aGUgVXNlclxuICAjIyNcblxuICAjIEVzc2VudGlhbDogVmlzdWFsbHkgYW5kIGF1ZGlibHkgdHJpZ2dlciBhIGJlZXAuXG4gIGJlZXA6IC0+XG4gICAgQGFwcGxpY2F0aW9uRGVsZWdhdGUucGxheUJlZXBTb3VuZCgpIGlmIEBjb25maWcuZ2V0KCdjb3JlLmF1ZGlvQmVlcCcpXG4gICAgQGVtaXR0ZXIuZW1pdCAnZGlkLWJlZXAnXG5cbiAgIyBFc3NlbnRpYWw6IEEgZmxleGlibGUgd2F5IHRvIG9wZW4gYSBkaWFsb2cgYWtpbiB0byBhbiBhbGVydCBkaWFsb2cuXG4gICNcbiAgIyAjIyBFeGFtcGxlc1xuICAjXG4gICMgYGBgY29mZmVlXG4gICMgYXRvbS5jb25maXJtXG4gICMgICBtZXNzYWdlOiAnSG93IHlvdSBmZWVsaW5nPydcbiAgIyAgIGRldGFpbGVkTWVzc2FnZTogJ0JlIGhvbmVzdC4nXG4gICMgICBidXR0b25zOlxuICAjICAgICBHb29kOiAtPiB3aW5kb3cuYWxlcnQoJ2dvb2QgdG8gaGVhcicpXG4gICMgICAgIEJhZDogLT4gd2luZG93LmFsZXJ0KCdidW1tZXInKVxuICAjIGBgYFxuICAjXG4gICMgKiBgb3B0aW9uc2AgQW4ge09iamVjdH0gd2l0aCB0aGUgZm9sbG93aW5nIGtleXM6XG4gICMgICAqIGBtZXNzYWdlYCBUaGUge1N0cmluZ30gbWVzc2FnZSB0byBkaXNwbGF5LlxuICAjICAgKiBgZGV0YWlsZWRNZXNzYWdlYCAob3B0aW9uYWwpIFRoZSB7U3RyaW5nfSBkZXRhaWxlZCBtZXNzYWdlIHRvIGRpc3BsYXkuXG4gICMgICAqIGBidXR0b25zYCAob3B0aW9uYWwpIEVpdGhlciBhbiBhcnJheSBvZiBzdHJpbmdzIG9yIGFuIG9iamVjdCB3aGVyZSBrZXlzIGFyZVxuICAjICAgICBidXR0b24gbmFtZXMgYW5kIHRoZSB2YWx1ZXMgYXJlIGNhbGxiYWNrcyB0byBpbnZva2Ugd2hlbiBjbGlja2VkLlxuICAjXG4gICMgUmV0dXJucyB0aGUgY2hvc2VuIGJ1dHRvbiBpbmRleCB7TnVtYmVyfSBpZiB0aGUgYnV0dG9ucyBvcHRpb24gd2FzIGFuIGFycmF5LlxuICBjb25maXJtOiAocGFyYW1zPXt9KSAtPlxuICAgIEBhcHBsaWNhdGlvbkRlbGVnYXRlLmNvbmZpcm0ocGFyYW1zKVxuXG4gICMjI1xuICBTZWN0aW9uOiBNYW5hZ2luZyB0aGUgRGV2IFRvb2xzXG4gICMjI1xuXG4gICMgRXh0ZW5kZWQ6IE9wZW4gdGhlIGRldiB0b29scyBmb3IgdGhlIGN1cnJlbnQgd2luZG93LlxuICAjXG4gICMgUmV0dXJucyBhIHtQcm9taXNlfSB0aGF0IHJlc29sdmVzIHdoZW4gdGhlIERldlRvb2xzIGhhdmUgYmVlbiBvcGVuZWQuXG4gIG9wZW5EZXZUb29sczogLT5cbiAgICBAYXBwbGljYXRpb25EZWxlZ2F0ZS5vcGVuV2luZG93RGV2VG9vbHMoKVxuXG4gICMgRXh0ZW5kZWQ6IFRvZ2dsZSB0aGUgdmlzaWJpbGl0eSBvZiB0aGUgZGV2IHRvb2xzIGZvciB0aGUgY3VycmVudCB3aW5kb3cuXG4gICNcbiAgIyBSZXR1cm5zIGEge1Byb21pc2V9IHRoYXQgcmVzb2x2ZXMgd2hlbiB0aGUgRGV2VG9vbHMgaGF2ZSBiZWVuIG9wZW5lZCBvclxuICAjIGNsb3NlZC5cbiAgdG9nZ2xlRGV2VG9vbHM6IC0+XG4gICAgQGFwcGxpY2F0aW9uRGVsZWdhdGUudG9nZ2xlV2luZG93RGV2VG9vbHMoKVxuXG4gICMgRXh0ZW5kZWQ6IEV4ZWN1dGUgY29kZSBpbiBkZXYgdG9vbHMuXG4gIGV4ZWN1dGVKYXZhU2NyaXB0SW5EZXZUb29sczogKGNvZGUpIC0+XG4gICAgQGFwcGxpY2F0aW9uRGVsZWdhdGUuZXhlY3V0ZUphdmFTY3JpcHRJbldpbmRvd0RldlRvb2xzKGNvZGUpXG5cbiAgIyMjXG4gIFNlY3Rpb246IFByaXZhdGVcbiAgIyMjXG5cbiAgYXNzZXJ0OiAoY29uZGl0aW9uLCBtZXNzYWdlLCBjYWxsYmFja09yTWV0YWRhdGEpIC0+XG4gICAgcmV0dXJuIHRydWUgaWYgY29uZGl0aW9uXG5cbiAgICBlcnJvciA9IG5ldyBFcnJvcihcIkFzc2VydGlvbiBmYWlsZWQ6ICN7bWVzc2FnZX1cIilcbiAgICBFcnJvci5jYXB0dXJlU3RhY2tUcmFjZShlcnJvciwgQGFzc2VydClcblxuICAgIGlmIGNhbGxiYWNrT3JNZXRhZGF0YT9cbiAgICAgIGlmIHR5cGVvZiBjYWxsYmFja09yTWV0YWRhdGEgaXMgJ2Z1bmN0aW9uJ1xuICAgICAgICBjYWxsYmFja09yTWV0YWRhdGE/KGVycm9yKVxuICAgICAgZWxzZVxuICAgICAgICBlcnJvci5tZXRhZGF0YSA9IGNhbGxiYWNrT3JNZXRhZGF0YVxuXG4gICAgQGVtaXR0ZXIuZW1pdCAnZGlkLWZhaWwtYXNzZXJ0aW9uJywgZXJyb3JcbiAgICB1bmxlc3MgQGlzUmVsZWFzZWRWZXJzaW9uKClcbiAgICAgIHRocm93IGVycm9yXG5cbiAgICBmYWxzZVxuXG4gIGxvYWRUaGVtZXM6IC0+XG4gICAgQHRoZW1lcy5sb2FkKClcblxuICAjIE5vdGlmeSB0aGUgYnJvd3NlciBwcm9qZWN0IG9mIHRoZSB3aW5kb3cncyBjdXJyZW50IHByb2plY3QgcGF0aFxuICB3YXRjaFByb2plY3RQYXRoczogLT5cbiAgICBAZGlzcG9zYWJsZXMuYWRkIEBwcm9qZWN0Lm9uRGlkQ2hhbmdlUGF0aHMgPT5cbiAgICAgIEBhcHBsaWNhdGlvbkRlbGVnYXRlLnNldFJlcHJlc2VudGVkRGlyZWN0b3J5UGF0aHMoQHByb2plY3QuZ2V0UGF0aHMoKSlcblxuICBzZXREb2N1bWVudEVkaXRlZDogKGVkaXRlZCkgLT5cbiAgICBAYXBwbGljYXRpb25EZWxlZ2F0ZS5zZXRXaW5kb3dEb2N1bWVudEVkaXRlZD8oZWRpdGVkKVxuXG4gIHNldFJlcHJlc2VudGVkRmlsZW5hbWU6IChmaWxlbmFtZSkgLT5cbiAgICBAYXBwbGljYXRpb25EZWxlZ2F0ZS5zZXRXaW5kb3dSZXByZXNlbnRlZEZpbGVuYW1lPyhmaWxlbmFtZSlcblxuICBhZGRQcm9qZWN0Rm9sZGVyOiAtPlxuICAgIEBwaWNrRm9sZGVyIChzZWxlY3RlZFBhdGhzID0gW10pID0+XG4gICAgICBAYWRkVG9Qcm9qZWN0KHNlbGVjdGVkUGF0aHMpXG5cbiAgYWRkVG9Qcm9qZWN0OiAocHJvamVjdFBhdGhzKSAtPlxuICAgIEBsb2FkU3RhdGUoQGdldFN0YXRlS2V5KHByb2plY3RQYXRocykpLnRoZW4gKHN0YXRlKSA9PlxuICAgICAgaWYgc3RhdGUgYW5kIEBwcm9qZWN0LmdldFBhdGhzKCkubGVuZ3RoIGlzIDBcbiAgICAgICAgQGF0dGVtcHRSZXN0b3JlUHJvamVjdFN0YXRlRm9yUGF0aHMoc3RhdGUsIHByb2plY3RQYXRocylcbiAgICAgIGVsc2VcbiAgICAgICAgQHByb2plY3QuYWRkUGF0aChmb2xkZXIpIGZvciBmb2xkZXIgaW4gcHJvamVjdFBhdGhzXG5cbiAgYXR0ZW1wdFJlc3RvcmVQcm9qZWN0U3RhdGVGb3JQYXRoczogKHN0YXRlLCBwcm9qZWN0UGF0aHMsIGZpbGVzVG9PcGVuID0gW10pIC0+XG4gICAgY2VudGVyID0gQHdvcmtzcGFjZS5nZXRDZW50ZXIoKVxuICAgIHdpbmRvd0lzVW51c2VkID0gPT5cbiAgICAgIGZvciBjb250YWluZXIgaW4gQHdvcmtzcGFjZS5nZXRQYW5lQ29udGFpbmVycygpXG4gICAgICAgIGZvciBpdGVtIGluIGNvbnRhaW5lci5nZXRQYW5lSXRlbXMoKVxuICAgICAgICAgIGlmIGl0ZW0gaW5zdGFuY2VvZiBUZXh0RWRpdG9yXG4gICAgICAgICAgICByZXR1cm4gZmFsc2UgaWYgaXRlbS5nZXRQYXRoKCkgb3IgaXRlbS5pc01vZGlmaWVkKClcbiAgICAgICAgICBlbHNlXG4gICAgICAgICAgICByZXR1cm4gZmFsc2UgaWYgY29udGFpbmVyIGlzIGNlbnRlclxuICAgICAgdHJ1ZVxuXG4gICAgaWYgd2luZG93SXNVbnVzZWQoKVxuICAgICAgQHJlc3RvcmVTdGF0ZUludG9UaGlzRW52aXJvbm1lbnQoc3RhdGUpXG4gICAgICBQcm9taXNlLmFsbCAoQHdvcmtzcGFjZS5vcGVuKGZpbGUpIGZvciBmaWxlIGluIGZpbGVzVG9PcGVuKVxuICAgIGVsc2VcbiAgICAgIG5vdW5zID0gaWYgcHJvamVjdFBhdGhzLmxlbmd0aCBpcyAxIHRoZW4gJ2ZvbGRlcicgZWxzZSAnZm9sZGVycydcbiAgICAgIGJ0biA9IEBjb25maXJtXG4gICAgICAgIG1lc3NhZ2U6ICdQcmV2aW91cyBhdXRvbWF0aWNhbGx5LXNhdmVkIHByb2plY3Qgc3RhdGUgZGV0ZWN0ZWQnXG4gICAgICAgIGRldGFpbGVkTWVzc2FnZTogXCJUaGVyZSBpcyBwcmV2aW91c2x5IHNhdmVkIHN0YXRlIGZvciB0aGUgc2VsZWN0ZWQgI3tub3Vuc30uIFwiICtcbiAgICAgICAgICBcIldvdWxkIHlvdSBsaWtlIHRvIGFkZCB0aGUgI3tub3Vuc30gdG8gdGhpcyB3aW5kb3csIHBlcm1hbmVudGx5IGRpc2NhcmRpbmcgdGhlIHNhdmVkIHN0YXRlLCBcIiArXG4gICAgICAgICAgXCJvciBvcGVuIHRoZSAje25vdW5zfSBpbiBhIG5ldyB3aW5kb3csIHJlc3RvcmluZyB0aGUgc2F2ZWQgc3RhdGU/XCJcbiAgICAgICAgYnV0dG9uczogW1xuICAgICAgICAgICdPcGVuIGluIG5ldyB3aW5kb3cgYW5kIHJlY292ZXIgc3RhdGUnXG4gICAgICAgICAgJ0FkZCB0byB0aGlzIHdpbmRvdyBhbmQgZGlzY2FyZCBzdGF0ZSdcbiAgICAgICAgXVxuICAgICAgaWYgYnRuIGlzIDBcbiAgICAgICAgQG9wZW5cbiAgICAgICAgICBwYXRoc1RvT3BlbjogcHJvamVjdFBhdGhzLmNvbmNhdChmaWxlc1RvT3BlbilcbiAgICAgICAgICBuZXdXaW5kb3c6IHRydWVcbiAgICAgICAgICBkZXZNb2RlOiBAaW5EZXZNb2RlKClcbiAgICAgICAgICBzYWZlTW9kZTogQGluU2FmZU1vZGUoKVxuICAgICAgICBQcm9taXNlLnJlc29sdmUobnVsbClcbiAgICAgIGVsc2UgaWYgYnRuIGlzIDFcbiAgICAgICAgQHByb2plY3QuYWRkUGF0aChzZWxlY3RlZFBhdGgpIGZvciBzZWxlY3RlZFBhdGggaW4gcHJvamVjdFBhdGhzXG4gICAgICAgIFByb21pc2UuYWxsIChAd29ya3NwYWNlLm9wZW4oZmlsZSkgZm9yIGZpbGUgaW4gZmlsZXNUb09wZW4pXG5cbiAgcmVzdG9yZVN0YXRlSW50b1RoaXNFbnZpcm9ubWVudDogKHN0YXRlKSAtPlxuICAgIHN0YXRlLmZ1bGxTY3JlZW4gPSBAaXNGdWxsU2NyZWVuKClcbiAgICBwYW5lLmRlc3Ryb3koKSBmb3IgcGFuZSBpbiBAd29ya3NwYWNlLmdldFBhbmVzKClcbiAgICBAZGVzZXJpYWxpemUoc3RhdGUpXG5cbiAgc2hvd1NhdmVEaWFsb2c6IChjYWxsYmFjaykgLT5cbiAgICBjYWxsYmFjayhAc2hvd1NhdmVEaWFsb2dTeW5jKCkpXG5cbiAgc2hvd1NhdmVEaWFsb2dTeW5jOiAob3B0aW9ucz17fSkgLT5cbiAgICBAYXBwbGljYXRpb25EZWxlZ2F0ZS5zaG93U2F2ZURpYWxvZyhvcHRpb25zKVxuXG4gIHNhdmVTdGF0ZTogKG9wdGlvbnMsIHN0b3JhZ2VLZXkpIC0+XG4gICAgbmV3IFByb21pc2UgKHJlc29sdmUsIHJlamVjdCkgPT5cbiAgICAgIGlmIEBlbmFibGVQZXJzaXN0ZW5jZSBhbmQgQHByb2plY3RcbiAgICAgICAgc3RhdGUgPSBAc2VyaWFsaXplKG9wdGlvbnMpXG4gICAgICAgIHNhdmVQcm9taXNlID1cbiAgICAgICAgICBpZiBzdG9yYWdlS2V5ID89IEBnZXRTdGF0ZUtleShAcHJvamVjdD8uZ2V0UGF0aHMoKSlcbiAgICAgICAgICAgIEBzdGF0ZVN0b3JlLnNhdmUoc3RvcmFnZUtleSwgc3RhdGUpXG4gICAgICAgICAgZWxzZVxuICAgICAgICAgICAgQGFwcGxpY2F0aW9uRGVsZWdhdGUuc2V0VGVtcG9yYXJ5V2luZG93U3RhdGUoc3RhdGUpXG4gICAgICAgIHNhdmVQcm9taXNlLmNhdGNoKHJlamVjdCkudGhlbihyZXNvbHZlKVxuICAgICAgZWxzZVxuICAgICAgICByZXNvbHZlKClcblxuICBsb2FkU3RhdGU6IChzdGF0ZUtleSkgLT5cbiAgICBpZiBAZW5hYmxlUGVyc2lzdGVuY2VcbiAgICAgIGlmIHN0YXRlS2V5ID89IEBnZXRTdGF0ZUtleShAZ2V0TG9hZFNldHRpbmdzKCkuaW5pdGlhbFBhdGhzKVxuICAgICAgICBAc3RhdGVTdG9yZS5sb2FkKHN0YXRlS2V5KS50aGVuIChzdGF0ZSkgPT5cbiAgICAgICAgICBpZiBzdGF0ZVxuICAgICAgICAgICAgc3RhdGVcbiAgICAgICAgICBlbHNlXG4gICAgICAgICAgICAjIFRPRE86IHJlbW92ZSB0aGlzIHdoZW4gZXZlcnkgdXNlciBoYXMgbWlncmF0ZWQgdG8gdGhlIEluZGV4ZWREYiBzdGF0ZSBzdG9yZS5cbiAgICAgICAgICAgIEBnZXRTdG9yYWdlRm9sZGVyKCkubG9hZChzdGF0ZUtleSlcbiAgICAgIGVsc2VcbiAgICAgICAgQGFwcGxpY2F0aW9uRGVsZWdhdGUuZ2V0VGVtcG9yYXJ5V2luZG93U3RhdGUoKVxuICAgIGVsc2VcbiAgICAgIFByb21pc2UucmVzb2x2ZShudWxsKVxuXG4gIGRlc2VyaWFsaXplOiAoc3RhdGUpIC0+XG4gICAgcmV0dXJuIFByb21pc2UucmVzb2x2ZSgpIHVubGVzcyBzdGF0ZT9cblxuICAgIGlmIGdyYW1tYXJPdmVycmlkZXNCeVBhdGggPSBzdGF0ZS5ncmFtbWFycz8uZ3JhbW1hck92ZXJyaWRlc0J5UGF0aFxuICAgICAgQGdyYW1tYXJzLmdyYW1tYXJPdmVycmlkZXNCeVBhdGggPSBncmFtbWFyT3ZlcnJpZGVzQnlQYXRoXG5cbiAgICBAc2V0RnVsbFNjcmVlbihzdGF0ZS5mdWxsU2NyZWVuKVxuXG4gICAgQHBhY2thZ2VzLnBhY2thZ2VTdGF0ZXMgPSBzdGF0ZS5wYWNrYWdlU3RhdGVzID8ge31cblxuICAgIHN0YXJ0VGltZSA9IERhdGUubm93KClcbiAgICBpZiBzdGF0ZS5wcm9qZWN0P1xuICAgICAgcHJvamVjdFByb21pc2UgPSBAcHJvamVjdC5kZXNlcmlhbGl6ZShzdGF0ZS5wcm9qZWN0LCBAZGVzZXJpYWxpemVycylcbiAgICBlbHNlXG4gICAgICBwcm9qZWN0UHJvbWlzZSA9IFByb21pc2UucmVzb2x2ZSgpXG5cbiAgICBwcm9qZWN0UHJvbWlzZS50aGVuID0+XG4gICAgICBAZGVzZXJpYWxpemVUaW1pbmdzLnByb2plY3QgPSBEYXRlLm5vdygpIC0gc3RhcnRUaW1lXG5cbiAgICAgIEB0ZXh0RWRpdG9ycy5kZXNlcmlhbGl6ZShzdGF0ZS50ZXh0RWRpdG9ycykgaWYgc3RhdGUudGV4dEVkaXRvcnNcblxuICAgICAgc3RhcnRUaW1lID0gRGF0ZS5ub3coKVxuICAgICAgQHdvcmtzcGFjZS5kZXNlcmlhbGl6ZShzdGF0ZS53b3Jrc3BhY2UsIEBkZXNlcmlhbGl6ZXJzKSBpZiBzdGF0ZS53b3Jrc3BhY2U/XG4gICAgICBAZGVzZXJpYWxpemVUaW1pbmdzLndvcmtzcGFjZSA9IERhdGUubm93KCkgLSBzdGFydFRpbWVcblxuICBnZXRTdGF0ZUtleTogKHBhdGhzKSAtPlxuICAgIGlmIHBhdGhzPy5sZW5ndGggPiAwXG4gICAgICBzaGExID0gY3J5cHRvLmNyZWF0ZUhhc2goJ3NoYTEnKS51cGRhdGUocGF0aHMuc2xpY2UoKS5zb3J0KCkuam9pbihcIlxcblwiKSkuZGlnZXN0KCdoZXgnKVxuICAgICAgXCJlZGl0b3ItI3tzaGExfVwiXG4gICAgZWxzZVxuICAgICAgbnVsbFxuXG4gIGdldFN0b3JhZ2VGb2xkZXI6IC0+XG4gICAgQHN0b3JhZ2VGb2xkZXIgPz0gbmV3IFN0b3JhZ2VGb2xkZXIoQGdldENvbmZpZ0RpclBhdGgoKSlcblxuICBnZXRDb25maWdEaXJQYXRoOiAtPlxuICAgIEBjb25maWdEaXJQYXRoID89IHByb2Nlc3MuZW52LkFUT01fSE9NRVxuXG4gIGdldFVzZXJJbml0U2NyaXB0UGF0aDogLT5cbiAgICBpbml0U2NyaXB0UGF0aCA9IGZzLnJlc29sdmUoQGdldENvbmZpZ0RpclBhdGgoKSwgJ2luaXQnLCBbJ2pzJywgJ2NvZmZlZSddKVxuICAgIGluaXRTY3JpcHRQYXRoID8gcGF0aC5qb2luKEBnZXRDb25maWdEaXJQYXRoKCksICdpbml0LmNvZmZlZScpXG5cbiAgcmVxdWlyZVVzZXJJbml0U2NyaXB0OiAtPlxuICAgIGlmIHVzZXJJbml0U2NyaXB0UGF0aCA9IEBnZXRVc2VySW5pdFNjcmlwdFBhdGgoKVxuICAgICAgdHJ5XG4gICAgICAgIHJlcXVpcmUodXNlckluaXRTY3JpcHRQYXRoKSBpZiBmcy5pc0ZpbGVTeW5jKHVzZXJJbml0U2NyaXB0UGF0aClcbiAgICAgIGNhdGNoIGVycm9yXG4gICAgICAgIEBub3RpZmljYXRpb25zLmFkZEVycm9yIFwiRmFpbGVkIHRvIGxvYWQgYCN7dXNlckluaXRTY3JpcHRQYXRofWBcIixcbiAgICAgICAgICBkZXRhaWw6IGVycm9yLm1lc3NhZ2VcbiAgICAgICAgICBkaXNtaXNzYWJsZTogdHJ1ZVxuXG4gICMgVE9ETzogV2Ugc2hvdWxkIGRlcHJlY2F0ZSB0aGUgdXBkYXRlIGV2ZW50cyBoZXJlLCBhbmQgdXNlIGBhdG9tLmF1dG9VcGRhdGVyYCBpbnN0ZWFkXG4gIG9uVXBkYXRlQXZhaWxhYmxlOiAoY2FsbGJhY2spIC0+XG4gICAgQGVtaXR0ZXIub24gJ3VwZGF0ZS1hdmFpbGFibGUnLCBjYWxsYmFja1xuXG4gIHVwZGF0ZUF2YWlsYWJsZTogKGRldGFpbHMpIC0+XG4gICAgQGVtaXR0ZXIuZW1pdCAndXBkYXRlLWF2YWlsYWJsZScsIGRldGFpbHNcblxuICBsaXN0ZW5Gb3JVcGRhdGVzOiAtPlxuICAgICMgbGlzdGVuIGZvciB1cGRhdGVzIGF2YWlsYWJsZSBsb2NhbGx5ICh0aGF0IGhhdmUgYmVlbiBzdWNjZXNzZnVsbHkgZG93bmxvYWRlZClcbiAgICBAZGlzcG9zYWJsZXMuYWRkKEBhdXRvVXBkYXRlci5vbkRpZENvbXBsZXRlRG93bmxvYWRpbmdVcGRhdGUoQHVwZGF0ZUF2YWlsYWJsZS5iaW5kKHRoaXMpKSlcblxuICBzZXRCb2R5UGxhdGZvcm1DbGFzczogLT5cbiAgICBAZG9jdW1lbnQuYm9keS5jbGFzc0xpc3QuYWRkKFwicGxhdGZvcm0tI3twcm9jZXNzLnBsYXRmb3JtfVwiKVxuXG4gIHNldEF1dG9IaWRlTWVudUJhcjogKGF1dG9IaWRlKSAtPlxuICAgIEBhcHBsaWNhdGlvbkRlbGVnYXRlLnNldEF1dG9IaWRlV2luZG93TWVudUJhcihhdXRvSGlkZSlcbiAgICBAYXBwbGljYXRpb25EZWxlZ2F0ZS5zZXRXaW5kb3dNZW51QmFyVmlzaWJpbGl0eShub3QgYXV0b0hpZGUpXG5cbiAgZGlzcGF0Y2hBcHBsaWNhdGlvbk1lbnVDb21tYW5kOiAoY29tbWFuZCwgYXJnKSAtPlxuICAgIGFjdGl2ZUVsZW1lbnQgPSBAZG9jdW1lbnQuYWN0aXZlRWxlbWVudFxuICAgICMgVXNlIHRoZSB3b3Jrc3BhY2UgZWxlbWVudCBpZiBib2R5IGhhcyBmb2N1c1xuICAgIGlmIGFjdGl2ZUVsZW1lbnQgaXMgQGRvY3VtZW50LmJvZHlcbiAgICAgIGFjdGl2ZUVsZW1lbnQgPSBAd29ya3NwYWNlLmdldEVsZW1lbnQoKVxuICAgIEBjb21tYW5kcy5kaXNwYXRjaChhY3RpdmVFbGVtZW50LCBjb21tYW5kLCBhcmcpXG5cbiAgZGlzcGF0Y2hDb250ZXh0TWVudUNvbW1hbmQ6IChjb21tYW5kLCBhcmdzLi4uKSAtPlxuICAgIEBjb21tYW5kcy5kaXNwYXRjaChAY29udGV4dE1lbnUuYWN0aXZlRWxlbWVudCwgY29tbWFuZCwgYXJncylcblxuICBvcGVuTG9jYXRpb25zOiAobG9jYXRpb25zKSAtPlxuICAgIG5lZWRzUHJvamVjdFBhdGhzID0gQHByb2plY3Q/LmdldFBhdGhzKCkubGVuZ3RoIGlzIDBcblxuICAgIGZvbGRlcnNUb0FkZFRvUHJvamVjdCA9IFtdXG4gICAgZmlsZUxvY2F0aW9uc1RvT3BlbiA9IFtdXG5cbiAgICBwdXNoRm9sZGVyVG9PcGVuID0gKGZvbGRlcikgLT5cbiAgICAgIGlmIGZvbGRlciBub3QgaW4gZm9sZGVyc1RvQWRkVG9Qcm9qZWN0XG4gICAgICAgIGZvbGRlcnNUb0FkZFRvUHJvamVjdC5wdXNoKGZvbGRlcilcblxuICAgIGZvciB7cGF0aFRvT3BlbiwgaW5pdGlhbExpbmUsIGluaXRpYWxDb2x1bW4sIGZvcmNlQWRkVG9XaW5kb3d9IGluIGxvY2F0aW9uc1xuICAgICAgaWYgcGF0aFRvT3Blbj8gYW5kIChuZWVkc1Byb2plY3RQYXRocyBvciBmb3JjZUFkZFRvV2luZG93KVxuICAgICAgICBpZiBmcy5leGlzdHNTeW5jKHBhdGhUb09wZW4pXG4gICAgICAgICAgcHVzaEZvbGRlclRvT3BlbiBAcHJvamVjdC5nZXREaXJlY3RvcnlGb3JQcm9qZWN0UGF0aChwYXRoVG9PcGVuKS5nZXRQYXRoKClcbiAgICAgICAgZWxzZSBpZiBmcy5leGlzdHNTeW5jKHBhdGguZGlybmFtZShwYXRoVG9PcGVuKSlcbiAgICAgICAgICBwdXNoRm9sZGVyVG9PcGVuIEBwcm9qZWN0LmdldERpcmVjdG9yeUZvclByb2plY3RQYXRoKHBhdGguZGlybmFtZShwYXRoVG9PcGVuKSkuZ2V0UGF0aCgpXG4gICAgICAgIGVsc2VcbiAgICAgICAgICBwdXNoRm9sZGVyVG9PcGVuIEBwcm9qZWN0LmdldERpcmVjdG9yeUZvclByb2plY3RQYXRoKHBhdGhUb09wZW4pLmdldFBhdGgoKVxuXG4gICAgICB1bmxlc3MgZnMuaXNEaXJlY3RvcnlTeW5jKHBhdGhUb09wZW4pXG4gICAgICAgIGZpbGVMb2NhdGlvbnNUb09wZW4ucHVzaCh7cGF0aFRvT3BlbiwgaW5pdGlhbExpbmUsIGluaXRpYWxDb2x1bW59KVxuXG4gICAgcHJvbWlzZSA9IFByb21pc2UucmVzb2x2ZShudWxsKVxuICAgIGlmIGZvbGRlcnNUb0FkZFRvUHJvamVjdC5sZW5ndGggPiAwXG4gICAgICBwcm9taXNlID0gQGxvYWRTdGF0ZShAZ2V0U3RhdGVLZXkoZm9sZGVyc1RvQWRkVG9Qcm9qZWN0KSkudGhlbiAoc3RhdGUpID0+XG4gICAgICAgIGlmIHN0YXRlIGFuZCBuZWVkc1Byb2plY3RQYXRocyAjIG9ubHkgbG9hZCBzdGF0ZSBpZiB0aGlzIGlzIHRoZSBmaXJzdCBwYXRoIGFkZGVkIHRvIHRoZSBwcm9qZWN0XG4gICAgICAgICAgZmlsZXMgPSAobG9jYXRpb24ucGF0aFRvT3BlbiBmb3IgbG9jYXRpb24gaW4gZmlsZUxvY2F0aW9uc1RvT3BlbilcbiAgICAgICAgICBAYXR0ZW1wdFJlc3RvcmVQcm9qZWN0U3RhdGVGb3JQYXRocyhzdGF0ZSwgZm9sZGVyc1RvQWRkVG9Qcm9qZWN0LCBmaWxlcylcbiAgICAgICAgZWxzZVxuICAgICAgICAgIHByb21pc2VzID0gW11cbiAgICAgICAgICBAcHJvamVjdC5hZGRQYXRoKGZvbGRlcikgZm9yIGZvbGRlciBpbiBmb2xkZXJzVG9BZGRUb1Byb2plY3RcbiAgICAgICAgICBmb3Ige3BhdGhUb09wZW4sIGluaXRpYWxMaW5lLCBpbml0aWFsQ29sdW1ufSBpbiBmaWxlTG9jYXRpb25zVG9PcGVuXG4gICAgICAgICAgICBwcm9taXNlcy5wdXNoIEB3b3Jrc3BhY2U/Lm9wZW4ocGF0aFRvT3Blbiwge2luaXRpYWxMaW5lLCBpbml0aWFsQ29sdW1ufSlcbiAgICAgICAgICBQcm9taXNlLmFsbChwcm9taXNlcylcbiAgICBlbHNlXG4gICAgICBwcm9taXNlcyA9IFtdXG4gICAgICBmb3Ige3BhdGhUb09wZW4sIGluaXRpYWxMaW5lLCBpbml0aWFsQ29sdW1ufSBpbiBmaWxlTG9jYXRpb25zVG9PcGVuXG4gICAgICAgIHByb21pc2VzLnB1c2ggQHdvcmtzcGFjZT8ub3BlbihwYXRoVG9PcGVuLCB7aW5pdGlhbExpbmUsIGluaXRpYWxDb2x1bW59KVxuICAgICAgcHJvbWlzZSA9IFByb21pc2UuYWxsKHByb21pc2VzKVxuXG4gICAgcHJvbWlzZS50aGVuIC0+XG4gICAgICBpcGNSZW5kZXJlci5zZW5kICd3aW5kb3ctY29tbWFuZCcsICd3aW5kb3c6bG9jYXRpb25zLW9wZW5lZCdcblxuICByZXNvbHZlUHJveHk6ICh1cmwpIC0+XG4gICAgcmV0dXJuIG5ldyBQcm9taXNlIChyZXNvbHZlLCByZWplY3QpID0+XG4gICAgICByZXF1ZXN0SWQgPSBAbmV4dFByb3h5UmVxdWVzdElkKytcbiAgICAgIGRpc3Bvc2FibGUgPSBAYXBwbGljYXRpb25EZWxlZ2F0ZS5vbkRpZFJlc29sdmVQcm94eSAoaWQsIHByb3h5KSAtPlxuICAgICAgICBpZiBpZCBpcyByZXF1ZXN0SWRcbiAgICAgICAgICBkaXNwb3NhYmxlLmRpc3Bvc2UoKVxuICAgICAgICAgIHJlc29sdmUocHJveHkpXG5cbiAgICAgIEBhcHBsaWNhdGlvbkRlbGVnYXRlLnJlc29sdmVQcm94eShyZXF1ZXN0SWQsIHVybClcblxuIyBQcmVzZXJ2ZSB0aGlzIGRlcHJlY2F0aW9uIHVudGlsIDIuMC4gU29ycnkuIFNob3VsZCBoYXZlIHJlbW92ZWQgUSBzb29uZXIuXG5Qcm9taXNlLnByb3RvdHlwZS5kb25lID0gKGNhbGxiYWNrKSAtPlxuICBkZXByZWNhdGUoXCJBdG9tIG5vdyB1c2VzIEVTNiBQcm9taXNlcyBpbnN0ZWFkIG9mIFEuIENhbGwgcHJvbWlzZS50aGVuIGluc3RlYWQgb2YgcHJvbWlzZS5kb25lXCIpXG4gIEB0aGVuKGNhbGxiYWNrKVxuIl19
