(function() {
  var Grim, WrapGuideElement;

  Grim = require('grim');

  WrapGuideElement = require('./wrap-guide-element');

  module.exports = {
    activate: function() {
      this.updateConfiguration();
      return atom.workspace.observeTextEditors(function(editor) {
        var editorElement, wrapGuideElement;
        editorElement = atom.views.getView(editor);
        return wrapGuideElement = new WrapGuideElement(editor, editorElement);
      });
    },
    updateConfiguration: function() {
      var column, customColumn, customColumns, i, len, newColumns, pattern, scope;
      customColumns = atom.config.get('wrap-guide.columns');
      if (!customColumns) {
        return;
      }
      newColumns = [];
      for (i = 0, len = customColumns.length; i < len; i++) {
        customColumn = customColumns[i];
        if (!(typeof customColumn === 'object')) {
          continue;
        }
        pattern = customColumn.pattern, scope = customColumn.scope, column = customColumn.column;
        if (Grim.includeDeprecatedAPIs && pattern) {
          Grim.deprecate("The Wrap Guide package uses Atom's new language-specific configuration.\nUse of file name matching patterns for Wrap Guide configuration is deprecated.\nSee the README for details: https://github.com/atom/wrap-guide.");
          newColumns.push(customColumn);
        } else if (scope) {
          if (column === -1) {
            atom.config.set('wrap-guide.enabled', false, {
              scopeSelector: "." + scope
            });
          } else {
            atom.config.set('editor.preferredLineLength', column, {
              scopeSelector: "." + scope
            });
          }
        }
      }
      if (newColumns.length === 0) {
        newColumns = void 0;
      }
      return atom.config.set('wrap-guide.columns', newColumns);
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
