'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});
exports['default'] = dom;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _virtualDomH = require('virtual-dom/h');

var _virtualDomH2 = _interopRequireDefault(_virtualDomH);

var _virtualDomVirtualHyperscriptSvg = require('virtual-dom/virtual-hyperscript/svg');

var _virtualDomVirtualHyperscriptSvg2 = _interopRequireDefault(_virtualDomVirtualHyperscriptSvg);

var _refHook = require('./ref-hook');

var _refHook2 = _interopRequireDefault(_refHook);

var _componentWidget = require('./component-widget');

var _componentWidget2 = _interopRequireDefault(_componentWidget);

var _svgTags = require('./svg-tags');

var _svgTags2 = _interopRequireDefault(_svgTags);

var _svgAttributeTranslations = require('./svg-attribute-translations');

var _svgAttributeTranslations2 = _interopRequireDefault(_svgAttributeTranslations);

// This function is invoked by JSX expressions to construct `virtual-dom` trees.
//
// For normal HTML tags (when the `tag` parameter is a string), we call through
// to `h`, the virtual-dom library's method for building virtual nodes.
//
// If the user passes a *constructor*, however, we build a special "widget"
// instance to manage the component. [Widgets](https://github.com/Matt-Esch/virtual-dom/blob/master/docs/widget.md)
// are an extension mechanism in the virtual-dom API that allows us to control
// a particular DOM element directly using native DOM APIs. This allows the
// component to manage its DOM element using whatever mechanism it desires,
// independent of the fact that its containing DOM tree is managed by this
// particular library. For more information, see `./component-widget.js`.

function dom(tag, properties) {
  for (var _len = arguments.length, children = Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
    children[_key - 2] = arguments[_key];
  }

  if (typeof tag === 'function') {
    return new _componentWidget2['default'](tag, properties || {}, children);
  } else {
    // Etch allows for a special `ref` property, which will automatically create
    // named references to DOM elements containing the property. We implement
    // this with virtual-dom's [hook system](https://github.com/Matt-Esch/virtual-dom/blob/master/docs/hooks.md),
    // which allows a particular property to be associated with behavior when
    // the element is created or destroyed.
    if (properties && properties.ref) {
      properties.ref = new _refHook2['default'](properties.ref);
    }

    if (_svgTags2['default'].has(tag)) {
      if (properties) {
        var _iteratorNormalCompletion = true;
        var _didIteratorError = false;
        var _iteratorError = undefined;

        try {
          for (var _iterator = Object.keys(properties)[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
            var property = _step.value;

            if (_svgAttributeTranslations2['default'].hasOwnProperty(property)) {
              properties[_svgAttributeTranslations2['default'][property]] = properties[property];
              delete properties[property];
            }
          }
        } catch (err) {
          _didIteratorError = true;
          _iteratorError = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion && _iterator['return']) {
              _iterator['return']();
            }
          } finally {
            if (_didIteratorError) {
              throw _iteratorError;
            }
          }
        }
      }
      return (0, _virtualDomVirtualHyperscriptSvg2['default'])(tag, properties, children);
    } else {
      return (0, _virtualDomH2['default'])(tag, properties, children);
    }
  }
}

module.exports = exports['default'];