Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _mruItemView = require('./mru-item-view');

var _mruItemView2 = _interopRequireDefault(_mruItemView);

var _atom = require('atom');

'use babel';

var MRUListView = (function () {
  function MRUListView() {
    _classCallCheck(this, MRUListView);
  }

  _createClass(MRUListView, [{
    key: 'initialize',
    value: function initialize(pane) {
      this.ownerDiv = document.createElement('div');
      this.element = document.createElement('ol');
      this.ownerDiv.appendChild(this.element);
      this.ownerDiv.classList.add('select-list', 'tabs-mru-switcher');

      this.pane = pane;
      this.subscribe();
      this.panel = atom.workspace.addModalPanel({
        item: this.ownerDiv,
        visible: false
      });
      this.element.classList.add('list-group');

      this.hideClickHandler = this.hide.bind(this);
      this.preventPropagationClickHandler = this.preventPropagation.bind(this);
    }
  }, {
    key: 'subscribe',
    value: function subscribe() {
      var _this = this;

      this.subscriptions = new _atom.CompositeDisposable();

      /* Check for existence of events. Allows package tests to pass until this
      change hits stable. */
      if (typeof this.pane.onChooseNextMRUItem === 'function') {
        /* Because the chosen item is passed in the callback, both the
        ChooseNext and ChooseLast events can call our our single choose
        method. */
        this.subscriptions.add(this.pane.onChooseNextMRUItem(function (item) {
          return _this.choose(item);
        }));
        this.subscriptions.add(this.pane.onChooseLastMRUItem(function (item) {
          return _this.choose(item);
        }));

        this.subscriptions.add(this.pane.onDoneChoosingMRUItem(function () {
          return _this.stopChoosing();
        }));
      }

      this.subscriptions.add(this.pane.onDidDestroy(function () {
        return _this.destroy();
      }));

      this.subscriptions.add(atom.commands.add('atom-workspace', {
        'core:cancel': function coreCancel(event) {
          if (_this.hide()) event.stopPropagation();
        }
      }));
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      this.subscriptions.dispose();
      this.panel.destroy();
    }
  }, {
    key: 'choose',
    value: function choose(selectedItem) {
      this.show(selectedItem);
    }
  }, {
    key: 'stopChoosing',
    value: function stopChoosing() {
      this.hide();
    }
  }, {
    key: 'show',
    value: function show(selectedItem) {
      var selectedViewElement = undefined;
      if (!this.panel.visible) {
        selectedViewElement = this.buildListView(selectedItem);
        this.panel.show();
        this.addClickHandlers();
      } else {
        selectedViewElement = this.updateSelectedItem(selectedItem);
      }
      this.scrollToItemView(selectedViewElement);
    }
  }, {
    key: 'preventPropagation',
    value: function preventPropagation() {
      event.stopPropagation();
    }
  }, {
    key: 'addClickHandlers',
    value: function addClickHandlers() {
      document.body.addEventListener('click', this.hideClickHandler);
      this.ownerDiv.addEventListener('click', this.preventPropagationClickHandler);
    }
  }, {
    key: 'removeClickHandler',
    value: function removeClickHandler() {
      document.body.removeEventListener('click', this.hideClickHandler);
      this.ownerDiv.removeEventListener('click', this.preventPropagationClickHandler);
    }
  }, {
    key: 'hide',
    value: function hide() {
      var willClose = this.panel.visible;
      if (willClose) {
        this.removeClickHandler();
        this.panel.hide();
      }
      return willClose;
    }
  }, {
    key: 'updateSelectedItem',
    value: function updateSelectedItem(selectedItem) {
      var selectedView = undefined;
      for (var viewElement of this.element.children) {
        if (viewElement.itemViewData.item === selectedItem) {
          viewElement.itemViewData.select();
          selectedView = viewElement;
        } else viewElement.itemViewData.unselect();
      }
      return selectedView;
    }
  }, {
    key: 'scrollToItemView',
    value: function scrollToItemView(view) {
      var desiredTop = view.offsetTop;
      var desiredBottom = desiredTop + view.offsetHeight;

      if (desiredTop < this.element.scrollTop) {
        this.element.scrollTop = desiredTop;
      } else if (desiredBottom > this.element.scrollTop + this.element.clientHeight) {
        this.element.scrollTop = desiredBottom - this.element.clientHeight;
      }
    }
  }, {
    key: 'buildListView',
    value: function buildListView(selectedItem) {
      /* Making this more efficient, and not simply building the view for the
      entire stack every time it's shown, has significant complexity cost.
      The pane system completely owns the MRU stack. Adding events and
      handlers to incrementally update the UI here would mean two copies of
      the stack to maintain and keep in sync. Let's take on that complexity
      only if this exhibits real-world performance issues. */
      while (this.element.firstChild) this.element.removeChild(this.element.firstChild);

      var selectedViewElement = undefined;
      /* We're inserting each item at the top so we traverse the stack from
      the bottom, resulting in the most recently used item at the top of the
      UI. */
      for (var i = this.pane.itemStack.length - 1; i >= 0; i--) {
        var item = this.pane.itemStack[i];
        var itemView = new _mruItemView2['default']();
        itemView.initialize(this, item);
        this.element.appendChild(itemView.element);
        if (item === selectedItem) {
          itemView.select();
          selectedViewElement = itemView;
        }
      }
      return selectedViewElement.element;
    }
  }]);

  return MRUListView;
})();

exports['default'] = MRUListView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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